/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.structuralsearch.impl.matcher.strategies.MatchingStrategy;

public class JSMatchingStrategy
implements MatchingStrategy {
    private final Language myLanguage;

    public JSMatchingStrategy(Language language) {
        if (!(language instanceof JSLanguageDialect)) {
            throw new IllegalArgumentException();
        }
        this.myLanguage = language;
    }

    public boolean continueMatching(PsiElement start) {
        Language language = JSMatchingStrategy.getLanguage(start);
        return language.isKindOf(this.myLanguage);
    }

    private static Language getLanguage(PsiElement element) {
        PsiElement context2;
        if (element instanceof LeafPsiElement && (context2 = element.getContext()) instanceof JSElement) {
            return context2.getLanguage();
        }
        return element.getLanguage();
    }

    public boolean shouldSkip(PsiElement element, PsiElement elementToMatchWith) {
        return false;
    }
}

