/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.lang.javascript.config.JSConfig;
import com.intellij.lang.javascript.config.JSFileExportsImpl;
import com.intellij.lang.javascript.config.JSFileImports;
import com.intellij.lang.javascript.config.JSFileImportsImpl;
import com.intellij.lang.javascript.config.JSImportSimpleResolveContextImpl;
import com.intellij.lang.javascript.config.JSProjectFileInclude;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImportsResolver;
import com.intellij.lang.typescript.tsconfig.TypeScriptImportSimpleResolveContextImpl;
import com.intellij.lang.typescript.tsconfig.TypeScriptImportsResolverProvider;
import com.intellij.lang.typescript.tsconfig.TypeScriptProjectFileInclude;
import com.intellij.lang.typescript.tsconfig.TypeScriptSimpleFileInclude;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSFileImportsFactory {
    @NotNull
    public static JSFileImports createFileExports(@NotNull Project project, @Nullable JSConfig config, @NotNull VirtualFile startFile) {
        TypeScriptConfig tsConfig;
        if (project == null) {
            JSFileImportsFactory.$$$reportNull$$$0(0);
        }
        if (startFile == null) {
            JSFileImportsFactory.$$$reportNull$$$0(1);
        }
        return (tsConfig = (TypeScriptConfig)ObjectUtils.tryCast((Object)config, TypeScriptConfig.class)) == null ? new JSFileExportsImpl(project, new TypeScriptSimpleFileInclude(project, startFile), startFile) : new JSFileExportsImpl(project, tsConfig, startFile);
    }

    @Nullable
    public static JSFileImports createFileImports(@NotNull PsiElement context2) {
        PsiFile contextPsiFile;
        VirtualFile contextFile;
        if (context2 == null) {
            JSFileImportsFactory.$$$reportNull$$$0(2);
        }
        if ((contextFile = (contextPsiFile = context2.getContainingFile().getOriginalFile()).getVirtualFile()) == null) {
            return null;
        }
        Project project = context2.getProject();
        TypeScriptConfig config = TypeScriptConfigUtil.getConfigForPsiFile(contextPsiFile, true);
        return config == null ? JSFileImportsFactory.createFileScopeImports(project, contextFile) : new JSFileImportsImpl(project, config);
    }

    @NotNull
    public static JSFileImports createFileScopeImports(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            JSFileImportsFactory.$$$reportNull$$$0(3);
        }
        if (file == null) {
            JSFileImportsFactory.$$$reportNull$$$0(4);
        }
        return new JSFileImportsImpl(project, new TypeScriptSimpleFileInclude(project, file));
    }

    @NotNull
    public static JSFileImports createProjectScopeImports(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            JSFileImportsFactory.$$$reportNull$$$0(5);
        }
        if (file == null) {
            JSFileImportsFactory.$$$reportNull$$$0(6);
        }
        if (TypeScriptUtil.isTypeScriptFile(file)) {
            TypeScriptImportSimpleResolveContextImpl context2 = new TypeScriptImportSimpleResolveContextImpl(file);
            TypeScriptFileImportsResolver resolver = TypeScriptImportsResolverProvider.getDefaultProvider(project, context2);
            TypeScriptProjectFileInclude fileInclude = new TypeScriptProjectFileInclude(file, resolver, null, context2);
            return new JSFileImportsImpl(project, fileInclude);
        }
        JSImportSimpleResolveContextImpl context3 = new JSImportSimpleResolveContextImpl(file);
        TypeScriptFileImportsResolver resolver = TypeScriptImportsResolverProvider.getDefaultProvider(project, context3);
        JSProjectFileInclude fileInclude = new JSProjectFileInclude(file, resolver, null, context3);
        return new JSFileImportsImpl(project, fileInclude);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/tsconfig/JSFileImportsFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createFileExports";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createFileImports";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createFileScopeImports";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createProjectScopeImports";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

