/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.modules;

import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleDirectorySearchProcessor;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.ResolvedModuleInfo;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.typescript.modules.TypeScriptTypingsMapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptNodeSearchProcessor
extends NodeModuleDirectorySearchProcessor {
    public static final TypeScriptNodeSearchProcessor TS_PROCESSOR = new TypeScriptNodeSearchProcessor();
    public static final Function<CompletionModuleInfo, CompletionModuleInfo> MAP_COMPLETION_MODULE = info -> {
        String name = ES6CreateImportUtil.convertAtTypesToOriginalName(info.getName());
        return new CompletionModuleInfo(name, info.getVirtualFile(), info.getType()){

            @Override
            @NotNull
            public String getPresentablePath(@Nullable VirtualFile requester) {
                VirtualFile file = this.getVirtualFile();
                assert (file != null);
                String string = file.getName();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/modules/TypeScriptNodeSearchProcessor$1", "getPresentablePath"));
            }
        };
    };

    public TypeScriptNodeSearchProcessor() {
        super(TypeScriptUtil.TYPESCRIPT_EXTENSIONS);
    }

    public TypeScriptNodeSearchProcessor(String @NotNull [] extensionsWithDot) {
        if (extensionsWithDot == null) {
            TypeScriptNodeSearchProcessor.$$$reportNull$$$0(0);
        }
        super(extensionsWithDot);
    }

    @Override
    protected String findPathInPackageJson(@NotNull PackageJsonData data2, @NotNull VirtualFile packageJson) {
        String extension;
        if (data2 == null) {
            TypeScriptNodeSearchProcessor.$$$reportNull$$$0(1);
        }
        if (packageJson == null) {
            TypeScriptNodeSearchProcessor.$$$reportNull$$$0(2);
        }
        if (data2.hasTypings()) {
            return TypeScriptTypingsMapper.substituteTypings(data2.getDefaultMain(), packageJson, data2, true);
        }
        String main = data2.getDefaultMain();
        if (main != null && (ArrayUtil.contains((String)(extension = JSFileReferencesUtil.findImplicitExtension(main)), (String[])TypeScriptUtil.TYPESCRIPT_EXTENSIONS) || extension == null)) {
            return main;
        }
        return null;
    }

    @Override
    @Nullable
    public ResolvedModuleInfo loadDirectory(@Nullable VirtualFile moduleSourceRoot, @NotNull VirtualFile dir, @NotNull ModuleType type2, boolean respectPackageJson) {
        PackageJsonData packageJsonData;
        String main;
        VirtualFile packageJson;
        if (dir == null) {
            TypeScriptNodeSearchProcessor.$$$reportNull$$$0(3);
        }
        if (type2 == null) {
            TypeScriptNodeSearchProcessor.$$$reportNull$$$0(4);
        }
        if (moduleSourceRoot == null) {
            moduleSourceRoot = dir;
        }
        if (respectPackageJson && (packageJson = dir.findChild("package.json")) != null && (main = this.findPathInPackageJson(packageJsonData = PackageJsonData.getOrCreate(packageJson), packageJson)) != null) {
            main = StringUtil.trimEnd((String)main, (char)'/');
            Collection<String> sourceCandidates = TypeScriptUtil.getSourceNamesForDeclaration(main);
            for (String tsCandidate : sourceCandidates) {
                ResolvedModuleInfo info = this.doResolveModule(moduleSourceRoot, type2, dir, tsCandidate, true, false);
                if (info == null) continue;
                return info;
            }
            ResolvedModuleInfo info = this.doResolveModule(moduleSourceRoot, type2, dir, main, true, false);
            if (info != null) {
                return info;
            }
        }
        return this.doResolveModule(moduleSourceRoot, type2, dir, "index", false, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionsWithDot";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/modules/TypeScriptNodeSearchProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findPathInPackageJson";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "loadDirectory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

