/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.action;

import com.intellij.icons.AllIcons;
import com.intellij.lang.LangBundle;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.TypeScriptServiceHolder;
import com.intellij.lang.typescript.compiler.TypeScriptServiceRestarter;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import org.jetbrains.annotations.NotNull;

public class TypeScriptRestartServiceAction
extends AnAction {
    private final String myServiceName;

    public TypeScriptRestartServiceAction() {
        super(JavaScriptBundle.messagePointer("typescript.service.action.restart", JavaScriptBundle.message("typescript.language.service.name", new Object[0])), AllIcons.Actions.StopAndRestart);
        this.myServiceName = JavaScriptBundle.message("typescript.language.service.name", new Object[0]);
    }

    public TypeScriptRestartServiceAction(@NotNull @NlsSafe String name) {
        if (name == null) {
            TypeScriptRestartServiceAction.$$$reportNull$$$0(0);
        }
        super(JavaScriptBundle.messagePointer("action.restart.service", new Object[0]), AllIcons.Actions.StopAndRestart);
        this.myServiceName = name;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            TypeScriptRestartServiceAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) != null) {
            TypeScriptServiceRestarter.restartServices(project);
            String title = LangBundle.message((String)"language.services.0.restarted.notification.title", (Object[])new Object[]{this.myServiceName});
            JSLanguageServiceUtil.showServiceStoppedOrRestartedNotification(project, title, "");
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            TypeScriptRestartServiceAction.$$$reportNull$$$0(2);
        }
        Project project = e.getProject();
        Presentation presentation = e.getPresentation();
        if (project == null) {
            this.setEnableAndVisible(presentation, false);
            return;
        }
        boolean hasStarted = TypeScriptServiceHolder.hasAnyCreatedServices(project);
        this.setEnableAndVisible(presentation, hasStarted);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            TypeScriptRestartServiceAction.$$$reportNull$$$0(3);
        }
        return actionUpdateThread;
    }

    protected void setEnableAndVisible(Presentation presentation, boolean isEnabled) {
        presentation.setEnabledAndVisible(isEnabled);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/action/TypeScriptRestartServiceAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/action/TypeScriptRestartServiceAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

