/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.codeHighlighting.DirtyScopeTrackingHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.highlighting.JSLanguageServiceHighlightingPass;
import com.intellij.lang.typescript.compiler.TypeScriptServiceHolder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u001aB\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u0004J\b\u0010\f\u001a\u00020\nH\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/lang/typescript/compiler/TypeScriptServiceHighlightingPassFactory;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/codeHighlighting/DirtyScopeTrackingHighlightingPassFactory;", "highlightingPassRegistrar", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;", "<init>", "(Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;)V", "serviceName", "", "passId", "", "registerPass", "getPassId", "createHighlightingPass", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "psiFile", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isAcceptablePsiFile", "", "file", "getService", "Lcom/intellij/lang/javascript/service/JSLanguageService;", "dispose", "", "Registrar", "intellij.javascript.impl"})
public final class TypeScriptServiceHighlightingPassFactory
implements Disposable,
DirtyScopeTrackingHighlightingPassFactory {
    @NotNull
    private final String serviceName;
    private final int passId;

    private TypeScriptServiceHighlightingPassFactory(TextEditorHighlightingPassRegistrar highlightingPassRegistrar) {
        this.serviceName = "TypeScript";
        this.passId = this.registerPass(highlightingPassRegistrar);
    }

    public final int registerPass(@NotNull TextEditorHighlightingPassRegistrar highlightingPassRegistrar) {
        int[] nArray;
        Intrinsics.checkNotNullParameter((Object)highlightingPassRegistrar, (String)"highlightingPassRegistrar");
        if (Registry.Companion.is("typescript.service.geterr.enabled")) {
            nArray = null;
        } else {
            int[] nArray2 = new int[]{4};
            nArray = nArray2;
        }
        int[] runAfterCompletionOf = nArray;
        return highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, runAfterCompletionOf, null, true, -1);
    }

    public int getPassId() {
        return this.passId;
    }

    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile psiFile, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (!this.isAcceptablePsiFile(psiFile)) {
            return null;
        }
        JSLanguageService service = this.getService(psiFile);
        Project project = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return (TextEditorHighlightingPass)new JSLanguageServiceHighlightingPass(project, service, psiFile, editor, this.serviceName);
    }

    private final boolean isAcceptablePsiFile(PsiFile file) {
        return file instanceof JSFile || file instanceof XmlFile;
    }

    private final JSLanguageService getService(PsiFile file) {
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null || DumbService.Companion.isDumb(project2)) {
            return null;
        }
        return TypeScriptServiceHolder.getForFile(project2, virtualFile);
    }

    public void dispose() {
    }

    public /* synthetic */ TypeScriptServiceHighlightingPassFactory(TextEditorHighlightingPassRegistrar highlightingPassRegistrar, DefaultConstructorMarker $constructor_marker) {
        this(highlightingPassRegistrar);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/lang/typescript/compiler/TypeScriptServiceHighlightingPassFactory$Registrar;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactoryRegistrar;", "<init>", "()V", "registerHighlightingPassFactory", "", "registrar", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.javascript.impl"})
    public static final class Registrar
    implements TextEditorHighlightingPassFactoryRegistrar {
        public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            new TypeScriptServiceHighlightingPassFactory(registrar, null);
        }
    }
}

