/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.evaluable;

import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationResultElement;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTask;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTasks;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyType;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyTypeBase;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import java.text.CharacterIterator;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSReturnedExpressionType
extends JSEvaluableOnlyTypeBase
implements JSEvaluableOnlyType {
    private final int myReturnedExpressionIndex;

    public JSReturnedExpressionType(int returnedExpressionIndex, @NotNull JSTypeSource source) {
        if (source == null) {
            JSReturnedExpressionType.$$$reportNull$$$0(0);
        }
        super(source);
        this.myReturnedExpressionIndex = returnedExpressionIndex;
    }

    public JSReturnedExpressionType(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            JSReturnedExpressionType.$$$reportNull$$$0(1);
        }
        if (inputStream == null) {
            JSReturnedExpressionType.$$$reportNull$$$0(2);
        }
        super(source);
        this.myReturnedExpressionIndex = JSTypeSerializer.readInt(inputStream);
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSReturnedExpressionType.$$$reportNull$$$0(3);
        }
        super.serialize(outputStream);
        JSTypeSerializer.writeInt(this.myReturnedExpressionIndex, outputStream);
    }

    @Override
    protected int hashCodeImpl() {
        return Objects.hash(this.getSourceElement(), this.myReturnedExpressionIndex);
    }

    @Override
    protected boolean isEquivalentToWithSameClass(@NotNull JSType type2, @Nullable ProcessingContext context2, boolean allowResolve) {
        if (type2 == null) {
            JSReturnedExpressionType.$$$reportNull$$$0(4);
        }
        return Objects.equals(this.getSourceElement(), type2.getSourceElement()) && this.myReturnedExpressionIndex == ((JSReturnedExpressionType)type2).myReturnedExpressionIndex;
    }

    @Override
    @NotNull
    protected JSReturnedExpressionType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSReturnedExpressionType.$$$reportNull$$$0(5);
        }
        return new JSReturnedExpressionType(this.myReturnedExpressionIndex, source);
    }

    @Nullable
    public JSExpression findAssociatedExpression() {
        PsiElement sourceElement = this.getSourceElement();
        if (!(sourceElement instanceof JSFunction)) {
            String className = sourceElement == null ? null : sourceElement.getClass().getSimpleName();
            Logger.getInstance(JSReturnedExpressionType.class).error("Expected function, was " + className);
            return null;
        }
        return JSStubBasedPsiTreeUtil.findReturnedExpressions((JSFunction)sourceElement).stream().filter(JSReturnedExpressionType::isCountableReturnedExpression).skip(this.myReturnedExpressionIndex).findFirst().orElse(null);
    }

    public static boolean isCountableReturnedExpression(@NotNull JSExpression returnedExpression) {
        PsiElement context2;
        if (returnedExpression == null) {
            JSReturnedExpressionType.$$$reportNull$$$0(6);
        }
        if ((context2 = returnedExpression.getContext()) instanceof JSParenthesizedExpression) {
            context2 = JSUtils.getParentSkipParentheses(context2);
        }
        return JSStubBasedPsiTreeUtil.isStubBased((PsiElement)returnedExpression) && (context2 instanceof JSReturnStatement || context2 instanceof JSFunctionExpression) && JSStubBasedPsiTreeUtil.isStubBased(context2);
    }

    @Override
    @NotNull
    public JSEvaluationTask evaluate(@NotNull JSEvaluateContext evaluateContext) {
        JSExpression expression;
        if (evaluateContext == null) {
            JSReturnedExpressionType.$$$reportNull$$$0(7);
        }
        JSEvaluationTask jSEvaluationTask = (expression = this.findAssociatedExpression()) != null ? JSEvaluationResultElement.fromType(this.getTypeFromResolvedElement((PsiElement)expression, evaluateContext), evaluateContext) : JSEvaluationTasks.EMPTY;
        if (jSEvaluationTask == null) {
            JSReturnedExpressionType.$$$reportNull$$$0(8);
        }
        return jSEvaluationTask;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnedExpression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluateContext";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/evaluable/JSReturnedExpressionType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/evaluable/JSReturnedExpressionType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isCountableReturnedExpression";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }
}

