/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.ex.EditInspectionToolsSettingsAction;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptAnnotatingVisitor;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.typescript.inspections.TypeScriptSmartCastInspection;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TypeScriptDisableSmartCastIntention
implements IntentionAction,
LowPriorityAction {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = JavaScriptBundle.message("typescript.type.guard.name.disable", new Object[0]);
        if (string == null) {
            TypeScriptDisableSmartCastIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("typescript.type.guard.name.disable", new Object[0]);
        if (string == null) {
            TypeScriptDisableSmartCastIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiElement element;
        if (project == null) {
            TypeScriptDisableSmartCastIntention.$$$reportNull$$$0(2);
        }
        if ((element = file.findElementAt(editor.getCaretModel().getOffset())) == null) {
            return false;
        }
        JSReferenceExpression expression = PsiUtilCore.getElementType((PsiElement)element) == JSTokenTypes.IDENTIFIER ? (JSReferenceExpression)ObjectUtils.tryCast((Object)element.getParent(), JSReferenceExpression.class) : null;
        return expression != null && TypeScriptAnnotatingVisitor.isSmartCastInspectionEnabled(expression) && JSTypeGuardUtil.getTypeIfAffectedByTypeGuard(expression) != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            TypeScriptDisableSmartCastIntention.$$$reportNull$$$0(3);
        }
        TypeScriptDisableSmartCastIntention.doEnable(project, false);
        TypeScriptDisableSmartCastIntention.showHint(project);
    }

    private static void doEnable(@NotNull Project project, boolean enabled) {
        if (project == null) {
            TypeScriptDisableSmartCastIntention.$$$reportNull$$$0(4);
        }
        String id = JSInspection.calcShortNameFromClass(TypeScriptSmartCastInspection.class);
        InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile().setToolEnabled(id, enabled);
        for (Project it : ProjectManager.getInstance().getOpenProjects()) {
            PsiManager psiManager = PsiManager.getInstance((Project)it);
            DaemonCodeAnalyzer daemonCodeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)it);
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)it);
            for (VirtualFile selectedFile : fileEditorManager.getSelectedFiles()) {
                PsiFile psiFile = psiManager.findFile(selectedFile);
                if (psiFile == null) continue;
                daemonCodeAnalyzer.restart();
            }
        }
    }

    private static void showHint(final Project project) {
        NotificationListener.Adapter listener2 = new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                switch (event.getDescription()) {
                    case "settings": {
                        this.showSettings();
                        break;
                    }
                    case "undo": {
                        TypeScriptDisableSmartCastIntention.doEnable(project, true);
                    }
                }
                notification.expire();
            }

            private void showSettings() {
                String id = JSInspection.calcShortNameFromClass(TypeScriptSmartCastInspection.class);
                HighlightDisplayKey key = HighlightDisplayKey.find((String)id);
                new EditInspectionToolsSettingsAction(key).editToolSettings(project, InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/intentions/TypeScriptDisableSmartCastIntention$1";
                objectArray[2] = "hyperlinkActivated";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        new Notification("Coloring of Type Guard Narrowed Types", JavaScriptBundle.message("notification.title.coloring.types.narrowed.by.type.guard.was.disabled", new Object[0]), JavaScriptBundle.message("notification.content.html.href.settings.show.inspection.settings.or.href.undo.undo.html", new Object[0]), NotificationType.INFORMATION).setListener((NotificationListener)listener2).notify(project);
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/TypeScriptDisableSmartCastIntention";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/TypeScriptDisableSmartCastIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doEnable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

