/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.jsx;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.frameworks.jsx.JSXAttributeDescriptor;
import com.intellij.lang.javascript.frameworks.jsx.JSXEmbeddedContentUtil;
import com.intellij.lang.javascript.frameworks.jsx.JSXImplementation;
import com.intellij.lang.javascript.frameworks.jsx.JSXTagNameReference;
import com.intellij.lang.javascript.frameworks.jsx.JSXXmlElementDescriptor;
import com.intellij.lang.javascript.frameworks.jsx.references.JSXNamespaceReference;
import com.intellij.lang.javascript.frameworks.jsx.references.JSXResolveUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.impl.JSXXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.HtmlXmlExtension;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.XmlTagNameProvider;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSXXmlExtension
extends HtmlXmlExtension
implements XmlTagNameProvider {
    private static final XmlExtension.AttributeValuePresentation BRACES_PRESENTATION = new XmlExtension.AttributeValuePresentation(){

        @NotNull
        public String getPrefix() {
            return "{";
        }

        @NotNull
        public String getPostfix() {
            return "}";
        }

        public boolean showAutoPopup() {
            return false;
        }
    };
    private static final XmlExtension.AttributeValuePresentation EMPTY_VALUE_PRESENTATION = new XmlExtension.AttributeValuePresentation(){

        @NotNull
        public String getPrefix() {
            return "";
        }

        @NotNull
        public String getPostfix() {
            return "";
        }

        public boolean showAutoPopup() {
            return false;
        }
    };

    @Nullable
    public static JSXNamespaceReference getQualifierReference(@NotNull XmlTag tag) {
        PsiReference[] references;
        if (tag == null) {
            JSXXmlExtension.$$$reportNull$$$0(0);
        }
        if ((references = tag.getReferences()).length == 0) {
            return null;
        }
        PsiReference lastRef = references[references.length - 1];
        if (!(lastRef instanceof JSXNamespaceReference)) {
            return null;
        }
        return (JSXNamespaceReference)lastRef;
    }

    @NotNull
    public static JSCodeStyleSettings.JSXAttributeValuePresentation getAttributeValue(@NotNull XmlTag tag, @NotNull String attributeName) {
        if (tag == null) {
            JSXXmlExtension.$$$reportNull$$$0(1);
        }
        if (attributeName == null) {
            JSXXmlExtension.$$$reportNull$$$0(2);
        }
        if (tag instanceof JSXXmlLiteralExpressionImpl) {
            XmlAttributeDescriptor attributeDescriptor;
            XmlElementDescriptor descriptor;
            JSCodeStyleSettings.JSXAttributeValuePresentation value = JSCodeStyleSettings.getJSXAttributeValue((PsiElement)tag);
            if (value == JSCodeStyleSettings.JSXAttributeValuePresentation.TYPE_BASED && (descriptor = tag.getDescriptor()) != null && (attributeDescriptor = descriptor.getAttributeDescriptor(attributeName, tag)) instanceof JSXAttributeDescriptor) {
                return JSXXmlExtension.getTypeBasedJSXAttributeValuePresentation(attributeDescriptor);
            }
            JSCodeStyleSettings.JSXAttributeValuePresentation jSXAttributeValuePresentation = value;
            if (jSXAttributeValuePresentation == null) {
                JSXXmlExtension.$$$reportNull$$$0(3);
            }
            return jSXAttributeValuePresentation;
        }
        JSCodeStyleSettings.JSXAttributeValuePresentation jSXAttributeValuePresentation = JSCodeStyleSettings.JSXAttributeValuePresentation.QUOTES;
        if (jSXAttributeValuePresentation == null) {
            JSXXmlExtension.$$$reportNull$$$0(4);
        }
        return jSXAttributeValuePresentation;
    }

    @Nullable
    public static GlobalSearchScope getResolveScopeForIndexProcessing(@NotNull XmlTag tag, boolean hasQName) {
        boolean acceptOnlyModules;
        if (tag == null) {
            JSXXmlExtension.$$$reportNull$$$0(5);
        }
        boolean bl = acceptOnlyModules = ES6PsiUtil.findExternalModule((PsiElement)tag) != null;
        if (!hasQName && acceptOnlyModules) {
            return null;
        }
        if (acceptOnlyModules) {
            List namespaceDeclarations = ((StreamEx)((StreamEx)((StreamEx)StreamEx.of((Object[])tag.getReferences()).select(JSXNamespaceReference.class).filter(reference -> reference.isPrimary())).flatMap(reference -> Stream.of(reference.multiResolve(false))).filter(ResolveResult::isValidResult)).map(ResolveResult::getElement).nonNull().flatMap(element -> JSXXmlExtension.expandElements(element).stream()).filter(element -> element.isValid())).toList();
            List files = ((StreamEx)StreamEx.of((Object)tag).append((Collection)namespaceDeclarations).map(element -> PsiUtilCore.getVirtualFile((PsiElement)element)).nonNull().distinct()).toList();
            return GlobalSearchScope.filesScope((Project)tag.getProject(), (Collection)files);
        }
        final PsiManager manager = tag.getManager();
        return new DelegatingGlobalSearchScope(JSResolveUtil.getResolveScope((PsiElement)tag)){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!super.contains(file)) {
                    return false;
                }
                PsiFile psiFile = manager.findFile(file);
                if (!(psiFile instanceof JSFile)) {
                    return false;
                }
                return !((JSFile)psiFile).isCommonJSModule();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/frameworks/jsx/JSXXmlExtension$3", "contains"));
            }
        };
    }

    public boolean isAvailable(PsiFile file) {
        if (file instanceof JSFile) {
            return true;
        }
        FileType type2 = file.getFileType();
        if (type2 instanceof LanguageFileType && HTMLLanguage.INSTANCE.equals(((LanguageFileType)type2).getLanguage())) {
            JSLanguageDialect configuredJSVersion = DialectDetector.getConfiguredJSVersion(file);
            return configuredJSVersion.getOptionHolder().isJSX();
        }
        return false;
    }

    public boolean shouldCompleteTag(XmlTag context2) {
        return !(context2 instanceof JSXXmlLiteralExpressionImpl) || !JSXResolveUtil.isComponentName(context2.getName());
    }

    @Nullable
    public TagNameReference createTagNameReference(ASTNode nameElement, boolean startTagFlag) {
        return nameElement.getTreeParent() instanceof JSXXmlLiteralExpressionImpl ? new JSXTagNameReference(nameElement, startTagFlag) : super.createTagNameReference(nameElement, startTagFlag);
    }

    public void addTagNameVariants(List<LookupElement> elements, @NotNull XmlTag tag, String prefix) {
        if (tag == null) {
            JSXXmlExtension.$$$reportNull$$$0(6);
        }
    }

    @NotNull
    public static @NotNull Collection<@NotNull PsiElement> expandElements(@Nullable PsiElement element) {
        return JSXXmlExtension.expandElements(element, true);
    }

    @NotNull
    public static Collection<PsiElement> expandElements(@Nullable PsiElement element, boolean resolveCallExpression) {
        if (element == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSXXmlExtension.$$$reportNull$$$0(7);
            }
            return list;
        }
        Predicate<PsiElement> stopAt = el -> DialectDetector.isTypeScript(element) && element instanceof JSVariable;
        Collection collection = JSStubBasedPsiTreeUtil.calculateMeaningfulElements(element, null, stopAt, el -> false, false).stream().flatMap(el -> {
            JSExpression initializer;
            JSVariable variable;
            if (resolveCallExpression && el instanceof JSCallExpression) {
                JSCallExpression callExpression = (JSCallExpression)el;
                return JSXImplementation.resolveCallExpression(callExpression).stream();
            }
            if (el instanceof JSVariable && (variable = (JSVariable)el).getTypeElement() == null && (initializer = JSPsiImplUtils.getRightmostInitializer(variable)) instanceof JSFunction) {
                el = initializer;
            }
            return Stream.of(el);
        }).collect(Collectors.toList());
        if (collection == null) {
            JSXXmlExtension.$$$reportNull$$$0(8);
        }
        return collection;
    }

    public static boolean hasQualifiedName(@NotNull XmlTag tag) {
        if (tag == null) {
            JSXXmlExtension.$$$reportNull$$$0(9);
        }
        String name = tag.getName();
        String localName = tag.getLocalName();
        return !localName.equals(name);
    }

    @Nullable
    public XmlNSDescriptor getNSDescriptor(XmlTag element, String namespace, boolean strict) {
        XmlElementDescriptor elementDescriptor = element.getDescriptor();
        if (elementDescriptor instanceof JSXXmlElementDescriptor) {
            return elementDescriptor.getNSDescriptor();
        }
        return super.getNSDescriptor(element, namespace, strict);
    }

    public boolean isCollapsibleTag(XmlTag tag) {
        if (!(tag instanceof JSXmlLiteralExpression)) {
            return super.isCollapsibleTag(tag);
        }
        ASTNode end = XmlChildRole.START_TAG_END_FINDER.findChild(tag.getNode());
        return end != null && TreeUtil.findSibling((ASTNode)end, (TokenSet)JSXEmbeddedContentUtil.EMBEDDED_CONTENT_TOKENS) == null;
    }

    public boolean isRequiredAttributeImplicitlyPresent(XmlTag tag, String attrName) {
        String tagName = tag.getName();
        if (!JSXResolveUtil.isComponentName(tagName)) {
            return false;
        }
        boolean children = "children".equals(attrName);
        boolean passedAttributes = false;
        for (PsiElement child : tag.getChildren()) {
            if ((!children || passedAttributes) && child instanceof JSEmbeddedContent) {
                return true;
            }
            IElementType type2 = child.getNode().getElementType();
            if (children && (child instanceof XmlText || child instanceof XmlTag || type2 == JSTokenTypes.XML_ENTITY_REF)) {
                return true;
            }
            if (!children && (type2 == XmlTokenType.XML_EMPTY_ELEMENT_END || type2 == XmlTokenType.XML_TAG_END)) break;
            passedAttributes |= type2 == XmlTokenType.XML_TAG_END;
        }
        return false;
    }

    public boolean shouldBeInserted(XmlAttributeDescriptor descriptor) {
        if ("children".equals(descriptor.getName())) {
            return false;
        }
        return super.shouldBeInserted(descriptor);
    }

    @NotNull
    public XmlExtension.AttributeValuePresentation getAttributeValuePresentation(@Nullable XmlTag tag, @NotNull String attributeName, @NotNull String defaultAttributeQuote) {
        if (attributeName == null) {
            JSXXmlExtension.$$$reportNull$$$0(10);
        }
        if (defaultAttributeQuote == null) {
            JSXXmlExtension.$$$reportNull$$$0(11);
        }
        if (tag instanceof JSXXmlLiteralExpressionImpl) {
            JSCodeStyleSettings.JSXAttributeValuePresentation presentation = JSXXmlExtension.getAttributeValue(tag, attributeName);
            if (presentation == JSCodeStyleSettings.JSXAttributeValuePresentation.BRACES) {
                return JSXXmlExtension.createValueWithBraces();
            }
            if (presentation == JSCodeStyleSettings.JSXAttributeValuePresentation.NONE) {
                return JSXXmlExtension.createEmptyValue();
            }
        }
        XmlExtension.AttributeValuePresentation attributeValuePresentation = super.getAttributeValuePresentation(tag, attributeName, defaultAttributeQuote);
        if (attributeValuePresentation == null) {
            JSXXmlExtension.$$$reportNull$$$0(12);
        }
        return attributeValuePresentation;
    }

    @NotNull
    private static XmlExtension.AttributeValuePresentation createValueWithBraces() {
        XmlExtension.AttributeValuePresentation attributeValuePresentation = BRACES_PRESENTATION;
        if (attributeValuePresentation == null) {
            JSXXmlExtension.$$$reportNull$$$0(13);
        }
        return attributeValuePresentation;
    }

    @NotNull
    private static XmlExtension.AttributeValuePresentation createEmptyValue() {
        XmlExtension.AttributeValuePresentation attributeValuePresentation = EMPTY_VALUE_PRESENTATION;
        if (attributeValuePresentation == null) {
            JSXXmlExtension.$$$reportNull$$$0(14);
        }
        return attributeValuePresentation;
    }

    @Nullable
    public static JSType getType(@Nullable XmlAttributeDescriptor descriptor) {
        if (!(descriptor instanceof JSXAttributeDescriptor)) {
            return null;
        }
        return ((JSXAttributeDescriptor)descriptor).getValueType();
    }

    @Nullable
    public static JSType getPropType(@Nullable PsiElement declaration) {
        if (declaration instanceof JSTypeOwner) {
            JSTypeOwner signature = (JSTypeOwner)declaration;
            return signature.getJSType();
        }
        return null;
    }

    @NotNull
    public static JSCodeStyleSettings.JSXAttributeValuePresentation getTypeBasedJSXAttributeValuePresentation(@NotNull XmlAttributeDescriptor descriptor) {
        JSType attributeType;
        if (descriptor == null) {
            JSXXmlExtension.$$$reportNull$$$0(15);
        }
        if ((attributeType = JSXXmlExtension.getType(descriptor)) != null && attributeType.isTypeScript()) {
            attributeType = attributeType.substitute();
        }
        JSCodeStyleSettings.JSXAttributeValuePresentation jSXAttributeValuePresentation = !JSTypeUtils.isStringOrStringUnion(attributeType, true) ? JSCodeStyleSettings.JSXAttributeValuePresentation.BRACES : JSCodeStyleSettings.JSXAttributeValuePresentation.QUOTES;
        if (jSXAttributeValuePresentation == null) {
            JSXXmlExtension.$$$reportNull$$$0(16);
        }
        return jSXAttributeValuePresentation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 7, 8, 12, 13, 14, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/jsx/JSXXmlExtension";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultAttributeQuote";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/jsx/JSXXmlExtension";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeValue";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "expandElements";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeValuePresentation";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createValueWithBraces";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyValue";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeBasedJSXAttributeValuePresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierReference";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeValue";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getResolveScopeForIndexProcessing";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addTagNameVariants";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hasQualifiedName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeValuePresentation";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTypeBasedJSXAttributeValuePresentation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 7, 8, 12, 13, 14, 16 -> new IllegalStateException(string);
        };
    }
}

