/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.jsx;

import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.emmet.XmlEmmetParser;
import com.intellij.codeInsight.template.emmet.generators.ZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.nodes.TemplateNode;
import com.intellij.codeInsight.template.emmet.nodes.ZenCodingNode;
import com.intellij.codeInsight.template.emmet.tokens.TemplateToken;
import com.intellij.codeInsight.template.emmet.tokens.ZenCodingToken;
import com.intellij.codeInsight.template.impl.TemplateContextTypes;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.lang.javascript.frameworks.jsx.JSXHtmlContextType;
import com.intellij.lang.javascript.frameworks.jsx.references.JSXResolveUtil;
import com.intellij.lang.javascript.liveTemplates.typescript.TSXHtmlContextType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.util.HtmlUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSXEmmetParser
extends XmlEmmetParser {
    public JSXEmmetParser(List<ZenCodingToken> tokens, CustomTemplateCallback callback, ZenCodingGenerator generator, boolean surroundWithTemplate) {
        super(tokens, (CustomTemplateCallback)new JSXTemplateCallback(callback), generator, surroundWithTemplate);
    }

    @Nullable
    public ZenCodingNode parse() {
        String key;
        TemplateToken token;
        ZenCodingNode node = super.parse();
        if (node instanceof TemplateNode && (token = ((TemplateNode)node).getTemplateToken()) != null && token.getAttributes().isEmpty() && !JSXResolveUtil.isComponentName(key = token.getKey()) && this.myCallback.findApplicableTemplate(key) == null && !this.isKnownHtml5Tag(key)) {
            return null;
        }
        return node;
    }

    protected boolean setTemplate(TemplateToken token, TemplateImpl template) {
        boolean result2 = super.setTemplate(token, template);
        if (result2) {
            String templateString;
            int indexOf;
            String templateText;
            XmlTag tag = token.getXmlTag();
            TemplateImpl tokenTemplate = token.getTemplate();
            if (tag != null && tokenTemplate != null && HtmlUtil.isSingleHtmlTag((String)tag.getName(), (boolean)false) && StringUtil.endsWithChar((CharSequence)(templateText = tokenTemplate.getTemplateText()), (char)'>') && !StringUtil.endsWith((CharSequence)templateText, (CharSequence)"/>") && !StringUtil.endsWith((CharSequence)templateText, (CharSequence)("</" + tag.getName() + ">")) && (indexOf = (templateString = tokenTemplate.getString()).lastIndexOf(">")) >= 0) {
                TemplateImpl newTemplate = tokenTemplate.copy();
                newTemplate.setString(templateString.substring(0, indexOf) + "/>" + templateString.substring(indexOf + 1));
                newTemplate.parseSegments();
                result2 = super.setTemplate(token, newTemplate);
            }
        }
        return result2;
    }

    private boolean isKnownHtml5Tag(@NotNull String tag) {
        if (tag == null) {
            JSXEmmetParser.$$$reportNull$$$0(0);
        }
        if (ContainerUtil.exists((Object[])HtmlUtil.getCustomTagDescriptors((PsiElement)this.myCallback.getContext()), t -> tag.equals(t.getName()))) {
            return true;
        }
        XmlTag htmlTag = XmlElementFactory.getInstance((Project)this.myCallback.getProject()).createHTMLTagFromText("<!doctype html><div></div>");
        XmlNSDescriptor nsDescriptor = htmlTag.getNSDescriptor("http://www.w3.org/1999/html", true);
        if (nsDescriptor != null) {
            XmlDocument document = ((XmlFile)htmlTag.getContainingFile()).getDocument();
            for (XmlElementDescriptor descriptor : nsDescriptor.getAllElementsDescriptors(document)) {
                if (descriptor instanceof HtmlUtil.CustomXmlTagDescriptor || !tag.equals(descriptor.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/lang/javascript/frameworks/jsx/JSXEmmetParser", "isKnownHtml5Tag"));
    }

    private static class JSXTemplateCallback
    extends CustomTemplateCallback {
        JSXTemplateCallback(CustomTemplateCallback callback) {
            super(callback.getEditor(), callback.getFile());
            this.myApplicableContextTypes = ContainerUtil.newHashSet((Object[])new TemplateContextType[]{TemplateContextTypes.getByClass(JSXHtmlContextType.class), TemplateContextTypes.getByClass(TSXHtmlContextType.class)});
        }
    }
}

