/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow.flowconfig;

import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfigImpl;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfigUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FlowModuleMapping {
    private static final String BLACKLIST = "module.system.haste.paths.blacklist";
    private static final String WHITELIST = "module.system.haste.paths.whitelist";
    private static final String USE_NAME_REDUCER = "module.system.haste.use_name_reducers";
    private static final String MODULE_SYSTEM = "module.system";
    private static final String[] JS_EXTENSION = new String[]{".js.flow", ".js"};
    private static final String[] TARGET_EXTENSION = new String[]{".ios", ".android", ".native"};
    @NotNull
    private final List<String> myBlacklist;
    @NotNull
    private final List<String> myWhitelist;
    @NotNull
    private final VirtualFile myConfigDir;
    private final NullableLazyValue<Condition<VirtualFile>> myPredicate;

    public FlowModuleMapping(@NotNull List<String> _blacklist, @NotNull List<String> _whitelist, @NotNull VirtualFile configDir) {
        if (_blacklist == null) {
            FlowModuleMapping.$$$reportNull$$$0(0);
        }
        if (_whitelist == null) {
            FlowModuleMapping.$$$reportNull$$$0(1);
        }
        if (configDir == null) {
            FlowModuleMapping.$$$reportNull$$$0(2);
        }
        this.myBlacklist = _blacklist;
        this.myWhitelist = _whitelist;
        this.myConfigDir = configDir;
        this.myPredicate = NullableLazyValue.lazyNullable(() -> {
            Pattern whitelist = FlowJSConfigImpl.createPattern(FlowJSConfigUtil.getRegularExpression(this.myWhitelist, this.myConfigDir));
            if (whitelist == null) {
                return null;
            }
            Pattern blacklist = FlowJSConfigImpl.createPattern(FlowJSConfigUtil.getRegularExpression(this.myBlacklist, this.myConfigDir));
            return file -> {
                if (!VfsUtilCore.isAncestor((VirtualFile)this.myConfigDir, (VirtualFile)file, (boolean)false)) {
                    return false;
                }
                String path2 = file.getPath();
                return FlowJSConfigImpl.checkPattern(path2, whitelist) && (blacklist == null || !FlowJSConfigImpl.checkPattern(path2, blacklist));
            };
        });
    }

    @Nullable
    public Condition<VirtualFile> getFileAcceptor() {
        return (Condition)this.myPredicate.getValue();
    }

    @NotNull
    public String reduceName(@NotNull String name) {
        if (name == null) {
            FlowModuleMapping.$$$reportNull$$$0(3);
        }
        String string = JSFileReferencesUtil.getFileNameWithoutExtension(JSFileReferencesUtil.getFileNameWithoutExtension(name, JS_EXTENSION), TARGET_EXTENSION);
        if (string == null) {
            FlowModuleMapping.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public static FlowModuleMapping parse(@NotNull VirtualFile configDir, @NotNull Collection<String> options) {
        if (configDir == null) {
            FlowModuleMapping.$$$reportNull$$$0(5);
        }
        if (options == null) {
            FlowModuleMapping.$$$reportNull$$$0(6);
        }
        SmartList blacklist = new SmartList();
        SmartList whitelist = new SmartList();
        boolean useNameReducer = false;
        boolean isHaste = false;
        for (String option : options) {
            int separator = option.indexOf("=");
            if (separator <= 0) continue;
            String id = option.substring(0, separator).trim();
            String value = option.substring(separator + 1).trim();
            if (StringUtil.isEmpty((String)value)) continue;
            switch (id) {
                case "module.system.haste.paths.blacklist": {
                    blacklist.add(value);
                    break;
                }
                case "module.system.haste.paths.whitelist": {
                    whitelist.add(value);
                    break;
                }
                case "module.system": {
                    isHaste = value.trim().equals("haste");
                    break;
                }
                case "module.system.haste.use_name_reducers": {
                    useNameReducer = Boolean.parseBoolean(value);
                    break;
                }
            }
        }
        return isHaste && !whitelist.isEmpty() && useNameReducer ? new FlowModuleMapping((List<String>)blacklist, (List<String>)whitelist, configDir) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_blacklist";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_whitelist";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flow/flowconfig/FlowModuleMapping";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flow/flowconfig/FlowModuleMapping";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "reduceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reduceName";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

