/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.lang.javascript.completion.JSLookupContext;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.completion.JSPartialIconService;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.index.JSItemPresentation;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.model.Pointer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSLookupElementRenderer
extends LookupElementRenderer<LookupElement> {
    private final String myName;
    private final JSLookupPriority myPriority;
    private final boolean myPartial;
    private final Icon myIcon;
    private final String myTailPostfix;
    @NotNull
    private final JSLookupContext myLookupContext;
    private final boolean myParamsOnly;
    private final LookupElementRenderer<LookupElement> myExpensiveRenderer;

    @Deprecated(forRemoval=true)
    public JSLookupElementRenderer(String name, @Nullable JSLookupPriority priority, boolean partial, @Nullable JSTypeSubstitutor typeSubstitutor) {
        this(name, priority, partial, null, null, new JSLookupContext(null, typeSubstitutor), false);
    }

    public JSLookupElementRenderer(String name, @Nullable JSLookupPriority priority, boolean partial, @NotNull JSLookupContext lookupContext) {
        if (lookupContext == null) {
            JSLookupElementRenderer.$$$reportNull$$$0(0);
        }
        this(name, priority, partial, null, null, lookupContext, false);
    }

    public JSLookupElementRenderer(String name, @Nullable JSLookupPriority priority, boolean partial, @Nullable Icon icon, @Nullable String tailPostfix, @NotNull JSLookupContext lookupContext, boolean paramsOnly) {
        if (lookupContext == null) {
            JSLookupElementRenderer.$$$reportNull$$$0(1);
        }
        this.myExpensiveRenderer = new JSLookupElementExpensiveRenderer();
        this.myName = name;
        this.myPriority = priority;
        this.myPartial = partial;
        this.myIcon = icon;
        this.myTailPostfix = tailPostfix;
        this.myLookupContext = lookupContext;
        this.myParamsOnly = paramsOnly;
    }

    @NotNull
    public LookupElementBuilder applyToBuilder(@NotNull LookupElementBuilder builder2) {
        if (builder2 == null) {
            JSLookupElementRenderer.$$$reportNull$$$0(2);
        }
        LookupElementBuilder lookupElementBuilder = builder2.withRenderer((LookupElementRenderer)this).withExpensiveRenderer(this.getExpensiveRenderer());
        if (lookupElementBuilder == null) {
            JSLookupElementRenderer.$$$reportNull$$$0(3);
        }
        return lookupElementBuilder;
    }

    public void renderElement(LookupElement element, LookupElementPresentation presentation) {
        this.doRenderElement(element, presentation, (x, y) -> null);
    }

    private void doRenderElement(LookupElement element, LookupElementPresentation presentation, @NotNull @NotNull BiFunction<@Nullable LookupElement, @NotNull PsiElement, @Nullable JSLookupUtilImpl.TypeAndTail> tailEvaluator) {
        if (tailEvaluator == null) {
            JSLookupElementRenderer.$$$reportNull$$$0(4);
        }
        if (presentation instanceof JSLookupUtilImpl.BoldCheckingLookupElementPresentation) {
            return;
        }
        PsiElement value = JSLookupElementRenderer.getValidElement(element);
        if (!this.myParamsOnly) {
            presentation.setItemText(this.myName);
        }
        Icon icon = this.myIcon != null ? this.myIcon : JSLookupUtilImpl.getLookupElementIcon(value);
        presentation.setIcon(icon);
        presentation.setStrikeout(JSDocumentationUtils.isDeprecated(value));
        boolean isPartialLike = this.isPartialOrObjectMember(value);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            presentation.setItemTextBold(!isPartialLike);
        } else if (isPartialLike && icon != null) {
            Color color = UIUtil.toAlpha((Color)presentation.getItemTextForeground(), (int)150);
            presentation.setItemTextForeground(color);
            JSPartialIconService service = value == null ? null : JSPartialIconService.getInstance(value.getProject());
            presentation.setIcon(service != null ? service.getPartialIcon(icon) : icon);
        }
        if (value != null) {
            JSLookupUtilImpl.TypeAndTail data2 = tailEvaluator.apply(element, value);
            if (data2 != null) {
                this.renderTypeAndTail(presentation, data2, value, isPartialLike);
            }
        } else {
            Object object = element.getObject();
            if (object instanceof Collection) {
                Set types;
                List data3 = ContainerUtil.mapNotNull((Collection)((Collection)object), ptr -> {
                    if (!(ptr instanceof Pointer)) {
                        return null;
                    }
                    PsiElement mergedElement = (PsiElement)ObjectUtils.tryCast((Object)((Pointer)ptr).dereference(), PsiElement.class);
                    if (mergedElement == null || !mergedElement.isValid()) {
                        return null;
                    }
                    JSLookupUtilImpl.TypeAndTail typeAndTail = (JSLookupUtilImpl.TypeAndTail)tailEvaluator.apply(null, mergedElement);
                    if (typeAndTail == null) {
                        return null;
                    }
                    return Pair.create((Object)mergedElement, (Object)typeAndTail);
                });
                if (data3.size() == 1) {
                    this.renderTypeAndTail(presentation, (JSLookupUtilImpl.TypeAndTail)((Pair)data3.get((int)0)).second, (PsiElement)((Pair)data3.get((int)0)).first, isPartialLike);
                } else if (!data3.isEmpty() && (types = ContainerUtil.map2SetNotNull((Collection)data3, it -> ((JSLookupUtilImpl.TypeAndTail)it.second).typeText)).size() == 1) {
                    presentation.setTypeText((String)ContainerUtil.getFirstItem((Collection)types));
                }
            }
            presentation.setTailText(this.myTailPostfix, false);
        }
    }

    private boolean isPartialOrObjectMember(@Nullable PsiElement value) {
        if (this.myPartial) {
            return true;
        }
        if (!(value instanceof JSElementBase)) {
            return false;
        }
        JSQualifiedName namespace = ((JSElementBase)value).getNamespace();
        String name = namespace == null ? null : namespace.getQualifiedName();
        return "Object".equals(name);
    }

    private void renderTypeAndTail(@NotNull LookupElementPresentation presentation, @NotNull JSLookupUtilImpl.TypeAndTail data2, @Nullable PsiElement element, boolean isPartialLike) {
        if (presentation == null) {
            JSLookupElementRenderer.$$$reportNull$$$0(5);
        }
        if (data2 == null) {
            JSLookupElementRenderer.$$$reportNull$$$0(6);
        }
        presentation.setTypeText(data2.typeText);
        String location = (isPartialLike || JSLookupElementRenderer.shouldShowLocation(element)) && !StringUtil.isEmpty((String)data2.location) ? " " + data2.location : "";
        String tail = StringUtil.notNullize((String)data2.tailText) + StringUtil.notNullize((String)this.myTailPostfix) + location;
        if (this.myParamsOnly) {
            presentation.setItemText(StringUtil.trimEnd((String)StringUtil.trimStart((String)tail, (String)"("), (String)")"));
        } else {
            presentation.setTailText(tail, false);
        }
    }

    private static boolean shouldShowLocation(@Nullable PsiElement element) {
        if (JSItemPresentation.isLocalVariable(element) || JSItemPresentation.isLocalParameter(element)) {
            return false;
        }
        return element == null || !(JSResolveUtil.findParent(element) instanceof JSClass);
    }

    @Nullable
    public static PsiElement getValidElement(@NotNull LookupElement element) {
        PsiElement value;
        if (element == null) {
            JSLookupElementRenderer.$$$reportNull$$$0(7);
        }
        if ((value = element.getPsiElement()) != null && !value.isValid()) {
            value = null;
        }
        return value;
    }

    @NotNull
    public LookupElementBuilder applyToBuilderWithIcon(@NotNull LookupElementBuilder builder2, @NotNull Icon icon) {
        if (builder2 == null) {
            JSLookupElementRenderer.$$$reportNull$$$0(8);
        }
        if (icon == null) {
            JSLookupElementRenderer.$$$reportNull$$$0(9);
        }
        if (icon == this.myIcon && builder2.getRenderer() == this && builder2.getExpensiveRenderer() == this.getExpensiveRenderer()) {
            LookupElementBuilder lookupElementBuilder = builder2;
            if (lookupElementBuilder == null) {
                JSLookupElementRenderer.$$$reportNull$$$0(10);
            }
            return lookupElementBuilder;
        }
        LookupElementBuilder lookupElementBuilder = new JSLookupElementRenderer(this.myName, this.myPriority, this.myPartial, icon, this.myTailPostfix, this.myLookupContext, this.myParamsOnly).applyToBuilder(builder2);
        if (lookupElementBuilder == null) {
            JSLookupElementRenderer.$$$reportNull$$$0(11);
        }
        return lookupElementBuilder;
    }

    @NotNull
    public LookupElementBuilder applyToBuilderWithPartial(@NotNull LookupElementBuilder builder2, boolean partial) {
        if (builder2 == null) {
            JSLookupElementRenderer.$$$reportNull$$$0(12);
        }
        if (partial == this.myPartial && builder2.getRenderer() == this && builder2.getExpensiveRenderer() == this.getExpensiveRenderer()) {
            LookupElementBuilder lookupElementBuilder = builder2;
            if (lookupElementBuilder == null) {
                JSLookupElementRenderer.$$$reportNull$$$0(13);
            }
            return lookupElementBuilder;
        }
        LookupElementBuilder lookupElementBuilder = new JSLookupElementRenderer(this.myName, this.myPriority, partial, this.myIcon, this.myTailPostfix, this.myLookupContext, this.myParamsOnly).applyToBuilder(builder2);
        if (lookupElementBuilder == null) {
            JSLookupElementRenderer.$$$reportNull$$$0(14);
        }
        return lookupElementBuilder;
    }

    @NotNull
    public LookupElementRenderer<LookupElement> getExpensiveRenderer() {
        LookupElementRenderer<LookupElement> lookupElementRenderer = this.myExpensiveRenderer;
        if (lookupElementRenderer == null) {
            JSLookupElementRenderer.$$$reportNull$$$0(15);
        }
        return lookupElementRenderer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 10, 11, 13, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupContext";
                break;
            }
            case 2: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/completion/JSLookupElementRenderer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tailEvaluator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/completion/JSLookupElementRenderer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "applyToBuilder";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "applyToBuilderWithIcon";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "applyToBuilderWithPartial";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpensiveRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyToBuilder";
                break;
            }
            case 3: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doRenderElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "renderTypeAndTail";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getValidElement";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "applyToBuilderWithIcon";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "applyToBuilderWithPartial";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 10, 11, 13, 14, 15 -> new IllegalStateException(string);
        };
    }

    public class JSLookupElementExpensiveRenderer
    extends LookupElementRenderer<LookupElement> {
        public void renderElement(LookupElement element, LookupElementPresentation presentation) {
            JSLookupElementRenderer.this.doRenderElement(element, presentation, this::computeTypeAndTail);
        }

        @Nullable
        JSLookupUtilImpl.TypeAndTail computeTypeAndTail(@Nullable LookupElement lookupElement, @NotNull PsiElement element) {
            if (element == null) {
                JSLookupElementExpensiveRenderer.$$$reportNull$$$0(0);
            }
            ProgressManager.checkCanceled();
            if (!element.isValid() || DumbService.isDumb((Project)element.getProject())) {
                return null;
            }
            ApplicationManager.getApplication().assertIsNonDispatchThread();
            return JSLookupUtilImpl.getTypeAndTailTexts(lookupElement, element, JSLookupElementRenderer.this.myLookupContext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/completion/JSLookupElementRenderer$JSLookupElementExpensiveRenderer", "computeTypeAndTail"));
        }
    }
}

