/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.command.ListContainersCmd;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.core.command.AbstrDockerCmd;
import com.github.dockerjava.core.util.FiltersBuilder;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListContainersCmdImpl
extends AbstrDockerCmd<ListContainersCmd, List<Container>>
implements ListContainersCmd {
    private Integer limit = -1;
    private Boolean showSize;
    private Boolean showAll = false;
    private String sinceId;
    private String beforeId;
    private FiltersBuilder filters = new FiltersBuilder();

    public ListContainersCmdImpl(ListContainersCmd.Exec exec2) {
        super(exec2);
    }

    @Override
    public Integer getLimit() {
        return this.limit;
    }

    @Override
    public Boolean hasShowSizeEnabled() {
        return this.showSize;
    }

    @Override
    public Boolean hasShowAllEnabled() {
        return this.showAll;
    }

    @Override
    public String getSinceId() {
        return this.sinceId;
    }

    @Override
    public String getBeforeId() {
        return this.beforeId;
    }

    @Override
    public Map<String, List<String>> getFilters() {
        return this.filters.build();
    }

    @Override
    public ListContainersCmd withShowAll(Boolean showAll) {
        this.showAll = showAll;
        return this;
    }

    @Override
    public ListContainersCmd withShowSize(Boolean showSize) {
        this.showSize = showSize;
        return this;
    }

    @Override
    public ListContainersCmd withLimit(Integer limit) {
        Objects.requireNonNull(limit, "limit was not specified");
        Preconditions.checkArgument((limit > 0 ? 1 : 0) != 0, (Object)"limit must be greater 0");
        this.limit = limit;
        return this;
    }

    @Override
    public ListContainersCmd withSince(String since) {
        this.sinceId = Objects.requireNonNull(since, "since was not specified");
        return this;
    }

    @Override
    public ListContainersCmd withBefore(String before) {
        this.beforeId = Objects.requireNonNull(before, "before was not specified");
        return this;
    }

    @Override
    public ListContainersCmd withNameFilter(Collection<String> name2) {
        return this.withFilter("name", name2);
    }

    @Override
    public ListContainersCmd withIdFilter(Collection<String> id2) {
        return this.withFilter("id", id2);
    }

    @Override
    public ListContainersCmd withAncestorFilter(Collection<String> ancestor) {
        return this.withFilter("ancestor", ancestor);
    }

    @Override
    public ListContainersCmd withVolumeFilter(Collection<String> volume2) {
        return this.withFilter("volume", volume2);
    }

    @Override
    public ListContainersCmd withNetworkFilter(Collection<String> network2) {
        return this.withFilter("network", network2);
    }

    @Override
    public ListContainersCmd withLabelFilter(Collection<String> labels) {
        return this.withFilter("label", labels);
    }

    @Override
    public ListContainersCmd withLabelFilter(Map<String, String> labels) {
        Objects.requireNonNull(labels, "labels was not specified");
        this.filters.withLabels(labels);
        return this;
    }

    @Override
    public ListContainersCmd withExitedFilter(Integer exited) {
        Objects.requireNonNull(exited, "exited was not specified");
        this.filters.withFilter("exited", exited.toString());
        return this;
    }

    @Override
    public ListContainersCmd withFilter(String filterName, Collection<String> filterValues) {
        Objects.requireNonNull(filterValues, filterName + " was not specified");
        this.filters.withFilter(filterName, filterValues);
        return this;
    }

    @Override
    public ListContainersCmd withStatusFilter(Collection<String> status2) {
        Objects.requireNonNull(status2, "status was not specified");
        this.filters.withFilter("status", status2);
        return this;
    }
}

