/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.export;

import com.intellij.concurrency.ThreadContext;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramColors;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramElementManager;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNodeRenderer;
import com.intellij.diagram.DiagramNoteNode;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.components.DiagramNodeContainer;
import com.intellij.diagram.components.ScalableIconWrapper;
import com.intellij.diagram.util.DiagramExportService;
import com.intellij.diagram.util.DiagramIconUtil;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.geom.YPoint;
import com.intellij.openapi.graph.services.GraphEdgeRealizerService;
import com.intellij.openapi.graph.util.Futures;
import com.intellij.openapi.graph.view.Arrow;
import com.intellij.openapi.graph.view.EdgeLabel;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.NodeCellRenderer;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.uml.core.renderers.UmlNoteContainer;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009e\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0006\u0092\u0001\u0093\u0001\u0094\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010%\u001a\u00020&2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010'\u001a\u00020\u0004H\u0014J\b\u0010(\u001a\u00020\u000fH\u0014J\b\u0010)\u001a\u00020*H\u0016J\n\u0010+\u001a\u0004\u0018\u00010\u0004H\u0016J2\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010'\u001a\u00020\u00042\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020200H\u0016J\b\u00103\u001a\u000204H\u0014J\u001e\u00105\u001a\b\u0012\u0004\u0012\u0002040-2\u0006\u0010\b\u001a\u00020\t2\u0006\u00106\u001a\u000204H\u0014J\u001c\u00107\u001a\u000608j\u0002`9*\u000608j\u0002`92\u0006\u0010:\u001a\u00020\u001cH\u0004J\u001d\u0010;\u001a\u000608j\u0002`9*\u000608j\u0002`92\u0006\u0010<\u001a\u000204H\u0084\u0002J\u001d\u0010;\u001a\u000608j\u0002`9*\u000608j\u0002`92\u0006\u0010=\u001a\u00020>H\u0084\u0002J\u001d\u0010;\u001a\u000608j\u0002`9*\u000608j\u0002`92\u0006\u0010:\u001a\u00020\u001cH\u0084\u0002J&\u0010;\u001a\u000608j\u0002`9*\u000608j\u0002`92\f\u0010?\u001a\b\u0012\u0004\u0012\u00020&0@H\u0084\n\u00f8\u0001\u0000J\f\u0010A\u001a\u000204*\u000204H\u0014J\u0011\u0010B\u001a\u000704\u00a2\u0006\u0002\bC*\u000204H\u0014J\u0011\u0010D\u001a\u000704\u00a2\u0006\u0002\bC*\u000204H\u0014J\u0014\u0010E\u001a\u000204*\u0002042\u0006\u0010F\u001a\u00020\u001cH\u0014J\u0014\u0010G\u001a\u000608j\u0002`9*\u000608j\u0002`9H\u0014J\u0014\u0010H\u001a\u000608j\u0002`9*\u000608j\u0002`9H\u0014J\u0014\u0010I\u001a\u000608j\u0002`9*\u000608j\u0002`9H$J\u0014\u0010J\u001a\u000608j\u0002`9*\u000608j\u0002`9H$J \u0010K\u001a\u000608j\u0002`9*\u000608j\u0002`92\n\u0010L\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0014J \u0010M\u001a\u000608j\u0002`9*\u000608j\u0002`92\n\u0010N\u001a\u0006\u0012\u0002\b\u00030\"H\u0014J\u001c\u0010O\u001a\u000608j\u0002`9*\u000608j\u0002`92\u0006\u0010P\u001a\u00020\u001cH\u0014J\u001c\u0010Q\u001a\u000608j\u0002`9*\u000608j\u0002`92\u0006\u0010R\u001a\u00020\u001cH\u0014J \u0010S\u001a\u000608j\u0002`9*\u000608j\u0002`92\n\u0010L\u001a\u0006\u0012\u0002\b\u00030\u001bH$J \u0010T\u001a\u000608j\u0002`9*\u000608j\u0002`92\n\u0010L\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0014J\u001e\u0010U\u001a\u000608j\u0002`9*\u000608j\u0002`92\b\u0010V\u001a\u0004\u0018\u00010WH\u0014J\u0010\u0010X\u001a\u00020Y2\u0006\u0010Z\u001a\u00020[H\u0014J\u0010\u0010\\\u001a\u00020Y2\u0006\u0010V\u001a\u00020WH\u0014J\u0010\u0010]\u001a\u00020[2\u0006\u0010V\u001a\u00020WH\u0014J\u0014\u0010^\u001a\u00020_2\n\u0010L\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0002JA\u0010`\u001a\u000608j\u0002`9*\u000608j\u0002`92\n\u0010L\u001a\u0006\u0012\u0002\b\u00030\u001b2\u001f\u0010a\u001a\u001b\u0012\b\u0012\u000608j\u0002`9\u0012\b\u0012\u000608j\u0002`90b\u00a2\u0006\u0002\bcH$J(\u0010d\u001a\u000608j\u0002`9*\u000608j\u0002`92\n\u0010L\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010e\u001a\u00020fH$J(\u0010g\u001a\u000608j\u0002`9*\u000608j\u0002`92\n\u0010L\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010h\u001a\u00020iH$J(\u0010j\u001a\u000608j\u0002`9*\u000608j\u0002`92\n\u0010L\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010k\u001a\u00020lH$J6\u0010m\u001a\u000608j\u0002`9*\u000608j\u0002`92\f\u0010n\u001a\b\u0012\u0004\u0012\u00020p0o2\b\u0010q\u001a\u0004\u0018\u00010p2\b\u0010r\u001a\u0004\u0018\u00010pH\u0014J \u0010s\u001a\u000608j\u0002`9*\u000608j\u0002`92\n\u0010N\u001a\u0006\u0012\u0002\b\u00030\"H$J \u0010t\u001a\u000608j\u0002`9*\u000608j\u0002`92\n\u0010N\u001a\u0006\u0012\u0002\b\u00030\"H$J\u0014\u0010u\u001a\u000608j\u0002`9*\u000608j\u0002`9H$J \u0010v\u001a\u000608j\u0002`9*\u000608j\u0002`92\n\u0010N\u001a\u0006\u0012\u0002\b\u00030\"H$J\u0014\u0010w\u001a\u00020x2\n\u0010N\u001a\u0006\u0012\u0002\b\u00030\"H\u0014J \u0010y\u001a\u000608j\u0002`9*\u000608j\u0002`92\n\u0010N\u001a\u0006\u0012\u0002\b\u00030\"H$J \u0010z\u001a\u000608j\u0002`9*\u000608j\u0002`92\n\u0010N\u001a\u0006\u0012\u0002\b\u00030\"H\u0014J\u001a\u0010{\u001a\b\u0012\u0004\u0012\u00020}0|2\n\u0010N\u001a\u0006\u0012\u0002\b\u00030\"H\u0014JS\u0010~\u001a\u000608j\u0002`9*\u000608j\u0002`92\t\u0010\u007f\u001a\u0005\u0018\u00010\u0080\u00012\t\u0010\u0081\u0001\u001a\u0004\u0018\u00010}2\n\u0010N\u001a\u0006\u0012\u0002\b\u00030\"2\u0007\u0010\u0082\u0001\u001a\u00020\u001c2\b\u0010\u0083\u0001\u001a\u00030\u0084\u00012\b\u0010\u0085\u0001\u001a\u00030\u0086\u0001H$J)\u0010\u0087\u0001\u001a\u000608j\u0002`9*\u000608j\u0002`92\b\u0010\u0088\u0001\u001a\u00030\u0089\u00012\b\u0010\u0085\u0001\u001a\u00030\u0086\u0001H$J*\u0010\u008a\u0001\u001a\u000608j\u0002`9*\u000608j\u0002`92\b\u0010\u008b\u0001\u001a\u00030\u008c\u00012\t\b\u0002\u0010\u008d\u0001\u001a\u000204H$J!\u0010\u008e\u0001\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001040-2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010'\u001a\u00020\u0004H\u0016J\u0013\u0010\u008f\u0001\u001a\u0002042\b\u0010\u0090\u0001\u001a\u00030\u0091\u0001H$R\u0018\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0004X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R*\u0010\u0019\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b\u0012\u0004\u0012\u00020\u001c0\u001aX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R*\u0010!\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\"\u0012\u0004\u0012\u00020\u001c0\u001aX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001e\"\u0004\b$\u0010 \u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0095\u0001"}, d2={"Lcom/intellij/uml/export/BaseDiagramExporter;", "Lcom/intellij/diagram/util/DiagramExportService;", "supportedFormats", "", "Lcom/intellij/diagram/util/DiagramExportService$OutputFormat;", "<init>", "([Lcom/intellij/diagram/util/DiagramExportService$OutputFormat;)V", "[Lcom/intellij/diagram/util/DiagramExportService$OutputFormat;", "builder", "Lcom/intellij/diagram/DiagramBuilder;", "getBuilder", "()Lcom/intellij/diagram/DiagramBuilder;", "setBuilder", "(Lcom/intellij/diagram/DiagramBuilder;)V", "diagramType", "Lcom/intellij/uml/export/BaseDiagramExporter$DiagramType;", "getDiagramType", "()Lcom/intellij/uml/export/BaseDiagramExporter$DiagramType;", "setDiagramType", "(Lcom/intellij/uml/export/BaseDiagramExporter$DiagramType;)V", "requestedFormat", "getRequestedFormat", "()Lcom/intellij/diagram/util/DiagramExportService$OutputFormat;", "setRequestedFormat", "(Lcom/intellij/diagram/util/DiagramExportService$OutputFormat;)V", "node2Index", "", "Lcom/intellij/diagram/DiagramNode;", "", "getNode2Index", "()Ljava/util/Map;", "setNode2Index", "(Ljava/util/Map;)V", "edge2Index", "Lcom/intellij/diagram/DiagramEdge;", "getEdge2Index", "setEdge2Index", "initialize", "", "outputFormat", "guessDiagramType", "isExportInProgress", "", "getOutputFormatForCurrentExport", "runExportAsync", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "outputStreamSupplier", "Lcom/intellij/openapi/util/ThrowableComputable;", "Ljava/io/OutputStream;", "Ljava/io/IOException;", "exportToStringPreliminary", "", "formatOutput", "result", "append", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "i", "plus", "s", "c", "", "customAppend", "Lkotlin/Function0;", "escapeQuotes", "escapeXmlEntities", "Lorg/jetbrains/annotations/NotNull;", "removeHtmlTags", "wrapLinesAt", "maxLineLength", "appendGraphNodes", "appendGraphEdges", "appendGraphHeader", "appendGraphFooter", "appendNodeId", "node", "appendEdgeId", "edge", "appendLabelId", "labelIndex", "appendPortId", "portIndex", "appendNodeLayout", "appendNode", "appendIconAsBase64", "icon", "Ljavax/swing/Icon;", "imageToBytes", "", "image", "Ljava/awt/Image;", "iconToBytes", "toImage", "getNodeComponent", "Ljavax/swing/JComponent;", "appendNodeFromRenderedContainer", "appendContainer", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "appendNoteLikeContainer", "noteContainer", "Lcom/intellij/uml/core/renderers/UmlNoteContainer;", "appendLabelWithIconLikeContainer", "labelWithIconContainer", "Lcom/intellij/ui/SimpleColoredComponent;", "appendUmlLikeContainer", "umlNodeContainer", "Lcom/intellij/diagram/components/DiagramNodeContainer;", "appendUmlNodeItem", "elementManager", "Lcom/intellij/diagram/DiagramElementManager;", "", "element", "item", "appendEdgeLayout", "appendEdge", "appendEdgePaintingMode", "appendEdgeLineColor", "resolveEdgeColor", "Ljava/awt/Color;", "appendEdgeLineStyle", "appendEdgeLabels", "getEdgeLabels", "", "Lcom/intellij/openapi/graph/view/EdgeLabel;", "appendEdgeLabel", "label", "Lcom/intellij/diagram/DiagramRelationshipInfo$Label;", "graphLabel", "labelInd", "vLevel", "Lcom/intellij/uml/export/BaseDiagramExporter$VLevel;", "hLevel", "Lcom/intellij/uml/export/BaseDiagramExporter$HLevel;", "appendEdgeArrowType", "arrow", "Lcom/intellij/openapi/graph/view/Arrow;", "appendYPoint", "point", "Lcom/intellij/openapi/graph/geom/YPoint;", "extraAttributes", "generateUrlToOpenInWebEditorAsync", "generateUrl", "renderedGraph", "Ljava/io/ByteArrayInputStream;", "DiagramType", "VLevel", "HLevel", "intellij.diagram.impl"})
@SourceDebugExtension(value={"SMAP\nBaseDiagramExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseDiagramExporter.kt\ncom/intellij/uml/export/BaseDiagramExporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Futures.kt\ncom/intellij/openapi/graph/util/Futures\n*L\n1#1,448:1\n1216#2,2:449\n1246#2,4:451\n1216#2,2:455\n1246#2,4:457\n1557#2:462\n1628#2,3:463\n1557#2:466\n1628#2,3:467\n1#3:461\n224#4,4:470\n100#4,7:474\n*S KotlinDebug\n*F\n+ 1 BaseDiagramExporter.kt\ncom/intellij/uml/export/BaseDiagramExporter\n*L\n61#1:449,2\n61#1:451,4\n62#1:455,2\n62#1:457,4\n150#1:462\n150#1:463,3\n402#1:466\n402#1:467,3\n101#1:470,4\n110#1:474,7\n*E\n"})
public abstract class BaseDiagramExporter
implements DiagramExportService {
    @NotNull
    private final DiagramExportService.OutputFormat[] supportedFormats;
    protected DiagramBuilder builder;
    protected DiagramType diagramType;
    protected DiagramExportService.OutputFormat requestedFormat;
    protected Map<DiagramNode<?>, Integer> node2Index;
    protected Map<DiagramEdge<?>, Integer> edge2Index;

    public BaseDiagramExporter(DiagramExportService.OutputFormat ... supportedFormats) {
        Intrinsics.checkNotNullParameter((Object)supportedFormats, (String)"supportedFormats");
        this.supportedFormats = supportedFormats;
    }

    @NotNull
    protected final DiagramBuilder getBuilder() {
        DiagramBuilder diagramBuilder = this.builder;
        if (diagramBuilder != null) {
            return diagramBuilder;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
        return null;
    }

    protected final void setBuilder(@NotNull DiagramBuilder diagramBuilder) {
        Intrinsics.checkNotNullParameter((Object)diagramBuilder, (String)"<set-?>");
        this.builder = diagramBuilder;
    }

    @NotNull
    protected final DiagramType getDiagramType() {
        DiagramType diagramType = this.diagramType;
        if (diagramType != null) {
            return diagramType;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"diagramType");
        return null;
    }

    protected final void setDiagramType(@NotNull DiagramType diagramType) {
        Intrinsics.checkNotNullParameter((Object)((Object)diagramType), (String)"<set-?>");
        this.diagramType = diagramType;
    }

    @NotNull
    protected final DiagramExportService.OutputFormat getRequestedFormat() {
        DiagramExportService.OutputFormat outputFormat = this.requestedFormat;
        if (outputFormat != null) {
            return outputFormat;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"requestedFormat");
        return null;
    }

    protected final void setRequestedFormat(@NotNull DiagramExportService.OutputFormat outputFormat) {
        Intrinsics.checkNotNullParameter((Object)((Object)outputFormat), (String)"<set-?>");
        this.requestedFormat = outputFormat;
    }

    @NotNull
    protected final Map<DiagramNode<?>, Integer> getNode2Index() {
        Map<DiagramNode<?>, Integer> map = this.node2Index;
        if (map != null) {
            return map;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"node2Index");
        return null;
    }

    protected final void setNode2Index(@NotNull Map<DiagramNode<?>, Integer> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.node2Index = map;
    }

    @NotNull
    protected final Map<DiagramEdge<?>, Integer> getEdge2Index() {
        Map<DiagramEdge<?>, Integer> map = this.edge2Index;
        if (map != null) {
            return map;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"edge2Index");
        return null;
    }

    protected final void setEdge2Index(@NotNull Map<DiagramEdge<?>, Integer> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.edge2Index = map;
    }

    protected void initialize(@NotNull DiagramBuilder builder, @NotNull DiagramExportService.OutputFormat outputFormat) {
        Integer n;
        Object object;
        IndexedValue it;
        Map map;
        Iterable $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)((Object)outputFormat), (String)"outputFormat");
        if (!ArraysKt.contains((Object[])this.supportedFormats, (Object)((Object)outputFormat))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.setBuilder(builder);
        this.setDiagramType(this.guessDiagramType());
        this.setRequestedFormat(outputFormat);
        Collection<DiagramNode<?>> collection = builder.getNodeObjects();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getNodeObjects(...)");
        Iterable iterable = CollectionsKt.withIndex((Iterable)collection);
        BaseDiagramExporter baseDiagramExporter = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var6_8 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            IndexedValue indexedValue = (IndexedValue)element$iv$iv;
            map = destination$iv$iv;
            boolean bl = false;
            Object object2 = it.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"<get-value>(...)");
            it = (IndexedValue)element$iv$iv;
            object = (DiagramNode)object2;
            boolean bl2 = false;
            n = it.getIndex();
            map.put(object, n);
        }
        baseDiagramExporter.setNode2Index(destination$iv$iv);
        Collection<DiagramEdge<?>> collection2 = builder.getEdgeObjects();
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"getEdgeObjects(...)");
        $this$associateBy$iv = CollectionsKt.withIndex((Iterable)collection2);
        baseDiagramExporter = this;
        $i$f$associateBy = false;
        capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        $this$associateByTo$iv$iv = $this$associateBy$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            it = (IndexedValue)element$iv$iv;
            map = destination$iv$iv;
            boolean bl = false;
            Object object3 = it.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"<get-value>(...)");
            it = (IndexedValue)element$iv$iv;
            object = (DiagramEdge)object3;
            boolean bl3 = false;
            n = it.getIndex();
            map.put(object, n);
        }
        baseDiagramExporter.setEdge2Index(destination$iv$iv);
    }

    @NotNull
    protected DiagramType guessDiagramType() {
        DiagramType diagramType;
        DiagramType diagramType2;
        block2: {
            Collection<DiagramNode<?>> collection = this.getBuilder().getNodeObjects();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getNodeObjects(...)");
            for (DiagramNode it : (Iterable)collection) {
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                JComponent jComponent = this.getNodeComponent(it);
                DiagramType diagramType3 = jComponent instanceof DiagramNodeContainer ? DiagramType.UML : (jComponent instanceof SimpleColoredComponent ? DiagramType.FLOWCHART : null);
                if (diagramType3 == null) continue;
                diagramType2 = diagramType3;
                break block2;
            }
            diagramType2 = diagramType = null;
        }
        if (diagramType2 == null) {
            diagramType = DiagramType.UML;
        }
        return diagramType;
    }

    @Override
    public boolean isExportInProgress() {
        return DiagramExportService.getInstance().isExportInProgress();
    }

    @Override
    @Nullable
    public DiagramExportService.OutputFormat getOutputFormatForCurrentExport() {
        return DiagramExportService.getInstance().getOutputFormatForCurrentExport();
    }

    @Override
    @NotNull
    public CompletableFuture<Void> runExportAsync(@NotNull DiagramBuilder builder, @NotNull DiagramExportService.OutputFormat outputFormat, @NotNull ThrowableComputable<OutputStream, IOException> outputStreamSupplier) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)((Object)outputFormat), (String)"outputFormat");
        Intrinsics.checkNotNullParameter(outputStreamSupplier, (String)"outputStreamSupplier");
        Project project = builder.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        String string = DiagramBundle.message("diagram.export.progress", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return Futures.runAsyncProgressInBackground$default((Project)project, (String)string, (boolean)true, (PerformInBackgroundOption)PerformInBackgroundOption.DEAF, null, arg_0 -> BaseDiagramExporter.runExportAsync$lambda$10(arg_0 -> BaseDiagramExporter.runExportAsync$lambda$9(builder, this, outputFormat, outputStreamSupplier, arg_0), arg_0), (int)16, null);
    }

    @NotNull
    protected String exportToStringPreliminary() {
        StringBuilder stringBuilder;
        StringBuilder $this$exportToStringPreliminary_u24lambda_u2411 = stringBuilder = new StringBuilder();
        boolean bl = false;
        this.appendGraphHeader($this$exportToStringPreliminary_u24lambda_u2411);
        this.appendGraphNodes($this$exportToStringPreliminary_u24lambda_u2411);
        this.appendGraphEdges($this$exportToStringPreliminary_u24lambda_u2411);
        this.appendGraphFooter($this$exportToStringPreliminary_u24lambda_u2411);
        return stringBuilder.toString();
    }

    @NotNull
    protected CompletableFuture<String> formatOutput(@NotNull DiagramBuilder builder, @NotNull String result) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        CompletableFuture<String> completableFuture = CompletableFuture.supplyAsync(() -> BaseDiagramExporter.formatOutput$lambda$12(result), AppExecutorUtil.getAppExecutorService());
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(...)");
        return completableFuture;
    }

    @NotNull
    protected final Appendable append(@NotNull Appendable $this$append, int i) {
        Intrinsics.checkNotNullParameter((Object)$this$append, (String)"<this>");
        Appendable appendable = $this$append.append(String.valueOf(i));
        Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
        return appendable;
    }

    @NotNull
    protected final Appendable plus(@NotNull Appendable $this$plus, @NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Appendable appendable = $this$plus.append(s);
        Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
        return appendable;
    }

    @NotNull
    protected final Appendable plus(@NotNull Appendable $this$plus, char c) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Appendable appendable = $this$plus.append(c);
        Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
        return appendable;
    }

    @NotNull
    protected final Appendable plus(@NotNull Appendable $this$plus, int i) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Appendable appendable = $this$plus.append(String.valueOf(i));
        Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
        return appendable;
    }

    @NotNull
    protected final Appendable plus(@NotNull Appendable $this$plus, @NotNull Function0<Unit> customAppend) {
        Appendable appendable;
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter(customAppend, (String)"customAppend");
        boolean $i$f$plus = false;
        Appendable it = appendable = $this$plus;
        boolean bl = false;
        customAppend.invoke();
        return appendable;
    }

    @NotNull
    protected String escapeQuotes(@NotNull String $this$escapeQuotes) {
        Intrinsics.checkNotNullParameter((Object)$this$escapeQuotes, (String)"<this>");
        return StringsKt.replace$default((String)$this$escapeQuotes, (String)"\"", (String)"\\\"", (boolean)false, (int)4, null);
    }

    @NotNull
    protected String escapeXmlEntities(@NotNull String $this$escapeXmlEntities) {
        Intrinsics.checkNotNullParameter((Object)$this$escapeXmlEntities, (String)"<this>");
        String string = StringUtil.escapeXmlEntities((String)$this$escapeXmlEntities);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeXmlEntities(...)");
        return string;
    }

    @NotNull
    protected String removeHtmlTags(@NotNull String $this$removeHtmlTags) {
        Intrinsics.checkNotNullParameter((Object)$this$removeHtmlTags, (String)"<this>");
        String string = StringUtil.removeHtmlTags((String)$this$removeHtmlTags);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"removeHtmlTags(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected String wrapLinesAt(@NotNull String $this$wrapLinesAt, int maxLineLength) {
        StringBuilder stringBuilder;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$wrapLinesAt, (String)"<this>");
        String[] stringArray = new String[]{"\n"};
        List initialLines = StringsKt.split$default((CharSequence)$this$wrapLinesAt, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        Iterable $this$map$iv = initialLines;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void line;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String[] stringArray2 = new String[]{" "};
            List words = StringsKt.split$default((CharSequence)((CharSequence)line), (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            List wrappedLines = new ArrayList();
            List currentLine = new ArrayList();
            int currentLineLength = 0;
            for (String word : words) {
                ((Collection)currentLine).add(word);
                if ((currentLineLength += word.length()) + word.length() <= maxLineLength) continue;
                wrappedLines.add(currentLine);
                currentLine = new ArrayList();
                currentLineLength = 0;
            }
            if (currentLineLength > 0) {
                wrappedLines.add(currentLine);
            }
            collection.add(wrappedLines);
        }
        List resultChunks = (List)destination$iv$iv;
        StringBuilder $this$wrapLinesAt_u24lambda_u2417 = stringBuilder = new StringBuilder();
        boolean bl = false;
        CollectionsKt.joinTo$default((Iterable)resultChunks, (Appendable)$this$wrapLinesAt_u24lambda_u2417, (CharSequence)"\n", null, null, (int)0, null, arg_0 -> BaseDiagramExporter.wrapLinesAt$lambda$17$lambda$16($this$wrapLinesAt_u24lambda_u2417, arg_0), (int)60, null);
        return stringBuilder.toString();
    }

    @NotNull
    protected Appendable appendGraphNodes(@NotNull Appendable $this$appendGraphNodes) {
        Intrinsics.checkNotNullParameter((Object)$this$appendGraphNodes, (String)"<this>");
        this.getBuilder().getActionExecutor().runReadAction(() -> BaseDiagramExporter.appendGraphNodes$lambda$20(this, $this$appendGraphNodes));
        $this$appendGraphNodes.append('\n');
        return $this$appendGraphNodes;
    }

    @NotNull
    protected Appendable appendGraphEdges(@NotNull Appendable $this$appendGraphEdges) {
        Intrinsics.checkNotNullParameter((Object)$this$appendGraphEdges, (String)"<this>");
        this.getBuilder().getActionExecutor().runReadAction(() -> BaseDiagramExporter.appendGraphEdges$lambda$23(this, $this$appendGraphEdges));
        return $this$appendGraphEdges;
    }

    @NotNull
    protected abstract Appendable appendGraphHeader(@NotNull Appendable var1);

    @NotNull
    protected abstract Appendable appendGraphFooter(@NotNull Appendable var1);

    @NotNull
    protected Appendable appendNodeId(@NotNull Appendable $this$appendNodeId, @NotNull DiagramNode<?> node) {
        Intrinsics.checkNotNullParameter((Object)$this$appendNodeId, (String)"<this>");
        Intrinsics.checkNotNullParameter(node, (String)"node");
        Integer n = this.getNode2Index().get(node);
        Intrinsics.checkNotNull((Object)n);
        Appendable appendable = $this$appendNodeId.append("node" + n);
        Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
        return appendable;
    }

    @NotNull
    protected Appendable appendEdgeId(@NotNull Appendable $this$appendEdgeId, @NotNull DiagramEdge<?> edge) {
        Intrinsics.checkNotNullParameter((Object)$this$appendEdgeId, (String)"<this>");
        Intrinsics.checkNotNullParameter(edge, (String)"edge");
        Integer n = this.getEdge2Index().get(edge);
        Intrinsics.checkNotNull((Object)n);
        Appendable appendable = $this$appendEdgeId.append("edge" + n);
        Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
        return appendable;
    }

    @NotNull
    protected Appendable appendLabelId(@NotNull Appendable $this$appendLabelId, int labelIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$appendLabelId, (String)"<this>");
        Appendable appendable = $this$appendLabelId.append("label" + labelIndex);
        Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
        return appendable;
    }

    @NotNull
    protected Appendable appendPortId(@NotNull Appendable $this$appendPortId, int portIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$appendPortId, (String)"<this>");
        Appendable appendable = $this$appendPortId.append("port" + portIndex);
        Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
        return appendable;
    }

    @NotNull
    protected abstract Appendable appendNodeLayout(@NotNull Appendable var1, @NotNull DiagramNode<?> var2);

    @NotNull
    protected Appendable appendNode(@NotNull Appendable $this$appendNode, @NotNull DiagramNode<?> node) {
        Intrinsics.checkNotNullParameter((Object)$this$appendNode, (String)"<this>");
        Intrinsics.checkNotNullParameter(node, (String)"node");
        JComponent nodeComponent = this.getNodeComponent(node);
        Function1 appendContainer = arg_0 -> BaseDiagramExporter.appendNode$lambda$24(nodeComponent, this, node, arg_0);
        return this.appendNodeFromRenderedContainer($this$appendNode, node, (Function1<? super Appendable, ? extends Appendable>)appendContainer);
    }

    @NotNull
    protected Appendable appendIconAsBase64(@NotNull Appendable $this$appendIconAsBase64, @Nullable Icon icon) {
        Intrinsics.checkNotNullParameter((Object)$this$appendIconAsBase64, (String)"<this>");
        if (icon == null) {
            return $this$appendIconAsBase64;
        }
        Object it = icon;
        boolean bl = false;
        Icon icon2 = ScalableIconWrapper.unwrap((Icon)it);
        Intrinsics.checkNotNull((Object)icon2);
        it = icon2;
        boolean bl2 = false;
        it = DiagramIconUtil.deepScaleTo((Icon)it, 2.0f);
        boolean bl3 = false;
        Intrinsics.checkNotNull((Object)it);
        it = this.iconToBytes((Icon)it);
        boolean bl4 = false;
        String encodedIcon = Base64.getEncoder().encodeToString((byte[])it);
        Appendable appendable = this.plus($this$appendIconAsBase64, "data:image/png,");
        Intrinsics.checkNotNull((Object)encodedIcon);
        return this.plus(appendable, encodedIcon);
    }

    @NotNull
    protected byte[] imageToBytes(@NotNull Image image) throws IOException {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        BufferedImage bi = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g = bi.createGraphics();
        g.drawImage(image, 0, 0, null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bi, "png", baos);
        g.dispose();
        byte[] byArray = baos.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }

    @NotNull
    protected byte[] iconToBytes(@NotNull Icon icon) throws IOException {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        return this.imageToBytes(this.toImage(icon));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected Image toImage(@NotNull Icon icon) {
        Image image;
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        if (icon instanceof ImageIcon) {
            Image image2 = ((ImageIcon)icon).getImage();
            Intrinsics.checkNotNull((Object)image2);
            image = image2;
        } else {
            void var3_4;
            BufferedImage image3 = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(icon.getIconWidth(), icon.getIconHeight(), 3);
            Graphics2D g = image3.createGraphics();
            icon.paintIcon(null, g, 0, 0);
            g.dispose();
            void var2_3 = var3_4;
            Intrinsics.checkNotNull((Object)var2_3);
            image = (Image)var2_3;
        }
        return image;
    }

    private final JComponent getNodeComponent(DiagramNode<?> node) {
        JComponent jComponent;
        Node node2 = this.getBuilder().getNode(node);
        Intrinsics.checkNotNull((Object)node2);
        Node graphNode = node2;
        DiagramNodeRenderer diagramNodeRenderer = this.getBuilder().getPresentationModel().getRenderer();
        Intrinsics.checkNotNull((Object)diagramNodeRenderer, (String)"null cannot be cast to non-null type com.intellij.openapi.graph.view.NodeCellRenderer");
        NodeCellRenderer renderer = (NodeCellRenderer)diagramNodeRenderer;
        NodeRealizer realizer = this.getBuilder().getGraph().getRealizer(graphNode);
        JComponent component = renderer.getNodeCellRendererComponent(this.getBuilder().getView(), realizer, null, this.getBuilder().getGraph().isSelected(graphNode));
        UmlNoteContainer noteContainer = (UmlNoteContainer)UIUtil.findComponentOfType((JComponent)component, UmlNoteContainer.class);
        DiagramNodeContainer umlNodeContainer = (DiagramNodeContainer)((Object)UIUtil.findComponentOfType((JComponent)component, DiagramNodeContainer.class));
        SimpleColoredComponent labelWithIconContainer = (SimpleColoredComponent)UIUtil.findComponentOfType((JComponent)component, SimpleColoredComponent.class);
        UmlNoteContainer umlNoteContainer = noteContainer;
        if (umlNoteContainer != null) {
            jComponent = umlNoteContainer;
        } else {
            DiagramNodeContainer diagramNodeContainer = umlNodeContainer;
            if (diagramNodeContainer != null) {
                jComponent = (JComponent)((Object)diagramNodeContainer);
            } else {
                SimpleColoredComponent simpleColoredComponent = labelWithIconContainer;
                if (simpleColoredComponent != null) {
                    jComponent = (JComponent)simpleColoredComponent;
                } else {
                    throw new IllegalStateException("Unknown node shape".toString());
                }
            }
        }
        return jComponent;
    }

    @NotNull
    protected abstract Appendable appendNodeFromRenderedContainer(@NotNull Appendable var1, @NotNull DiagramNode<?> var2, @NotNull Function1<? super Appendable, ? extends Appendable> var3);

    @NotNull
    protected abstract Appendable appendNoteLikeContainer(@NotNull Appendable var1, @NotNull DiagramNode<?> var2, @NotNull UmlNoteContainer var3);

    @NotNull
    protected abstract Appendable appendLabelWithIconLikeContainer(@NotNull Appendable var1, @NotNull DiagramNode<?> var2, @NotNull SimpleColoredComponent var3);

    @NotNull
    protected abstract Appendable appendUmlLikeContainer(@NotNull Appendable var1, @NotNull DiagramNode<?> var2, @NotNull DiagramNodeContainer var3);

    @NotNull
    protected Appendable appendUmlNodeItem(@NotNull Appendable $this$appendUmlNodeItem, @NotNull DiagramElementManager<Object> elementManager, @Nullable Object element, @Nullable Object item) {
        Object object;
        Object itemText;
        Object object2;
        Object iconText;
        Intrinsics.checkNotNullParameter((Object)$this$appendUmlNodeItem, (String)"<this>");
        Intrinsics.checkNotNullParameter(elementManager, (String)"elementManager");
        Object object3 = elementManager.getItemIconAsText(element, item, this.getBuilder());
        if (object3 == null || (object3 = object3.toString()) == null) {
            object3 = iconText = "";
        }
        if ((object2 = elementManager.getItemName(element, item, this.getBuilder())) == null || (object2 = object2.toString()) == null) {
            object2 = itemText = "";
        }
        if ((object = elementManager.getItemType(element, item, this.getBuilder())) == null || (object = object.toString()) == null) {
            object = "";
        }
        Object typeText = object;
        return this.plus(this.plus(this.plus(this.plus(this.plus($this$appendUmlNodeItem, (String)iconText), " "), (String)itemText), ": "), (String)typeText);
    }

    @NotNull
    protected abstract Appendable appendEdgeLayout(@NotNull Appendable var1, @NotNull DiagramEdge<?> var2);

    @NotNull
    protected abstract Appendable appendEdge(@NotNull Appendable var1, @NotNull DiagramEdge<?> var2);

    @NotNull
    protected abstract Appendable appendEdgePaintingMode(@NotNull Appendable var1);

    @NotNull
    protected abstract Appendable appendEdgeLineColor(@NotNull Appendable var1, @NotNull DiagramEdge<?> var2);

    @NotNull
    protected Color resolveEdgeColor(@NotNull DiagramEdge<?> edge) {
        Object object;
        Object resultColor;
        Object object2;
        EditorColorsScheme lightScheme;
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter(edge, (String)"edge");
                ColorKey colorKey = this.getBuilder().getProvider().getColorManager().getEdgeColorKey(this.getBuilder(), edge);
                lightScheme = EditorColorsManager.getInstance().getScheme(EditorColorsManager.getDefaultSchemeName());
                object2 = colorKey;
                if (object2 == null) break block7;
                ColorKey it = object2;
                boolean bl = false;
                Color color = lightScheme.getColor(it);
                object2 = color;
                if (color != null) break block8;
            }
            Color color = this.getBuilder().getProvider().getColorManager().getEdgeColor(this.getBuilder(), edge);
            object2 = color;
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getEdgeColor(...)");
        }
        if (Intrinsics.areEqual((Object)(resultColor = object2), (Object)DiagramColors.DEFAULT_EDGE.getDefaultColor())) {
            object = lightScheme.getColor(DiagramColors.DEFAULT_EDGE);
            if (object == null) {
                object = resultColor;
            }
        } else {
            object = resultColor;
        }
        return object;
    }

    @NotNull
    protected abstract Appendable appendEdgeLineStyle(@NotNull Appendable var1, @NotNull DiagramEdge<?> var2);

    @NotNull
    protected Appendable appendEdgeLabels(@NotNull Appendable $this$appendEdgeLabels, @NotNull DiagramEdge<?> edge) {
        Object v7;
        Object var15_15;
        BaseDiagramExporter baseDiagramExporter;
        Appendable appendable;
        DiagramRelationshipInfo.Label label;
        int edgeInd;
        block11: {
            Object v6;
            EdgeLabel it;
            Iterable iterable;
            Iterable iterable2;
            List graphEdges;
            DiagramRelationshipInfo relationship;
            block10: {
                Object v5;
                block9: {
                    Object v4;
                    block8: {
                        Object v3;
                        block7: {
                            Object v2;
                            block6: {
                                Intrinsics.checkNotNullParameter((Object)$this$appendEdgeLabels, (String)"<this>");
                                Intrinsics.checkNotNullParameter(edge, (String)"edge");
                                DiagramRelationshipInfo diagramRelationshipInfo = edge.getRelationship();
                                Intrinsics.checkNotNullExpressionValue((Object)diagramRelationshipInfo, (String)"getRelationship(...)");
                                relationship = diagramRelationshipInfo;
                                Integer n = this.getEdge2Index().get(edge);
                                Intrinsics.checkNotNull((Object)n);
                                edgeInd = ((Number)n).intValue();
                                graphEdges = CollectionsKt.toMutableList((Collection)this.getEdgeLabels(edge));
                                iterable2 = graphEdges;
                                label = relationship.getUpperSourceLabel();
                                appendable = $this$appendEdgeLabels;
                                baseDiagramExporter = this;
                                iterable = iterable2;
                                for (Object t : iterable) {
                                    it = (EdgeLabel)t;
                                    boolean bl = false;
                                    if (!GraphManager.getGraphManager().arePhysicalyEqual((Object)it.getPreferredPlacementDescriptor(), (Object)GraphEdgeRealizerService.getInstance().getUpperSourceDescriptor())) continue;
                                    v2 = t;
                                    break block6;
                                }
                                v2 = null;
                            }
                            var15_15 = v2;
                            baseDiagramExporter.appendEdgeLabel(appendable, label, var15_15, edge, edgeInd * 6 + 0, VLevel.TOP, HLevel.SOURCE);
                            iterable2 = graphEdges;
                            label = relationship.getBottomSourceLabel();
                            appendable = $this$appendEdgeLabels;
                            baseDiagramExporter = this;
                            iterable = iterable2;
                            for (Object t : iterable) {
                                it = (EdgeLabel)t;
                                boolean bl = false;
                                if (!GraphManager.getGraphManager().arePhysicalyEqual((Object)it.getPreferredPlacementDescriptor(), (Object)GraphEdgeRealizerService.getInstance().getBottomSourceDescriptor())) continue;
                                v3 = t;
                                break block7;
                            }
                            v3 = null;
                        }
                        var15_15 = v3;
                        baseDiagramExporter.appendEdgeLabel(appendable, label, var15_15, edge, edgeInd * 6 + 1, VLevel.BOTTOM, HLevel.SOURCE);
                        iterable2 = graphEdges;
                        label = relationship.getUpperCenterLabel();
                        appendable = $this$appendEdgeLabels;
                        baseDiagramExporter = this;
                        iterable = iterable2;
                        for (Object t : iterable) {
                            it = (EdgeLabel)t;
                            boolean bl = false;
                            if (!GraphManager.getGraphManager().arePhysicalyEqual((Object)it.getPreferredPlacementDescriptor(), (Object)GraphEdgeRealizerService.getInstance().getUpperCenterDescriptor())) continue;
                            v4 = t;
                            break block8;
                        }
                        v4 = null;
                    }
                    var15_15 = v4;
                    baseDiagramExporter.appendEdgeLabel(appendable, label, var15_15, edge, edgeInd * 6 + 2, VLevel.TOP, HLevel.CENTER);
                    iterable2 = graphEdges;
                    label = relationship.getBottomCenterLabel();
                    appendable = $this$appendEdgeLabels;
                    baseDiagramExporter = this;
                    iterable = iterable2;
                    for (Object t : iterable) {
                        it = (EdgeLabel)t;
                        boolean bl = false;
                        if (!GraphManager.getGraphManager().arePhysicalyEqual((Object)it.getPreferredPlacementDescriptor(), (Object)GraphEdgeRealizerService.getInstance().getBottomCenterDescriptor())) continue;
                        v5 = t;
                        break block9;
                    }
                    v5 = null;
                }
                var15_15 = v5;
                baseDiagramExporter.appendEdgeLabel(appendable, label, var15_15, edge, edgeInd * 6 + 3, VLevel.BOTTOM, HLevel.CENTER);
                iterable2 = graphEdges;
                label = relationship.getUpperTargetLabel();
                appendable = $this$appendEdgeLabels;
                baseDiagramExporter = this;
                iterable = iterable2;
                for (Object t : iterable) {
                    it = (EdgeLabel)t;
                    boolean bl = false;
                    if (!GraphManager.getGraphManager().arePhysicalyEqual((Object)it.getPreferredPlacementDescriptor(), (Object)GraphEdgeRealizerService.getInstance().getUpperTargetDescriptor())) continue;
                    v6 = t;
                    break block10;
                }
                v6 = null;
            }
            var15_15 = v6;
            baseDiagramExporter.appendEdgeLabel(appendable, label, var15_15, edge, edgeInd * 6 + 4, VLevel.TOP, HLevel.TARGET);
            iterable2 = graphEdges;
            label = relationship.getBottomTargetLabel();
            appendable = $this$appendEdgeLabels;
            baseDiagramExporter = this;
            iterable = iterable2;
            for (Object t : iterable) {
                it = (EdgeLabel)t;
                boolean bl = false;
                if (!GraphManager.getGraphManager().arePhysicalyEqual((Object)it.getPreferredPlacementDescriptor(), (Object)GraphEdgeRealizerService.getInstance().getBottomTargetDescriptor())) continue;
                v7 = t;
                break block11;
            }
            v7 = null;
        }
        var15_15 = v7;
        baseDiagramExporter.appendEdgeLabel(appendable, label, var15_15, edge, edgeInd * 6 + 5, VLevel.BOTTOM, HLevel.TARGET);
        return $this$appendEdgeLabels;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<EdgeLabel> getEdgeLabels(@NotNull DiagramEdge<?> edge) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(edge, (String)"edge");
        Graph2D graph2D = this.getBuilder().getGraph();
        Edge edge2 = this.getBuilder().getEdge(edge);
        Intrinsics.checkNotNull((Object)edge2);
        EdgeRealizer realizer = graph2D.getRealizer(edge2);
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)realizer.labelCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(realizer.getLabel((int)it));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    protected abstract Appendable appendEdgeLabel(@NotNull Appendable var1, @Nullable DiagramRelationshipInfo.Label var2, @Nullable EdgeLabel var3, @NotNull DiagramEdge<?> var4, int var5, @NotNull VLevel var6, @NotNull HLevel var7);

    @NotNull
    protected abstract Appendable appendEdgeArrowType(@NotNull Appendable var1, @NotNull Arrow var2, @NotNull HLevel var3);

    @NotNull
    protected abstract Appendable appendYPoint(@NotNull Appendable var1, @NotNull YPoint var2, @NotNull String var3);

    public static /* synthetic */ Appendable appendYPoint$default(BaseDiagramExporter baseDiagramExporter, Appendable appendable, YPoint yPoint, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: appendYPoint");
        }
        if ((n & 2) != 0) {
            string = "";
        }
        return baseDiagramExporter.appendYPoint(appendable, yPoint, string);
    }

    @Override
    @NotNull
    public CompletableFuture<String> generateUrlToOpenInWebEditorAsync(@NotNull DiagramBuilder builder, @NotNull DiagramExportService.OutputFormat outputFormat) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)((Object)outputFormat), (String)"outputFormat");
        if (!ArraysKt.contains((Object[])this.supportedFormats, (Object)((Object)outputFormat))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        CompletionStage completionStage = this.runExportAsync(builder, outputFormat, (ThrowableComputable<OutputStream, IOException>)((ThrowableComputable)() -> BaseDiagramExporter.generateUrlToOpenInWebEditorAsync$lambda$37(buffer))).thenApplyAsync(ThreadContext.captureThreadContext(arg_0 -> BaseDiagramExporter.generateUrlToOpenInWebEditorAsync$lambda$38(buffer, this, arg_0)));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApplyAsync(...)");
        return completionStage;
    }

    @NotNull
    protected abstract String generateUrl(@NotNull ByteArrayInputStream var1);

    private static final CompletableFuture runExportAsync$lambda$9$lambda$6(BaseDiagramExporter this$0, DiagramBuilder $builder, String it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.formatOutput($builder, it);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void runExportAsync$lambda$9$lambda$8(ThrowableComputable $outputStreamSupplier, String renderedGraph) {
        Object object = $outputStreamSupplier.compute();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        Closeable closeable = (OutputStream)object;
        Object object2 = Charsets.UTF_8;
        Writer writer = new OutputStreamWriter((OutputStream)closeable, (Charset)object2);
        int n = 8192;
        closeable = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n);
        object2 = null;
        try {
            BufferedWriter it = (BufferedWriter)closeable;
            boolean bl = false;
            it.append(renderedGraph);
            writer = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
        }
    }

    private static final CompletableFuture runExportAsync$lambda$9(DiagramBuilder $builder, BaseDiagramExporter this$0, DiagramExportService.OutputFormat $outputFormat, ThrowableComputable $outputStreamSupplier, ProgressIndicator it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ModalityState modalityState$iv = null;
        boolean $i$f$runInEdtAsync = false;
        CompletableFuture completableFuture = CompletableFuture.supplyAsync(new Supplier($builder, this$0, $outputFormat){
            final /* synthetic */ DiagramBuilder $builder$inlined;
            final /* synthetic */ BaseDiagramExporter this$0;
            final /* synthetic */ DiagramExportService.OutputFormat $outputFormat$inlined;
            {
                this.$builder$inlined = diagramBuilder;
                this.this$0 = baseDiagramExporter;
                this.$outputFormat$inlined = outputFormat;
            }

            public final T get() {
                boolean bl = false;
                return (T)((String)this.$builder$inlined.getActionExecutor().suppressComputableReadLockAssertion(new ThrowableComputable(this.this$0, this.$builder$inlined, this.$outputFormat$inlined){
                    final /* synthetic */ BaseDiagramExporter this$0;
                    final /* synthetic */ DiagramBuilder $builder;
                    final /* synthetic */ DiagramExportService.OutputFormat $outputFormat;
                    {
                        this.this$0 = $receiver;
                        this.$builder = $builder;
                        this.$outputFormat = $outputFormat;
                    }

                    public final String compute() {
                        this.this$0.initialize(this.$builder, this.$outputFormat);
                        return this.this$0.exportToStringPreliminary();
                    }
                }));
            }
        }, Futures.inEdt(modalityState$iv));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(...)");
        Class<BaseDiagramExporter> loggingClass$iv = BaseDiagramExporter.class;
        boolean $i$f$logIfFailed = false;
        return ((CompletableFuture)((CompletableFuture)completableFuture.thenComposeAsync(ThreadContext.captureThreadContext(arg_0 -> BaseDiagramExporter.runExportAsync$lambda$9$lambda$6(this$0, $builder, arg_0)))).thenAcceptAsync(ThreadContext.captureThreadContext(arg_0 -> BaseDiagramExporter.runExportAsync$lambda$9$lambda$8($outputStreamSupplier, arg_0)))).whenComplete(new BiConsumer(loggingClass$iv){
            final /* synthetic */ Class $loggingClass;
            {
                this.$loggingClass = $loggingClass;
            }

            public final void accept(Object object, Throwable cause) {
                if (cause != null && !Futures.isCancellation((Throwable)cause)) {
                    Throwable throwable = cause;
                    Logger logger = Logger.getInstance((Class)this.$loggingClass);
                    boolean bl = false;
                    logger.error(throwable);
                }
            }
        });
    }

    private static final CompletableFuture runExportAsync$lambda$10(Function1 $tmp0, Object p0) {
        return (CompletableFuture)$tmp0.invoke(p0);
    }

    private static final String formatOutput$lambda$12(String $result) {
        return JDOMUtil.writeElement((Element)JDOMUtil.load((CharSequence)$result));
    }

    private static final CharSequence wrapLinesAt$lambda$17$lambda$16$lambda$15(StringBuilder $this_buildString, List words) {
        Intrinsics.checkNotNullParameter((Object)words, (String)"words");
        CollectionsKt.joinTo$default((Iterable)words, (Appendable)$this_buildString, (CharSequence)" ", null, null, (int)0, null, null, (int)124, null);
        return "";
    }

    private static final CharSequence wrapLinesAt$lambda$17$lambda$16(StringBuilder $this_buildString, List wrappedLines) {
        Intrinsics.checkNotNullParameter((Object)wrappedLines, (String)"wrappedLines");
        CollectionsKt.joinTo$default((Iterable)wrappedLines, (Appendable)$this_buildString, (CharSequence)"\n", null, null, (int)0, null, arg_0 -> BaseDiagramExporter.wrapLinesAt$lambda$17$lambda$16$lambda$15($this_buildString, arg_0), (int)60, null);
        return "";
    }

    private static final Comparable appendGraphNodes$lambda$20$lambda$18(DiagramNode it) {
        return it instanceof DiagramNoteNode ? (Comparable)Integer.valueOf(1) : (Comparable)Integer.valueOf(0);
    }

    private static final Comparable appendGraphNodes$lambda$20$lambda$19(DiagramNode it) {
        Object object = it.getPresentableTitle();
        return object != null && (object = object.toString()) != null ? (Comparable)object : (Comparable)((Object)"");
    }

    private static final void appendGraphNodes$lambda$20(BaseDiagramExporter this$0, Appendable $this_appendGraphNodes) {
        Collection<DiagramNode<?>> collection = this$0.getBuilder().getNodeObjects();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getNodeObjects(...)");
        Function1[] function1Array = new Function1[]{BaseDiagramExporter::appendGraphNodes$lambda$20$lambda$18, BaseDiagramExporter::appendGraphNodes$lambda$20$lambda$19};
        List sortedNodes = CollectionsKt.sortedWith((Iterable)collection, (Comparator)ComparisonsKt.compareBy((Function1[])function1Array));
        for (DiagramNode node : sortedNodes) {
            Intrinsics.checkNotNull((Object)node);
            this$0.appendNode($this_appendGraphNodes, node);
        }
    }

    private static final Comparable appendGraphEdges$lambda$23$lambda$21(DiagramEdge it) {
        Object object = it.getSource().getPresentableTitle();
        return object != null && (object = object.toString()) != null ? (Comparable)object : (Comparable)((Object)"");
    }

    private static final Comparable appendGraphEdges$lambda$23$lambda$22(DiagramEdge it) {
        Object object = it.getTarget().getPresentableTitle();
        return object != null && (object = object.toString()) != null ? (Comparable)object : (Comparable)((Object)"");
    }

    private static final void appendGraphEdges$lambda$23(BaseDiagramExporter this$0, Appendable $this_appendGraphEdges) {
        Collection<DiagramEdge<?>> collection = this$0.getBuilder().getEdgeObjects();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getEdgeObjects(...)");
        Function1[] function1Array = new Function1[]{BaseDiagramExporter::appendGraphEdges$lambda$23$lambda$21, BaseDiagramExporter::appendGraphEdges$lambda$23$lambda$22};
        List sortedEdges = CollectionsKt.sortedWith((Iterable)collection, (Comparator)ComparisonsKt.compareBy((Function1[])function1Array));
        for (DiagramEdge edge : sortedEdges) {
            Intrinsics.checkNotNull((Object)edge);
            this$0.appendEdge($this_appendGraphEdges, edge);
        }
    }

    private static final Appendable appendNode$lambda$24(JComponent $nodeComponent, BaseDiagramExporter this$0, DiagramNode $node, Appendable appendable) {
        Appendable appendable2;
        Intrinsics.checkNotNullParameter((Object)appendable, (String)"<this>");
        JComponent jComponent = $nodeComponent;
        if (jComponent instanceof UmlNoteContainer) {
            appendable2 = this$0.appendNoteLikeContainer(appendable, $node, (UmlNoteContainer)$nodeComponent);
        } else if (jComponent instanceof DiagramNodeContainer) {
            appendable2 = this$0.appendUmlLikeContainer(appendable, $node, (DiagramNodeContainer)((Object)$nodeComponent));
        } else if (jComponent instanceof SimpleColoredComponent) {
            appendable2 = this$0.appendLabelWithIconLikeContainer(appendable, $node, (SimpleColoredComponent)$nodeComponent);
        } else {
            throw new IllegalStateException("Unknown node shape".toString());
        }
        return appendable2;
    }

    private static final OutputStream generateUrlToOpenInWebEditorAsync$lambda$37(ByteArrayOutputStream $buffer) {
        return $buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String generateUrlToOpenInWebEditorAsync$lambda$38(ByteArrayOutputStream $buffer, BaseDiagramExporter this$0, Void it) {
        String string;
        byte[] byArray = $buffer.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        Object object = byArray;
        object = new ByteArrayInputStream((byte[])object);
        Throwable throwable = null;
        try {
            ByteArrayInputStream p0 = (ByteArrayInputStream)object;
            boolean bl = false;
            string = this$0.generateUrl(p0);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0084\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/uml/export/BaseDiagramExporter$DiagramType;", "", "<init>", "(Ljava/lang/String;I)V", "UML", "FLOWCHART", "intellij.diagram.impl"})
    protected static final class DiagramType
    extends Enum<DiagramType> {
        public static final /* enum */ DiagramType UML = new DiagramType();
        public static final /* enum */ DiagramType FLOWCHART = new DiagramType();
        private static final /* synthetic */ DiagramType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static DiagramType[] values() {
            return (DiagramType[])$VALUES.clone();
        }

        public static DiagramType valueOf(String value) {
            return Enum.valueOf(DiagramType.class, value);
        }

        @NotNull
        public static EnumEntries<DiagramType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = diagramTypeArray = new DiagramType[]{DiagramType.UML, DiagramType.FLOWCHART};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0084\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/uml/export/BaseDiagramExporter$HLevel;", "", "<init>", "(Ljava/lang/String;I)V", "SOURCE", "CENTER", "TARGET", "intellij.diagram.impl"})
    protected static final class HLevel
    extends Enum<HLevel> {
        public static final /* enum */ HLevel SOURCE = new HLevel();
        public static final /* enum */ HLevel CENTER = new HLevel();
        public static final /* enum */ HLevel TARGET = new HLevel();
        private static final /* synthetic */ HLevel[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static HLevel[] values() {
            return (HLevel[])$VALUES.clone();
        }

        public static HLevel valueOf(String value) {
            return Enum.valueOf(HLevel.class, value);
        }

        @NotNull
        public static EnumEntries<HLevel> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = hLevelArray = new HLevel[]{HLevel.SOURCE, HLevel.CENTER, HLevel.TARGET};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0084\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/uml/export/BaseDiagramExporter$VLevel;", "", "<init>", "(Ljava/lang/String;I)V", "BOTTOM", "TOP", "intellij.diagram.impl"})
    protected static final class VLevel
    extends Enum<VLevel> {
        public static final /* enum */ VLevel BOTTOM = new VLevel();
        public static final /* enum */ VLevel TOP = new VLevel();
        private static final /* synthetic */ VLevel[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static VLevel[] values() {
            return (VLevel[])$VALUES.clone();
        }

        public static VLevel valueOf(String value) {
            return Enum.valueOf(VLevel.class, value);
        }

        @NotNull
        public static EnumEntries<VLevel> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = vLevelArray = new VLevel[]{VLevel.BOTTOM, VLevel.TOP};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

