/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions.analysis;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.state.DiagramEdgeIdentity;
import com.intellij.diagram.util.DiagramAlgorithmsService;
import com.intellij.diagram.util.DiagramSelectionService;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.services.GraphLayoutService;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.graph.util.Futures;
import com.intellij.openapi.graph.view.focusview.GraphFocusOnEdgesView;
import com.intellij.openapi.graph.view.focusview.GraphFocusViewProvider;
import com.intellij.openapi.util.Pair;
import com.intellij.uml.core.actions.analysis.DiagramAbstractEnableFocusViewAction;
import com.intellij.uml.core.actions.analysis.DiagramFocusViewOnCyclesDialog;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiagramFocusViewOnCyclesAction
extends DiagramAbstractEnableFocusViewAction {
    @Override
    protected @NotNull CompletableFuture<@Nullable GraphFocusViewProvider> createFocusViewProviderAsync(@NotNull DiagramBuilder modelBuilder) {
        if (modelBuilder == null) {
            DiagramFocusViewOnCyclesAction.$$$reportNull$$$0(0);
        }
        List<DiagramNode<?>> selectedNodes = DiagramSelectionService.getInstance().getSelectedNodes(modelBuilder);
        DiagramAlgorithmsService.PathFindingParams requestParams = new DiagramAlgorithmsService.PathFindingParams(null, null, DiagramAlgorithmsService.PathDirection.DIRECTED_SOURCE_TO_TARGET, DiagramAlgorithmsService.PathFilter.All.getInstance());
        CompletionStage completionStage = ((CompletableFuture)new DiagramFocusViewOnCyclesDialog(requestParams, selectedNodes, modelBuilder.getProject()).showAsync().thenComposeAsync(__ -> DiagramAlgorithmsService.getInstance().findAllSimpleCyclesAsync(modelBuilder, requestParams), Futures.inEdt())).thenApplyAsync(cycles -> {
            Set nodePairs = cycles.stream().flatMap(it -> DiagramFocusViewOnCyclesAction.zipWithNext(it)).collect(Collectors.toSet());
            Set edges = modelBuilder.getEdgeObjects().stream().filter(it -> nodePairs.contains(Pair.create(it.getSource(), it.getTarget()))).collect(Collectors.toSet());
            return new GraphFocusOnEdgesView(ContainerUtil.map2Set(edges, it -> DiagramEdgeIdentity.of(it)), DiagramFocusViewOnCyclesAction::customizeViewSettings);
        }, Futures.inEdt());
        if (completionStage == null) {
            DiagramFocusViewOnCyclesAction.$$$reportNull$$$0(1);
        }
        return completionStage;
    }

    @NotNull
    private static <T> Stream<Pair<T, T>> zipWithNext(@NotNull List<T> list) {
        if (list == null) {
            DiagramFocusViewOnCyclesAction.$$$reportNull$$$0(2);
        }
        Stream<Pair<T, T>> stream = StreamSupport.stream(ContainerUtil.zip(list, list.subList(Math.min(1, list.size()), list.size())).spliterator(), false);
        if (stream == null) {
            DiagramFocusViewOnCyclesAction.$$$reportNull$$$0(3);
        }
        return stream;
    }

    private static void customizeViewSettings(@NotNull GraphSettings viewSettings) {
        if (viewSettings == null) {
            DiagramFocusViewOnCyclesAction.$$$reportNull$$$0(4);
        }
        viewSettings.setCurrentLayouter((Layouter)GraphLayoutService.getInstance().getCircularLayouter());
    }

    @Override
    protected boolean canBeEnabledFor(@NotNull DiagramBuilder modelBuilder) {
        if (modelBuilder == null) {
            DiagramFocusViewOnCyclesAction.$$$reportNull$$$0(5);
        }
        return true;
    }

    @Override
    @Nls
    @NotNull
    public String getActionName() {
        String string = DiagramBundle.message("action.Diagram.AnalyzeGraph.FocusOnCycles.text", new Object[0]);
        if (string == null) {
            DiagramFocusViewOnCyclesAction.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelBuilder";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/core/actions/analysis/DiagramFocusViewOnCyclesAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/core/actions/analysis/DiagramFocusViewOnCyclesAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createFocusViewProviderAsync";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "zipWithNext";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFocusViewProviderAsync";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "zipWithNext";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "customizeViewSettings";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canBeEnabledFor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 6 -> new IllegalStateException(string);
        };
    }
}

