/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.cast.JSStringToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToIntegerAsIntNodeGen;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.objects.JSObject;

public abstract class JSToIntegerAsIntNode
extends JavaScriptBaseNode {
    @NeverDefault
    public static JSToIntegerAsIntNode create() {
        return JSToIntegerAsIntNodeGen.create();
    }

    public abstract int executeInt(Object var1);

    @Specialization
    protected static int doInteger(int value2) {
        return value2;
    }

    @Specialization
    protected static int doBoolean(boolean value2) {
        return JSRuntime.booleanToNumber(value2);
    }

    @Specialization(guards={"isLongRepresentableAsInt32(value.longValue())"})
    protected static int doSafeIntegerInt32Range(SafeInteger value2) {
        return value2.intValue();
    }

    @Specialization(guards={"!isLongRepresentableAsInt32(value.longValue())"})
    protected static int doSafeIntegerOther(SafeInteger value2) {
        if (value2.isNegative()) {
            return Integer.MIN_VALUE;
        }
        return Integer.MAX_VALUE;
    }

    @Specialization
    protected static int doDouble(double value2) {
        return (int)value2;
    }

    @Specialization(guards={"isUndefined(value)"})
    protected static int doUndefined(Object value2) {
        return 0;
    }

    @Specialization(guards={"isJSNull(value)"})
    protected static int doNull(Object value2) {
        return 0;
    }

    @Specialization
    protected final int doSymbol(Symbol value2) {
        throw Errors.createTypeErrorCannotConvertToNumber("a Symbol value", this);
    }

    @Specialization
    protected final int doBigInt(BigInt value2) {
        throw Errors.createTypeErrorCannotConvertToNumber("a BigInt value", this);
    }

    @Specialization
    protected int doString(TruffleString value2, @Cached JSToIntegerAsIntNode nestedToIntegerNode, @Cached JSStringToNumberNode stringToNumberNode) {
        return nestedToIntegerNode.executeInt(stringToNumberNode.execute(value2));
    }

    @Specialization
    protected int doJSObject(JSObject value2, @Cached.Shared @Cached JSToNumberNode toNumberNode) {
        return JSRuntime.toInt32(toNumberNode.executeNumber(value2));
    }

    @Specialization(guards={"isJSObject(value) || isForeignObject(value)"}, replaces={"doJSObject"})
    protected int doJSOrForeignObject(Object value2, @Cached.Shared @Cached JSToNumberNode toNumberNode) {
        return JSRuntime.toInt32(toNumberNode.executeNumber(value2));
    }
}

