/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.temporal.JSTemporalBuiltinOperation;
import com.oracle.truffle.js.builtins.temporal.TemporalZonedDateTimePrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.access.EnumerableOwnPropertyNamesNode;
import com.oracle.truffle.js.nodes.access.GetMethodNode;
import com.oracle.truffle.js.nodes.cast.JSNumberToBigIntNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.temporal.CreateTimeZoneMethodsRecordNode;
import com.oracle.truffle.js.nodes.temporal.TemporalCalendarDateFromFieldsNode;
import com.oracle.truffle.js.nodes.temporal.TemporalCalendarFieldsNode;
import com.oracle.truffle.js.nodes.temporal.TemporalCalendarGetterNode;
import com.oracle.truffle.js.nodes.temporal.TemporalDurationAddNode;
import com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import com.oracle.truffle.js.nodes.temporal.TemporalMonthDayFromFieldsNode;
import com.oracle.truffle.js.nodes.temporal.TemporalRoundDurationNode;
import com.oracle.truffle.js.nodes.temporal.TemporalYearMonthFromFieldsNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalCalendarNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalDateNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalDurationNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalTimeNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalTimeZoneNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalZonedDateTimeNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.temporal.CalendarMethodsRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.ISODateRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalCalendarObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDateTimeRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDuration;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstant;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstantObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDate;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPrecisionRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.TimeDurationRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.TimeZoneMethodsRecord;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalErrors;
import com.oracle.truffle.js.runtime.util.TemporalUtil;
import java.util.EnumSet;
import java.util.List;

public class TemporalZonedDateTimePrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<TemporalZonedDateTimePrototype> {
    public static final JSBuiltinsContainer BUILTINS = new TemporalZonedDateTimePrototypeBuiltins();

    protected TemporalZonedDateTimePrototypeBuiltins() {
        super(JSTemporalZonedDateTime.PROTOTYPE_NAME, TemporalZonedDateTimePrototype.class);
    }

    @Override
    protected Object createNode(JSContext context2, JSBuiltin builtin, boolean construct, boolean newTarget, TemporalZonedDateTimePrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeGetterNodeGen.create(context2, builtin, builtinEnum, TemporalZonedDateTimePrototypeBuiltins.args().withThis().createArgumentNodes(context2));
            }
            case 38: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeToStringNodeGen.create(context2, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context2));
            }
            case 39: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeToLocaleStringNodeGen.create(context2, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context2));
            }
            case 40: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeToLocaleStringNodeGen.create(context2, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().createArgumentNodes(context2));
            }
            case 41: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeValueOfNodeGen.create(context2, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().createArgumentNodes(context2));
            }
            case 27: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeWithNodeGen.create(context2, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context2));
            }
            case 28: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeWithPlainTimeNodeGen.create(context2, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context2));
            }
            case 29: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeWithPlainDateNodeGen.create(context2, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context2));
            }
            case 30: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeWithTimeZoneNodeGen.create(context2, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context2));
            }
            case 31: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeWithCalendarNodeGen.create(context2, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context2));
            }
            case 32: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeAddSubNodeGen.create(context2, builtin, 1, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context2));
            }
            case 33: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeAddSubNodeGen.create(context2, builtin, -1, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context2));
            }
            case 34: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeUntilSinceNodeGen.create(context2, builtin, 1, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context2));
            }
            case 35: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeUntilSinceNodeGen.create(context2, builtin, -1, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context2));
            }
            case 36: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeRoundNodeGen.create(context2, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context2));
            }
            case 37: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeEqualsNodeGen.create(context2, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context2));
            }
            case 42: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeStartOfDayNodeGen.create(context2, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(0).createArgumentNodes(context2));
            }
            case 43: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeToInstantNodeGen.create(context2, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(0).createArgumentNodes(context2));
            }
            case 44: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeToPlainDateNodeGen.create(context2, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(0).createArgumentNodes(context2));
            }
            case 45: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeToPlainTimeNodeGen.create(context2, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(0).createArgumentNodes(context2));
            }
            case 46: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeToPlainDateTimeNodeGen.create(context2, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(0).createArgumentNodes(context2));
            }
            case 47: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeToPlainYearMonthNodeGen.create(context2, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(0).createArgumentNodes(context2));
            }
            case 48: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeToPlainMonthDayNodeGen.create(context2, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(0).createArgumentNodes(context2));
            }
            case 49: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeGetISOFieldsNodeGen.create(context2, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(0).createArgumentNodes(context2));
            }
        }
        return null;
    }

    public static enum TemporalZonedDateTimePrototype implements BuiltinEnum<TemporalZonedDateTimePrototype>
    {
        calendar(0),
        timeZone(0),
        year(0),
        month(0),
        monthCode(0),
        day(0),
        hour(0),
        minute(0),
        second(0),
        millisecond(0),
        microsecond(0),
        nanosecond(0),
        epochSeconds(0),
        epochMilliseconds(0),
        epochMicroseconds(0),
        epochNanoseconds(0),
        dayOfWeek(0),
        dayOfYear(0),
        weekOfYear(0),
        hoursInDay(0),
        daysInWeek(0),
        daysInMonth(0),
        daysInYear(0),
        monthsInYear(0),
        inLeapYear(0),
        offsetNanoseconds(0),
        offset(0),
        with(1),
        withPlainTime(0),
        withPlainDate(1),
        withTimeZone(1),
        withCalendar(1),
        add(1),
        subtract(1),
        until(1),
        since(1),
        round(1),
        equals(1),
        toString(0),
        toLocaleString(0),
        toJSON(0),
        valueOf(0),
        startOfDay(0),
        toInstant(0),
        toPlainDate(0),
        toPlainTime(0),
        toPlainDateTime(0),
        toPlainYearMonth(0),
        toPlainMonthDay(0),
        getISOFields(0);

        private final int length;

        private TemporalZonedDateTimePrototype(int length2) {
            this.length = length2;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isGetter() {
            return EnumSet.range(calendar, offset).contains(this);
        }
    }

    public static abstract class JSTemporalZonedDateTimeGetterNode
    extends JSBuiltinNode {
        protected final TemporalZonedDateTimePrototype property;

        protected JSTemporalZonedDateTimeGetterNode(JSContext context2, JSBuiltin builtin, TemporalZonedDateTimePrototype property) {
            super(context2, builtin);
            this.property = property;
        }

        @Specialization
        protected Object zonedDateTimeGetter(JSTemporalZonedDateTimeObject zdt, @Cached TemporalCalendarGetterNode calendarGetterNode, @Cached InlinedBranchProfile errorBranch, @Cached CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord) {
            switch (this.property.ordinal()) {
                case 0: {
                    return zdt.getCalendar();
                }
                case 1: {
                    return zdt.getTimeZone();
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 16: 
                case 17: 
                case 18: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    return this.getterCalendarDetails(zdt, calendarGetterNode, createTimeZoneMethodsRecord);
                }
                case 19: {
                    return this.getterHoursInDay(zdt, errorBranch, createTimeZoneMethodsRecord);
                }
                case 12: {
                    return JSTemporalZonedDateTimeGetterNode.getterEpoch(zdt, BigInt.valueOf(1000000000L)).doubleValue();
                }
                case 13: {
                    return JSTemporalZonedDateTimeGetterNode.getterEpoch(zdt, BigInt.valueOf(1000000L)).doubleValue();
                }
                case 14: {
                    return JSTemporalZonedDateTimeGetterNode.getterEpoch(zdt, BigInt.valueOf(1000L));
                }
                case 15: {
                    return JSTemporalZonedDateTimeGetterNode.getterEpoch(zdt, BigInt.ONE);
                }
                case 25: {
                    return this.getterOffsetNanoseconds(zdt, createTimeZoneMethodsRecord);
                }
                case 26: {
                    return this.getterOffset(zdt, createTimeZoneMethodsRecord);
                }
            }
            throw Errors.shouldNotReachHere();
        }

        private Object getterOffset(JSTemporalZonedDateTimeObject zdt, CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord) {
            JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), this.getRealm(), zdt.getNanoseconds());
            JSDynamicObject timeZone = zdt.getTimeZone();
            TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeOnlyGetOffsetNanosecondsFor(timeZone);
            return TemporalUtil.builtinTimeZoneGetOffsetStringFor(timeZoneRec, instant);
        }

        private Object getterOffsetNanoseconds(JSTemporalZonedDateTimeObject zdt, CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord) {
            JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), this.getRealm(), zdt.getNanoseconds());
            JSDynamicObject timeZone = zdt.getTimeZone();
            TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeOnlyGetOffsetNanosecondsFor(timeZone);
            return TemporalUtil.getOffsetNanosecondsFor(timeZoneRec, instant);
        }

        private Object getterHoursInDay(JSTemporalZonedDateTimeObject zdt, InlinedBranchProfile errorBranch, CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord) {
            JSDynamicObject timeZone = zdt.getTimeZone();
            TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeFull(timeZone);
            JSRealm realm = this.getRealm();
            JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), realm, zdt.getNanoseconds());
            JSTemporalCalendarObject isoCalendar = TemporalUtil.getISO8601Calendar(this.getContext(), realm);
            JSTemporalPlainDateTimeObject temporalDateTime = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(this.getContext(), realm, timeZoneRec, instant, isoCalendar);
            int year = temporalDateTime.getYear();
            int month = temporalDateTime.getMonth();
            int day = temporalDateTime.getDay();
            JSTemporalPlainDateTimeObject today = JSTemporalPlainDateTime.create(this.getContext(), realm, year, month, day, 0, 0, 0, 0, 0, 0, isoCalendar, this, errorBranch);
            ISODateRecord tomorrowFields = TemporalUtil.addISODate(year, month, day, 0, 0, 0, 1, TemporalUtil.Overflow.REJECT);
            JSTemporalPlainDateTimeObject tomorrow = JSTemporalPlainDateTime.create(this.getContext(), realm, tomorrowFields.year(), tomorrowFields.month(), tomorrowFields.day(), 0, 0, 0, 0, 0, 0, isoCalendar, this, errorBranch);
            JSTemporalInstantObject todayInstant = TemporalUtil.builtinTimeZoneGetInstantFor(this.getContext(), realm, timeZoneRec, today, TemporalUtil.Disambiguation.COMPATIBLE);
            JSTemporalInstantObject tomorrowInstant = TemporalUtil.builtinTimeZoneGetInstantFor(this.getContext(), realm, timeZoneRec, tomorrow, TemporalUtil.Disambiguation.COMPATIBLE);
            BigInt diffNs = tomorrowInstant.getNanoseconds().subtract(todayInstant.getNanoseconds());
            return diffNs.divide(BigInt.valueOf(36000000000000L));
        }

        private static BigInt getterEpoch(JSTemporalZonedDateTimeObject zdt, BigInt factor) {
            BigInt ns = zdt.getNanoseconds();
            BigInt s = ns.divide(factor);
            return s;
        }

        private Object getterCalendarDetails(JSTemporalZonedDateTimeObject zdt, TemporalCalendarGetterNode calendarGetterNode, CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord) {
            JSDynamicObject timeZone = zdt.getTimeZone();
            TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeOnlyGetOffsetNanosecondsFor(timeZone);
            JSRealm realm = this.getRealm();
            JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), realm, zdt.getNanoseconds());
            JSDynamicObject calendar = zdt.getCalendar();
            JSTemporalPlainDateTimeObject tdt = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(this.getContext(), realm, timeZoneRec, instant, calendar);
            switch (this.property.ordinal()) {
                case 2: {
                    return TemporalUtil.calendarYear(calendarGetterNode, calendar, tdt);
                }
                case 3: {
                    return TemporalUtil.calendarMonth(calendarGetterNode, calendar, tdt);
                }
                case 4: {
                    return TemporalUtil.calendarMonthCode(calendarGetterNode, calendar, tdt);
                }
                case 5: {
                    return TemporalUtil.calendarDay(calendarGetterNode, calendar, tdt);
                }
                case 6: {
                    return tdt.getHour();
                }
                case 7: {
                    return tdt.getMinute();
                }
                case 8: {
                    return tdt.getSecond();
                }
                case 9: {
                    return tdt.getMillisecond();
                }
                case 10: {
                    return tdt.getMicrosecond();
                }
                case 11: {
                    return tdt.getNanosecond();
                }
                case 16: {
                    return TemporalUtil.calendarDayOfWeek(calendarGetterNode, calendar, tdt);
                }
                case 17: {
                    return TemporalUtil.calendarDayOfYear(calendarGetterNode, calendar, tdt);
                }
                case 18: {
                    return TemporalUtil.calendarWeekOfYear(calendarGetterNode, calendar, tdt);
                }
                case 20: {
                    return TemporalUtil.calendarWeekOfYear(calendarGetterNode, calendar, tdt);
                }
                case 21: {
                    return TemporalUtil.calendarDaysInMonth(calendarGetterNode, calendar, tdt);
                }
                case 22: {
                    return TemporalUtil.calendarDaysInYear(calendarGetterNode, calendar, tdt);
                }
                case 23: {
                    return TemporalUtil.calendarMonthsInYear(calendarGetterNode, calendar, tdt);
                }
                case 24: {
                    return TemporalUtil.calendarInLeapYear(calendarGetterNode, calendar, tdt);
                }
            }
            throw Errors.shouldNotReachHere();
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeToString
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeToString(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected TruffleString toString(JSTemporalZonedDateTimeObject zonedDateTime, Object optionsParam, @Cached JSToStringNode toStringNode, @Cached TruffleString.EqualNode equalNode, @Cached TemporalGetOptionNode getOptionNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            JSDynamicObject options = this.getOptionsObject(optionsParam, this, errorBranch, optionUndefined);
            JSTemporalPrecisionRecord precision = TemporalUtil.toSecondsStringPrecision(options, toStringNode, getOptionNode, equalNode);
            TemporalUtil.RoundingMode roundingMode = JSTemporalZonedDateTimeToString.toTemporalRoundingMode(options, TemporalConstants.TRUNC, equalNode, getOptionNode);
            TemporalUtil.ShowCalendar showCalendar = TemporalUtil.toShowCalendarOption(options, getOptionNode, equalNode);
            TruffleString showTimeZone = TemporalUtil.toShowTimeZoneNameOption(options, getOptionNode);
            TruffleString showOffset = TemporalUtil.toShowOffsetOption(options, getOptionNode);
            return TemporalUtil.temporalZonedDateTimeToString(this.getContext(), this.getRealm(), zonedDateTime, precision.getPrecision(), showCalendar, showTimeZone, showOffset, precision.getIncrement(), precision.getUnit(), roundingMode);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj, Object optionsParam) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeToLocaleString
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeToLocaleString(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected TruffleString toLocaleString(JSTemporalZonedDateTimeObject zonedDateTime) {
            return TemporalUtil.temporalZonedDateTimeToString(this.getContext(), this.getRealm(), zonedDateTime, TemporalConstants.AUTO, TemporalUtil.ShowCalendar.AUTO, TemporalConstants.AUTO, TemporalConstants.AUTO);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeValueOf
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeValueOf(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected Object valueOf(Object thisObj) {
            throw Errors.createTypeError("Not supported.");
        }
    }

    public static abstract class JSTemporalZonedDateTimeWith
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeWith(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected Object with(JSTemporalZonedDateTimeObject zonedDateTime, Object temporalZonedDateTimeLike, Object optionsParam, @Cached(value="createKeys(getContext())") EnumerableOwnPropertyNamesNode namesNode, @Cached TemporalGetOptionNode getOptionNode, @Cached TruffleString.EqualNode equalNode, @Cached TemporalCalendarFieldsNode calendarFieldsNode, @Cached TemporalCalendarDateFromFieldsNode dateFromFieldsNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined, @Cached CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord) {
            if (!this.isObject(temporalZonedDateTimeLike)) {
                errorBranch.enter(this);
                throw Errors.createTypeError("object expected");
            }
            JSDynamicObject temporalZDTLike = TemporalUtil.toJSDynamicObject(temporalZonedDateTimeLike, this, errorBranch);
            TemporalUtil.rejectTemporalCalendarType(temporalZDTLike, this, errorBranch);
            Object calendarProperty = JSObject.get(temporalZDTLike, TemporalConstants.CALENDAR);
            if (calendarProperty != Undefined.instance) {
                errorBranch.enter(this);
                throw TemporalErrors.createTypeErrorUnexpectedCalendar();
            }
            Object timeZoneProperty = JSObject.get(temporalZDTLike, TemporalConstants.TIME_ZONE);
            if (timeZoneProperty != Undefined.instance) {
                errorBranch.enter(this);
                throw TemporalErrors.createTypeErrorUnexpectedTimeZone();
            }
            JSDynamicObject calendar = zonedDateTime.getCalendar();
            JSDynamicObject timeZone = zonedDateTime.getTimeZone();
            TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeFull(timeZone);
            List<TruffleString> fieldNames = calendarFieldsNode.execute(calendar, TemporalUtil.listDHMMMMMNSY);
            Boundaries.listAdd(fieldNames, TemporalConstants.OFFSET);
            JSObject partialZonedDateTime = TemporalUtil.preparePartialTemporalFields(this.getContext(), temporalZDTLike, fieldNames);
            JSDynamicObject options = this.getOptionsObject(optionsParam, this, errorBranch, optionUndefined);
            TemporalUtil.Disambiguation disambiguation = TemporalUtil.toTemporalDisambiguation(options, getOptionNode, equalNode);
            TemporalUtil.OffsetOption offset = TemporalUtil.toTemporalOffset(options, TemporalConstants.PREFER, getOptionNode, equalNode);
            Boundaries.listAdd(fieldNames, TemporalConstants.TIME_ZONE);
            JSDynamicObject fields = TemporalUtil.prepareTemporalFields(this.getContext(), zonedDateTime, fieldNames, TemporalUtil.listTimeZoneOffset);
            fields = TemporalUtil.calendarMergeFields(this.getContext(), this.getRealm(), calendar, fields, partialZonedDateTime, namesNode, this, errorBranch);
            fields = TemporalUtil.prepareTemporalFields(this.getContext(), fields, fieldNames, TemporalUtil.listTimeZone);
            Object offsetString = JSObject.get(fields, TemporalConstants.OFFSET);
            JSTemporalDateTimeRecord dateTimeResult = TemporalUtil.interpretTemporalDateTimeFields(calendar, fields, options, getOptionNode, dateFromFieldsNode);
            long offsetNanoseconds = TemporalUtil.parseTimeZoneOffsetString((TruffleString)offsetString);
            JSRealm realm = this.getRealm();
            BigInt epochNanoseconds = TemporalUtil.interpretISODateTimeOffset(this.getContext(), realm, dateTimeResult.getYear(), dateTimeResult.getMonth(), dateTimeResult.getDay(), dateTimeResult.getHour(), dateTimeResult.getMinute(), dateTimeResult.getSecond(), dateTimeResult.getMillisecond(), dateTimeResult.getMicrosecond(), dateTimeResult.getNanosecond(), TemporalUtil.OffsetBehaviour.OPTION, offsetNanoseconds, timeZoneRec, disambiguation, offset, TemporalUtil.MatchBehaviour.MATCH_EXACTLY);
            return JSTemporalZonedDateTime.create(this.getContext(), realm, epochNanoseconds, timeZone, calendar);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj, Object temporalZonedDateTimeLike, Object optionsParam) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeWithPlainTime
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeWithPlainTime(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected JSDynamicObject withPlainTime(JSTemporalZonedDateTimeObject zonedDateTime, Object plainTimeLike, @Cached ToTemporalTimeNode toTemporalTime, @Cached InlinedBranchProfile errorBranch, @Cached CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord) {
            JSRealm realm = this.getRealm();
            JSTemporalPlainTimeObject plainTime = plainTimeLike == Undefined.instance ? JSTemporalPlainTime.create(this.getContext(), realm, 0, 0, 0, 0, 0, 0, this, errorBranch) : toTemporalTime.execute(plainTimeLike, null);
            JSDynamicObject timeZone = zonedDateTime.getTimeZone();
            TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeFull(timeZone);
            JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), realm, zonedDateTime.getNanoseconds());
            JSDynamicObject calendar = zonedDateTime.getCalendar();
            JSTemporalPlainDateTimeObject plainDateTime = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(this.getContext(), realm, timeZoneRec, instant, calendar);
            JSTemporalPlainDateTimeObject resultPlainDateTime = JSTemporalPlainDateTime.create(this.getContext(), realm, plainDateTime.getYear(), plainDateTime.getMonth(), plainDateTime.getDay(), plainTime.getHour(), plainTime.getMinute(), plainTime.getSecond(), plainTime.getMillisecond(), plainTime.getMicrosecond(), plainTime.getNanosecond(), calendar, this, errorBranch);
            instant = TemporalUtil.builtinTimeZoneGetInstantFor(this.getContext(), realm, timeZoneRec, resultPlainDateTime, TemporalUtil.Disambiguation.COMPATIBLE);
            return JSTemporalZonedDateTime.create(this.getContext(), realm, instant.getNanoseconds(), timeZone, calendar);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj, Object plainTimeLike) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeWithPlainDate
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeWithPlainDate(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected JSDynamicObject withPlainDate(JSTemporalZonedDateTimeObject zonedDateTime, Object plainDateLike, @Cached ToTemporalDateNode toTemporalDate, @Cached JSToStringNode toStringNode, @Cached InlinedBranchProfile errorBranch, @Cached CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord) {
            JSTemporalPlainDateObject plainDate = toTemporalDate.execute(plainDateLike);
            JSDynamicObject timeZone = zonedDateTime.getTimeZone();
            TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeFull(timeZone);
            JSRealm realm = this.getRealm();
            JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), realm, zonedDateTime.getNanoseconds());
            JSTemporalPlainDateTimeObject plainDateTime = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(this.getContext(), realm, timeZoneRec, instant, zonedDateTime.getCalendar());
            JSDynamicObject calendar = TemporalUtil.consolidateCalendars(zonedDateTime.getCalendar(), plainDate.getCalendar(), toStringNode);
            JSTemporalPlainDateTimeObject resultPlainDateTime = JSTemporalPlainDateTime.create(this.getContext(), realm, plainDate.getYear(), plainDate.getMonth(), plainDate.getDay(), plainDateTime.getHour(), plainDateTime.getMinute(), plainDateTime.getSecond(), plainDateTime.getMillisecond(), plainDateTime.getMicrosecond(), plainDateTime.getNanosecond(), calendar, this, errorBranch);
            instant = TemporalUtil.builtinTimeZoneGetInstantFor(this.getContext(), realm, timeZoneRec, resultPlainDateTime, TemporalUtil.Disambiguation.COMPATIBLE);
            return JSTemporalZonedDateTime.create(this.getContext(), realm, instant.getNanoseconds(), timeZone, calendar);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj, Object plainDateLike) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeWithTimeZone
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeWithTimeZone(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected JSDynamicObject withTimeZone(JSTemporalZonedDateTimeObject zonedDateTime, Object timeZoneLike, @Cached ToTemporalTimeZoneNode toTemporalTimeZone) {
            JSDynamicObject timeZone = toTemporalTimeZone.execute(timeZoneLike);
            return JSTemporalZonedDateTime.create(this.getContext(), this.getRealm(), zonedDateTime.getNanoseconds(), timeZone, zonedDateTime.getCalendar());
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj, Object timeZoneLike) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeWithCalendar
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeWithCalendar(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected JSDynamicObject withCalendar(JSTemporalZonedDateTimeObject zonedDateTime, Object calendarLike, @Cached ToTemporalCalendarNode toTemporalCalendar) {
            JSDynamicObject calendar = toTemporalCalendar.execute(calendarLike);
            return JSTemporalZonedDateTime.create(this.getContext(), this.getRealm(), zonedDateTime.getNanoseconds(), zonedDateTime.getTimeZone(), calendar);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj, Object calendarLike) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeAddSubNode
    extends JSTemporalBuiltinOperation {
        private final int sign;
        @Node.Child
        private GetMethodNode getMethodDateAddNode;

        protected JSTemporalZonedDateTimeAddSubNode(JSContext context2, JSBuiltin builtin, int sign) {
            super(context2, builtin);
            this.sign = sign;
            this.getMethodDateAddNode = GetMethodNode.create(context2, TemporalConstants.DATE_ADD);
        }

        @Specialization
        protected JSTemporalZonedDateTimeObject addDurationToOrSubtractDurationFromZonedDateTime(JSTemporalZonedDateTimeObject zonedDateTime, Object temporalDurationLike, Object optionsParam, @Cached JSNumberToBigIntNode toBigInt, @Cached ToTemporalDurationNode toTemporalDurationNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined, @Cached CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord) {
            JSTemporalDurationObject duration = toTemporalDurationNode.execute(temporalDurationLike);
            JSDynamicObject options = this.getOptionsObject(optionsParam, this, errorBranch, optionUndefined);
            JSDynamicObject timeZone = zonedDateTime.getTimeZone();
            TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeFull(timeZone);
            JSDynamicObject calendar = zonedDateTime.getCalendar();
            CalendarMethodsRecord calendarRec = CalendarMethodsRecord.forDateAdd(calendar, this.getMethodDateAddNode.executeWithTarget(calendar));
            JSRealm realm = this.getRealm();
            BigInt epochNanoseconds = TemporalUtil.addZonedDateTime(this.getContext(), realm, zonedDateTime.getNanoseconds(), timeZoneRec, calendarRec, (long)this.sign * TemporalUtil.dtol(duration.getYears()), (long)this.sign * TemporalUtil.dtol(duration.getMonths()), (long)this.sign * TemporalUtil.dtol(duration.getWeeks()), (long)this.sign * TemporalUtil.dtol(duration.getDays()), (long)this.sign * TemporalUtil.dtol(duration.getHours()), (long)this.sign * TemporalUtil.dtol(duration.getMinutes()), (long)this.sign * TemporalUtil.dtol(duration.getSeconds()), (long)this.sign * TemporalUtil.dtol(duration.getMilliseconds()), (long)this.sign * TemporalUtil.dtol(duration.getMicroseconds()), toBigInt.executeBigInt((double)this.sign * duration.getNanoseconds()).bigIntegerValue(), null, options);
            return JSTemporalZonedDateTime.create(this.getContext(), realm, epochNanoseconds, timeZone, calendar);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj, Object temporalDurationLike, Object optionsParam) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeUntilSinceNode
    extends JSTemporalBuiltinOperation {
        private final int sign;
        @Node.Child
        private GetMethodNode getMethodDateAddNode;
        @Node.Child
        private GetMethodNode getMethodDateUntilNode;

        protected JSTemporalZonedDateTimeUntilSinceNode(JSContext context2, JSBuiltin builtin, int sign) {
            super(context2, builtin);
            this.sign = sign;
            this.getMethodDateAddNode = GetMethodNode.create(context2, TemporalConstants.DATE_ADD);
            this.getMethodDateUntilNode = GetMethodNode.create(context2, TemporalConstants.DATE_UNTIL);
        }

        @Specialization
        protected Object differenceTemporalZonedDateTime(JSTemporalZonedDateTimeObject zonedDateTime, Object otherParam, Object optionsParam, @Cached JSToNumberNode toNumber, @Cached(value="createKeys(getContext())") EnumerableOwnPropertyNamesNode namesNode, @Cached ToTemporalZonedDateTimeNode toTemporalZonedDateTime, @Cached JSToStringNode toStringNode, @Cached TruffleString.EqualNode equalNode, @Cached TemporalDurationAddNode durationAddNode, @Cached TemporalRoundDurationNode roundDurationNode, @Cached TemporalGetOptionNode getOptionNode, @Cached CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            JSTemporalZonedDateTimeObject other = toTemporalZonedDateTime.execute(otherParam, Undefined.instance);
            JSDynamicObject calendar = zonedDateTime.getCalendar();
            if (!TemporalUtil.calendarEquals(calendar, other.getCalendar(), toStringNode)) {
                errorBranch.enter(this);
                throw TemporalErrors.createRangeErrorIdenticalCalendarExpected();
            }
            JSDynamicObject options = this.getOptionsObject(optionsParam, this, errorBranch, optionUndefined);
            TemporalUtil.Unit smallestUnit = JSTemporalZonedDateTimeUntilSinceNode.toSmallestTemporalUnit(options, TemporalUtil.listEmpty, TemporalConstants.NANOSECOND, equalNode, getOptionNode, this, errorBranch);
            TemporalUtil.Unit defaultLargestUnit = TemporalUtil.largerOfTwoTemporalUnits(TemporalUtil.Unit.HOUR, smallestUnit);
            TemporalUtil.Unit largestUnit = JSTemporalZonedDateTimeUntilSinceNode.toLargestTemporalUnit(options, TemporalUtil.listEmpty, TemporalConstants.AUTO, defaultLargestUnit, equalNode, getOptionNode, this, errorBranch);
            TemporalUtil.validateTemporalUnitRange(largestUnit, smallestUnit);
            TemporalUtil.RoundingMode roundingMode = JSTemporalZonedDateTimeUntilSinceNode.toTemporalRoundingMode(options, TemporalConstants.TRUNC, equalNode, getOptionNode);
            Double maximum = TemporalUtil.maximumTemporalDurationRoundingIncrement(smallestUnit);
            double roundingIncrement = TemporalUtil.toTemporalRoundingIncrement(options, maximum, false, this.isObjectNode, toNumber);
            JSRealm realm = this.getRealm();
            if (TemporalUtil.Unit.YEAR != largestUnit && TemporalUtil.Unit.MONTH != largestUnit && TemporalUtil.Unit.WEEK != largestUnit && TemporalUtil.Unit.DAY != largestUnit) {
                TimeDurationRecord result2 = TemporalUtil.differenceInstant(zonedDateTime.getNanoseconds(), other.getNanoseconds(), roundingIncrement, smallestUnit, largestUnit, roundingMode, roundDurationNode);
                return JSTemporalDuration.createTemporalDuration(this.getContext(), realm, 0.0, 0.0, 0.0, 0.0, (double)this.sign * result2.hours(), (double)this.sign * result2.minutes(), (double)this.sign * result2.seconds(), (double)this.sign * result2.milliseconds(), (double)this.sign * result2.microseconds(), (double)this.sign * result2.nanoseconds(), this, errorBranch);
            }
            JSDynamicObject timeZone = zonedDateTime.getTimeZone();
            if (!TemporalUtil.timeZoneEquals(timeZone, other.getTimeZone(), toStringNode)) {
                errorBranch.enter(this);
                throw TemporalErrors.createRangeErrorIdenticalTimeZoneExpected();
            }
            if (zonedDateTime.getNanoseconds().compareTo(other.getNanoseconds()) == 0) {
                return JSTemporalDuration.createTemporalDuration(this.getContext(), realm, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, this, errorBranch);
            }
            TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeFull(timeZone);
            Object dateAdd = this.getMethodDateAddNode.executeWithTarget(calendar);
            Object dateUntil = this.getMethodDateUntilNode.executeWithTarget(calendar);
            CalendarMethodsRecord calendarRec = CalendarMethodsRecord.forDateAddDateUntil(calendar, dateAdd, dateUntil);
            JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), realm, zonedDateTime.getNanoseconds());
            JSTemporalPlainDateTimeObject precalculatedPlainDateTime = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(this.getContext(), realm, timeZoneRec, instant, options);
            JSTemporalPlainDateObject plainRelativeTo = JSTemporalPlainDate.create(this.getContext(), realm, precalculatedPlainDateTime.getYear(), precalculatedPlainDateTime.getMonth(), precalculatedPlainDateTime.getDay(), calendar, this, errorBranch);
            JSDynamicObject untilOptions = TemporalUtil.mergeLargestUnitOption(this.getContext(), namesNode, options, largestUnit);
            JSTemporalDurationRecord difference = TemporalUtil.differenceZonedDateTime(this.getContext(), realm, namesNode, zonedDateTime.getNanoseconds(), other.getNanoseconds(), timeZoneRec, calendarRec, largestUnit, precalculatedPlainDateTime, untilOptions);
            JSTemporalDurationRecord roundResult = roundDurationNode.execute(difference.getYears(), difference.getMonths(), difference.getWeeks(), difference.getDays(), difference.getHours(), difference.getMinutes(), difference.getSeconds(), difference.getMilliseconds(), difference.getMicroseconds(), difference.getNanoseconds(), (long)roundingIncrement, smallestUnit, roundingMode, plainRelativeTo, zonedDateTime, calendarRec, timeZoneRec, precalculatedPlainDateTime);
            JSTemporalDurationRecord result3 = TemporalUtil.adjustRoundedDurationDays(this.getContext(), realm, durationAddNode, roundDurationNode, roundResult.getYears(), roundResult.getMonths(), roundResult.getWeeks(), roundResult.getDays(), roundResult.getHours(), roundResult.getMinutes(), roundResult.getSeconds(), roundResult.getMilliseconds(), roundResult.getMicroseconds(), roundResult.getNanoseconds(), (long)roundingIncrement, smallestUnit, roundingMode, zonedDateTime, calendarRec, timeZoneRec, precalculatedPlainDateTime);
            return JSTemporalDuration.createTemporalDuration(this.getContext(), realm, (double)this.sign * result3.getYears(), (double)this.sign * result3.getMonths(), (double)this.sign * result3.getWeeks(), (double)this.sign * result3.getDays(), (double)this.sign * result3.getHours(), (double)this.sign * result3.getMinutes(), (double)this.sign * result3.getSeconds(), (double)this.sign * result3.getMilliseconds(), (double)this.sign * result3.getMicroseconds(), (double)this.sign * result3.getNanoseconds(), this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj, Object otherParam, Object optionsParam) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeRound
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeRound(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected JSDynamicObject round(JSTemporalZonedDateTimeObject zonedDateTime, Object roundToParam, @Cached JSToNumberNode toNumber, @Cached TruffleString.EqualNode equalNode, @Cached TemporalGetOptionNode getOptionNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined, @Cached CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord) {
            JSDynamicObject roundTo;
            if (roundToParam == Undefined.instance) {
                errorBranch.enter(this);
                throw TemporalErrors.createTypeErrorOptionsUndefined();
            }
            if (Strings.isTString(roundToParam)) {
                roundTo = JSOrdinary.createWithNullPrototype(this.getContext());
                JSRuntime.createDataPropertyOrThrow(roundTo, TemporalConstants.SMALLEST_UNIT, JSRuntime.toStringIsString(roundToParam));
            } else {
                roundTo = this.getOptionsObject(roundToParam, this, errorBranch, optionUndefined);
            }
            TemporalUtil.Unit smallestUnit = JSTemporalZonedDateTimeRound.toSmallestTemporalUnit(roundTo, TemporalUtil.listYMW, null, equalNode, getOptionNode, this, errorBranch);
            if (smallestUnit == TemporalUtil.Unit.EMPTY) {
                errorBranch.enter(this);
                throw TemporalErrors.createRangeErrorSmallestUnitExpected();
            }
            TemporalUtil.RoundingMode roundingMode = JSTemporalZonedDateTimeRound.toTemporalRoundingMode(roundTo, TemporalConstants.HALF_EXPAND, equalNode, getOptionNode);
            double roundingIncrement = TemporalUtil.toTemporalDateTimeRoundingIncrement(roundTo, smallestUnit, this.isObjectNode, toNumber);
            JSDynamicObject timeZone = zonedDateTime.getTimeZone();
            TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeFull(timeZone);
            JSRealm realm = this.getRealm();
            JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), realm, zonedDateTime.getNanoseconds());
            JSDynamicObject calendar = zonedDateTime.getCalendar();
            long offsetNanoseconds = TemporalUtil.getOffsetNanosecondsFor(timeZoneRec, instant);
            JSTemporalPlainDateTimeObject tdt = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(this.getContext(), realm, instant, calendar, offsetNanoseconds);
            JSTemporalCalendarObject isoCalendar = TemporalUtil.getISO8601Calendar(this.getContext(), realm);
            JSTemporalPlainDateTimeObject dtStart = JSTemporalPlainDateTime.create(this.getContext(), realm, tdt.getYear(), tdt.getMonth(), tdt.getDay(), 0, 0, 0, 0, 0, 0, isoCalendar, this, errorBranch);
            JSTemporalInstantObject instantStart = TemporalUtil.builtinTimeZoneGetInstantFor(this.getContext(), realm, timeZoneRec, dtStart, TemporalUtil.Disambiguation.COMPATIBLE);
            BigInt startNs = instantStart.getNanoseconds();
            BigInt endNs = TemporalUtil.addDaysToZonedDateTime(this.getContext(), realm, instantStart, dtStart, timeZoneRec, 1).epochNanoseconds();
            BigInt dayLengthNs = endNs.subtract(startNs);
            if (dayLengthNs.compareValueTo(0L) == 0) {
                errorBranch.enter(this);
                throw Errors.createRangeError("day length of zero now allowed");
            }
            JSTemporalDurationRecord roundResult = TemporalUtil.roundISODateTime(tdt.getYear(), tdt.getMonth(), tdt.getDay(), tdt.getHour(), tdt.getMinute(), tdt.getSecond(), tdt.getMillisecond(), tdt.getMicrosecond(), tdt.getNanosecond(), roundingIncrement, smallestUnit, roundingMode, TemporalUtil.bigIntToLong(dayLengthNs));
            BigInt epochNanoseconds = TemporalUtil.interpretISODateTimeOffset(this.getContext(), realm, TemporalUtil.dtoi(roundResult.getYears()), TemporalUtil.dtoi(roundResult.getMonths()), TemporalUtil.dtoi(roundResult.getDays()), TemporalUtil.dtoi(roundResult.getHours()), TemporalUtil.dtoi(roundResult.getMinutes()), TemporalUtil.dtoi(roundResult.getSeconds()), TemporalUtil.dtoi(roundResult.getMilliseconds()), TemporalUtil.dtoi(roundResult.getMicroseconds()), TemporalUtil.dtoi(roundResult.getNanoseconds()), TemporalUtil.OffsetBehaviour.OPTION, offsetNanoseconds, timeZoneRec, TemporalUtil.Disambiguation.COMPATIBLE, TemporalUtil.OffsetOption.PREFER, TemporalUtil.MatchBehaviour.MATCH_EXACTLY);
            return JSTemporalZonedDateTime.create(this.getContext(), realm, epochNanoseconds, timeZone, calendar);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj, Object roundToParam) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeEquals
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeEquals(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected boolean equals(JSTemporalZonedDateTimeObject thisZonedDateTime, Object otherParam, @Cached ToTemporalZonedDateTimeNode toTemporalZonedDateTime, @Cached JSToStringNode toStringNode) {
            JSTemporalZonedDateTimeObject otherZonedDateTime = toTemporalZonedDateTime.execute(otherParam, Undefined.instance);
            if (!thisZonedDateTime.getNanoseconds().equals(otherZonedDateTime.getNanoseconds())) {
                return false;
            }
            if (!TemporalUtil.timeZoneEquals(thisZonedDateTime.getTimeZone(), otherZonedDateTime.getTimeZone(), toStringNode)) {
                return false;
            }
            return TemporalUtil.calendarEquals(thisZonedDateTime.getCalendar(), otherZonedDateTime.getCalendar(), toStringNode);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static boolean invalidReceiver(Object thisObj, Object otherParam) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeStartOfDay
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeStartOfDay(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected Object startOfDay(JSTemporalZonedDateTimeObject zonedDateTime, @Cached InlinedBranchProfile errorBranch, @Cached CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord) {
            JSDynamicObject timeZone = zonedDateTime.getTimeZone();
            TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeFull(timeZone);
            JSDynamicObject calendar = zonedDateTime.getCalendar();
            JSRealm realm = this.getRealm();
            JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), realm, zonedDateTime.getNanoseconds());
            JSTemporalPlainDateTimeObject dt = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(this.getContext(), realm, timeZoneRec, instant, calendar);
            JSTemporalPlainDateTimeObject startDateTime = JSTemporalPlainDateTime.create(this.getContext(), realm, dt.getYear(), dt.getMonth(), dt.getDay(), 0, 0, 0, 0, 0, 0, calendar, this, errorBranch);
            JSTemporalInstantObject startInstant = TemporalUtil.builtinTimeZoneGetInstantFor(this.getContext(), realm, timeZoneRec, startDateTime, TemporalUtil.Disambiguation.COMPATIBLE);
            return JSTemporalZonedDateTime.create(this.getContext(), realm, startInstant.getNanoseconds(), timeZone, calendar);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeToInstant
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeToInstant(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected Object toInstant(JSTemporalZonedDateTimeObject zonedDateTime) {
            return JSTemporalInstant.create(this.getContext(), this.getRealm(), zonedDateTime.getNanoseconds());
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeToPlainDate
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeToPlainDate(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected Object toPlainDate(JSTemporalZonedDateTimeObject zdt, @Cached InlinedBranchProfile errorBranch, @Cached CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord) {
            JSDynamicObject timeZone = zdt.getTimeZone();
            TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeOnlyGetOffsetNanosecondsFor(timeZone);
            JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), this.getRealm(), zdt.getNanoseconds());
            JSDynamicObject calendar = zdt.getCalendar();
            JSTemporalPlainDateTimeObject dt = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(this.getContext(), this.getRealm(), timeZoneRec, instant, calendar);
            return JSTemporalPlainDate.create(this.getContext(), this.getRealm(), dt.getYear(), dt.getMonth(), dt.getDay(), calendar, this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeToPlainTime
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeToPlainTime(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected Object toPlainTime(JSTemporalZonedDateTimeObject zdt, @Cached InlinedBranchProfile errorBranch, @Cached CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord) {
            JSDynamicObject timeZone = zdt.getTimeZone();
            TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeOnlyGetOffsetNanosecondsFor(timeZone);
            JSRealm realm = this.getRealm();
            JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), realm, zdt.getNanoseconds());
            JSDynamicObject calendar = zdt.getCalendar();
            JSTemporalPlainDateTimeObject dt = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(this.getContext(), realm, timeZoneRec, instant, calendar);
            return JSTemporalPlainTime.create(this.getContext(), realm, dt.getHour(), dt.getMinute(), dt.getSecond(), dt.getMillisecond(), dt.getMicrosecond(), dt.getNanosecond(), this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeToPlainDateTime
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeToPlainDateTime(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected Object toPlainDateTime(JSTemporalZonedDateTimeObject zdt, @Cached CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord) {
            JSDynamicObject timeZone = zdt.getTimeZone();
            TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeOnlyGetOffsetNanosecondsFor(timeZone);
            JSRealm realm = this.getRealm();
            JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), realm, zdt.getNanoseconds());
            JSDynamicObject calendar = zdt.getCalendar();
            return TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(this.getContext(), realm, timeZoneRec, instant, calendar);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeToPlainYearMonth
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeToPlainYearMonth(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected Object toPlainYearMonth(JSTemporalZonedDateTimeObject zdt, @Cached TemporalYearMonthFromFieldsNode yearMonthFromFieldsNode, @Cached TemporalCalendarFieldsNode calendarFieldsNode, @Cached CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord) {
            JSDynamicObject timeZone = zdt.getTimeZone();
            TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeOnlyGetOffsetNanosecondsFor(timeZone);
            JSRealm realm = this.getRealm();
            JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), realm, zdt.getNanoseconds());
            JSDynamicObject calendar = zdt.getCalendar();
            JSTemporalPlainDateTimeObject temporalDateTime = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(this.getContext(), realm, timeZoneRec, instant, calendar);
            List<TruffleString> fieldNames = calendarFieldsNode.execute(calendar, TemporalUtil.listMCY);
            JSObject fields = TemporalUtil.prepareTemporalFields(this.getContext(), temporalDateTime, fieldNames, TemporalUtil.listEmpty);
            return yearMonthFromFieldsNode.execute(calendar, fields, Undefined.instance);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeToPlainMonthDay
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeToPlainMonthDay(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected Object toPlainMonthDay(JSTemporalZonedDateTimeObject zdt, @Cached TemporalMonthDayFromFieldsNode monthDayFromFieldsNode, @Cached TemporalCalendarFieldsNode calendarFieldsNode, @Cached CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord) {
            JSDynamicObject timeZone = zdt.getTimeZone();
            TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeOnlyGetOffsetNanosecondsFor(timeZone);
            JSRealm realm = this.getRealm();
            JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), realm, zdt.getNanoseconds());
            JSDynamicObject calendar = zdt.getCalendar();
            JSTemporalPlainDateTimeObject temporalDateTime = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(this.getContext(), realm, timeZoneRec, instant, calendar);
            List<TruffleString> fieldNames = calendarFieldsNode.execute(calendar, TemporalUtil.listDMC);
            JSObject fields = TemporalUtil.prepareTemporalFields(this.getContext(), temporalDateTime, fieldNames, TemporalUtil.listEmpty);
            return monthDayFromFieldsNode.execute(calendar, fields, Undefined.instance);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeGetISOFields
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeGetISOFields(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected JSObject getISOFields(JSTemporalZonedDateTimeObject zdt, @Cached CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord) {
            JSRealm realm = this.getRealm();
            JSObject obj = JSOrdinary.create(this.getContext(), realm);
            JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), realm, zdt.getNanoseconds());
            JSDynamicObject calendar = zdt.getCalendar();
            JSDynamicObject timeZone = zdt.getTimeZone();
            TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeOnlyGetOffsetNanosecondsFor(timeZone);
            JSTemporalPlainDateTimeObject dt = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(this.getContext(), realm, timeZoneRec, instant, calendar);
            TruffleString offset = TemporalUtil.builtinTimeZoneGetOffsetStringFor(timeZoneRec, instant);
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), obj, TemporalConstants.CALENDAR, calendar);
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), obj, TemporalConstants.ISO_DAY, dt.getDay());
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), obj, TemporalConstants.ISO_HOUR, dt.getHour());
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), obj, TemporalConstants.ISO_MICROSECOND, dt.getMicrosecond());
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), obj, TemporalConstants.ISO_MILLISECOND, dt.getMillisecond());
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), obj, TemporalConstants.ISO_MINUTE, dt.getMinute());
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), obj, TemporalConstants.ISO_MONTH, dt.getMonth());
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), obj, TemporalConstants.ISO_NANOSECOND, dt.getNanosecond());
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), obj, TemporalConstants.ISO_SECOND, dt.getSecond());
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), obj, TemporalConstants.ISO_YEAR, dt.getYear());
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), obj, TemporalConstants.OFFSET, offset);
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), obj, TemporalConstants.TIME_ZONE, timeZone);
            return obj;
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static JSObject invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }
}

