/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.substitution;

import com.intellij.httpClient.http.request.HttpRequestPersistentSubstitutor;
import com.intellij.httpClient.http.request.HttpRequestPsiUtilsKt;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutionKey;
import com.intellij.httpClient.http.request.HttpVariableNameInfo;
import com.intellij.httpClient.http.request.environment.HttpRequestEnvironment;
import com.intellij.httpClient.http.request.psi.HttpDynamicVariable;
import com.intellij.httpClient.http.request.run.HttpClientJsonVariablesHelperKt;
import com.intellij.httpClient.http.request.run.HttpClientSessionScope;
import com.intellij.httpClient.http.request.substitution.HttpDynamicVariableProvider;
import com.intellij.httpClient.http.request.substitution.HttpEnvironmentContextProviderKt;
import com.intellij.httpClient.http.request.variables.HttpClientEnvContext;
import com.intellij.httpClient.http.request.variables.HttpSingleVariableSubstitutionInfo;
import com.intellij.httpClient.http.request.variables.HttpVariableJsonProvider;
import com.intellij.httpClient.http.request.variables.HttpVariableSubstitutionInfo;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BC\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0006\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0004J\u0006\u0010\u0018\u001a\u00020\u0000J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ0\u0010\u001f\u001a\u0004\u0018\u00010\u001a2\u0006\u0010 \u001a\u00020\u001a2\b\u0010!\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0006J\u0006\u0010&\u001a\u00020'R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/httpClient/http/request/substitution/HttpEnvironmentContextProvider;", "", "providers", "", "Lcom/intellij/httpClient/http/request/variables/HttpVariableJsonProvider;", "validateVariables", "", "environment", "Lcom/intellij/httpClient/http/request/environment/HttpRequestEnvironment;", "ignoreDynamicVariables", "persistentSubstitutor", "Lcom/intellij/httpClient/http/request/HttpRequestPersistentSubstitutor;", "scope", "Lcom/intellij/httpClient/http/request/run/HttpClientSessionScope;", "<init>", "(Ljava/util/List;ZLcom/intellij/httpClient/http/request/environment/HttpRequestEnvironment;ZLcom/intellij/httpClient/http/request/HttpRequestPersistentSubstitutor;Lcom/intellij/httpClient/http/request/run/HttpClientSessionScope;)V", "getEnvironment", "()Lcom/intellij/httpClient/http/request/environment/HttpRequestEnvironment;", "getScope", "()Lcom/intellij/httpClient/http/request/run/HttpClientSessionScope;", "dynamicVariableProvider", "Lcom/intellij/httpClient/http/request/substitution/HttpDynamicVariableProvider;", "withAddedProvider", "provider", "withClearPersistentStateForDynamic", "getDynamicVariable", "", "dynamicVariable", "Lcom/intellij/httpClient/http/request/psi/HttpDynamicVariable;", "key", "Lcom/intellij/httpClient/http/request/HttpRequestVariableSubstitutionKey;", "getValue", "name", "defaultValue", "project", "Lcom/intellij/openapi/project/Project;", "withVariableValidation", "validate", "getEnvContext", "Lcom/intellij/httpClient/http/request/variables/HttpClientEnvContext;", "intellij.httpClient.executor"})
@SourceDebugExtension(value={"SMAP\nHttpEnvironmentContextProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpEnvironmentContextProvider.kt\ncom/intellij/httpClient/http/request/substitution/HttpEnvironmentContextProvider\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,158:1\n19#2:159\n1797#3,3:160\n*S KotlinDebug\n*F\n+ 1 HttpEnvironmentContextProvider.kt\ncom/intellij/httpClient/http/request/substitution/HttpEnvironmentContextProvider\n*L\n62#1:159\n78#1:160,3\n*E\n"})
public final class HttpEnvironmentContextProvider {
    @NotNull
    private final List<HttpVariableJsonProvider> providers;
    private final boolean validateVariables;
    @NotNull
    private final HttpRequestEnvironment environment;
    private final boolean ignoreDynamicVariables;
    @NotNull
    private final HttpRequestPersistentSubstitutor persistentSubstitutor;
    @NotNull
    private final HttpClientSessionScope scope;
    @NotNull
    private final HttpDynamicVariableProvider dynamicVariableProvider;

    public HttpEnvironmentContextProvider(@NotNull List<? extends HttpVariableJsonProvider> providers, boolean validateVariables, @NotNull HttpRequestEnvironment environment, boolean ignoreDynamicVariables, @NotNull HttpRequestPersistentSubstitutor persistentSubstitutor, @NotNull HttpClientSessionScope scope) {
        Intrinsics.checkNotNullParameter(providers, (String)"providers");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)persistentSubstitutor, (String)"persistentSubstitutor");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.providers = providers;
        this.validateVariables = validateVariables;
        this.environment = environment;
        this.ignoreDynamicVariables = ignoreDynamicVariables;
        this.persistentSubstitutor = persistentSubstitutor;
        this.scope = scope;
        this.dynamicVariableProvider = new HttpDynamicVariableProvider(this.persistentSubstitutor, this.validateVariables, this.ignoreDynamicVariables, this.environment);
    }

    public /* synthetic */ HttpEnvironmentContextProvider(List list2, boolean bl, HttpRequestEnvironment httpRequestEnvironment, boolean bl2, HttpRequestPersistentSubstitutor httpRequestPersistentSubstitutor, HttpClientSessionScope httpClientSessionScope, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        if ((n & 0x10) != 0) {
            httpRequestPersistentSubstitutor = HttpRequestPersistentSubstitutor.Companion.create();
        }
        this(list2, bl, httpRequestEnvironment, bl2, httpRequestPersistentSubstitutor, httpClientSessionScope);
    }

    @NotNull
    public final HttpRequestEnvironment getEnvironment() {
        return this.environment;
    }

    @NotNull
    public final HttpClientSessionScope getScope() {
        return this.scope;
    }

    @NotNull
    public final HttpEnvironmentContextProvider withAddedProvider(@NotNull HttpVariableJsonProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        return new HttpEnvironmentContextProvider(CollectionsKt.plus((Collection)this.providers, (Object)provider), this.validateVariables, this.environment, this.ignoreDynamicVariables, this.persistentSubstitutor, this.scope);
    }

    @NotNull
    public final HttpEnvironmentContextProvider withClearPersistentStateForDynamic() {
        return new HttpEnvironmentContextProvider(this.providers, this.validateVariables, this.environment, this.ignoreDynamicVariables, HttpRequestPersistentSubstitutor.Companion.create(), this.scope);
    }

    @NotNull
    public final String getDynamicVariable(@NotNull HttpDynamicVariable dynamicVariable, @Nullable HttpRequestVariableSubstitutionKey key) {
        Intrinsics.checkNotNullParameter((Object)dynamicVariable, (String)"dynamicVariable");
        return this.dynamicVariableProvider.getDynamicVariable(dynamicVariable, key);
    }

    @Nullable
    public final String getValue(@NotNull String name, @Nullable String defaultValue, @Nullable HttpRequestVariableSubstitutionKey key, @Nullable Project project) {
        Object object;
        HttpVariableSubstitutionInfo substitution;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (HttpRequestPsiUtilsKt.isDynamicVariable(name)) {
            if (project == null) {
                return defaultValue;
            }
            return this.dynamicVariableProvider.getDynamicVariable(name, defaultValue, key, project);
        }
        HttpVariableSubstitutionInfo $this$asSafely$iv = substitution = HttpEnvironmentContextProviderKt.tryToFindVariableSubstitution(new HttpVariableNameInfo(((Object)StringsKt.trim((CharSequence)name)).toString(), 0, 2, null), this.getEnvContext());
        boolean $i$f$asSafely = false;
        HttpVariableSubstitutionInfo httpVariableSubstitutionInfo = $this$asSafely$iv;
        if (!(httpVariableSubstitutionInfo instanceof HttpSingleVariableSubstitutionInfo)) {
            httpVariableSubstitutionInfo = null;
        }
        if ((object = (HttpSingleVariableSubstitutionInfo)httpVariableSubstitutionInfo) == null || (object = ((HttpSingleVariableSubstitutionInfo)object).getVariableValue()) == null) {
            object = defaultValue;
        }
        return object;
    }

    public static /* synthetic */ String getValue$default(HttpEnvironmentContextProvider httpEnvironmentContextProvider, String string, String string2, HttpRequestVariableSubstitutionKey httpRequestVariableSubstitutionKey, Project project, int n, Object object) {
        if ((n & 8) != 0) {
            project = null;
        }
        return httpEnvironmentContextProvider.getValue(string, string2, httpRequestVariableSubstitutionKey, project);
    }

    @NotNull
    public final HttpEnvironmentContextProvider withVariableValidation(boolean validate) {
        return new HttpEnvironmentContextProvider(this.providers, validate, this.environment, this.ignoreDynamicVariables, this.persistentSubstitutor, this.scope);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HttpClientEnvContext getEnvContext() {
        HttpClientEnvContext initial = new HttpClientEnvContext(HttpClientJsonVariablesHelperKt.newObjNode(), HttpClientJsonVariablesHelperKt.newObjNode());
        Iterable $this$fold$iv = this.providers;
        boolean $i$f$fold = false;
        HttpClientEnvContext accumulator$iv = initial;
        for (Object element$iv : $this$fold$iv) {
            void provider;
            HttpVariableJsonProvider httpVariableJsonProvider = (HttpVariableJsonProvider)element$iv;
            HttpClientEnvContext acc = accumulator$iv;
            boolean bl = false;
            HttpClientEnvContext context2 = provider.getHttpClientEnvContext(acc, this.validateVariables, this.dynamicVariableProvider);
            accumulator$iv = HttpEnvironmentContextProviderKt.access$merge(acc, context2);
        }
        return accumulator$iv;
    }
}

