/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.config;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.dashboard.RunDashboardCustomizer;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationNode;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.execution.common.CommonClientResponse;
import com.intellij.httpClient.http.request.run.HttpClientRequestProcessHandler;
import com.intellij.httpClient.http.request.run.config.HttpRequestRunConfiguration;
import com.intellij.httpClient.http.request.run.config.HttpRequestRunDashboardCustomizerKt;
import com.intellij.httpClient.http.request.run.config.HttpRequestRunType;
import com.intellij.httpClient.http.request.run.config.RequestPresentation;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.psi.PsiElement;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/httpClient/http/request/run/config/HttpRequestRunDashboardCustomizer;", "Lcom/intellij/execution/dashboard/RunDashboardCustomizer;", "<init>", "()V", "isApplicable", "", "settings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "descriptor", "Lcom/intellij/execution/ui/RunContentDescriptor;", "updatePresentation", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "node", "Lcom/intellij/execution/dashboard/RunDashboardRunConfigurationNode;", "getPsiElement", "Lcom/intellij/psi/PsiElement;", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpRequestRunDashboardCustomizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRequestRunDashboardCustomizer.kt\ncom/intellij/httpClient/http/request/run/config/HttpRequestRunDashboardCustomizer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,145:1\n1#2:146\n*E\n"})
public final class HttpRequestRunDashboardCustomizer
extends RunDashboardCustomizer {
    public boolean isApplicable(@NotNull RunnerAndConfigurationSettings settings, @Nullable RunContentDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return settings.getConfiguration() instanceof HttpRequestRunConfiguration;
    }

    public boolean updatePresentation(@NotNull PresentationData presentation2, @NotNull RunDashboardRunConfigurationNode node) {
        block8: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            RunConfiguration runConfiguration = node.getConfigurationSettings().getConfiguration();
            HttpRequestRunConfiguration httpRequestRunConfiguration = runConfiguration instanceof HttpRequestRunConfiguration ? (HttpRequestRunConfiguration)runConfiguration : null;
            if (httpRequestRunConfiguration == null) {
                return false;
            }
            HttpRequestRunConfiguration configuration = httpRequestRunConfiguration;
            if (configuration.getSettings().getRunType() != HttpRequestRunType.SINGLE_REQUEST) {
                return true;
            }
            RequestPresentation requestName = HttpRequestRunDashboardCustomizerKt.access$getRequestPresentation(configuration);
            if (requestName != null) {
                RunnerAndConfigurationSettings runnerAndConfigurationSettings = node.getConfigurationSettings();
                Intrinsics.checkNotNullExpressionValue((Object)runnerAndConfigurationSettings, (String)"getConfigurationSettings(...)");
                HttpRequestRunDashboardCustomizerKt.access$addRequestPresentationToNode(presentation2, runnerAndConfigurationSettings, node.getContent(), requestName);
            }
            RunContentDescriptor runContentDescriptor = node.getDescriptor();
            ProcessHandler processHandler = runContentDescriptor != null ? runContentDescriptor.getProcessHandler() : null;
            HttpClientRequestProcessHandler httpClientRequestProcessHandler = processHandler instanceof HttpClientRequestProcessHandler ? (HttpClientRequestProcessHandler)processHandler : null;
            if (httpClientRequestProcessHandler == null) {
                return true;
            }
            HttpClientRequestProcessHandler handler = httpClientRequestProcessHandler;
            if (!handler.isProcessTerminated()) {
                if (handler.isStartNotified()) {
                    presentation2.setIcon((Icon)AnimatedIcon.Default.INSTANCE);
                }
                return true;
            }
            CommonClientResponse commonClientResponse = handler.getResponse();
            if (commonClientResponse == null) {
                return true;
            }
            CommonClientResponse response2 = commonClientResponse;
            Object it = object = response2.getStatusPresentation();
            boolean bl = false;
            Object object2 = !Intrinsics.areEqual((Object)it, (Object)"") ? object : null;
            if (object2 != null) {
                it = object2;
                boolean bl2 = false;
                presentation2.addText(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                Object[] objectArray = new Object[]{it};
                presentation2.addText(RestClientBundle.message("http.request.run.dashboard.customization.status.label", objectArray), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
            it = object = response2.getExecutionTime();
            boolean bl3 = false;
            Object object3 = !Intrinsics.areEqual((Object)handler.getUserData(ProcessHandler.TERMINATION_REQUESTED), (Object)true) ? object : null;
            if (object3 == null) break block8;
            long it2 = ((Number)object3).longValue();
            boolean bl4 = false;
            presentation2.addText(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            presentation2.addText("(" + NlsMessages.formatDuration((long)it2) + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
        return true;
    }

    @Nullable
    public PsiElement getPsiElement(@NotNull RunDashboardRunConfigurationNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return (PsiElement)HttpRequestRunDashboardCustomizerKt.access$findRequest(node);
    }
}

