/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend;

import com.intellij.find.SearchReplaceComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.LineWrapPositionStrategy;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.actions.ChangeEditorFontSizeStrategy;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.SoftWrapModelEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.SoftWrapModelImpl;
import com.intellij.openapi.editor.impl.softwrap.EmptySoftWrapPainter;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapPainter;
import com.intellij.openapi.observable.util.RevertOnDisposeUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.TerminalFontSizeProvider;
import com.intellij.terminal.frontend.CopyOnSelectionHandler;
import com.intellij.terminal.frontend.ReworkedTerminalView;
import com.intellij.terminal.frontend.TerminalBlocksDecorator;
import com.intellij.terminal.frontend.TerminalCursorPainter;
import com.intellij.terminal.frontend.TerminalEventDispatcherKt;
import com.intellij.terminal.frontend.TerminalEventsHandlerImpl;
import com.intellij.terminal.frontend.TerminalInput;
import com.intellij.terminal.frontend.TerminalKeyEncodingManager;
import com.intellij.terminal.frontend.TerminalLineWrapPositionStrategy;
import com.intellij.terminal.frontend.TerminalOutputScrollingModel;
import com.intellij.terminal.frontend.TerminalOutputScrollingModelImpl;
import com.intellij.terminal.frontend.TerminalSearchController;
import com.intellij.terminal.frontend.TerminalSearchControllerListener;
import com.intellij.terminal.frontend.TerminalSearchSession;
import com.intellij.terminal.frontend.TerminalSessionController;
import com.intellij.terminal.frontend.TerminalVfsSynchronizer;
import com.intellij.terminal.frontend.fus.TerminalFusCursorPainterListener;
import com.intellij.terminal.frontend.fus.TerminalFusFirstOutputListener;
import com.intellij.terminal.session.TerminalOutputBlock;
import com.intellij.terminal.session.TerminalSession;
import com.intellij.terminal.session.TerminalState;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.util.CoroutineScopeKt;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.TtyConnector;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import javax.swing.JComponent;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalFontSettingsListener;
import org.jetbrains.plugins.terminal.TerminalFontSettingsService;
import org.jetbrains.plugins.terminal.TerminalFontSizeProviderImpl;
import org.jetbrains.plugins.terminal.TerminalPanelMarker;
import org.jetbrains.plugins.terminal.block.TerminalContentView;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputEditorInputMethodSupport;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputHighlightingsSnapshot;
import org.jetbrains.plugins.terminal.block.output.TerminalTextHighlighter;
import org.jetbrains.plugins.terminal.block.reworked.TerminalBlocksModel;
import org.jetbrains.plugins.terminal.block.reworked.TerminalBlocksModelImpl;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModel;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModelImpl;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModelListener;
import org.jetbrains.plugins.terminal.block.reworked.TerminalSessionModel;
import org.jetbrains.plugins.terminal.block.reworked.TerminalSessionModelImpl;
import org.jetbrains.plugins.terminal.block.reworked.hyperlinks.TerminalHyperlinkHighlighter;
import org.jetbrains.plugins.terminal.block.ui.ChangeTerminalFontSizeStrategy;
import org.jetbrains.plugins.terminal.block.ui.TerminalUi;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtils;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtilsKt;
import org.jetbrains.plugins.terminal.block.ui.VerticalSpaceInlayRenderer;
import org.jetbrains.plugins.terminal.block.util.TerminalDataContextUtils;
import org.jetbrains.plugins.terminal.fus.FrontendLatencyService;
import org.jetbrains.plugins.terminal.fus.FrontendOutputActivity;
import org.jetbrains.plugins.terminal.fus.TerminalStartupFusInfo;
import org.jetbrains.plugins.terminal.util.TerminalCoroutineKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00d4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002YZB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001c\u0010(\u001a\u00020)2\n\u0010*\u001a\u00060+j\u0002`,2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020)2\u0006\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u000203H\u0016J\n\u00104\u001a\u0004\u0018\u000105H\u0016J\f\u00106\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016J\b\u00107\u001a\u000203H\u0016J\u0016\u00108\u001a\u00020)2\u0006\u0010\"\u001a\u00020#2\u0006\u00109\u001a\u00020.J\b\u0010:\u001a\u00020)H\u0002J\b\u0010;\u001a\u00020)H\u0002J\b\u0010<\u001a\u00020)H\u0002J\b\u0010=\u001a\u00020)H\u0002J\b\u0010>\u001a\u00020\u001cH\u0002Jn\u0010?\u001a\u00020)2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010@\u001a\u00020\u001c2\u0006\u0010A\u001a\u00020B2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010C\u001a\u0004\u0018\u00010D2\b\u0010E\u001a\u0004\u0018\u00010F2\u0006\u0010G\u001a\u000203H\u0002J\u0010\u0010H\u001a\u00020)2\u0006\u0010@\u001a\u00020IH\u0002J\u0018\u0010J\u001a\u00020\u001c2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010-\u001a\u00020.H\u0002J\u0018\u0010K\u001a\u00020\u001c2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010-\u001a\u00020.H\u0002J \u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020O2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010-\u001a\u00020.H\u0002J\f\u0010P\u001a\u00020)*\u00020MH\u0002J\b\u0010Q\u001a\u00020)H\u0016J\u0018\u0010R\u001a\u00020)2\u0006\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u000205H\u0016J\u0018\u0010V\u001a\u00020)2\u0006\u0010-\u001a\u00020.2\u0006\u0010W\u001a\u00020XH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010 \u001a\u00060!R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010%\u00a8\u0006["}, d2={"Lcom/intellij/terminal/frontend/ReworkedTerminalView;", "Lorg/jetbrains/plugins/terminal/block/TerminalContentView;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "sessionFuture", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/terminal/session/TerminalSession;", "startupFusInfo", "Lorg/jetbrains/plugins/terminal/fus/TerminalStartupFusInfo;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;Ljava/util/concurrent/CompletableFuture;Lorg/jetbrains/plugins/terminal/fus/TerminalStartupFusInfo;)V", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "sessionModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalSessionModel;", "blocksModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalBlocksModel;", "encodingManager", "Lcom/intellij/terminal/frontend/TerminalKeyEncodingManager;", "controller", "Lcom/intellij/terminal/frontend/TerminalSessionController;", "terminalInput", "Lcom/intellij/terminal/frontend/TerminalInput;", "terminalSearchController", "Lcom/intellij/terminal/frontend/TerminalSearchController;", "outputEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "alternateBufferEditor", "scrollingModel", "Lcom/intellij/terminal/frontend/TerminalOutputScrollingModel;", "terminalPanel", "Lcom/intellij/terminal/frontend/ReworkedTerminalView$TerminalPanel;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "preferredFocusableComponent", "getPreferredFocusableComponent", "addTerminationCallback", "", "onTerminated", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "sendCommandToExecute", "shellCommand", "", "isCommandRunning", "", "getTerminalSize", "Lcom/jediterm/core/util/TermSize;", "getTerminalSizeInitializedFuture", "isFocused", "setTopComponent", "disposable", "listenSearchController", "listenPanelSizeChanges", "sendResizeEvent", "listenAlternateBufferSwitch", "getCurEditor", "configureOutputEditor", "editor", "model", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;", "fusCursorPainterListener", "Lcom/intellij/terminal/frontend/fus/TerminalFusCursorPainterListener;", "fusFirstOutputListener", "Lcom/intellij/terminal/frontend/fus/TerminalFusFirstOutputListener;", "withTopAndBottomInsets", "addTopAndBottomInsets", "Lcom/intellij/openapi/editor/Editor;", "createOutputEditor", "createAlternateBufferEditor", "createEditor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "document", "Lcom/intellij/openapi/editor/Document;", "resizeIfShowing", "dispose", "connectToTty", "ttyConnector", "Lcom/jediterm/terminal/TtyConnector;", "initialTermSize", "addFocusListener", "listener", "Ljava/awt/event/FocusListener;", "TerminalPanel", "TerminalLayeredPane", "intellij.terminal.frontend"})
@SourceDebugExtension(value={"SMAP\nReworkedTerminalView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReworkedTerminalView.kt\ncom/intellij/terminal/frontend/ReworkedTerminalView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,545:1\n1#2:546\n*E\n"})
public final class ReworkedTerminalView
implements TerminalContentView {
    @NotNull
    private final Project project;
    @NotNull
    private final CompletableFuture<TerminalSession> sessionFuture;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final TerminalSessionModel sessionModel;
    @NotNull
    private final TerminalBlocksModel blocksModel;
    @NotNull
    private final TerminalKeyEncodingManager encodingManager;
    @NotNull
    private final TerminalSessionController controller;
    @NotNull
    private final TerminalInput terminalInput;
    @NotNull
    private final TerminalSearchController terminalSearchController;
    @NotNull
    private final EditorEx outputEditor;
    @NotNull
    private final EditorEx alternateBufferEditor;
    @NotNull
    private final TerminalOutputScrollingModel scrollingModel;
    @NotNull
    private final TerminalPanel terminalPanel;

    public ReworkedTerminalView(@NotNull Project project, @NotNull JBTerminalSystemSettingsProviderBase settings, @NotNull CompletableFuture<TerminalSession> sessionFuture, @Nullable TerminalStartupFusInfo startupFusInfo) {
        TerminalFusFirstOutputListener terminalFusFirstOutputListener;
        TerminalFusCursorPainterListener terminalFusCursorPainterListener;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter(sessionFuture, (String)"sessionFuture");
        this.project = project;
        this.sessionFuture = sessionFuture;
        this.coroutineScope = com.intellij.platform.util.coroutines.CoroutineScopeKt.childScope$default((CoroutineScope)TerminalCoroutineKt.terminalProjectScope(this.project), (String)"ReworkedTerminalView", null, (boolean)false, (int)6, null);
        Disposer.register((Disposable)this, () -> ReworkedTerminalView._init_$lambda$0(this));
        this.sessionModel = new TerminalSessionModelImpl();
        this.encodingManager = new TerminalKeyEncodingManager(this.sessionModel, com.intellij.platform.util.coroutines.CoroutineScopeKt.childScope$default((CoroutineScope)this.coroutineScope, (String)"TerminalKeyEncodingManager", null, (boolean)false, (int)6, null));
        this.terminalInput = new TerminalInput(this.sessionFuture, this.sessionModel, startupFusInfo, com.intellij.platform.util.coroutines.CoroutineScopeKt.childScope$default((CoroutineScope)this.coroutineScope, (String)"TerminalInput", null, (boolean)false, (int)6, null));
        TerminalStartupFusInfo terminalStartupFusInfo = startupFusInfo;
        if (terminalStartupFusInfo != null) {
            TerminalStartupFusInfo it = terminalStartupFusInfo;
            boolean bl = false;
            terminalFusCursorPainterListener = new TerminalFusCursorPainterListener(it);
        } else {
            terminalFusCursorPainterListener = null;
        }
        TerminalFusCursorPainterListener fusCursorPaintingListener = terminalFusCursorPainterListener;
        TerminalStartupFusInfo terminalStartupFusInfo2 = startupFusInfo;
        if (terminalStartupFusInfo2 != null) {
            TerminalStartupFusInfo it = terminalStartupFusInfo2;
            boolean bl = false;
            terminalFusFirstOutputListener = new TerminalFusFirstOutputListener(it);
        } else {
            terminalFusFirstOutputListener = null;
        }
        TerminalFusFirstOutputListener fusFirstOutputListener = terminalFusFirstOutputListener;
        this.alternateBufferEditor = this.createAlternateBufferEditor(settings, this);
        DocumentEx documentEx = this.alternateBufferEditor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        TerminalOutputModelImpl alternateBufferModel = new TerminalOutputModelImpl((Document)documentEx, 0);
        this.configureOutputEditor(this.project, this.alternateBufferEditor, alternateBufferModel, settings, this.sessionModel, this.encodingManager, this.terminalInput, com.intellij.platform.util.coroutines.CoroutineScopeKt.childScope$default((CoroutineScope)this.coroutineScope, (String)"TerminalAlternateBufferModel", null, (boolean)false, (int)6, null), null, fusCursorPaintingListener, fusFirstOutputListener, false);
        this.outputEditor = this.createOutputEditor(settings, this);
        DocumentEx documentEx2 = this.outputEditor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx2, (String)"getDocument(...)");
        TerminalOutputModelImpl outputModel = new TerminalOutputModelImpl((Document)documentEx2, TerminalUiUtils.INSTANCE.getDefaultMaxOutputLength());
        this.scrollingModel = new TerminalOutputScrollingModelImpl(this.outputEditor, outputModel, this.sessionModel, com.intellij.platform.util.coroutines.CoroutineScopeKt.childScope$default((CoroutineScope)this.coroutineScope, (String)"TerminalOutputScrollingModel", null, (boolean)false, (int)6, null));
        this.outputEditor.putUserData(TerminalOutputScrollingModel.Companion.getKEY(), (Object)this.scrollingModel);
        this.configureOutputEditor(this.project, this.outputEditor, outputModel, settings, this.sessionModel, this.encodingManager, this.terminalInput, com.intellij.platform.util.coroutines.CoroutineScopeKt.childScope$default((CoroutineScope)this.coroutineScope, (String)"TerminalOutputModel", null, (boolean)false, (int)6, null), this.scrollingModel, fusCursorPaintingListener, fusFirstOutputListener, true);
        this.terminalSearchController = new TerminalSearchController(this.project);
        DocumentEx documentEx3 = this.outputEditor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx3, (String)"getDocument(...)");
        this.blocksModel = new TerminalBlocksModelImpl((Document)documentEx3);
        new TerminalBlocksDecorator(this.outputEditor, this.blocksModel, this.scrollingModel, com.intellij.platform.util.coroutines.CoroutineScopeKt.childScope$default((CoroutineScope)this.coroutineScope, (String)"TerminalBlocksDecorator", null, (boolean)false, (int)6, null));
        FrontendLatencyService frontendLatencyService = FrontendLatencyService.Companion.getInstance();
        EditorEx editorEx = this.outputEditor;
        Intrinsics.checkNotNull((Object)editorEx, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        EditorImpl editorImpl = (EditorImpl)editorEx;
        EditorEx editorEx2 = this.alternateBufferEditor;
        Intrinsics.checkNotNull((Object)editorEx2, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        FrontendOutputActivity fusActivity = frontendLatencyService.startFrontendOutputActivity(editorImpl, (EditorImpl)editorEx2);
        this.controller = new TerminalSessionController(this.sessionModel, outputModel, alternateBufferModel, this.blocksModel, settings, com.intellij.platform.util.coroutines.CoroutineScopeKt.childScope$default((CoroutineScope)this.coroutineScope, (String)"TerminalSessionController", null, (boolean)false, (int)6, null), fusActivity);
        this.sessionFuture.thenAccept(arg_0 -> ReworkedTerminalView._init_$lambda$4(arg_0 -> ReworkedTerminalView._init_$lambda$3(this, arg_0), arg_0));
        this.terminalPanel = new TerminalPanel((Editor)this.outputEditor);
        this.listenSearchController();
        this.listenPanelSizeChanges();
        this.listenAlternateBufferSwitch();
        TerminalVfsSynchronizer.Companion.install(this.controller, (Function2<? super Disposable, ? super FocusListener, Unit>)((Function2)new Function2<Disposable, FocusListener, Unit>((Object)this){

            public final void invoke(Disposable p0, FocusListener p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                ((ReworkedTerminalView)this.receiver).addFocusListener(p0, p1);
            }
        }), this);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return (JComponent)((Object)this.terminalPanel);
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusableComponent() {
        return this.terminalPanel.getPreferredFocusableComponent();
    }

    @Override
    public void addTerminationCallback(@NotNull Runnable onTerminated, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)onTerminated, (String)"onTerminated");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.controller.addTerminationCallback(onTerminated, parentDisposable);
    }

    @Override
    public void sendCommandToExecute(@NotNull String shellCommand) {
        Intrinsics.checkNotNullParameter((Object)shellCommand, (String)"shellCommand");
        byte[] byArray = this.encodingManager.getCode(10, 0);
        Intrinsics.checkNotNull((Object)byArray);
        byte[] newLineBytes = byArray;
        byte[] byArray2 = shellCommand.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        byte[] bytes = ArraysKt.plus((byte[])byArray2, (byte[])newLineBytes);
        this.terminalInput.sendBytes(bytes);
    }

    @Override
    public boolean isCommandRunning() {
        TerminalSession terminalSession = this.sessionFuture.getNow(null);
        if (terminalSession == null) {
            return false;
        }
        TerminalSession session2 = terminalSession;
        return ((TerminalOutputBlock)CollectionsKt.last(this.blocksModel.getBlocks())).getOutputStartOffset() != -1 && !session2.isClosed();
    }

    @Override
    @Nullable
    public TermSize getTerminalSize() {
        return TerminalUiUtilsKt.calculateTerminalSize((Editor)this.getCurEditor());
    }

    @Override
    @NotNull
    public CompletableFuture<?> getTerminalSizeInitializedFuture() {
        return TerminalUiUtils.INSTANCE.getComponentSizeInitializedFuture(this.getComponent());
    }

    @Override
    public boolean isFocused() {
        return this.getComponent().hasFocus();
    }

    public final void setTopComponent(@NotNull JComponent component2, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        ComponentAdapter resizeListener2 = new ComponentAdapter(this){
            final /* synthetic */ ReworkedTerminalView this$0;
            {
                this.this$0 = $receiver;
            }

            public void componentResized(ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ReworkedTerminalView.access$getScrollingModel$p(this.this$0).scrollToCursor(false);
            }
        };
        component2.addComponentListener(resizeListener2);
        this.terminalPanel.setTopComponent(component2);
        Disposer.register((Disposable)disposable, () -> ReworkedTerminalView.setTopComponent$lambda$5(component2, resizeListener2, this));
    }

    private final void listenSearchController() {
        this.terminalSearchController.addListener(new TerminalSearchControllerListener(this){
            final /* synthetic */ ReworkedTerminalView this$0;
            {
                this.this$0 = $receiver;
            }

            public void searchSessionStarted(TerminalSearchSession session2) {
                Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
                ReworkedTerminalView.access$getTerminalPanel$p(this.this$0).installSearchComponent(session2.getComponent());
            }

            public void searchSessionFinished(TerminalSearchSession session2) {
                Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
                ReworkedTerminalView.access$getTerminalPanel$p(this.this$0).removeSearchComponent(session2.getComponent());
            }
        });
    }

    private final void listenPanelSizeChanges() {
        this.getComponent().addComponentListener(new ComponentAdapter(this){
            final /* synthetic */ ReworkedTerminalView this$0;
            {
                this.this$0 = $receiver;
            }

            public void componentResized(ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ReworkedTerminalView.access$sendResizeEvent(this.this$0);
            }
        });
    }

    private final void sendResizeEvent() {
        TermSize termSize = this.getTerminalSize();
        if (termSize == null) {
            return;
        }
        TermSize newSize = termSize;
        this.terminalInput.sendResize(newSize);
    }

    private final void listenAlternateBufferSwitch() {
        CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
        ModalityState modalityState = ModalityState.any();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)).plus((CoroutineContext)new CoroutineName("Alternate buffer switch listener")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ReworkedTerminalView this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Ref.BooleanRef isAlternateScreenBuffer = new Ref.BooleanRef();
                        this.label = 1;
                        Object object3 = ReworkedTerminalView.access$getSessionModel$p(this.this$0).getTerminalState().collect(new FlowCollector(isAlternateScreenBuffer, this.this$0){
                            final /* synthetic */ Ref.BooleanRef $isAlternateScreenBuffer;
                            final /* synthetic */ ReworkedTerminalView this$0;
                            {
                                this.$isAlternateScreenBuffer = $isAlternateScreenBuffer;
                                this.this$0 = $receiver;
                            }

                            public final Object emit(TerminalState state, Continuation<? super Unit> $completion) {
                                if (state.isAlternateScreenBuffer() != this.$isAlternateScreenBuffer.element) {
                                    this.$isAlternateScreenBuffer.element = state.isAlternateScreenBuffer();
                                    EditorEx editor = state.isAlternateScreenBuffer() ? ReworkedTerminalView.access$getAlternateBufferEditor$p(this.this$0) : ReworkedTerminalView.access$getOutputEditor$p(this.this$0);
                                    ReworkedTerminalView.access$getTerminalPanel$p(this.this$0).setTerminalContent((Editor)editor);
                                    ReworkedTerminalView.access$getTerminalSearchController$p(this.this$0).finishSearchSession();
                                    IdeFocusManager.getInstance((Project)ReworkedTerminalView.access$getProject$p(this.this$0)).requestFocus((Component)ReworkedTerminalView.access$getTerminalPanel$p(this.this$0).getPreferredFocusableComponent(), true);
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) throw new KotlinNothingValueException();
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final EditorEx getCurEditor() {
        return ((TerminalState)this.sessionModel.getTerminalState().getValue()).isAlternateScreenBuffer() ? this.alternateBufferEditor : this.outputEditor;
    }

    private final void configureOutputEditor(Project project, EditorEx editor, TerminalOutputModel model, JBTerminalSystemSettingsProviderBase settings, TerminalSessionModel sessionModel, TerminalKeyEncodingManager encodingManager, TerminalInput terminalInput, CoroutineScope coroutineScope, TerminalOutputScrollingModel scrollingModel, TerminalFusCursorPainterListener fusCursorPainterListener, TerminalFusFirstOutputListener fusFirstOutputListener, boolean withTopAndBottomInsets) {
        block3: {
            Disposable parentDisposable = CoroutineScopeKt.asDisposable((CoroutineScope)coroutineScope);
            model.addListener(parentDisposable, new TerminalOutputModelListener(editor){
                final /* synthetic */ EditorEx $editor;
                {
                    this.$editor = $editor;
                }

                public void beforeContentChanged(TerminalOutputModel model) {
                    Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                    TerminalUiUtilsKt.setTerminalOutputScrollChangingActionInProgress((Editor)this.$editor, true);
                }

                public void afterContentChanged(TerminalOutputModel model, int startOffset) {
                    Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                    TerminalUiUtilsKt.setTerminalOutputScrollChangingActionInProgress((Editor)this.$editor, false);
                    this.$editor.repaint(startOffset, this.$editor.getDocument().getTextLength());
                }
            });
            if (fusFirstOutputListener != null) {
                model.addListener(parentDisposable, fusFirstOutputListener);
            }
            editor.setHighlighter((EditorHighlighter)new TerminalTextHighlighter((Function0<TerminalOutputHighlightingsSnapshot>)((Function0)() -> ReworkedTerminalView.configureOutputEditor$lambda$6(model))));
            TerminalHyperlinkHighlighter.Companion.install(project, model, (Editor)editor, coroutineScope);
            TerminalCursorPainter cursorPainter = TerminalCursorPainter.Companion.install(editor, model, sessionModel, com.intellij.platform.util.coroutines.CoroutineScopeKt.childScope$default((CoroutineScope)coroutineScope, (String)"TerminalCursorPainter", null, (boolean)false, (int)6, null));
            if (fusCursorPainterListener != null) {
                cursorPainter.addListener(parentDisposable, fusCursorPainterListener);
            }
            if (withTopAndBottomInsets) {
                this.addTopAndBottomInsets((Editor)editor);
            }
            TerminalEventsHandlerImpl eventsHandler = new TerminalEventsHandlerImpl(sessionModel, editor, encodingManager, terminalInput, settings, scrollingModel);
            TerminalEventDispatcherKt.setupKeyEventDispatcher(editor, settings, eventsHandler, parentDisposable);
            TerminalEventDispatcherKt.setupMouseListener(editor, sessionModel, settings, eventsHandler, parentDisposable);
            new TerminalOutputEditorInputMethodSupport(editor, com.intellij.platform.util.coroutines.CoroutineScopeKt.childScope$default((CoroutineScope)coroutineScope, (String)"TerminalInputMethodSupport", null, (boolean)false, (int)6, null), (Function0<? extends LogicalPosition>)((Function0)() -> ReworkedTerminalView.configureOutputEditor$lambda$7(model, editor)), model.getCursorOffsetState(), (Function1<? super String, Unit>)((Function1)arg_0 -> ReworkedTerminalView.configureOutputEditor$lambda$8(terminalInput, arg_0)));
            CopyOnSelectionHandler.Companion.install((Editor)editor, settings);
            SoftWrapModelEx softWrapModelEx = editor.getSoftWrapModel();
            SoftWrapModelImpl softWrapModelImpl = softWrapModelEx instanceof SoftWrapModelImpl ? (SoftWrapModelImpl)softWrapModelEx : null;
            if (softWrapModelImpl == null) break block3;
            softWrapModelImpl.setSoftWrapPainter((SoftWrapPainter)EmptySoftWrapPainter.INSTANCE);
        }
    }

    private final void addTopAndBottomInsets(Editor editor) {
        InlayModel inlayModel = editor.getInlayModel();
        Intrinsics.checkNotNullExpressionValue((Object)inlayModel, (String)"getInlayModel(...)");
        InlayModel inlayModel2 = inlayModel;
        VerticalSpaceInlayRenderer topRenderer = new VerticalSpaceInlayRenderer(6);
        Intrinsics.checkNotNull((Object)inlayModel2.addBlockElement(0, false, true, 200, (EditorCustomElementRenderer)topRenderer));
        VerticalSpaceInlayRenderer bottomRenderer = new VerticalSpaceInlayRenderer(6);
        inlayModel2.addBlockElement(editor.getDocument().getTextLength(), true, false, 0, (EditorCustomElementRenderer)bottomRenderer);
    }

    private final EditorEx createOutputEditor(JBTerminalSystemSettingsProviderBase settings, Disposable parentDisposable) {
        DocumentImpl document = new DocumentImpl((CharSequence)"", true);
        EditorImpl editor = this.createEditor((Document)document, settings, parentDisposable);
        editor.putUserData(TerminalDataContextUtils.INSTANCE.getIS_OUTPUT_MODEL_EDITOR_KEY(), (Object)true);
        editor.getSettings().setUseSoftWraps(true);
        TerminalUi.INSTANCE.useTerminalDefaultBackground((EditorEx)editor, this);
        Disposer.register((Disposable)parentDisposable, () -> ReworkedTerminalView.createOutputEditor$lambda$9(editor));
        return (EditorEx)editor;
    }

    private final EditorEx createAlternateBufferEditor(JBTerminalSystemSettingsProviderBase settings, Disposable parentDisposable) {
        DocumentImpl document = new DocumentImpl((CharSequence)"", true);
        EditorImpl editor = this.createEditor((Document)document, settings, parentDisposable);
        editor.putUserData(TerminalDataContextUtils.INSTANCE.getIS_ALTERNATE_BUFFER_MODEL_EDITOR_KEY(), (Object)true);
        TerminalUi.INSTANCE.useTerminalDefaultBackground((EditorEx)editor, this);
        editor.getScrollPane().setVerticalScrollBarPolicy(21);
        editor.getScrollPane().setHorizontalScrollBarPolicy(31);
        Disposer.register((Disposable)parentDisposable, () -> ReworkedTerminalView.createAlternateBufferEditor$lambda$10(editor));
        return (EditorEx)editor;
    }

    private final EditorImpl createEditor(Document document, JBTerminalSystemSettingsProviderBase settings, Disposable parentDisposable) {
        EditorImpl result2 = TerminalUiUtils.INSTANCE.createOutputEditor(document, this.project, settings, false);
        result2.setContextMenuGroupId("Terminal.ReworkedTerminalContextMenu");
        result2.getSoftWrapModel().getApplianceManager().setLineWrapPositionStrategy((LineWrapPositionStrategy)new TerminalLineWrapPositionStrategy());
        result2.getSoftWrapModel().getApplianceManager().setSoftWrapsUnderScrollBar(true);
        result2.putUserData(ChangeEditorFontSizeStrategy.KEY, (Object)ChangeTerminalFontSizeStrategy.INSTANCE);
        result2.putUserData(TerminalFontSizeProvider.KEY, (Object)TerminalFontSizeProviderImpl.Companion.getInstance());
        TerminalFontSettingsListener fontSettingsListener2 = new TerminalFontSettingsListener(result2, settings, this){
            final /* synthetic */ EditorImpl $result;
            final /* synthetic */ JBTerminalSystemSettingsProviderBase $settings;
            final /* synthetic */ ReworkedTerminalView this$0;
            {
                this.$result = $result;
                this.$settings = $settings;
                this.this$0 = $receiver;
            }

            public void fontSettingsChanged() {
                TerminalUiUtilsKt.applyFontSettings(this.$result, this.$settings);
                this.$result.reinitSettings();
                ReworkedTerminalView.access$resizeIfShowing(this.this$0, this.$result);
            }
        };
        TerminalFontSettingsService.Companion.getInstance().addListener(fontSettingsListener2, parentDisposable);
        TerminalFontSizeProviderImpl.Companion.getInstance().addListener(parentDisposable, new TerminalFontSizeProvider.Listener(result2, this){
            final /* synthetic */ EditorImpl $result;
            final /* synthetic */ ReworkedTerminalView this$0;
            {
                this.$result = $result;
                this.this$0 = $receiver;
            }

            public void fontChanged(boolean showZoomIndicator) {
                TerminalUiUtilsKt.setTerminalFontSize(this.$result, TerminalFontSizeProviderImpl.Companion.getInstance().getFontSize(), showZoomIndicator);
                ReworkedTerminalView.access$resizeIfShowing(this.this$0, this.$result);
            }
        });
        return result2;
    }

    private final void resizeIfShowing(EditorImpl $this$resizeIfShowing) {
        if ($this$resizeIfShowing.getComponent().isShowing()) {
            this.sendResizeEvent();
        }
    }

    public void dispose() {
    }

    @Override
    public void connectToTty(@NotNull TtyConnector ttyConnector, @NotNull TermSize initialTermSize) {
        Intrinsics.checkNotNullParameter((Object)ttyConnector, (String)"ttyConnector");
        Intrinsics.checkNotNullParameter((Object)initialTermSize, (String)"initialTermSize");
        throw new IllegalStateException("connectToTty is not supported in ReworkedTerminalView".toString());
    }

    private final void addFocusListener(Disposable parentDisposable, FocusListener listener2) {
        RevertOnDisposeUtilKt.addFocusListener((Component)((Component)((Object)this.terminalPanel)), (Disposable)parentDisposable, (FocusListener)listener2);
    }

    private static final void _init_$lambda$0(ReworkedTerminalView this$0) {
        kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)this$0.coroutineScope, null, (int)1, null);
    }

    private static final Unit _init_$lambda$3(ReworkedTerminalView this$0, TerminalSession session2) {
        TerminalSessionController terminalSessionController = this$0.controller;
        Intrinsics.checkNotNull((Object)session2);
        terminalSessionController.handleEvents(session2);
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void setTopComponent$lambda$5(JComponent $component, setTopComponent.resizeListener.1 $resizeListener, ReworkedTerminalView this$0) {
        $component.removeComponentListener($resizeListener);
        this$0.terminalPanel.remoteTopComponent($component);
    }

    private static final TerminalOutputHighlightingsSnapshot configureOutputEditor$lambda$6(TerminalOutputModel $model) {
        return $model.getHighlightings();
    }

    private static final LogicalPosition configureOutputEditor$lambda$7(TerminalOutputModel $model, EditorEx $editor) {
        int offset = ((Number)$model.getCursorOffsetState().getValue()).intValue();
        return $editor.offsetToLogicalPosition(offset);
    }

    private static final Unit configureOutputEditor$lambda$8(TerminalInput $terminalInput, String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        $terminalInput.sendString(text);
        return Unit.INSTANCE;
    }

    private static final void createOutputEditor$lambda$9(EditorImpl $editor) {
        EditorFactory.getInstance().releaseEditor((Editor)$editor);
    }

    private static final void createAlternateBufferEditor$lambda$10(EditorImpl $editor) {
        EditorFactory.getInstance().releaseEditor((Editor)$editor);
    }

    public static final /* synthetic */ TerminalOutputScrollingModel access$getScrollingModel$p(ReworkedTerminalView $this) {
        return $this.scrollingModel;
    }

    public static final /* synthetic */ TerminalPanel access$getTerminalPanel$p(ReworkedTerminalView $this) {
        return $this.terminalPanel;
    }

    public static final /* synthetic */ void access$sendResizeEvent(ReworkedTerminalView $this) {
        $this.sendResizeEvent();
    }

    public static final /* synthetic */ TerminalSessionModel access$getSessionModel$p(ReworkedTerminalView $this) {
        return $this.sessionModel;
    }

    public static final /* synthetic */ EditorEx access$getAlternateBufferEditor$p(ReworkedTerminalView $this) {
        return $this.alternateBufferEditor;
    }

    public static final /* synthetic */ EditorEx access$getOutputEditor$p(ReworkedTerminalView $this) {
        return $this.outputEditor;
    }

    public static final /* synthetic */ Project access$getProject$p(ReworkedTerminalView $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$resizeIfShowing(ReworkedTerminalView $this, EditorImpl $receiver) {
        $this.resizeIfShowing($receiver);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003J\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\fH\u0016J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0016H\u0002R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lcom/intellij/terminal/frontend/ReworkedTerminalView$TerminalLayeredPane;", "Lcom/intellij/ui/components/JBLayeredPane;", "initialContent", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "curEditor", "preferredFocusableComponent", "Ljavax/swing/JComponent;", "getPreferredFocusableComponent", "()Ljavax/swing/JComponent;", "setTerminalContent", "", "editor", "installSearchComponent", "component", "Lcom/intellij/find/SearchReplaceComponent;", "removeSearchComponent", "getPreferredSize", "Ljava/awt/Dimension;", "doLayout", "layoutEditor", "Ljava/awt/Component;", "layoutSearchComponent", "intellij.terminal.frontend"})
    private static final class TerminalLayeredPane
    extends JBLayeredPane {
        @NotNull
        private Editor curEditor;

        public TerminalLayeredPane(@NotNull Editor initialContent) {
            Intrinsics.checkNotNullParameter((Object)initialContent, (String)"initialContent");
            this.curEditor = initialContent;
            this.setTerminalContent(initialContent);
        }

        @NotNull
        public final JComponent getPreferredFocusableComponent() {
            JComponent jComponent = this.curEditor.getContentComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
            return jComponent;
        }

        public final void setTerminalContent(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Editor prevEditor = this.curEditor;
            if (prevEditor != null) {
                this.remove(this.curEditor.getComponent());
            }
            this.curEditor = editor;
            JBLayeredPane jBLayeredPane = this;
            JComponent jComponent = editor.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
            Integer n = JBLayeredPane.DEFAULT_LAYER;
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"DEFAULT_LAYER");
            TerminalUiUtilsKt.addToLayer(jBLayeredPane, jComponent, ((Number)n).intValue());
            this.revalidate();
            this.repaint();
        }

        public final void installSearchComponent(@NotNull SearchReplaceComponent component2) {
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            JBLayeredPane jBLayeredPane = this;
            JComponent jComponent = (JComponent)component2;
            Integer n = JBLayeredPane.POPUP_LAYER;
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"POPUP_LAYER");
            TerminalUiUtilsKt.addToLayer(jBLayeredPane, jComponent, ((Number)n).intValue());
            this.revalidate();
            this.repaint();
        }

        public final void removeSearchComponent(@NotNull SearchReplaceComponent component2) {
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            this.remove((Component)component2);
            this.revalidate();
            this.repaint();
        }

        @NotNull
        public Dimension getPreferredSize() {
            Dimension dimension;
            if (this.curEditor.getDocument().getTextLength() == 0) {
                dimension = new Dimension();
            } else {
                Editor editor = this.curEditor;
                Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
                Dimension dimension2 = ((EditorImpl)editor).getPreferredSize();
                dimension = dimension2;
                Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"getPreferredSize(...)");
            }
            return dimension;
        }

        public void doLayout() {
            Iterator iterator = ArrayIteratorKt.iterator((Object[])this.getComponents());
            while (iterator.hasNext()) {
                Component component2 = (Component)iterator.next();
                Component component3 = component2;
                if (Intrinsics.areEqual((Object)component3, (Object)this.curEditor.getComponent())) {
                    Intrinsics.checkNotNull((Object)component2);
                    this.layoutEditor(component2);
                    continue;
                }
                if (!(component3 instanceof SearchReplaceComponent)) continue;
                this.layoutSearchComponent(component2);
            }
        }

        private final void layoutEditor(Component component2) {
            component2.setBounds(0, 0, this.getWidth(), this.getHeight());
        }

        private final void layoutSearchComponent(Component component2) {
            Dimension prefSize = component2.getPreferredSize();
            Dimension maxSize = component2.getMaximumSize();
            int compWidth = Math.min(this.getWidth(), Math.min(prefSize.width, maxSize.width));
            int compHeight = Math.min(prefSize.height, maxSize.height);
            component2.setBounds(this.getWidth() - compWidth, 0, compWidth, compHeight);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000G\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007*\u0001\u0010\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0005J\u000e\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\fJ\u000e\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\fJ\u0018\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0005H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u0006!"}, d2={"Lcom/intellij/terminal/frontend/ReworkedTerminalView$TerminalPanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "Lorg/jetbrains/plugins/terminal/TerminalPanelMarker;", "initialContent", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/terminal/frontend/ReworkedTerminalView;Lcom/intellij/openapi/editor/Editor;)V", "layeredPane", "Lcom/intellij/terminal/frontend/ReworkedTerminalView$TerminalLayeredPane;", "curEditor", "preferredFocusableComponent", "Ljavax/swing/JComponent;", "getPreferredFocusableComponent", "()Ljavax/swing/JComponent;", "delegatingFocusListener", "com/intellij/terminal/frontend/ReworkedTerminalView$TerminalPanel$delegatingFocusListener$1", "Lcom/intellij/terminal/frontend/ReworkedTerminalView$TerminalPanel$delegatingFocusListener$1;", "uiDataSnapshot", "", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "setTerminalContent", "editor", "installSearchComponent", "component", "Lcom/intellij/find/SearchReplaceComponent;", "removeSearchComponent", "setTopComponent", "remoteTopComponent", "updateFocusListeners", "prevEditor", "newEditor", "intellij.terminal.frontend"})
    private final class TerminalPanel
    extends BorderLayoutPanel
    implements UiDataProvider,
    TerminalPanelMarker {
        @NotNull
        private final TerminalLayeredPane layeredPane;
        @NotNull
        private Editor curEditor;
        @NotNull
        private final delegatingFocusListener.1 delegatingFocusListener;

        public TerminalPanel(Editor initialContent) {
            Intrinsics.checkNotNullParameter((Object)initialContent, (String)"initialContent");
            this.layeredPane = new TerminalLayeredPane(initialContent);
            this.curEditor = initialContent;
            this.delegatingFocusListener = new FocusListener(this){
                final /* synthetic */ TerminalPanel this$0;
                {
                    this.this$0 = $receiver;
                }

                public void focusGained(FocusEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    FocusListener[] focusListenerArray = this.this$0.getFocusListeners();
                    Intrinsics.checkNotNullExpressionValue((Object)focusListenerArray, (String)"getFocusListeners(...)");
                    Object[] $this$forEach$iv = focusListenerArray;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        FocusListener it = (FocusListener)element$iv;
                        boolean bl = false;
                        it.focusGained(e);
                    }
                }

                public void focusLost(FocusEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    FocusListener[] focusListenerArray = this.this$0.getFocusListeners();
                    Intrinsics.checkNotNullExpressionValue((Object)focusListenerArray, (String)"getFocusListeners(...)");
                    Object[] $this$forEach$iv = focusListenerArray;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        FocusListener it = (FocusListener)element$iv;
                        boolean bl = false;
                        it.focusLost(e);
                    }
                }
            };
            this.addToCenter((Component)((Object)this.layeredPane));
            this.updateFocusListeners(initialContent, initialContent);
        }

        @NotNull
        public final JComponent getPreferredFocusableComponent() {
            return this.layeredPane.getPreferredFocusableComponent();
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            DataKey dataKey = CommonDataKeys.EDITOR;
            Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"EDITOR");
            sink.set(dataKey, (Object)this.curEditor);
            sink.set(TerminalInput.Companion.getKEY(), (Object)ReworkedTerminalView.this.terminalInput);
            sink.set(TerminalSearchController.Companion.getKEY(), (Object)ReworkedTerminalView.this.terminalSearchController);
        }

        public final void setTerminalContent(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            this.layeredPane.setTerminalContent(editor);
            this.updateFocusListeners(this.curEditor, editor);
            this.curEditor = editor;
        }

        public final void installSearchComponent(@NotNull SearchReplaceComponent component2) {
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            this.layeredPane.installSearchComponent(component2);
        }

        public final void removeSearchComponent(@NotNull SearchReplaceComponent component2) {
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            this.layeredPane.removeSearchComponent(component2);
        }

        public final void setTopComponent(@NotNull JComponent component2) {
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            this.addToTop(component2);
            this.revalidate();
            this.repaint();
        }

        public final void remoteTopComponent(@NotNull JComponent component2) {
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            this.remove(component2);
            this.revalidate();
            this.repaint();
        }

        private final void updateFocusListeners(Editor prevEditor, Editor newEditor) {
            prevEditor.getContentComponent().removeFocusListener(this.delegatingFocusListener);
            newEditor.getContentComponent().addFocusListener(this.delegatingFocusListener);
        }
    }
}

