/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.download.permanentToken;

import com.intellij.codeWithMe.ClientId;
import com.intellij.indexing.shared.download.SharedIndexDownloadAuthExtension;
import com.intellij.indexing.shared.download.SharedIndexSuggestion;
import com.intellij.indexing.shared.download.permanentToken.PermanentAuthExtensionBase;
import com.intellij.indexing.shared.download.permanentToken.PermanentTokenEnsureParams;
import com.intellij.indexing.shared.download.permanentToken.PermanentTokenWrapper;
import com.intellij.indexing.shared.download.permanentToken.PermanentTokensState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\b\u0010\tJ<\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0019H\u0016J&\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001c\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001b2\u0006\u0010\u001e\u001a\u00020\u0004H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/indexing/shared/download/permanentToken/PermanentAuthExtension;", "Lcom/intellij/indexing/shared/download/SharedIndexDownloadAuthExtension;", "Lcom/intellij/indexing/shared/download/permanentToken/PermanentAuthExtensionBase;", "tokenName", "", "headerName", "tokenPrefix", "explicitToken", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getTokenName", "()Ljava/lang/String;", "getHeaderName", "getTokenPrefix", "checkAuthenticated", "", "presentableReason", "suggestions", "", "Lcom/intellij/indexing/shared/download/SharedIndexSuggestion;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "lifetime", "Lcom/intellij/openapi/Disposable;", "onAuthCompleted", "Lkotlin/Function0;", "tryGenerateToken", "", "feedUrl", "passwordToHeaders", "token", "intellij.indexing.shared"})
@SourceDebugExtension(value={"SMAP\nSharedIndexAuthPermanent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedIndexAuthPermanent.kt\ncom/intellij/indexing/shared/download/permanentToken/PermanentAuthExtension\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,77:1\n1557#2:78\n1628#2,3:79\n1#3:82\n40#4,3:83\n40#4,3:86\n*S KotlinDebug\n*F\n+ 1 SharedIndexAuthPermanent.kt\ncom/intellij/indexing/shared/download/permanentToken/PermanentAuthExtension\n*L\n48#1:78\n48#1:79,3\n56#1:83,3\n67#1:86,3\n*E\n"})
final class PermanentAuthExtension
implements SharedIndexDownloadAuthExtension,
PermanentAuthExtensionBase {
    @NotNull
    private final String tokenName;
    @NotNull
    private final String headerName;
    @NotNull
    private final String tokenPrefix;
    @Nullable
    private final String explicitToken;

    public PermanentAuthExtension(@NotNull String tokenName, @NotNull String headerName, @NotNull String tokenPrefix, @Nullable String explicitToken) {
        Intrinsics.checkNotNullParameter((Object)tokenName, (String)"tokenName");
        Intrinsics.checkNotNullParameter((Object)headerName, (String)"headerName");
        Intrinsics.checkNotNullParameter((Object)tokenPrefix, (String)"tokenPrefix");
        this.tokenName = tokenName;
        this.headerName = headerName;
        this.tokenPrefix = tokenPrefix;
        this.explicitToken = explicitToken;
    }

    @NotNull
    public final String getTokenName() {
        return this.tokenName;
    }

    @NotNull
    public final String getHeaderName() {
        return this.headerName;
    }

    @NotNull
    public final String getTokenPrefix() {
        return this.tokenPrefix;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void checkAuthenticated(@NotNull String presentableReason, @NotNull List<? extends SharedIndexSuggestion> suggestions, @NotNull ProgressIndicator indicator, @NotNull Disposable lifetime, @NotNull Function0<Unit> onAuthCompleted) {
        Object testUrl;
        SortedSet urls;
        block6: {
            Object object;
            Iterator $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)presentableReason, (String)"presentableReason");
            Intrinsics.checkNotNullParameter(suggestions, (String)"suggestions");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter(onAuthCompleted, (String)"onAuthCompleted");
            if (this.explicitToken != null) {
                onAuthCompleted.invoke();
                return;
            }
            Iterable $this$map$iv = suggestions;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv = iterator.next();
                SharedIndexSuggestion sharedIndexSuggestion = (SharedIndexSuggestion)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getUrl());
            }
            urls = CollectionsKt.toSortedSet((Iterable)((List)destination$iv$iv));
            for (Object it : (Iterable)suggestions) {
                boolean bl = false;
                if ((it = it.getTestConnectionUrl()) == null) continue;
                object = it;
                break block6;
            }
            object = testUrl = null;
        }
        if (urls.isEmpty()) {
            onAuthCompleted.invoke();
            return;
        }
        boolean $i$f$service = false;
        Class<PermanentTokensState> serviceClass$iv = PermanentTokensState.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        PermanentTokenWrapper token = ((PermanentTokensState)object).definePassword(this.tokenName, urls);
        Object e = urls.first();
        Intrinsics.checkNotNullExpressionValue(e, (String)"first(...)");
        char[] cArray = new char[]{'/'};
        PermanentTokenEnsureParams params2 = new PermanentTokenEnsureParams(lifetime, StringsKt.trimEnd((String)((String)e), (char[])cArray), (String)testUrl, (Function1<? super String, ? extends Map<String, String>>)((Function1)new Function1<String, Map<String, ? extends String>>((Object)this){

            public final Map<String, String> invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return PermanentAuthExtension.access$passwordToHeaders((PermanentAuthExtension)this.receiver, p0);
            }
        }), onAuthCompleted);
        if (token.ensureToken(params2, indicator)) {
            onAuthCompleted.invoke();
        }
    }

    @Override
    @Nullable
    public Map<String, String> tryGenerateToken(@NotNull String feedUrl, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)feedUrl, (String)"feedUrl");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        String string = this.explicitToken;
        if (string == null) {
            boolean $i$f$service = false;
            Class<PermanentTokensState> serviceClass$iv = PermanentTokensState.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            PermanentTokenWrapper permanentTokenWrapper = ((PermanentTokensState)object).findPassword(this.tokenName);
            string = permanentTokenWrapper != null ? permanentTokenWrapper.readToken() : null;
            if (string == null) {
                return null;
            }
        }
        String token = string;
        return this.passwordToHeaders(token);
    }

    private final Map<String, String> passwordToHeaders(String token) {
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)this.headerName, (Object)(this.tokenPrefix + token)));
    }

    public static final /* synthetic */ Map access$passwordToHeaders(PermanentAuthExtension $this, String token) {
        return $this.passwordToHeaders(token);
    }
}

