/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdba.jdbc.JdbcConnectionProvider;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateFacade;
import com.intellij.database.remote.jdba.jdbc.UnknownDatabaseExceptionRecognizer;
import com.intellij.database.remote.jdba.jdbc.UnknownDatabaseIntermediateFacade;
import com.intellij.database.remote.jdbc.ColumnInfo;
import com.intellij.database.remote.jdbc.GeoWrapper;
import com.intellij.database.remote.jdbc.JdbcInjection;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.remote.jdbc.RemoteCloseable;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.SQLExceptionWithProperties;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.JdbcSettings;
import com.intellij.database.remote.jdbc.helpers.RemoteLogHelper;
import com.intellij.database.remote.jdbc.impl.FileBlob;
import com.intellij.database.remote.jdbc.impl.FileClob;
import com.intellij.database.remote.jdbc.impl.JdbcClassLoader;
import com.intellij.database.remote.jdbc.impl.JdbcRemoteObject;
import com.intellij.database.remote.jdbc.impl.ReflectionHelper;
import com.intellij.database.remote.jdbc.impl.RemoteBlobImpl;
import com.intellij.database.remote.jdbc.impl.RemoteClobImpl;
import com.intellij.database.remote.jdbc.impl.RemoteConnectionImpl;
import com.intellij.database.remote.jdbc.impl.RemotePreparedStatementImpl;
import com.intellij.database.remote.jdbc.impl.RemoteResultSetImpl;
import com.intellij.database.remote.jdbc.impl.RemoteResultSetMetaDataImpl;
import com.intellij.database.remote.jdbc.impl.UnparsedValue;
import com.intellij.database.remote.jdbc.impl.UnparsedValueKind;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.ExceptionUtilRt;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JdbcHelperImpl
implements JdbcHelper {
    public static final String FAILED_TO_LOAD = "<failed to load>";
    public static final String UNKNOWN = "UNKNOWN";
    @NotNull
    private final String myDbmsName;
    @Nullable
    private final String myVersion;
    @Nullable
    private final String myDriverVersion;
    @Nullable
    protected final Connection myConnection;
    private final boolean myJdbcCatalogIsSchema;
    protected static final TemporalGetter LOCAL_TIME_GETTER = new TemporalGetter(){
        private final DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendPattern("HH:mm:ss").optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 1, 9, true).optionalEnd().toFormatter();

        @Override
        public Object get(@NotNull ResultSet set, @NotNull RemoteResultSet.DataRetrievingOptions options, int idx) throws SQLException {
            if (set == null) {
                2.$$$reportNull$$$0(0);
            }
            if (options == null) {
                2.$$$reportNull$$$0(1);
            }
            return LocalTime.parse(set.getString(idx), this.formatter);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "set";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "options";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/remote/jdbc/helpers/JdbcHelperImpl$2";
            objectArray[2] = "get";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    protected static final TemporalGetter LOCAL_TIMESTAMP_GETTER = new TemporalGetter(){
        private final DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd").appendPattern("[ ]").appendPattern("HH:mm:ss").optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 1, 9, true).optionalEnd().toFormatter();

        @Override
        public Object get(@NotNull ResultSet set, @NotNull RemoteResultSet.DataRetrievingOptions options, int idx) throws SQLException {
            if (set == null) {
                3.$$$reportNull$$$0(0);
            }
            if (options == null) {
                3.$$$reportNull$$$0(1);
            }
            return Timestamp.valueOf(LocalDateTime.parse(set.getString(idx), this.formatter));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "set";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "options";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/remote/jdbc/helpers/JdbcHelperImpl$3";
            objectArray[2] = "get";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    protected static final TemporalGetter OFFSET_TIME_GETTER = new TemporalGetter(){
        private final Pattern HOUR_PATTERN = Pattern.compile(".*[+-](\\d):.*");
        private final DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendPattern("HH:mm:ss").optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 1, 9, true).optionalEnd().appendOffset("+HH:mm", "+0:00").toFormatter();

        @Override
        public Object get(@NotNull ResultSet set, @NotNull RemoteResultSet.DataRetrievingOptions options, int idx) throws SQLException {
            String s;
            Matcher matcher;
            if (set == null) {
                4.$$$reportNull$$$0(0);
            }
            if (options == null) {
                4.$$$reportNull$$$0(1);
            }
            if ((matcher = this.HOUR_PATTERN.matcher(s = set.getString(idx))).matches()) {
                int start = matcher.start(1);
                s = s.substring(0, start) + "0" + s.substring(start);
            }
            return OffsetTime.parse(s, this.formatter);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "set";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "options";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/remote/jdbc/helpers/JdbcHelperImpl$4";
            objectArray[2] = "get";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    protected static final TemporalGetter OFFSET_TIMESTAMP_GETTER = new TemporalGetter(){
        private final DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd").appendPattern("[ ]").appendPattern("HH:mm:ss").optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 1, 9, true).optionalEnd().appendPattern("[ ]").appendZoneOrOffsetId().toFormatter();

        @Override
        public Object get(@NotNull ResultSet set, @NotNull RemoteResultSet.DataRetrievingOptions options, int idx) throws SQLException {
            if (set == null) {
                5.$$$reportNull$$$0(0);
            }
            if (options == null) {
                5.$$$reportNull$$$0(1);
            }
            return ZonedDateTime.parse(set.getString(idx), this.formatter);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "set";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "options";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/remote/jdbc/helpers/JdbcHelperImpl$5";
            objectArray[2] = "get";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    protected static final TemporalGetter DATE_GETTER_IMPLICIT_TZ = new TemporalGetter(){

        @Override
        public Object get(@NotNull ResultSet set, @NotNull RemoteResultSet.DataRetrievingOptions options, int idx) throws SQLException {
            if (set == null) {
                6.$$$reportNull$$$0(0);
            }
            if (options == null) {
                6.$$$reportNull$$$0(1);
            }
            return set.getDate(idx);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "set";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "options";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/remote/jdbc/helpers/JdbcHelperImpl$6";
            objectArray[2] = "get";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    protected static final Set<String> DEFAULT_UNLIMITED_TYPES = JdbcNativeUtil.addAll(new HashSet(), "integer", "int", "clob", "blob", "boolean");
    protected static final int MAX_SIZE = Integer.MAX_VALUE;
    protected static final int NO_SIZE = -1;
    protected static final int NO_SCALE = 0;

    public JdbcHelperImpl(@NotNull String dbmsName, @Nullable String version, @Nullable Connection connection) {
        if (dbmsName == null) {
            JdbcHelperImpl.$$$reportNull$$$0(0);
        }
        this.myDbmsName = dbmsName;
        this.myVersion = version;
        this.myConnection = connection;
        this.myDriverVersion = JdbcHelperImpl.getDriverVersion(connection);
        this.myJdbcCatalogIsSchema = this.computeJdbcCatalogIsSchema();
    }

    @NotNull
    public ClassLoader getJdbcClassLoader() {
        ClassLoader classLoader = JdbcClassLoader.getInstance();
        if (classLoader == null) {
            JdbcHelperImpl.$$$reportNull$$$0(1);
        }
        return classLoader;
    }

    public abstract JdbcHelperImpl create(@Nullable String var1, @Nullable Connection var2);

    @Nullable
    public String getVersion() {
        return this.myVersion;
    }

    @Nullable
    public String getDriverVersion() {
        return this.myDriverVersion;
    }

    @NotNull
    public final String getDbmsName() {
        String string = this.myDbmsName;
        if (string == null) {
            JdbcHelperImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public JdbcIntermediateFacade createFacade(@NotNull JdbcConnectionProvider ds) {
        if (ds == null) {
            JdbcHelperImpl.$$$reportNull$$$0(3);
        }
        return new UnknownDatabaseIntermediateFacade(ds, UnknownDatabaseExceptionRecognizer.INSTANCE, this){};
    }

    @Nullable
    public Connection getConnection() {
        return this.myConnection;
    }

    @Override
    public boolean supportsCalendarInPreparedStatement() {
        return true;
    }

    @Override
    public boolean supportsLimitMaxRows() {
        return true;
    }

    @Nullable
    public RemoteCloseable setStatementParameter(@NotNull RemotePreparedStatement statement, @Nullable Object value, @NotNull ColumnInfo columnInfo, boolean needsEscaping, int idx) throws Exception {
        if (statement == null) {
            JdbcHelperImpl.$$$reportNull$$$0(4);
        }
        if (columnInfo == null) {
            JdbcHelperImpl.$$$reportNull$$$0(5);
        }
        int type = columnInfo.getType();
        if (value == null) {
            statement.setNull(idx, type);
        } else if (value instanceof JdbcInjection) {
            ((JdbcInjection)value).inject(idx, (RemotePreparedStatementImpl)statement, this);
        } else {
            if (value instanceof LobInfo.FileBlobInfo) {
                LobInfo.FileBlobInfo info = (LobInfo.FileBlobInfo)value;
                return statement.setBlob(idx, new FileBlob(info.file));
            }
            if (value instanceof LobInfo.FileClobInfo) {
                LobInfo.FileClobInfo info = (LobInfo.FileClobInfo)value;
                return statement.setClob(idx, new FileClob(info.file, info.charset));
            }
            if (value instanceof LobInfo.BlobInfo) {
                statement.setBytes(idx, ((LobInfo.BlobInfo)value).data);
            } else if (value instanceof LobInfo.ClobInfo) {
                statement.setString(idx, this.escapeSqlRegex(((LobInfo.ClobInfo)value).data, needsEscaping));
            } else if (value instanceof GeoWrapper) {
                statement.setBytes(idx, ((GeoWrapper)value).getBinary());
            } else if (value instanceof byte[]) {
                statement.setBytes(idx, (byte[])value);
            } else if (value instanceof Date) {
                this.setDate(statement, value, idx, type);
            } else if (type == -5 && value instanceof BigInteger) {
                this.setBigInteger(statement, (BigInteger)value, idx);
            } else {
                statement.setObject(idx, this.escapeSqlRegex(value, needsEscaping));
            }
        }
        return null;
    }

    private void setDate(@NotNull RemotePreparedStatement statement, @NotNull Object value, int idx, int type) throws Exception {
        if (statement == null) {
            JdbcHelperImpl.$$$reportNull$$$0(6);
        }
        if (value == null) {
            JdbcHelperImpl.$$$reportNull$$$0(7);
        }
        long millis = ((Date)value).getTime();
        if (this.isTimestamp(type)) {
            Timestamp timestamp = value instanceof Timestamp ? (Timestamp)value : new Timestamp(millis);
            this.setTimestamp(statement, idx, timestamp);
        } else if (type == 92) {
            Time time = value instanceof Time ? (Time)value : new Time(millis);
            this.setTime(statement, idx, time);
        } else {
            statement.setDate(idx, JdbcNativeUtil.createSqlDate((java.sql.Date)value));
        }
    }

    protected void setTimestamp(@NotNull RemotePreparedStatement statement, int idx, Timestamp timestamp) throws Exception {
        if (statement == null) {
            JdbcHelperImpl.$$$reportNull$$$0(8);
        }
        statement.setTimestamp(idx, timestamp, JdbcNativeUtil.getUtcCalendar());
    }

    protected void setTime(@NotNull RemotePreparedStatement statement, int idx, Time time) throws RemoteException, SQLException {
        if (statement == null) {
            JdbcHelperImpl.$$$reportNull$$$0(9);
        }
        statement.setTime(idx, time, JdbcNativeUtil.getUtcCalendar());
    }

    @Override
    public boolean isTimestamp(int type) {
        return type == 93;
    }

    @Override
    @Contract(value="!null, _ -> !null")
    public <T> T escapeSqlRegex(T value, boolean needsEscaping) {
        if (!needsEscaping) {
            return value;
        }
        if (!this.getLikeSupport().isSupported(true)) {
            return value;
        }
        if (!(value instanceof String)) {
            return value;
        }
        String s = (String)value;
        String charsToEscape = this.getCharsToEscape();
        StringBuilder result = null;
        char escapeChar = this.getEscapeChar();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (charsToEscape.indexOf(c) != -1) {
                if (result == null) {
                    result = new StringBuilder(s.length() + 1);
                    result.append(s, 0, i);
                }
                result.append(escapeChar);
            }
            if (result == null) continue;
            result.append(c);
        }
        return (T)(result != null ? result.toString() : s);
    }

    @Override
    public char getEscapeChar() {
        return '#';
    }

    @NotNull
    protected String getCharsToEscape() {
        return "%_#";
    }

    @Override
    public JdbcHelper.LikeSupport getLikeSupport() {
        return JdbcHelper.LikeSupport.FULL;
    }

    @Override
    public boolean supportsIlike() {
        return false;
    }

    @Override
    public boolean supportsEscape() {
        return true;
    }

    protected void setBigInteger(@NotNull RemotePreparedStatement statement, @NotNull BigInteger value, int idx) throws Exception {
        if (statement == null) {
            JdbcHelperImpl.$$$reportNull$$$0(10);
        }
        if (value == null) {
            JdbcHelperImpl.$$$reportNull$$$0(11);
        }
        statement.setObject(idx, value, -5);
    }

    @Override
    @Nullable
    public UnparsedValueKind detectUnparsedValueKind(@Nullable String typeName, int jdbcType) {
        return null;
    }

    @Override
    public final boolean isZonedColumn(@Nullable String typeName, int jdbcType) {
        return this.isZonedTimeColumn(typeName, jdbcType) || this.isZonedTimestampColumn(typeName, jdbcType);
    }

    @Override
    public final boolean isZonedTimestampColumn(@Nullable String typeName, int jdbcType) {
        return this.detectUnparsedValueKind(typeName, jdbcType) == UnparsedValueKind.ZONED_TIMESTAMP;
    }

    @Override
    public final boolean isZonedTimeColumn(@Nullable String typeName, int jdbcType) {
        return this.detectUnparsedValueKind(typeName, jdbcType) == UnparsedValueKind.ZONED_TIME;
    }

    public int fixJdbcType(@Nullable String typeName, @Nullable String clazz, int type) {
        return type;
    }

    public int fixScale(int type, int precision, int scale) {
        return scale;
    }

    protected Object convertValue(JdbcRemoteObject exporter, Object o) throws RemoteException, SQLException {
        Class<?> c = o.getClass();
        String className = c.getName();
        if (c.getClassLoader() == null || className.startsWith("com.intellij")) {
            return o;
        }
        String stringValue = o.toString();
        return stringValue.startsWith(className) ? "<failed to load> " + className : stringValue;
    }

    public Object[] getCurrentRow(@NotNull RemoteResultSet.DataRetrievingOptions options, @NotNull JdbcRemoteObject exporter, @NotNull ResultSet resultSet, @NotNull ResultSetMetaData metaData) throws SQLException {
        if (options == null) {
            JdbcHelperImpl.$$$reportNull$$$0(12);
        }
        if (exporter == null) {
            JdbcHelperImpl.$$$reportNull$$$0(13);
        }
        if (resultSet == null) {
            JdbcHelperImpl.$$$reportNull$$$0(14);
        }
        if (metaData == null) {
            JdbcHelperImpl.$$$reportNull$$$0(15);
        }
        int columnCount = metaData.getColumnCount();
        Object[] objects = new Object[columnCount];
        for (int i = 1; i <= columnCount; ++i) {
            Object object = this.getObject(options, exporter, resultSet, metaData, i);
            objects[i - 1] = this.fixRowObject(object, metaData, i);
        }
        return objects;
    }

    protected Object fixRowObject(Object object, ResultSetMetaData metaData, int i) throws SQLException {
        return object;
    }

    public Object getObject(@NotNull RemoteResultSet.DataRetrievingOptions options, @NotNull JdbcRemoteObject exporter, @NotNull ResultSet resultSet, @NotNull ResultSetMetaData metaData, int index) {
        if (options == null) {
            JdbcHelperImpl.$$$reportNull$$$0(16);
        }
        if (exporter == null) {
            JdbcHelperImpl.$$$reportNull$$$0(17);
        }
        if (resultSet == null) {
            JdbcHelperImpl.$$$reportNull$$$0(18);
        }
        if (metaData == null) {
            JdbcHelperImpl.$$$reportNull$$$0(19);
        }
        try {
            int type = RemoteResultSetMetaDataImpl.getFixedColumnType(index, metaData, this);
            return this.createInfoIfNeeded(exporter, options, metaData, index, this.getObject(options, exporter, resultSet, metaData, type, index));
        }
        catch (Throwable e) {
            return "<failed to load>\n" + ExceptionUtilRt.getThrowableText((Throwable)e, (String)"com.intellij.");
        }
    }

    protected Object createInfoIfNeeded(@NotNull JdbcRemoteObject exporter, @Nullable RemoteResultSet.DataRetrievingOptions options, @NotNull ResultSetMetaData metaData, int index, Object o) throws Exception {
        if (exporter == null) {
            JdbcHelperImpl.$$$reportNull$$$0(20);
        }
        if (metaData == null) {
            JdbcHelperImpl.$$$reportNull$$$0(21);
        }
        return this.createInfoIfNeeded(exporter, options, o);
    }

    protected Object createInfoIfNeeded(@NotNull JdbcRemoteObject exporter, @Nullable RemoteResultSet.DataRetrievingOptions options, Object o) throws Exception {
        if (exporter == null) {
            JdbcHelperImpl.$$$reportNull$$$0(22);
        }
        if (options != null && !options.raw) {
            if (o instanceof String) {
                return LobInfo.fromString((String)((String)o), (int)options.maxLobLength);
            }
            if (o instanceof byte[]) {
                return LobInfo.fromByteArray((byte[])((byte[])o), (int)options.maxLobLength);
            }
            if (o instanceof Blob) {
                return LobInfo.fromBlob((Blob)((Blob)o), (int)options.maxLobLength);
            }
            if (o instanceof Clob) {
                return LobInfo.fromClob((Clob)((Clob)o), (int)options.maxLobLength);
            }
            if (o instanceof InputStream) {
                return LobInfo.fromInputStream((InputStream)((InputStream)o), (int)options.maxLobLength);
            }
            if (o instanceof Reader) {
                return LobInfo.fromReader((Reader)((Reader)o), (int)options.maxLobLength);
            }
        }
        return this.wrapIfNeeded(exporter, o, options);
    }

    public Object getObject(@NotNull RemoteResultSet.DataRetrievingOptions options, @NotNull JdbcRemoteObject exporter, @NotNull ResultSet resultSet, @NotNull ResultSetMetaData metaData, int jdbcType, int index) throws SQLException {
        Object result;
        UnparsedValueKind unparsedValueKind;
        if (options == null) {
            JdbcHelperImpl.$$$reportNull$$$0(23);
        }
        if (exporter == null) {
            JdbcHelperImpl.$$$reportNull$$$0(24);
        }
        if (resultSet == null) {
            JdbcHelperImpl.$$$reportNull$$$0(25);
        }
        if (metaData == null) {
            JdbcHelperImpl.$$$reportNull$$$0(26);
        }
        if (jdbcType == 2004 || jdbcType == 2005) {
            return JdbcHelperImpl.getBlobOrClob(resultSet, index, jdbcType == 2004);
        }
        String typeName = metaData.getColumnTypeName(index);
        if (this.isDriverFailsOnType(jdbcType, typeName)) {
            return resultSet.getString(index);
        }
        if (!options.raw && (unparsedValueKind = this.detectUnparsedValueKind(typeName, jdbcType)) != null) {
            return this.createUnparsedValue(resultSet, index, unparsedValueKind);
        }
        TemporalGetter getter = this.getTemporalGetter(typeName, jdbcType);
        if (getter != null) {
            try {
                return getter.get(resultSet, options, index);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (result = this.tryGetObject(options, resultSet, metaData, index)) == null ? resultSet.getObject(index) : result;
    }

    @Nullable
    protected Object tryGetObject(@NotNull RemoteResultSet.DataRetrievingOptions options, @NotNull ResultSet resultSet, @NotNull ResultSetMetaData metaData, int index) throws SQLException {
        if (options == null) {
            JdbcHelperImpl.$$$reportNull$$$0(27);
        }
        if (resultSet == null) {
            JdbcHelperImpl.$$$reportNull$$$0(28);
        }
        if (metaData == null) {
            JdbcHelperImpl.$$$reportNull$$$0(29);
        }
        return null;
    }

    @Nullable
    protected TemporalGetter getTemporalGetter(@Nullable String typeName, int type) {
        return StandardGetter.of(type);
    }

    @Nullable
    protected UnparsedValue createUnparsedValue(@NotNull ResultSet resultSet, int index, UnparsedValueKind kind) throws SQLException {
        String timestamp;
        if (resultSet == null) {
            JdbcHelperImpl.$$$reportNull$$$0(30);
        }
        return (timestamp = resultSet.getString(index)) != null ? new UnparsedValue(kind, timestamp) : null;
    }

    protected boolean isDriverFailsOnType(int jdbcType, String typeName) {
        return jdbcType == 12 || jdbcType == 1 || jdbcType == -9 || jdbcType == -15;
    }

    public RemoteConnection wrap(Connection connection) {
        return new RemoteConnectionImpl(connection, this);
    }

    public boolean getAutoCommit(Connection delegate) throws SQLException {
        return delegate.getAutoCommit();
    }

    @Override
    public boolean supportsTransactions() {
        return true;
    }

    public int getType(@NotNull ResultSet delegate) throws SQLException {
        if (delegate == null) {
            JdbcHelperImpl.$$$reportNull$$$0(31);
        }
        return delegate.getType();
    }

    public int fixUpdateCount(int update) {
        return update;
    }

    @Nullable
    public Boolean supportsSavepoints() {
        return null;
    }

    public boolean canChangePassword(@NotNull Driver driver, String url, @NotNull Properties properties) {
        if (driver == null) {
            JdbcHelperImpl.$$$reportNull$$$0(32);
        }
        if (properties == null) {
            JdbcHelperImpl.$$$reportNull$$$0(33);
        }
        return false;
    }

    public int getPrecision(ResultSetMetaData delegate, int column) throws SQLException {
        return delegate.getPrecision(column);
    }

    public void cancel(@NotNull Statement stmt) throws SQLException {
        if (stmt == null) {
            JdbcHelperImpl.$$$reportNull$$$0(34);
        }
        stmt.cancel();
    }

    public void setFetchSize(Statement stmt, int fetchSize) throws SQLException {
        stmt.setFetchSize(fetchSize);
    }

    public void setFetchSize(ResultSet rs, int fetchSize) throws SQLException {
        rs.setFetchSize(fetchSize);
    }

    public String getColumnTypeName(@NotNull ResultSetMetaData delegate, int idx) throws SQLException {
        if (delegate == null) {
            JdbcHelperImpl.$$$reportNull$$$0(35);
        }
        return delegate.getColumnTypeName(idx);
    }

    public boolean getJdbcCatalogIsSchema() {
        return this.myJdbcCatalogIsSchema;
    }

    protected boolean computeJdbcCatalogIsSchema() {
        if (this.myConnection == null) {
            return false;
        }
        DatabaseMetaData metaData = (DatabaseMetaData)JdbcNativeUtil.computeSafe(this.myConnection::getMetaData);
        if (metaData == null) {
            return false;
        }
        String catTerm = StringUtilRt.notNullize((String)((String)JdbcNativeUtil.computeSafe(metaData::getCatalogTerm)));
        String scTerm = StringUtilRt.notNullize((String)((String)JdbcNativeUtil.computeSafe(metaData::getSchemaTerm)));
        return !catTerm.isEmpty() && scTerm.isEmpty();
    }

    public String getCatalogName(@NotNull ResultSetMetaData delegate, int column) throws SQLException {
        if (delegate == null) {
            JdbcHelperImpl.$$$reportNull$$$0(36);
        }
        return this.getJdbcCatalogIsSchema() ? delegate.getSchemaName(column) : delegate.getCatalogName(column);
    }

    public String getSchemaName(@NotNull ResultSetMetaData delegate, int column) throws SQLException {
        if (delegate == null) {
            JdbcHelperImpl.$$$reportNull$$$0(37);
        }
        return this.getJdbcCatalogIsSchema() ? delegate.getCatalogName(column) : delegate.getSchemaName(column);
    }

    public String getTableName(@NotNull ResultSetMetaData delegate, int column) throws SQLException {
        if (delegate == null) {
            JdbcHelperImpl.$$$reportNull$$$0(38);
        }
        return delegate.getTableName(column);
    }

    private static Object getBlobOrClob(ResultSet resultSet, int index, boolean isBlob) throws SQLException {
        try {
            return isBlob ? resultSet.getBlob(index) : resultSet.getClob(index);
        }
        catch (SQLException e) {
            return resultSet.getObject(index);
        }
    }

    protected static Properties replaceInvalidProperties(@NotNull Driver driver, Properties properties, List<PropertyReplacement> replacements) {
        if (driver == null) {
            JdbcHelperImpl.$$$reportNull$$$0(39);
        }
        if (properties == null) {
            return null;
        }
        Properties result = properties;
        for (PropertyReplacement replacement : replacements) {
            if (!replacement.isActiveFor(driver)) continue;
            result = replacement.replace(driver, result);
        }
        return result;
    }

    public Object wrapIfNeeded(@NotNull JdbcRemoteObject exporter, Object o) throws RemoteException, SQLException {
        if (exporter == null) {
            JdbcHelperImpl.$$$reportNull$$$0(40);
        }
        return this.wrapIfNeeded(exporter, o, null);
    }

    protected Object wrapIfNeeded(@NotNull JdbcRemoteObject exporter, Object o, @Nullable RemoteResultSet.DataRetrievingOptions options) throws RemoteException, SQLException {
        if (exporter == null) {
            JdbcHelperImpl.$$$reportNull$$$0(41);
        }
        if (o == null) {
            return null;
        }
        Class<?> c = o.getClass();
        if (o instanceof ResultSet) {
            return exporter.export((Remote)((Object)RemoteResultSetImpl.wrap((ResultSet)o, this)));
        }
        if (o instanceof Clob) {
            return exporter.export2((Remote)((Object)RemoteClobImpl.wrap((Clob)o)));
        }
        if (o instanceof Blob) {
            return exporter.export2((Remote)((Object)RemoteBlobImpl.wrap((Blob)o)));
        }
        if (o instanceof Array) {
            return this.wrapIfNeeded(exporter, (Array)o, options);
        }
        if (o instanceof Object[]) {
            Object[] array = (Object[])o;
            Object[] result = new Object[array.length];
            for (int i = 0; i < array.length; ++i) {
                result[i] = this.wrapIfNeeded(exporter, array[i], options);
            }
            return result;
        }
        if (o instanceof Timestamp) {
            return c != Timestamp.class ? new Timestamp(((Timestamp)o).getTime()) : o;
        }
        if (o instanceof Time) {
            return c != Time.class ? new Time(((Time)o).getTime()) : o;
        }
        if (o instanceof java.sql.Date) {
            return c != java.sql.Date.class ? new java.sql.Date(((java.sql.Date)o).getTime()) : o;
        }
        if (o instanceof Date) {
            return c != Date.class ? new Date(((Date)o).getTime()) : o;
        }
        if (o instanceof Map) {
            return this.convertMap(exporter, (Map)o, options);
        }
        if (o instanceof ByteBuffer) {
            return ((ByteBuffer)o).array();
        }
        if (o instanceof List) {
            return this.convertList(exporter, (List)o, options);
        }
        if (o instanceof Set) {
            return this.convertSet(exporter, (Set)o, options);
        }
        return this.convertValue(exporter, o);
    }

    protected Object wrapIfNeeded(@NotNull JdbcRemoteObject exporter, Array a, @Nullable RemoteResultSet.DataRetrievingOptions options) throws SQLException, RemoteException {
        int type;
        if (exporter == null) {
            JdbcHelperImpl.$$$reportNull$$$0(42);
        }
        if ((type = a.getBaseType()) == 1111) {
            return a.toString();
        }
        Object array = a.getArray();
        return this.wrapIfNeeded(exporter, array, options);
    }

    protected Map<?, ?> convertMap(@NotNull JdbcRemoteObject exporter, @NotNull Map<?, ?> map, @Nullable RemoteResultSet.DataRetrievingOptions options) throws RemoteException, SQLException {
        if (exporter == null) {
            JdbcHelperImpl.$$$reportNull$$$0(43);
        }
        if (map == null) {
            JdbcHelperImpl.$$$reportNull$$$0(44);
        }
        LinkedHashMap newMap = new LinkedHashMap();
        for (Map.Entry<?, ?> o1 : map.entrySet()) {
            newMap.put(o1.getKey(), this.wrapIfNeeded(exporter, o1.getValue(), options));
        }
        return newMap;
    }

    private List<?> convertList(@NotNull JdbcRemoteObject exporter, @NotNull List<?> list, @Nullable RemoteResultSet.DataRetrievingOptions options) throws RemoteException, SQLException {
        if (exporter == null) {
            JdbcHelperImpl.$$$reportNull$$$0(45);
        }
        if (list == null) {
            JdbcHelperImpl.$$$reportNull$$$0(46);
        }
        ArrayList<Object> newList = new ArrayList<Object>();
        this.convertCollection(exporter, list, newList, options);
        return newList;
    }

    private Set<?> convertSet(@NotNull JdbcRemoteObject exporter, @NotNull Set<?> set, @Nullable RemoteResultSet.DataRetrievingOptions options) throws RemoteException, SQLException {
        if (exporter == null) {
            JdbcHelperImpl.$$$reportNull$$$0(47);
        }
        if (set == null) {
            JdbcHelperImpl.$$$reportNull$$$0(48);
        }
        LinkedHashSet<Object> newSet = new LinkedHashSet<Object>();
        this.convertCollection(exporter, set, newSet, options);
        return newSet;
    }

    protected void convertCollection(@NotNull JdbcRemoteObject exporter, @NotNull Collection<?> c, @NotNull Collection<Object> newC, @Nullable RemoteResultSet.DataRetrievingOptions options) throws RemoteException, SQLException {
        if (exporter == null) {
            JdbcHelperImpl.$$$reportNull$$$0(49);
        }
        if (c == null) {
            JdbcHelperImpl.$$$reportNull$$$0(50);
        }
        if (newC == null) {
            JdbcHelperImpl.$$$reportNull$$$0(51);
        }
        for (Object value : c) {
            newC.add(this.wrapIfNeeded(exporter, value, options));
        }
    }

    public int getRow(@NotNull ResultSet rs) throws SQLException {
        if (rs == null) {
            JdbcHelperImpl.$$$reportNull$$$0(52);
        }
        return rs.getRow();
    }

    public String fixColumnLabel(String columnLabel) {
        return columnLabel;
    }

    @Nullable
    private static String getDriverVersion(@Nullable Connection connection) {
        if (connection == null) {
            return null;
        }
        try {
            DatabaseMetaData metadata = connection.getMetaData();
            return metadata.getDriverMajorVersion() + "." + metadata.getDriverMinorVersion();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Override
    public void adjustType(@NotNull JdbcHelper.Type e) {
        if (e == null) {
            JdbcHelperImpl.$$$reportNull$$$0(53);
        }
        if (e.typeName == null) {
            return;
        }
        if (DEFAULT_UNLIMITED_TYPES.contains(e.typeName.toLowerCase(Locale.ENGLISH))) {
            e.length = -1;
        }
    }

    protected static void processForBitData(@NotNull JdbcHelper.Type e) {
        if (e == null) {
            JdbcHelperImpl.$$$reportNull$$$0(54);
        }
        String forBitData = " () for bit data";
        if (e.typeName != null && StringUtilRt.endsWithIgnoreCase((CharSequence)e.typeName, (CharSequence)forBitData)) {
            int end = e.typeName.length() - forBitData.length();
            e.typeSuffix = e.typeName.substring(end + 4);
            e.typeName = e.typeName.substring(0, end);
        }
    }

    @Nullable
    public abstract JdbcHelperImpl detect(@Nullable Connection var1, @Nullable String var2, @Nullable String var3, @Nullable JdbcHelperImpl var4) throws Exception;

    public boolean detect(@NotNull Driver driver, @Nullable String url) {
        if (driver == null) {
            JdbcHelperImpl.$$$reportNull$$$0(55);
        }
        return false;
    }

    @Nullable
    public Connection connect(@NotNull Driver driver, String url, @NotNull Properties properties, @NotNull Map<String, Serializable> extra) throws SQLException {
        List portForwardings;
        JdbcSettings.SslMode sslMode;
        if (driver == null) {
            JdbcHelperImpl.$$$reportNull$$$0(56);
        }
        if (properties == null) {
            JdbcHelperImpl.$$$reportNull$$$0(57);
        }
        if (extra == null) {
            JdbcHelperImpl.$$$reportNull$$$0(58);
        }
        if ((sslMode = JdbcSettings.SSL_MODE.get(extra)) != null) {
            JdbcNativeUtil.logInfo("SSL MODE is " + (Object)((Object)sslMode));
            if (sslMode == JdbcSettings.SslMode.REQUIRE) {
                System.setProperty("sslTrustEverybody", "true");
            }
            this.enableSsl(driver, properties, sslMode);
        }
        Level level = JdbcSettings.LOG_LEVEL.get(extra);
        String logPath = JdbcSettings.LOG_PATH.get(extra);
        if (level != null || logPath != null) {
            JdbcNativeUtil.logInfo("setting driver log level to " + (level == null ? null : level.getName()));
            JdbcNativeUtil.logInfo("setting driver log path to " + logPath);
            this.setDriverLogLevel(driver, properties, level, logPath);
        }
        if (JdbcSettings.INTEGRATED_SECURITY.is(extra, false)) {
            JdbcNativeUtil.logInfo("INTEGRATED SECURITY is on");
            this.enableIntegratedSecurity(driver, properties);
        }
        if ((portForwardings = (List)JdbcSettings.PORT_FORWARDINGS.get(extra)) != null) {
            this.setPortForwardings(properties, portForwardings);
        }
        return driver.connect(url, properties);
    }

    protected void setDriverLogLevel(Driver driver, Properties properties, @Nullable Level level, @Nullable String logPath) {
        RemoteLogHelper.setDriverManagerLogLevel(level);
        if (level != null) {
            String pkg = driver.getClass().getPackage().getName();
            int end = pkg.length();
            while (true) {
                int cur = end;
                cur = JdbcHelperImpl.trim(pkg, cur, ".jdbc");
                if ((cur = JdbcHelperImpl.trim(pkg, cur, ".client")) == end) break;
                end = cur;
            }
            RemoteLogHelper.setLogLevel(pkg.substring(0, end), level);
        }
    }

    protected static void configureSimbaLogging(Properties properties, Level level, String logPath) {
        if (level != null) {
            JdbcHelperImpl.setIfEmpty(properties, "LogLevel", level == Level.OFF ? "0" : (level.intValue() >= Level.SEVERE.intValue() ? "2" : (level.intValue() >= Level.WARNING.intValue() ? "3" : (level.intValue() >= Level.INFO.intValue() ? "4" : (level.intValue() >= Level.FINE.intValue() ? "5" : "6")))));
        }
        if (logPath != null) {
            JdbcHelperImpl.setIfEmpty(properties, "LogPath", logPath);
        }
    }

    private static int trim(String s, int end, String suffix) {
        int len = suffix.length();
        if (s.regionMatches(end - len, suffix, 0, len)) {
            return end - len;
        }
        return end;
    }

    public void changeExpiredPassword(@NotNull Driver driver, String url, @NotNull Properties properties, @NotNull Map<String, Serializable> extra, @NotNull String newPassword) throws SQLException {
        if (driver == null) {
            JdbcHelperImpl.$$$reportNull$$$0(59);
        }
        if (properties == null) {
            JdbcHelperImpl.$$$reportNull$$$0(60);
        }
        if (extra == null) {
            JdbcHelperImpl.$$$reportNull$$$0(61);
        }
        if (newPassword == null) {
            JdbcHelperImpl.$$$reportNull$$$0(62);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public JdbcSettings.SslMode @Nullable(value="no support at all") [] supportedSslModes() {
        return JdbcSettings.SslMode.EMPTY_ARRAY;
    }

    protected void enableSsl(@NotNull Driver driver, @NotNull Properties properties, @NotNull JdbcSettings.SslMode sslMode) {
        if (driver == null) {
            JdbcHelperImpl.$$$reportNull$$$0(63);
        }
        if (properties == null) {
            JdbcHelperImpl.$$$reportNull$$$0(64);
        }
        if (sslMode == null) {
            JdbcHelperImpl.$$$reportNull$$$0(65);
        }
    }

    @Override
    public boolean supportsIntegratedSecurity() {
        return false;
    }

    @Override
    public boolean hasLazyConnection() {
        return false;
    }

    @Nullable
    protected Map<String, Serializable> getAdditionalProperties(@NotNull SQLException ex) {
        if (ex == null) {
            JdbcHelperImpl.$$$reportNull$$$0(66);
        }
        return null;
    }

    protected void enableIntegratedSecurity(@NotNull Driver driver, @NotNull Properties properties) {
        if (driver == null) {
            JdbcHelperImpl.$$$reportNull$$$0(67);
        }
        if (properties == null) {
            JdbcHelperImpl.$$$reportNull$$$0(68);
        }
    }

    protected void setPortForwardings(@NotNull Properties properties, @NotNull List<JdbcSettings.PortForwarding> portForwardings) {
        if (properties == null) {
            JdbcHelperImpl.$$$reportNull$$$0(69);
        }
        if (portForwardings == null) {
            JdbcHelperImpl.$$$reportNull$$$0(70);
        }
    }

    protected static boolean setIfEmpty(@NotNull Properties properties, @NotNull String key, @NotNull String value) {
        String user;
        if (properties == null) {
            JdbcHelperImpl.$$$reportNull$$$0(71);
        }
        if (key == null) {
            JdbcHelperImpl.$$$reportNull$$$0(72);
        }
        if (value == null) {
            JdbcHelperImpl.$$$reportNull$$$0(73);
        }
        if ((user = properties.getProperty(key)) != null) {
            JdbcNativeUtil.logInfo("Not setting `" + key + "` to `" + value + "` as it is set to `" + user + "`");
            return false;
        }
        JdbcNativeUtil.logInfo("Setting `" + key + "` to `" + value + "`");
        properties.setProperty(key, value);
        return true;
    }

    protected static boolean classNameContains(@NotNull Driver driver, @NotNull String s) {
        if (driver == null) {
            JdbcHelperImpl.$$$reportNull$$$0(74);
        }
        if (s == null) {
            JdbcHelperImpl.$$$reportNull$$$0(75);
        }
        String className = driver.getClass().getName();
        return className.contains(s);
    }

    protected static void closeSafe(Connection c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (Throwable th) {
            JdbcNativeUtil.logWarn(null, th);
        }
    }

    public int relOrder(JdbcHelperImpl other) {
        return 0;
    }

    @Override
    @NotNull
    public JdbcHelper.Case getCaseMode(boolean sensitive, boolean forceLower, boolean forceUpper, boolean asIs) {
        JdbcHelper.Case case_ = sensitive ? JdbcHelper.Case.EXACT : (forceLower ? JdbcHelper.Case.LOWER : (forceUpper ? JdbcHelper.Case.UPPER : JdbcHelper.Case.MIXED));
        if (case_ == null) {
            JdbcHelperImpl.$$$reportNull$$$0(76);
        }
        return case_;
    }

    public Class<?> classForName(String className) throws ClassNotFoundException {
        return ReflectionHelper.classForName(className, this.getJdbcClassLoader());
    }

    public ExceptionProcessor createExceptionProcessor() {
        return new ExceptionProcessor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 76: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 76: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbmsName";
                break;
            }
            case 1: 
            case 2: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/JdbcHelperImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnInfo";
                break;
            }
            case 7: 
            case 11: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 12: 
            case 16: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 13: 
            case 17: 
            case 20: 
            case 22: 
            case 24: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exporter";
                break;
            }
            case 14: 
            case 18: 
            case 25: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 15: 
            case 19: 
            case 21: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaData";
                break;
            }
            case 31: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 32: 
            case 39: 
            case 55: 
            case 56: 
            case 59: 
            case 63: 
            case 67: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 33: 
            case 57: 
            case 60: 
            case 64: 
            case 68: 
            case 69: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stmt";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newC";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rs";
                break;
            }
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 58: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extra";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPassword";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sslMode";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ex";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "portForwardings";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/JdbcHelperImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getJdbcClassLoader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbmsName";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaseMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 76: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createFacade";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setStatementParameter";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setDate";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setTimestamp";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setTime";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setBigInteger";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentRow";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getObject";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createInfoIfNeeded";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "tryGetObject";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createUnparsedValue";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "canChangePassword";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "cancel";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getColumnTypeName";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getCatalogName";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaName";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getTableName";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "replaceInvalidProperties";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "wrapIfNeeded";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "convertMap";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "convertList";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "convertSet";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "convertCollection";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getRow";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "adjustType";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "processForBitData";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "connect";
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "changeExpiredPassword";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "enableSsl";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalProperties";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "enableIntegratedSecurity";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "setPortForwardings";
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "setIfEmpty";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "classNameContains";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 76: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static interface TemporalGetter {
        public Object get(@NotNull ResultSet var1, @NotNull RemoteResultSet.DataRetrievingOptions var2, int var3) throws SQLException;
    }

    private static enum StandardGetter implements TemporalGetter
    {
        TIME(new int[]{92}){

            @Override
            @Nullable
            public Object get(@NotNull ResultSet set, @NotNull RemoteResultSet.DataRetrievingOptions options, int idx) throws SQLException {
                if (set == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (options == null) {
                    1.$$$reportNull$$$0(1);
                }
                return set.getTime(idx, JdbcNativeUtil.getUtcCalendar());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "set";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "options";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/remote/jdbc/helpers/JdbcHelperImpl$StandardGetter$1";
                objectArray[2] = "get";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        TIMESTAMP(new int[]{93}){

            @Override
            @Nullable
            public Object get(@NotNull ResultSet set, @NotNull RemoteResultSet.DataRetrievingOptions options, int idx) throws SQLException {
                if (set == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (options == null) {
                    2.$$$reportNull$$$0(1);
                }
                return set.getTimestamp(idx, JdbcNativeUtil.getUtcCalendar());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "set";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "options";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/remote/jdbc/helpers/JdbcHelperImpl$StandardGetter$2";
                objectArray[2] = "get";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        DATE(new int[]{91}){

            @Override
            @Nullable
            public Object get(@NotNull ResultSet set, @NotNull RemoteResultSet.DataRetrievingOptions options, int idx) throws SQLException {
                if (set == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (options == null) {
                    3.$$$reportNull$$$0(1);
                }
                return set.getDate(idx, JdbcNativeUtil.getUtcCalendar());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "set";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "options";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/remote/jdbc/helpers/JdbcHelperImpl$StandardGetter$3";
                objectArray[2] = "get";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };

        private final int[] myTypes;

        private StandardGetter(int ... type) {
            this.myTypes = type;
            Arrays.sort(this.myTypes);
        }

        boolean isSuitable(int type) {
            return Arrays.binarySearch(this.myTypes, type) >= 0;
        }

        @Nullable
        static StandardGetter of(int type) {
            for (StandardGetter getter : StandardGetter.values()) {
                if (!getter.isSuitable(type)) continue;
                return getter;
            }
            return null;
        }
    }

    protected static abstract class PropertyReplacement {
        private final String myKey;
        private final List<Couple<String>> myReplacements;

        PropertyReplacement(@NotNull String key, @NotNull List<Couple<String>> replacements) {
            if (key == null) {
                PropertyReplacement.$$$reportNull$$$0(0);
            }
            if (replacements == null) {
                PropertyReplacement.$$$reportNull$$$0(1);
            }
            this.myKey = key;
            this.myReplacements = replacements;
        }

        @NotNull
        Properties replace(@NotNull Driver driver, @NotNull Properties properties) {
            String value;
            if (driver == null) {
                PropertyReplacement.$$$reportNull$$$0(2);
            }
            if (properties == null) {
                PropertyReplacement.$$$reportNull$$$0(3);
            }
            if ((value = properties.getProperty(this.myKey)) == null) {
                Properties properties2 = properties;
                if (properties2 == null) {
                    PropertyReplacement.$$$reportNull$$$0(4);
                }
                return properties2;
            }
            Direction direction = this.getDirection(driver);
            Couple<String> replacement = null;
            for (Couple<String> couple : this.myReplacements) {
                if (!value.equals(direction.from(couple))) continue;
                replacement = couple;
                break;
            }
            if (replacement != null) {
                properties.setProperty(this.myKey, direction.to(replacement));
            }
            Properties properties3 = properties;
            if (properties3 == null) {
                PropertyReplacement.$$$reportNull$$$0(5);
            }
            return properties3;
        }

        boolean isActiveFor(@NotNull Driver driver) {
            if (driver == null) {
                PropertyReplacement.$$$reportNull$$$0(6);
            }
            return true;
        }

        @NotNull
        abstract Direction getDirection(@NotNull Driver var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "replacements";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "driver";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "properties";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/JdbcHelperImpl$PropertyReplacement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/JdbcHelperImpl$PropertyReplacement";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "replace";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "replace";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isActiveFor";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        static enum Direction {
            FORWARD{

                @Override
                @NotNull
                String from(@NotNull Couple<String> couple) {
                    if (couple == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    String string = (String)couple.first;
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                @Override
                @NotNull
                String to(@NotNull Couple<String> couple) {
                    if (couple == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    String string = (String)couple.second;
                    if (string == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: 
                        case 3: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: 
                        case 3: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "couple";
                            break;
                        }
                        case 1: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/JdbcHelperImpl$PropertyReplacement$Direction$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/JdbcHelperImpl$PropertyReplacement$Direction$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "from";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "to";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "from";
                            break;
                        }
                        case 1: 
                        case 3: {
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "to";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: 
                        case 3: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            }
            ,
            BACKWARD{

                @Override
                @NotNull
                String from(@NotNull Couple<String> couple) {
                    if (couple == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    String string = FORWARD.to(couple);
                    if (string == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                @Override
                @NotNull
                String to(@NotNull Couple<String> couple) {
                    if (couple == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    String string = FORWARD.from(couple);
                    if (string == null) {
                        2.$$$reportNull$$$0(3);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: 
                        case 3: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: 
                        case 3: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "couple";
                            break;
                        }
                        case 1: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/JdbcHelperImpl$PropertyReplacement$Direction$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/JdbcHelperImpl$PropertyReplacement$Direction$2";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "from";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "to";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "from";
                            break;
                        }
                        case 1: 
                        case 3: {
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "to";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: 
                        case 3: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };


            @NotNull
            abstract String from(@NotNull Couple<String> var1);

            @NotNull
            abstract String to(@NotNull Couple<String> var1);
        }
    }

    public class ExceptionProcessor
    extends JdbcRemoteObject.JdbcExceptionProcessor {
        @Override
        @NotNull
        protected SQLException createSqlExceptionWrapper(@NotNull SQLException ex, @Nullable Throwable wCause) {
            Map<String, Serializable> properties;
            if (ex == null) {
                ExceptionProcessor.$$$reportNull$$$0(0);
            }
            if ((properties = JdbcHelperImpl.this.getAdditionalProperties(ex)) != null) {
                SQLExceptionWithProperties wException = new SQLExceptionWithProperties(ex, wCause, properties);
                wException.setStackTrace(ex.getStackTrace());
                SQLExceptionWithProperties sQLExceptionWithProperties = wException;
                if (sQLExceptionWithProperties == null) {
                    ExceptionProcessor.$$$reportNull$$$0(1);
                }
                return sQLExceptionWithProperties;
            }
            SQLException sQLException = super.createSqlExceptionWrapper(ex, wCause);
            if (sQLException == null) {
                ExceptionProcessor.$$$reportNull$$$0(2);
            }
            return sQLException;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ex";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/JdbcHelperImpl$ExceptionProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/JdbcHelperImpl$ExceptionProcessor";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createSqlExceptionWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createSqlExceptionWrapper";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

