/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.impl.BitString;
import com.intellij.database.remote.jdbc.impl.JdbcRemoteObject;
import com.intellij.database.remote.jdbc.impl.ReflectionHelper;
import com.intellij.database.remote.jdbc.impl.UnparsedValueKind;
import com.intellij.util.ReflectionUtilRt;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HsqlJdbcHelper
extends JdbcHelperImpl {
    private static final Set<String> HSQLDB_UNLIMITED_TYPES = JdbcNativeUtil.addAll(new HashSet(), "integer", "smallint", "bigint", "tinyint", "double", "uuid", "date");

    public HsqlJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super("HSQLDB", version, connection);
    }

    public HsqlJdbcHelper() {
        this(null, null);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return HsqlJdbcHelper.extractVersion(version);
    }

    @Override
    public JdbcHelperImpl create(@Nullable String version, @Nullable Connection connection) {
        return new HsqlJdbcHelper(version, connection);
    }

    @Override
    public Object convertValue(JdbcRemoteObject exporter, Object o) throws RemoteException, SQLException {
        Object result;
        Class<?> c = o.getClass();
        String className = c.getName();
        if ("org.hsqldb.types.BinaryData".equals(className) && (result = HsqlJdbcHelper.convertBinaryData(o)) != null) {
            return result;
        }
        return super.convertValue(exporter, o);
    }

    @Override
    @Nullable
    protected Object tryGetObject(@NotNull RemoteResultSet.DataRetrievingOptions options, @NotNull ResultSet resultSet, @NotNull ResultSetMetaData metaData, int index) throws SQLException {
        int precision;
        String typeName;
        boolean isBit;
        if (options == null) {
            HsqlJdbcHelper.$$$reportNull$$$0(0);
        }
        if (resultSet == null) {
            HsqlJdbcHelper.$$$reportNull$$$0(1);
        }
        if (metaData == null) {
            HsqlJdbcHelper.$$$reportNull$$$0(2);
        }
        if ((isBit = "bit".equalsIgnoreCase(typeName = metaData.getColumnTypeName(index))) && !options.raw && (precision = metaData.getPrecision(index)) > 1) {
            byte[] bytes = resultSet.getBytes(index);
            return BitString.of(bytes, precision);
        }
        return super.tryGetObject(options, resultSet, metaData, index);
    }

    @Override
    @Nullable
    public UnparsedValueKind detectUnparsedValueKind(@Nullable String typeName, int jdbcType) {
        if ("TIMESTAMP WITH TIME ZONE".equals(typeName)) {
            return UnparsedValueKind.ZONED_TIMESTAMP;
        }
        return super.detectUnparsedValueKind(typeName, jdbcType);
    }

    @Override
    @Nullable
    protected JdbcHelperImpl.TemporalGetter getTemporalGetter(@Nullable String typeName, int type) {
        if ("TIME WITH TIME ZONE".equals(typeName)) {
            return OFFSET_TIME_GETTER;
        }
        return super.getTemporalGetter(typeName, type);
    }

    @Override
    public void adjustType(@NotNull JdbcHelper.Type e) {
        if (e == null) {
            HsqlJdbcHelper.$$$reportNull$$$0(3);
        }
        if (e.typeName == null) {
            return;
        }
        String t = e.typeName.toLowerCase(Locale.ENGLISH);
        long oneGb = 0x40000000L;
        long sixteenMb = 0x1000000L;
        if (HSQLDB_UNLIMITED_TYPES.contains(t) || e.length == 0 || t.startsWith("time") || t.startsWith("timestamp") || t.startsWith("interval") || (t.equals("clob") || t.equals("blob")) && (long)e.length == oneGb || t.equals("varbinary") && (long)e.length == sixteenMb || (t.equals("numeric") || t.equals("decimal")) && e.length == 128) {
            e.length = -1;
        }
    }

    @Nullable
    private static Object convertBinaryData(@NotNull Object o) {
        if (o == null) {
            HsqlJdbcHelper.$$$reportNull$$$0(4);
        }
        Object bits = ReflectionHelper.tryInvokeMethod(o, "isBits", null, null);
        Object bytes = JdbcNativeUtil.tryGetBytes(o);
        if (!(bytes instanceof byte[] && bits instanceof Boolean && ((Boolean)bits).booleanValue())) {
            return bytes;
        }
        Long length = (Long)ReflectionUtilRt.getField(o.getClass(), (Object)o, Long.TYPE, (String)"bitLength");
        if (length == null) {
            return bytes;
        }
        return BitString.of((byte[])bytes, length);
    }

    @Override
    @Nullable
    public JdbcHelperImpl detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer, @Nullable JdbcHelperImpl connectHelper) {
        if (!JdbcNativeUtil.detectString(product, "hsql")) {
            return null;
        }
        JdbcNativeUtil.logInfo("getDatabaseProductName: " + product);
        return HsqlJdbcHelper.create(delegate, productVer);
    }

    @Override
    public boolean detect(@NotNull Driver driver, @Nullable String url) {
        if (driver == null) {
            HsqlJdbcHelper.$$$reportNull$$$0(5);
        }
        return HsqlJdbcHelper.classNameContains(driver, "org.hsqldb.");
    }

    @Override
    protected void setDriverLogLevel(Driver driver, Properties properties, Level level, String logPath) {
        super.setDriverLogLevel(driver, properties, level, logPath);
        if (level != null) {
            HsqlJdbcHelper.setIfEmpty(properties, "hsqldb.applog", level == Level.OFF ? "0" : (level.intValue() >= Level.SEVERE.intValue() ? "1" : (level.intValue() >= Level.WARNING.intValue() ? "2" : "3")));
        }
    }

    @NotNull
    private static HsqlJdbcHelper create(@Nullable Connection delegate, @Nullable String productVer) {
        JdbcNativeUtil.logInfo("getDatabaseProductVersion: " + productVer);
        return new HsqlJdbcHelper(HsqlJdbcHelper.extractVersion(productVer), delegate);
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/HsqlJdbcHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "tryGetObject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "convertBinaryData";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "detect";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

