/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.ui.editor.actions.command.mode;

import com.intellij.notebooks.ui.editor.actions.command.mode.NotebookEditorMode;
import com.intellij.notebooks.ui.editor.actions.command.mode.NotebookEditorModeKt;
import com.intellij.notebooks.ui.editor.actions.command.mode.NotebookEditorModeListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretVisualAttributes;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u0018B\u0011\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\tH\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001d\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u00122\u0006\u0010\f\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\tH\u0002J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/notebooks/ui/editor/actions/command/mode/NotebookEditorModeListenerAdapter;", "Lcom/intellij/notebooks/ui/editor/actions/command/mode/NotebookEditorModeListener;", "Lcom/intellij/openapi/editor/event/CaretListener;", "Lcom/intellij/openapi/Disposable$Default;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "currentEditorMode", "Lcom/intellij/notebooks/ui/editor/actions/command/mode/NotebookEditorMode;", "onModeChange", "", "mode", "caretAdded", "event", "Lcom/intellij/openapi/editor/event/CaretEvent;", "caretRemoved", "getCaretAttributes", "Lcom/intellij/openapi/editor/CaretVisualAttributes;", "kotlin.jvm.PlatformType", "(Lcom/intellij/notebooks/ui/editor/actions/command/mode/NotebookEditorMode;)Lcom/intellij/openapi/editor/CaretVisualAttributes;", "isCaretRowShown", "", "handleCarets", "Companion", "intellij.notebooks.ui"})
@SourceDebugExtension(value={"SMAP\nNotebookEditorModeListenerAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookEditorModeListenerAdapter.kt\ncom/intellij/notebooks/ui/editor/actions/command/mode/NotebookEditorModeListenerAdapter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n25#2:100\n4135#3,11:101\n1863#4,2:112\n1863#4,2:114\n*S KotlinDebug\n*F\n+ 1 NotebookEditorModeListenerAdapter.kt\ncom/intellij/notebooks/ui/editor/actions/command/mode/NotebookEditorModeListenerAdapter\n*L\n24#1:100\n29#1:101,11\n29#1:112,2\n41#1:114,2\n*E\n"})
public final class NotebookEditorModeListenerAdapter
implements NotebookEditorModeListener,
CaretListener,
Disposable.Default {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @Nullable
    private NotebookEditorMode currentEditorMode;

    private NotebookEditorModeListenerAdapter(Editor editor) {
        this.editor = editor;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onModeChange(@NotNull Editor editor, @NotNull NotebookEditorMode mode) {
        void $this$forEach$iv;
        Iterator $this$filterIsInstanceTo$iv$iv;
        MarkupModelEx $this$thisLogger$iv2;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        boolean modeWasChanged = this.currentEditorMode != mode;
        this.currentEditorMode = mode;
        if (editor.isDisposed()) {
            NotebookEditorModeListenerAdapter $this$thisLogger$iv2 = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(NotebookEditorModeListenerAdapter.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Cannot change notebook mode, Editor is disposed already");
            return;
        }
        MarkupModel markupModel = editor.getMarkupModel();
        Intrinsics.checkNotNull((Object)markupModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.MarkupModelEx");
        MarkupModelEx $this$onModeChange_u24lambda_u241 = $this$thisLogger$iv2 = (MarkupModelEx)markupModel;
        boolean bl = false;
        RangeHighlighter[] rangeHighlighterArray = $this$onModeChange_u24lambda_u241.getAllHighlighters();
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterArray, (String)"getAllHighlighters(...)");
        Object $this$filterIsInstance$iv = rangeHighlighterArray;
        boolean $i$f$filterIsInstance = false;
        Object[] objectArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof RangeHighlighterEx)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RangeHighlighterEx it = (RangeHighlighterEx)element$iv;
            boolean bl2 = false;
            LineMarkerRenderer lineMarkerRenderer = it.getLineMarkerRenderer();
            it.setLineMarkerRenderer(null);
            it.setLineMarkerRenderer(lineMarkerRenderer);
        }
        if (modeWasChanged) {
            this.handleCarets(mode);
            editor.getSettings().setCaretRowShown(this.isCaretRowShown(mode));
        }
        List list = editor.getCaretModel().getAllCarets();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllCarets(...)");
        Iterable $this$forEach$iv2 = list;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            Caret caret = (Caret)element$iv;
            boolean bl3 = false;
            caret.setVisualAttributes(this.getCaretAttributes(mode));
        }
        JComponent jComponent = editor.getContentComponent();
        jComponent.putClientProperty(ActionUtil.ALLOW_PlAIN_LETTER_SHORTCUTS, switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 1 -> false;
            case 2 -> true;
            default -> throw new NoWhenBranchMatchedException();
        });
        JComponent jComponent2 = editor.getContentComponent();
        jComponent2.enableInputMethods(switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 1 -> true;
            case 2 -> false;
            default -> throw new NoWhenBranchMatchedException();
        });
    }

    public void caretAdded(@NotNull CaretEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        NotebookEditorMode notebookEditorMode = this.currentEditorMode;
        if (notebookEditorMode == null) {
            return;
        }
        NotebookEditorMode mode = notebookEditorMode;
        Caret caret = event.getCaret();
        if (caret != null) {
            caret.setVisualAttributes(this.getCaretAttributes(mode));
        }
        Editor editor = this.editor;
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        ((EditorEx)editor).getGutterComponentEx().repaint();
    }

    public void caretRemoved(@NotNull CaretEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Editor editor = this.editor;
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        ((EditorEx)editor).getGutterComponentEx().repaint();
    }

    private final CaretVisualAttributes getCaretAttributes(NotebookEditorMode mode) {
        return switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 1 -> CaretVisualAttributes.getDefault();
            case 2 -> NotebookEditorModeKt.getINVISIBLE_CARET();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final boolean isCaretRowShown(NotebookEditorMode mode) {
        return switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 1 -> true;
            case 2 -> false;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final void handleCarets(NotebookEditorMode mode) {
        switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 1: {
                this.editor.getCaretModel().removeSecondaryCarets();
                break;
            }
            case 2: {
                for (Caret caret : this.editor.getCaretModel().getAllCarets()) {
                    caret.removeSelection();
                }
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public /* synthetic */ NotebookEditorModeListenerAdapter(Editor editor, DefaultConstructorMarker $constructor_marker) {
        this(editor);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/notebooks/ui/editor/actions/command/mode/NotebookEditorModeListenerAdapter$Companion;", "", "<init>", "()V", "setupForEditor", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.notebooks.ui"})
    public static final class Companion {
        private Companion() {
        }

        public final void setupForEditor(@NotNull Editor editor) {
            MessageBusConnection connection;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            NotebookEditorModeListenerAdapter listener2 = new NotebookEditorModeListenerAdapter(editor, null);
            editor.getCaretModel().addCaretListener((CaretListener)listener2, (Disposable)listener2);
            EditorUtil.disposeWithEditor((Editor)editor, (Disposable)((Disposable)listener2));
            Project project = editor.getProject();
            MessageBusConnection messageBusConnection = connection = project != null && (project = project.getMessageBus()) != null ? project.connect((Disposable)listener2) : null;
            if (messageBusConnection != null) {
                messageBusConnection.subscribe(NotebookEditorModeKt.getNOTEBOOK_EDITOR_MODE(), (Object)listener2);
            }
            listener2.onModeChange(editor, NotebookEditorModeKt.getCurrentMode(editor));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NotebookEditorMode.values().length];
            try {
                nArray[NotebookEditorMode.EDIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotebookEditorMode.COMMAND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

