/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.inspection;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.ui.CustomInspectionActions;
import com.intellij.profile.codeInspection.ui.InspectionMetaDataDialog;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.inspection.InspectionProfileUtil;
import com.intellij.structuralsearch.inspection.SSBasedInspection;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationCellRenderer;
import com.intellij.structuralsearch.plugin.ui.ConfigurationUtil;
import com.intellij.structuralsearch.plugin.ui.SearchConfiguration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.StructuralSearchDialog;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class StructuralSearchFakeInspection
extends LocalInspectionTool {
    private Configuration myMainConfiguration;
    @NotNull
    private final List<Configuration> myConfigurations;

    public StructuralSearchFakeInspection(@NotNull @NotNull Collection<@NotNull Configuration> configurations) {
        if (configurations == null) {
            StructuralSearchFakeInspection.$$$reportNull$$$0(0);
        }
        if (configurations.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.myConfigurations = new SmartList(configurations);
        this.myConfigurations.sort(Comparator.comparingInt(Configuration::getOrder));
        int size = this.myConfigurations.size();
        for (int i = 0; i < size; ++i) {
            Configuration configuration = this.myConfigurations.get(i);
            if (configuration.getOrder() == i) continue;
            configuration.setOrder(i);
        }
        this.myMainConfiguration = this.myConfigurations.get(0);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getDisplayName() {
        String string = this.myMainConfiguration.getName();
        if (string == null) {
            StructuralSearchFakeInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        String string = this.myMainConfiguration.getUuid();
        if (string == null) {
            StructuralSearchFakeInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public boolean isCleanup() {
        return this.isCleanupAllowed() && this.myMainConfiguration.isCleanup();
    }

    private boolean isCleanupAllowed() {
        return ContainerUtil.exists(this.myConfigurations, c -> c instanceof ReplaceConfiguration);
    }

    @NotNull
    public String getID() {
        HighlightDisplayKey key = HighlightDisplayKey.find((String)this.getShortName());
        if (key != null) {
            String string = key.getID();
            if (string == null) {
                StructuralSearchFakeInspection.$$$reportNull$$$0(3);
            }
            return string;
        }
        String suppressId = this.myMainConfiguration.getSuppressId();
        return !StringUtil.isEmpty((String)suppressId) ? suppressId : "SSBasedInspection";
    }

    @NotNull
    public String getAlternativeID() {
        return "SSBasedInspection";
    }

    @NotNull
    public String getMainToolId() {
        return "SSBasedInspection";
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getGroupDisplayName() {
        String string = SSRBundle.message("structural.search.group.name", new Object[0]);
        if (string == null) {
            StructuralSearchFakeInspection.$$$reportNull$$$0(4);
        }
        return string;
    }

    public @Nls(capitalization=Nls.Capitalization.Sentence) String @NotNull [] getGroupPath() {
        String[] stringArray = InspectionProfileUtil.getGroup();
        if (stringArray == null) {
            StructuralSearchFakeInspection.$$$reportNull$$$0(5);
        }
        return stringArray;
    }

    @NotNull
    public String getStaticDescription() {
        String description = this.myMainConfiguration.getDescription();
        if (StringUtil.isEmpty((String)description)) {
            String string = SSRBundle.message("no.description.message", new Object[0]);
            if (string == null) {
                StructuralSearchFakeInspection.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = description;
        if (string == null) {
            StructuralSearchFakeInspection.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public List<Configuration> getConfigurations() {
        List<Configuration> list2 = Collections.unmodifiableList(this.myConfigurations);
        if (list2 == null) {
            StructuralSearchFakeInspection.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @NotNull
    public JComponent createOptionsPanel() {
        MyListModel model = new MyListModel();
        JButton button = new JButton(SSRBundle.message("edit.metadata.button", new Object[0]));
        button.addActionListener(__ -> this.performEditMetaData(button));
        JBList<Configuration> list2 = new JBList<Configuration>((ListModel)model){

            protected String itemToText(int index, Configuration value) {
                return ConfigurationUtil.toXml(value);
            }
        };
        list2.setCellRenderer((ListCellRenderer<Configuration>)((Object)new ConfigurationCellRenderer()));
        JPanel listPanel = ToolbarDecorator.createDecorator((JList)list2).setAddAction(arg_0 -> this.lambda$createOptionsPanel$2((JList)list2, arg_0)).setAddActionName(SSRBundle.message("add.pattern.action", new Object[0])).setRemoveAction(arg_0 -> this.lambda$createOptionsPanel$3((JList)list2, arg_0)).setRemoveActionUpdater(arg_0 -> StructuralSearchFakeInspection.lambda$createOptionsPanel$4((JList)list2, arg_0)).setEditAction(arg_0 -> this.lambda$createOptionsPanel$5((JList)list2, arg_0)).setMoveUpAction(arg_0 -> this.lambda$createOptionsPanel$6((JList)list2, arg_0)).setMoveDownAction(arg_0 -> this.lambda$createOptionsPanel$7((JList)list2, arg_0)).createPanel();
        new DoubleClickListener((JList)list2){
            final /* synthetic */ JList val$list;
            {
                this.val$list = jList;
            }

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                StructuralSearchFakeInspection.this.performEdit(this.val$list);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/inspection/StructuralSearchFakeInspection$2", "onDoubleClick"));
            }
        }.installOn((Component)list2);
        JPanel panel = new FormBuilder().addComponent((JComponent)button).addLabeledComponentFillVertically(SSRBundle.message("templates.title", new Object[0]), (JComponent)listPanel).getPanel();
        panel.setBorder((Border)JBUI.Borders.emptyTop((int)10));
        JPanel jPanel = panel;
        if (jPanel == null) {
            StructuralSearchFakeInspection.$$$reportNull$$$0(9);
        }
        return jPanel;
    }

    private void performEditMetaData(@NotNull Component context) {
        if (context == null) {
            StructuralSearchFakeInspection.$$$reportNull$$$0(10);
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(context));
        InspectionProfileModifiableModel profile = InspectionProfileUtil.getInspectionProfile(context);
        if (profile == null) {
            return;
        }
        SSBasedInspection inspection = SSBasedInspection.getStructuralSearchInspection((InspectionProfile)profile);
        InspectionMetaDataDialog dialog = inspection.createMetaDataDialog(project2, profile.getDisplayName(), this.myMainConfiguration);
        if (this.isCleanupAllowed()) {
            dialog.showCleanupOption(this.myMainConfiguration.isCleanup());
        }
        if (!dialog.showAndGet()) {
            return;
        }
        String name = dialog.getName();
        for (Configuration c : this.myConfigurations) {
            c.setName(name);
        }
        this.myMainConfiguration.setDescription(dialog.getDescription());
        this.myMainConfiguration.setProblemDescriptor(dialog.getProblemDescriptor());
        this.myMainConfiguration.setSuppressId(dialog.getSuppressId());
        this.myMainConfiguration.setCleanup(dialog.isCleanup());
        inspection.removeConfigurationsWithUuid(this.myMainConfiguration.getUuid());
        inspection.addConfigurations(this.myConfigurations);
        profile.setModified(true);
        CustomInspectionActions.fireProfileChanged((InspectionProfileImpl)profile);
    }

    private void performMove(@NotNull JList<Configuration> list2, boolean up) {
        if (list2 == null) {
            StructuralSearchFakeInspection.$$$reportNull$$$0(11);
        }
        MyListModel model = (MyListModel)list2.getModel();
        Comparator<Configuration> c = Comparator.comparingInt(Configuration::getOrder);
        List values = ContainerUtil.sorted(list2.getSelectedValuesList(), up ? c : c.reversed());
        int[] indices = new int[values.size()];
        int size = values.size();
        for (int i = 0; i < size; ++i) {
            Configuration value = (Configuration)values.get(i);
            int order = value.getOrder();
            model.swap(order, order + (up ? -1 : 1));
            indices[i] = value.getOrder();
        }
        this.myMainConfiguration = StructuralSearchFakeInspection.moveMetaData(this.myMainConfiguration, this.myConfigurations.get(0));
        list2.setSelectedIndices(indices);
        list2.scrollRectToVisible(list2.getCellBounds(indices[0], indices[indices.length - 1]));
        model.fireContentsChanged(list2);
        this.saveChangesToProfile(list2);
    }

    @NotNull
    private static Configuration moveMetaData(@NotNull Configuration source, @NotNull Configuration target) {
        if (source == null) {
            StructuralSearchFakeInspection.$$$reportNull$$$0(12);
        }
        if (target == null) {
            StructuralSearchFakeInspection.$$$reportNull$$$0(13);
        }
        if (source == target) {
            Configuration configuration = source;
            if (configuration == null) {
                StructuralSearchFakeInspection.$$$reportNull$$$0(14);
            }
            return configuration;
        }
        target.setDescription(source.getDescription());
        target.setSuppressId(source.getSuppressId());
        target.setProblemDescriptor(source.getProblemDescriptor());
        target.setCleanup(source.isCleanup());
        source.setDescription(null);
        source.setSuppressId(null);
        source.setProblemDescriptor(null);
        Configuration configuration = target;
        if (configuration == null) {
            StructuralSearchFakeInspection.$$$reportNull$$$0(15);
        }
        return configuration;
    }

    private void performAdd(@NotNull JList<Configuration> list2, @NotNull AnActionButton b) {
        if (list2 == null) {
            StructuralSearchFakeInspection.$$$reportNull$$$0(16);
        }
        if (b == null) {
            StructuralSearchFakeInspection.$$$reportNull$$$0(17);
        }
        AnAction[] children = new AnAction[]{new AddTemplateAction(list2, false), new AddTemplateAction(list2, true)};
        RelativePoint point = b.getPreferredPopupPoint();
        JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)new DefaultActionGroup(children), DataManager.getInstance().getDataContext((Component)b.getContextComponent()), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true).show(point);
    }

    private void performRemove(@NotNull JList<Configuration> list2) {
        if (list2 == null) {
            StructuralSearchFakeInspection.$$$reportNull$$$0(18);
        }
        boolean metaData = false;
        for (Configuration configuration : list2.getSelectedValuesList()) {
            if (configuration.getOrder() == 0) {
                metaData = true;
            }
            this.myConfigurations.remove(configuration);
        }
        if (metaData) {
            this.myMainConfiguration = StructuralSearchFakeInspection.moveMetaData(this.myMainConfiguration, this.myConfigurations.get(0));
        }
        int size = this.myConfigurations.size();
        for (int i = 0; i < size; ++i) {
            this.myConfigurations.get(i).setOrder(i);
        }
        int maxIndex = list2.getMaxSelectionIndex();
        if (maxIndex != list2.getMinSelectionIndex()) {
            list2.setSelectedIndex(maxIndex);
        }
        ((MyListModel)list2.getModel()).fireContentsChanged(list2);
        if (list2.getSelectedIndex() >= size) {
            list2.setSelectedIndex(size - 1);
        }
        int index = list2.getSelectedIndex();
        list2.scrollRectToVisible(list2.getCellBounds(index, index));
        this.saveChangesToProfile(list2);
    }

    private void performEdit(@NotNull JList<Configuration> list2) {
        Project project2;
        if (list2 == null) {
            StructuralSearchFakeInspection.$$$reportNull$$$0(19);
        }
        if ((project2 = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(list2))) == null) {
            return;
        }
        int index = list2.getSelectedIndex();
        if (index < 0) {
            return;
        }
        Configuration configuration = this.myConfigurations.get(index);
        if (configuration == null) {
            return;
        }
        SearchContext searchContext = new SearchContext(project2);
        StructuralSearchDialog dialog = new StructuralSearchDialog(searchContext, !(configuration instanceof SearchConfiguration), true);
        dialog.loadConfiguration(configuration);
        if (!dialog.showAndGet()) {
            return;
        }
        Configuration newConfiguration = dialog.getConfiguration();
        if (configuration.getOrder() == 0) {
            this.myMainConfiguration = newConfiguration;
        }
        this.myConfigurations.set(index, newConfiguration);
        ((MyListModel)list2.getModel()).fireContentsChanged(list2);
        this.saveChangesToProfile(list2);
    }

    private void saveChangesToProfile(@NotNull JList<Configuration> list2) {
        InspectionProfileModifiableModel profile;
        if (list2 == null) {
            StructuralSearchFakeInspection.$$$reportNull$$$0(20);
        }
        if ((profile = InspectionProfileUtil.getInspectionProfile(list2)) == null) {
            return;
        }
        SSBasedInspection inspection = SSBasedInspection.getStructuralSearchInspection((InspectionProfile)profile);
        inspection.removeConfigurationsWithUuid(this.myMainConfiguration.getUuid());
        inspection.addConfigurations(this.myConfigurations);
        profile.setModified(true);
    }

    private /* synthetic */ void lambda$createOptionsPanel$7(JList list2, AnActionButton b) {
        this.performMove(list2, false);
    }

    private /* synthetic */ void lambda$createOptionsPanel$6(JList list2, AnActionButton b) {
        this.performMove(list2, true);
    }

    private /* synthetic */ void lambda$createOptionsPanel$5(JList list2, AnActionButton b) {
        this.performEdit(list2);
    }

    private static /* synthetic */ boolean lambda$createOptionsPanel$4(JList list2, AnActionEvent e) {
        return list2.getSelectedValuesList().size() < list2.getModel().getSize();
    }

    private /* synthetic */ void lambda$createOptionsPanel$3(JList list2, AnActionButton b) {
        this.performRemove(list2);
    }

    private /* synthetic */ void lambda$createOptionsPanel$2(JList list2, AnActionButton b) {
        this.performAdd(list2, b);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/inspection/StructuralSearchFakeInspection";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/inspection/StructuralSearchFakeInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupPath";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStaticDescription";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurations";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptionsPanel";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "moveMetaData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "performEditMetaData";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "performMove";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "moveMetaData";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "performAdd";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "performRemove";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "performEdit";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "saveChangesToProfile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 14, 15 -> new IllegalStateException(string);
        };
    }

    private class MyListModel
    extends AbstractListModel<Configuration> {
        private MyListModel() {
        }

        @Override
        public int getSize() {
            return StructuralSearchFakeInspection.this.myConfigurations.size();
        }

        @Override
        public Configuration getElementAt(int index) {
            return StructuralSearchFakeInspection.this.myConfigurations.get(index);
        }

        public void fireContentsChanged(Object source) {
            this.fireContentsChanged(source, -1, -1);
        }

        public void swap(int first, int second) {
            if (second == -1) {
                return;
            }
            Configuration one = StructuralSearchFakeInspection.this.myConfigurations.get(first);
            Configuration two = StructuralSearchFakeInspection.this.myConfigurations.get(second);
            int order = one.getOrder();
            one.setOrder(two.getOrder());
            two.setOrder(order);
            StructuralSearchFakeInspection.this.myConfigurations.set(second, one);
            StructuralSearchFakeInspection.this.myConfigurations.set(first, two);
        }
    }

    private final class AddTemplateAction
    extends DumbAwareAction {
        @NotNull
        private final JList<Configuration> myList;
        private final boolean myReplace;

        private AddTemplateAction(JList<Configuration> list2, boolean replace) {
            if (list2 == null) {
                AddTemplateAction.$$$reportNull$$$0(0);
            }
            super(replace ? SSRBundle.message("SSRInspection.add.replace.template.button", new Object[0]) : SSRBundle.message("SSRInspection.add.search.template.button", new Object[0]));
            this.myList = list2;
            this.myReplace = replace;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddTemplateAction.$$$reportNull$$$0(1);
            }
            Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
            assert (project2 != null);
            SearchContext context = new SearchContext(project2);
            StructuralSearchDialog dialog = new StructuralSearchDialog(context, this.myReplace, true);
            if (!dialog.showAndGet()) {
                return;
            }
            Configuration configuration = dialog.getConfiguration();
            configuration.setUuid(StructuralSearchFakeInspection.this.myMainConfiguration.getUuid());
            configuration.setName(StructuralSearchFakeInspection.this.myMainConfiguration.getName());
            configuration.setDescription(null);
            configuration.setSuppressId(null);
            configuration.setProblemDescriptor(null);
            MyListModel model = (MyListModel)this.myList.getModel();
            int size = model.getSize();
            configuration.setOrder(size);
            InspectionProfileModifiableModel profile = InspectionProfileUtil.getInspectionProfile(this.myList);
            if (profile == null) {
                return;
            }
            if (SSBasedInspection.getStructuralSearchInspection((InspectionProfile)profile).addConfiguration(configuration)) {
                StructuralSearchFakeInspection.this.myConfigurations.add(configuration);
                model.fireContentsChanged(this.myList);
                this.myList.setSelectedIndex(size);
                this.myList.scrollRectToVisible(this.myList.getCellBounds(size, size));
                profile.setModified(true);
            } else {
                int index = StructuralSearchFakeInspection.this.myConfigurations.indexOf(configuration);
                if (index >= 0) {
                    this.myList.setSelectedIndex(index);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/structuralsearch/inspection/StructuralSearchFakeInspection$AddTemplateAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

