/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsRootSettings;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public final class VcsDirectoryMapping {
    public static final String DEFAULT_MAPPING_DIR = "";
    public static final Supplier<@Nls String> PROJECT_CONSTANT = VcsBundle.messagePointer("label.project.vcs.root.mapping", new Object[0]);
    public static final VcsDirectoryMapping[] EMPTY_ARRAY = new VcsDirectoryMapping[0];
    @NotNull
    private final String myDirectory;
    private final String myVcs;
    private final VcsRootSettings myRootSettings;

    public VcsDirectoryMapping(@NotNull String directory, @Nullable String vcs) {
        if (directory == null) {
            VcsDirectoryMapping.$$$reportNull$$$0(0);
        }
        this(directory, vcs, null);
    }

    public VcsDirectoryMapping(@NotNull String directory, @Nullable String vcs, @Nullable VcsRootSettings rootSettings) {
        if (directory == null) {
            VcsDirectoryMapping.$$$reportNull$$$0(1);
        }
        this.myDirectory = FileUtil.normalize((String)directory);
        this.myVcs = StringUtil.notNullize((String)vcs);
        this.myRootSettings = rootSettings;
    }

    @NotNull
    public static VcsDirectoryMapping createDefault(@NotNull String vcs) {
        if (vcs == null) {
            VcsDirectoryMapping.$$$reportNull$$$0(2);
        }
        return new VcsDirectoryMapping(DEFAULT_MAPPING_DIR, vcs);
    }

    @NotNull
    public @SystemIndependent String getDirectory() {
        String string = this.myDirectory;
        if (string == null) {
            VcsDirectoryMapping.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getVcs() {
        String string = this.myVcs;
        if (string == null) {
            VcsDirectoryMapping.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public VcsRootSettings getRootSettings() {
        return this.myRootSettings;
    }

    public boolean isDefaultMapping() {
        return this.myDirectory.isEmpty();
    }

    public boolean isNoneMapping() {
        return this.myVcs.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcsDirectoryMapping mapping = (VcsDirectoryMapping)o;
        if (!this.myDirectory.equals(mapping.myDirectory)) {
            return false;
        }
        if (!Objects.equals(this.myVcs, mapping.myVcs)) {
            return false;
        }
        return Objects.equals(this.myRootSettings, mapping.myRootSettings);
    }

    public int hashCode() {
        int result2 = this.myDirectory.hashCode();
        result2 = 31 * result2 + (this.myVcs != null ? this.myVcs.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return this.isDefaultMapping() ? PROJECT_CONSTANT.get() : this.myDirectory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/VcsDirectoryMapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/VcsDirectoryMapping";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createDefault";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

