/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.quickfix.BaseExtResourceAction;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.WatchedRootsProvider;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.xml.XmlEntityCache;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.net.IOExceptionDialog;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.XmlUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FetchExtResourceAction
extends BaseExtResourceAction {
    private static final Logger LOG = Logger.getInstance(FetchExtResourceAction.class);
    @NonNls
    private static final String HTML_MIME = "text/html";
    @NonNls
    private static final String HTTP_PROTOCOL = "http://";
    @NonNls
    private static final String HTTPS_PROTOCOL = "https://";
    @NonNls
    private static final String FTP_PROTOCOL = "ftp://";
    @NonNls
    private static final String EXT_RESOURCES_FOLDER = "extResources";
    private final boolean myForceResultIsValid;
    private static final String KEY = "xml.intention.fetch.name";

    public FetchExtResourceAction() {
        this.myForceResultIsValid = false;
    }

    public FetchExtResourceAction(boolean forceResultIsValid) {
        this.myForceResultIsValid = forceResultIsValid;
    }

    @Override
    protected String getQuickFixKeyId() {
        return KEY;
    }

    @Override
    protected boolean isAcceptableUri(String uri) {
        return uri.startsWith(HTTP_PROTOCOL) || uri.startsWith(FTP_PROTOCOL) || uri.startsWith(HTTPS_PROTOCOL);
    }

    public static String findUrl(PsiFile file, int offset, String uri) {
        String attrValue;
        String prefix;
        XmlTag tag;
        PsiElement currentElement = file.findElementAt(offset);
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)currentElement, XmlAttribute.class);
        if (attribute != null && (tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)currentElement, XmlTag.class)) != null && (prefix = tag.getPrefixByNamespace("http://www.w3.org/2001/XMLSchema-instance")) != null && (attrValue = tag.getAttributeValue("schemaLocation", "http://www.w3.org/2001/XMLSchema-instance")) != null) {
            StringTokenizer tokenizer = new StringTokenizer(attrValue);
            while (tokenizer.hasMoreElements()) {
                if (uri.equals(tokenizer.nextToken())) {
                    if (!tokenizer.hasMoreElements()) {
                        return uri;
                    }
                    String url = tokenizer.nextToken();
                    return url.startsWith(HTTP_PROTOCOL) ? url : uri;
                }
                if (!tokenizer.hasMoreElements()) {
                    return uri;
                }
                tokenizer.nextToken();
            }
        }
        return uri;
    }

    @NotNull
    private static Path checkExists(String dir) {
        Path path = Paths.get(dir, new String[0]);
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOG.warn("Unable to create: " + String.valueOf(path), (Throwable)e);
        }
        Path path2 = path;
        if (path2 == null) {
            FetchExtResourceAction.$$$reportNull$$$0(0);
        }
        return path2;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Override
    protected void doInvoke(final @NotNull PsiFile file, int offset, final @NotNull String uri, Editor editor) throws IncorrectOperationException {
        if (file == null) {
            FetchExtResourceAction.$$$reportNull$$$0(1);
        }
        if (uri == null) {
            FetchExtResourceAction.$$$reportNull$$$0(2);
        }
        final String url = FetchExtResourceAction.findUrl(file, offset, uri);
        final Project project2 = file.getProject();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, XmlBundle.message((String)"xml.intention.fetch.progress.fetching.resource", (Object[])new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                while (true) {
                    try {
                        HttpConfigurable.getInstance().prepareURL(url);
                        FetchExtResourceAction.this.fetchDtd(project2, uri, url, indicator);
                        ApplicationManager.getApplication().invokeLater(() -> DaemonCodeAnalyzer.getInstance((Project)project2).restart(file));
                        return;
                    }
                    catch (IOException ex) {
                        LOG.info((Throwable)ex);
                        String problemUrl = ex instanceof FetchingResourceIOException ? ((FetchingResourceIOException)ex).url : url;
                        String message = XmlBundle.message((String)"xml.intention.fetch.error.fetching.title", (Object[])new Object[0]);
                        if (url.equals(problemUrl)) continue;
                        message = XmlBundle.message((String)"xml.intention.fetch.error.fetching.dependent.resource", (Object[])new Object[0]);
                        if (IOExceptionDialog.showErrorDialog((String)message, (String)XmlBundle.message((String)"xml.intention.fetch.error.fetching.resource", (Object[])new Object[]{problemUrl}))) continue;
                        return;
                    }
                    break;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInsight/daemon/impl/quickfix/FetchExtResourceAction$1", "run"));
            }
        });
    }

    private void fetchDtd(Project project2, String dtdUrl, String url, ProgressIndicator indicator) throws IOException {
        String extResourcesPath = FetchExtResourceAction.getExternalResourcesPath();
        File extResources = new File(extResourcesPath);
        LOG.assertTrue(extResources.mkdirs() || extResources.exists(), (Object)extResources);
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        ApplicationManager.getApplication().invokeAndWait(() -> WriteAction.run(() -> {
            String path = FileUtil.toSystemIndependentName((String)extResources.getAbsolutePath());
            VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
            LOG.assertTrue(vFile != null, (Object)path);
        }));
        LinkedList<String> downloadedResources = new LinkedList<String>();
        LinkedList<String> resourceUrls = new LinkedList<String>();
        IOException[] nestedException = new IOException[1];
        try {
            String resPath = this.fetchOneFile(indicator, url, project2, extResourcesPath, null);
            if (resPath == null) {
                return;
            }
            resourceUrls.add(dtdUrl);
            downloadedResources.add(resPath);
            VirtualFile virtualFile = FetchExtResourceAction.findFileByPath(resPath, dtdUrl, project2);
            HashSet<String> processedLinks = new HashSet<String>();
            HashMap<String, Object> baseUrls = new HashMap<String, Object>();
            HashMap<String, Object> parentRefs = new HashMap<String, Object>();
            VirtualFile contextFile = virtualFile;
            HashSet<String> linksToProcess = new HashSet<String>(FetchExtResourceAction.extractEmbeddedFileReferences(virtualFile, null, psiManager, url));
            while (!linksToProcess.isEmpty()) {
                String resourcePath;
                String parentRef;
                Object resourceUrl;
                boolean absoluteUrl;
                String s = (String)linksToProcess.iterator().next();
                linksToProcess.remove(s);
                processedLinks.add(s);
                boolean bl = absoluteUrl = s.startsWith(HTTP_PROTOCOL) || s.startsWith(HTTPS_PROTOCOL);
                if (absoluteUrl) {
                    resourceUrl = s;
                } else {
                    String baseUrl = (String)baseUrls.get(s);
                    if (baseUrl == null) {
                        baseUrl = url;
                    }
                    resourceUrl = baseUrl.substring(0, baseUrl.lastIndexOf(47) + 1) + s;
                    try {
                        URL base = new URL(baseUrl);
                        resourceUrl = new URL(base, s).toString();
                    }
                    catch (MalformedURLException e) {
                        LOG.warn((Throwable)e);
                    }
                }
                Object refName = s;
                if (absoluteUrl) {
                    refName = Integer.toHexString(s.hashCode()) + "_" + ((String)refName).substring(((String)refName).lastIndexOf(47) + 1);
                } else if (!((String)refName).startsWith("/") && (parentRef = (String)parentRefs.get(refName)) != null && !parentRef.startsWith("/") && parentRef.contains("/")) {
                    refName = new File(new File(parentRef).getParent(), (String)refName).getPath();
                }
                try {
                    resourcePath = this.fetchOneFile(indicator, (String)resourceUrl, project2, extResourcesPath, (String)refName);
                }
                catch (IOException e) {
                    nestedException[0] = new FetchingResourceIOException(e, (String)resourceUrl);
                    break;
                }
                if (resourcePath != null) {
                    virtualFile = FetchExtResourceAction.findFileByPath(resourcePath, absoluteUrl ? s : null, project2);
                    downloadedResources.add(resourcePath);
                    if (absoluteUrl) {
                        resourceUrls.add(s);
                    }
                    Set<String> newLinks = FetchExtResourceAction.extractEmbeddedFileReferences(virtualFile, contextFile, psiManager, (String)resourceUrl);
                    for (String u : newLinks) {
                        baseUrls.put(u, resourceUrl);
                        parentRefs.put(u, refName);
                        if (processedLinks.contains(u)) continue;
                        linksToProcess.add(u);
                    }
                    continue;
                }
                break;
            }
        }
        catch (IOException ex) {
            nestedException[0] = ex;
        }
        if (nestedException[0] != null) {
            this.cleanup(resourceUrls, downloadedResources);
            throw nestedException[0];
        }
    }

    private static VirtualFile findFileByPath(String resPath, @Nullable String dtdUrl, Project project2) {
        Ref ref = new Ref();
        ApplicationManager.getApplication().invokeAndWait(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            ref.set((Object)LocalFileSystem.getInstance().refreshAndFindFileByPath(resPath.replace(File.separatorChar, '/')));
            if (dtdUrl != null) {
                ExternalResourceManager.getInstance().addResource(dtdUrl, resPath);
            } else if (!project2.isDisposed()) {
                ExternalResourceManager.getInstance().incModificationCount();
                PsiManager.getInstance((Project)project2).dropPsiCaches();
            }
        }));
        return (VirtualFile)ref.get();
    }

    public static String getExternalResourcesPath() {
        return PathManager.getSystemPath() + File.separator + EXT_RESOURCES_FOLDER;
    }

    private void cleanup(final List<String> resourceUrls, final List<String> downloadedResources) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        for (String resourcesUrl : resourceUrls) {
                            ExternalResourceManager.getInstance().removeResource(resourcesUrl);
                        }
                        for (String downloadedResource : downloadedResources) {
                            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(new File(downloadedResource));
                            if (virtualFile == null) continue;
                            try {
                                virtualFile.delete((Object)this);
                            }
                            catch (IOException iOException) {}
                        }
                    }
                });
            }
        });
    }

    @Nullable
    private String fetchOneFile(ProgressIndicator indicator, String resourceUrl, Project project2, String extResourcesPath, @Nullable String refname) throws IOException {
        SwingUtilities.invokeLater(() -> indicator.setText(XmlBundle.message((String)"xml.intention.fetch.progress.fetching", (Object[])new Object[]{resourceUrl})));
        FetchResult result2 = FetchExtResourceAction.fetchData(project2, resourceUrl, indicator);
        if (result2 == null) {
            return null;
        }
        if (!this.resultIsValid(project2, indicator, resourceUrl, result2)) {
            return null;
        }
        String resPath = extResourcesPath + File.separatorChar;
        if (refname != null) {
            int refNameSlashIndex = (resPath = resPath + refname).lastIndexOf(47);
            if (refNameSlashIndex != -1) {
                FetchExtResourceAction.checkExists(resPath.substring(0, refNameSlashIndex));
            }
        } else {
            int slashIndex = resourceUrl.lastIndexOf(47);
            resPath = resPath + Integer.toHexString(resourceUrl.hashCode()) + "_" + resourceUrl.substring(slashIndex + 1);
        }
        int lastDoPosInResourceUrl = resourceUrl.lastIndexOf(46);
        if (lastDoPosInResourceUrl == -1 || FileTypeManager.getInstance().getFileTypeByExtension(resourceUrl.substring(lastDoPosInResourceUrl + 1)) == FileTypes.UNKNOWN) {
            String extension = result2.contentType != null && result2.contentType.contains(HTML_MIME) ? HtmlFileType.INSTANCE.getDefaultExtension() : XmlFileType.INSTANCE.getDefaultExtension();
            resPath = resPath + "." + extension;
        }
        File res = new File(resPath);
        FileUtil.writeToFile((File)res, (byte[])result2.bytes);
        return resPath;
    }

    private boolean resultIsValid(Project project2, ProgressIndicator indicator, String resourceUrl, FetchResult result2) {
        if (this.myForceResultIsValid) {
            return true;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && result2.contentType != null && result2.contentType.contains(HTML_MIME) && new String(result2.bytes, StandardCharsets.UTF_8).contains("<html")) {
            ApplicationManager.getApplication().invokeLater(() -> Messages.showMessageDialog((Project)project2, (String)XmlBundle.message((String)"xml.intention.fetch.error.invalid.url.no.xml.file.at.location", (Object[])new Object[]{resourceUrl}), (String)XmlBundle.message((String)"xml.intention.fetch.error.invalid.url.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon()), indicator.getModalityState());
            return false;
        }
        return true;
    }

    private static Set<String> extractEmbeddedFileReferences(XmlFile file, XmlFile context, String url) {
        if (context != null) {
            XmlEntityCache.copyEntityCaches((PsiFile)file, (PsiFile)context);
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>();
        XmlUtil.processXmlElements((XmlElement)file, (PsiElementProcessor<? super PsiElement>)((PsiElementProcessor)element -> {
            block7: {
                String schemaLocation;
                XmlTag tag;
                block9: {
                    block8: {
                        if (!(element instanceof XmlEntityDecl)) break block8;
                        String candidateName = null;
                        for (PsiElement e = element.getLastChild(); e != null; e = e.getPrevSibling()) {
                            if (e instanceof XmlAttributeValue && candidateName == null) {
                                candidateName = e.getText().substring(1, e.getTextLength() - 1);
                                continue;
                            }
                            if (!(e instanceof XmlToken) || candidateName == null || ((XmlToken)e).getTokenType() != XmlTokenType.XML_DOCTYPE_PUBLIC && ((XmlToken)e).getTokenType() != XmlTokenType.XML_DOCTYPE_SYSTEM) continue;
                            result2.add(candidateName);
                            break block7;
                        }
                        break block7;
                    }
                    if (!(element instanceof XmlTag)) break block7;
                    tag = (XmlTag)element;
                    schemaLocation = tag.getAttributeValue("schemaLocation");
                    if (schemaLocation == null) break block9;
                    PsiReference[] references = tag.getAttribute("schemaLocation").getValueElement().getReferences();
                    if (references.length <= 0) break block7;
                    String extension = FileUtilRt.getExtension((String)new File(url).getName());
                    String namespace = tag.getAttributeValue("namespace");
                    if (namespace != null && schemaLocation.indexOf(47) == -1 && !extension.equals(FileUtilRt.getExtension((String)schemaLocation))) {
                        result2.add(namespace.substring(0, namespace.lastIndexOf(47) + 1) + schemaLocation);
                    } else {
                        result2.add(schemaLocation);
                    }
                    break block7;
                }
                schemaLocation = tag.getAttributeValue("schemaLocation", "http://www.w3.org/2001/XMLSchema-instance");
                if (schemaLocation != null) {
                    StringTokenizer tokenizer = new StringTokenizer(schemaLocation);
                    while (tokenizer.hasMoreTokens()) {
                        tokenizer.nextToken();
                        if (tokenizer.hasMoreTokens()) {
                            String location = tokenizer.nextToken();
                            result2.add(location);
                            continue;
                        }
                        break;
                    }
                }
            }
            return true;
        }), true, true);
        return result2;
    }

    public static Set<String> extractEmbeddedFileReferences(VirtualFile vFile, @Nullable VirtualFile contextVFile, PsiManager psiManager, String url) {
        return (Set)ReadAction.compute(() -> {
            PsiFile file = psiManager.findFile(vFile);
            if (file instanceof XmlFile) {
                PsiFile contextFile = contextVFile != null ? psiManager.findFile(contextVFile) : null;
                return FetchExtResourceAction.extractEmbeddedFileReferences((XmlFile)file, contextFile instanceof XmlFile ? (XmlFile)contextFile : null, url);
            }
            return Collections.emptySet();
        });
    }

    @Nullable
    private static FetchResult fetchData(Project project2, String dtdUrl, ProgressIndicator indicator) throws IOException {
        try {
            return (FetchResult)HttpRequests.request((String)dtdUrl).accept("text/xml,application/xml,text/html,*/*").connect(request -> {
                FetchResult result2 = new FetchResult();
                result2.bytes = request.readBytes(indicator);
                result2.contentType = request.getConnection().getContentType();
                return result2;
            });
        }
        catch (MalformedURLException e) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                ApplicationManager.getApplication().invokeLater(() -> Messages.showMessageDialog((Project)project2, (String)XmlBundle.message((String)"xml.intention.fetch.error.invalid.url.message", (Object[])new Object[]{dtdUrl}), (String)XmlBundle.message((String)"xml.intention.fetch.error.invalid.url.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon()), indicator.getModalityState());
            }
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/FetchExtResourceAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "checkExists";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/FetchExtResourceAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    static final class FetchingResourceIOException
    extends IOException {
        private final String url;

        FetchingResourceIOException(Throwable cause, String url) {
            this.initCause(cause);
            this.url = url;
        }
    }

    protected static class FetchResult {
        byte[] bytes;
        String contentType;

        protected FetchResult() {
        }
    }

    static final class MyWatchedRootsProvider
    implements WatchedRootsProvider {
        MyWatchedRootsProvider() {
        }

        @NotNull
        public Set<String> getRootsToWatch(@NotNull Project project2) {
            if (project2 == null) {
                MyWatchedRootsProvider.$$$reportNull$$$0(0);
            }
            String path = FetchExtResourceAction.getExternalResourcesPath();
            Path file = FetchExtResourceAction.checkExists(path);
            Set<String> set = Collections.singleton(file.toAbsolutePath().toString());
            if (set == null) {
                MyWatchedRootsProvider.$$$reportNull$$$0(1);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/FetchExtResourceAction$MyWatchedRootsProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/FetchExtResourceAction$MyWatchedRootsProvider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRootsToWatch";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getRootsToWatch";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

