/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.analysis.XmlPathReferenceInspection;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlFile;
import com.intellij.xml.util.AnchorReference;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.NotNull;

public class HtmlUnknownTargetInspection
extends XmlPathReferenceInspection {
    @NotNull
    public String getShortName() {
        return "HtmlUnknownTarget";
    }

    @Override
    protected boolean isForHtml() {
        return true;
    }

    @Override
    protected boolean needToCheckRef(PsiReference reference) {
        return super.needToCheckRef(reference) && !(reference instanceof AnchorReference) && HtmlUnknownTargetInspection.notRemoteBase(reference);
    }

    static boolean notRemoteBase(PsiReference reference) {
        PsiFile file = reference.getElement().getContainingFile();
        String basePath = file instanceof XmlFile ? HtmlUtil.getHrefBase((XmlFile)file) : null;
        return basePath == null || !HtmlUtil.hasHtmlPrefix(basePath);
    }
}

