/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.util;

import com.intellij.execution.ExecutionResult;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentDescriptorReusePolicy;
import com.intellij.javascript.karma.execution.KarmaConsoleView;
import com.intellij.javascript.karma.server.KarmaServer;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.lang.javascript.JSLanguageUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.LocalFileFinder;

public final class KarmaUtil {
    public static final String KARMA_PACKAGE_NAME = "karma";
    public static final String ANGULAR_CLI__PACKAGE_NAME = "@angular/cli";
    private static final String NX = "nx";
    public static final NodePackageDescriptor PKG_DESCRIPTOR = KarmaUtil.createPackageDescriptor();
    private static final String[] STARTING_PARTS = new String[]{"karma"};
    private static final String NAME_PART_DELIMITERS = ".-";
    private static final String[] BEFORE_EXT_PARTS = new String[]{"conf", "karma"};
    private static final String[] EXTENSIONS = new String[]{"js", "coffee", "es6", "ts"};
    private static final String[] MOST_RELEVANT_NAMES = new String[]{"karma.conf", "karma-conf", "karma-js.conf"};

    private KarmaUtil() {
    }

    @NotNull
    public static List<VirtualFile> listPossibleConfigFilesInProject(@NotNull Project project) {
        if (project == null) {
            KarmaUtil.$$$reportNull$$$0(0);
        }
        GlobalSearchScope contentScope = ProjectScope.getContentScope((Project)project);
        GlobalSearchScope scope = contentScope.intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)ProjectScope.getLibrariesScope((Project)project)));
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (FileType type : JSLanguageUtil.getFileTypesCompilableToJavaScript()) {
            Collection files = FileTypeIndex.getFiles((FileType)type, (GlobalSearchScope)scope);
            for (VirtualFile file : files) {
                if (file == null || !file.isValid() || file.isDirectory() || !KarmaUtil.isKarmaConfigFile(file.getNameSequence(), false) || JSLibraryUtil.isProbableLibraryFile((VirtualFile)file)) continue;
                result.add(file);
            }
        }
        ArrayList<VirtualFile> arrayList = result;
        if (arrayList == null) {
            KarmaUtil.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    public static boolean isKarmaConfigFile(@NotNull CharSequence filename, boolean matchMostRelevantNamesOnly) {
        int len;
        int extensionInd;
        if (filename == null) {
            KarmaUtil.$$$reportNull$$$0(2);
        }
        if ((extensionInd = StringUtil.lastIndexOf((CharSequence)filename, (char)'.', (int)0, (int)(len = filename.length()))) == -1) {
            return false;
        }
        boolean extMatched = false;
        for (String ext : EXTENSIONS) {
            if (ext.length() != len - extensionInd - 1 || !StringUtil.endsWith((CharSequence)filename, (CharSequence)ext)) continue;
            extMatched = true;
            break;
        }
        if (matchMostRelevantNamesOnly) {
            return KarmaUtil.isStartingPartMatched(filename, MOST_RELEVANT_NAMES);
        }
        if (!extMatched) {
            return false;
        }
        for (String beforeExtPart : BEFORE_EXT_PARTS) {
            int startOffset = extensionInd - beforeExtPart.length();
            if (startOffset <= 0 || !CharArrayUtil.regionMatches((CharSequence)filename, (int)startOffset, (CharSequence)beforeExtPart) || NAME_PART_DELIMITERS.indexOf(filename.charAt(startOffset - 1)) < 0) continue;
            return !StringUtil.contains((CharSequence)filename, (CharSequence)"protractor");
        }
        return KarmaUtil.isStartingPartMatched(filename, STARTING_PARTS);
    }

    private static boolean isStartingPartMatched(@NotNull CharSequence filename, String @NotNull [] startingParts) {
        if (filename == null) {
            KarmaUtil.$$$reportNull$$$0(3);
        }
        if (startingParts == null) {
            KarmaUtil.$$$reportNull$$$0(4);
        }
        for (String startingPart : startingParts) {
            if (startingPart.length() >= filename.length() || !CharArrayUtil.regionMatches((CharSequence)filename, (int)0, (CharSequence)startingPart) || NAME_PART_DELIMITERS.indexOf(filename.charAt(startingPart.length())) < 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isPathUnderContentRoots(@NotNull Project project, @NotNull NodePackage pkg) {
        VirtualFile file;
        if (project == null) {
            KarmaUtil.$$$reportNull$$$0(5);
        }
        if (pkg == null) {
            KarmaUtil.$$$reportNull$$$0(6);
        }
        if ((file = LocalFileFinder.findFile((String)pkg.getSystemIndependentPath())) == null || !file.isValid()) {
            return false;
        }
        VirtualFile contentRoot = JSLibraryUtil.getContentRootForFile((Project)project, (VirtualFile)file);
        return contentRoot != null;
    }

    @NotNull
    public static RunContentDescriptor createDefaultDescriptor(@NotNull ExecutionResult executionResult, @NotNull ExecutionEnvironment environment) {
        ExecutionConsole console;
        if (executionResult == null) {
            KarmaUtil.$$$reportNull$$$0(7);
        }
        if (environment == null) {
            KarmaUtil.$$$reportNull$$$0(8);
        }
        KarmaServer server = (console = executionResult.getExecutionConsole()) instanceof KarmaConsoleView ? ((KarmaConsoleView)console).getKarmaServer() : null;
        RunContentBuilder contentBuilder = new RunContentBuilder(executionResult, environment);
        RunContentDescriptor descriptor = contentBuilder.showRunContent(environment.getContentToReuse());
        return KarmaUtil.withReusePolicy(descriptor, server);
    }

    @NotNull
    public static RunContentDescriptor withReusePolicy(@NotNull RunContentDescriptor descriptor, final @Nullable KarmaServer karmaServer) {
        if (descriptor == null) {
            KarmaUtil.$$$reportNull$$$0(9);
        }
        descriptor.setReusePolicy(new RunContentDescriptorReusePolicy(){

            public boolean canBeReusedBy(@NotNull RunContentDescriptor newDescriptor) {
                if (newDescriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (karmaServer == null || karmaServer.getProcessHandler().isProcessTerminated()) {
                    return true;
                }
                KarmaConsoleView newConsole = (KarmaConsoleView)((Object)ObjectUtils.tryCast((Object)newDescriptor.getExecutionConsole(), KarmaConsoleView.class));
                return newConsole != null && newConsole.getKarmaServer().equals(karmaServer);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newDescriptor", "com/intellij/javascript/karma/util/KarmaUtil$1", "canBeReusedBy"));
            }
        });
        RunContentDescriptor runContentDescriptor = descriptor;
        if (runContentDescriptor == null) {
            KarmaUtil.$$$reportNull$$$0(10);
        }
        return runContentDescriptor;
    }

    public static boolean isAngularCliPkg(@NotNull NodePackage pkg) {
        if (pkg == null) {
            KarmaUtil.$$$reportNull$$$0(11);
        }
        return pkg.getSystemIndependentPath().endsWith("/@angular/cli");
    }

    public static boolean isNxPkg(@NotNull NodePackage pkg) {
        if (pkg == null) {
            KarmaUtil.$$$reportNull$$$0(12);
        }
        return pkg.getName().equals(NX);
    }

    @NotNull
    private static NodePackageDescriptor createPackageDescriptor() {
        return new NodePackageDescriptor(new String[]{ANGULAR_CLI__PACKAGE_NAME, KARMA_PACKAGE_NAME}){

            @NotNull
            public List<NodePackage> listAvailable(@NotNull Project project, @Nullable NodeJsInterpreter interpreter, @Nullable VirtualFile contextFileOrDirectory, boolean directDependenciesInsideProject, boolean dependenciesShouldBeVisibleFromContext) {
                VirtualFile improvedContext;
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                List nxPackages = List.of();
                VirtualFile virtualFile = improvedContext = contextFileOrDirectory != null ? contextFileOrDirectory : ProjectUtil.guessProjectDir((Project)project);
                if (improvedContext != null && JSProjectUtil.findFileUpToContentRoot((Project)project, (VirtualFile)improvedContext, (String[])new String[]{"nx.json"}) != null) {
                    nxPackages = new NodePackageDescriptor(KarmaUtil.NX).listAvailable(project, interpreter, improvedContext, directDependenciesInsideProject, true);
                }
                ArrayList<NodePackage> result = new ArrayList<NodePackage>();
                result.addAll(nxPackages);
                result.addAll(super.listAvailable(project, interpreter, contextFileOrDirectory, directDependenciesInsideProject, dependenciesShouldBeVisibleFromContext));
                ArrayList<NodePackage> arrayList = result;
                if (arrayList == null) {
                    2.$$$reportNull$$$0(1);
                }
                return arrayList;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/javascript/karma/util/KarmaUtil$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/javascript/karma/util/KarmaUtil$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "listAvailable";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "listAvailable";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/karma/util/KarmaUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filename";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startingParts";
                break;
            }
            case 6: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionResult";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/karma/util/KarmaUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "listPossibleConfigFilesInProject";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "withReusePolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "listPossibleConfigFilesInProject";
                break;
            }
            case 1: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isKarmaConfigFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isStartingPartMatched";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isPathUnderContentRoots";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultDescriptor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "withReusePolicy";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isAngularCliPkg";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isNxPkg";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 10 -> new IllegalStateException(string);
        };
    }
}

