/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dataWrangler.impl.view.transformation;

import com.intellij.dataWrangler.executor.DataWranglerContext;
import com.intellij.dataWrangler.impl.DataWranglerBundle;
import com.intellij.dataWrangler.impl.ui.DataWranglerUiSession;
import com.intellij.dataWrangler.impl.ui.operations.ParameterPanel;
import com.intellij.dataWrangler.impl.view.transformation.TransformationsCommandNode;
import com.intellij.dataWrangler.impl.view.transformation.TransformationsFilterTree;
import com.intellij.dataWrangler.impl.view.transformation.TransformationsTree;
import com.intellij.dataWrangler.operations.CommandFactory;
import com.intellij.dataWrangler.operations.TransformationStep;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.JBCardLayout;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TopGap;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00000\u0003B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\u001e\u001a\u00020\u001f2\u0010\u0010 \u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00000!H\u0002J(\u0010\"\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020#\u0012\u0004\u0012\u00028\u00000\u00152\u0010\u0010 \u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00000!H\u0002J\u001a\u0010$\u001a\u00020\u001f2\u0010\u0010%\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00000\u0015H\u0002J\u001a\u0010&\u001a\u00020\u001f2\u0010\u0010'\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00000\u0015H\u0002J\b\u0010(\u001a\u00020\u001fH\u0002J\b\u0010)\u001a\u00020\u001fH\u0002J\b\u0010*\u001a\u00020\u001fH\u0002J\b\u0010+\u001a\u00020,H\u0002J\u0013\u0010-\u001a\u0004\u0018\u00010\u001f*\u00020.H\u0002\u00a2\u0006\u0002\u0010/J\b\u00100\u001a\u000201H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R$\u0010\u0014\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00000\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0013R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/dataWrangler/impl/view/transformation/TransformationsPanel;", "C", "Lcom/intellij/dataWrangler/executor/DataWranglerContext;", "Lcom/intellij/ui/components/JBPanel;", "session", "Lcom/intellij/dataWrangler/impl/ui/DataWranglerUiSession;", "<init>", "(Lcom/intellij/dataWrangler/impl/ui/DataWranglerUiSession;)V", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "getProject", "()Lcom/intellij/openapi/project/Project;", "cardLayout", "Lcom/intellij/ui/JBCardLayout;", "cardPanel", "Ljavax/swing/JPanel;", "treePanel", "getTreePanel", "()Ljavax/swing/JPanel;", "parameterPanel", "Lcom/intellij/dataWrangler/impl/ui/operations/ParameterPanel;", "getParameterPanel", "()Lcom/intellij/dataWrangler/impl/ui/operations/ParameterPanel;", "setParameterPanel", "(Lcom/intellij/dataWrangler/impl/ui/operations/ParameterPanel;)V", "paramPanelWrapper", "getParamPanelWrapper", "paramsScrollPane", "Lcom/intellij/ui/components/JBScrollPane;", "updateParametersPanel", "", "commandFactory", "Lcom/intellij/dataWrangler/operations/CommandFactory;", "createParametersPanel", "", "setParametersPanel", "newChildPanel", "disposeParametersPanel", "parameters", "parameterApplyHandler", "swipeToTreeView", "swipeToParameterPanel", "createTreeView", "Lcom/intellij/dataWrangler/impl/view/transformation/TransformationsTree;", "perform", "Lcom/intellij/dataWrangler/impl/view/transformation/TransformationsCommandNode;", "(Lcom/intellij/dataWrangler/impl/view/transformation/TransformationsCommandNode;)Lkotlin/Unit;", "createBackButton", "Ljavax/swing/JButton;", "intellij.dataWrangler.impl"})
@SourceDebugExtension(value={"SMAP\nTransformationsPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransformationsPanel.kt\ncom/intellij/dataWrangler/impl/view/transformation/TransformationsPanel\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,181:1\n19#2:182\n*S KotlinDebug\n*F\n+ 1 TransformationsPanel.kt\ncom/intellij/dataWrangler/impl/view/transformation/TransformationsPanel\n*L\n166#1:182\n*E\n"})
public final class TransformationsPanel<C extends DataWranglerContext>
extends JBPanel<TransformationsPanel<C>> {
    @NotNull
    private final DataWranglerUiSession<C> session;
    @NotNull
    private final Project project;
    @NotNull
    private final JBCardLayout cardLayout;
    @NotNull
    private final JPanel cardPanel;
    @NotNull
    private final JPanel treePanel;
    @NotNull
    private ParameterPanel<?, C> parameterPanel;
    @NotNull
    private final JPanel paramPanelWrapper;
    @NotNull
    private final JBScrollPane paramsScrollPane;

    public TransformationsPanel(@NotNull DataWranglerUiSession<C> session) {
        DialogPanel dialogPanel;
        JButton jButton;
        Intrinsics.checkNotNullParameter(session, (String)"session");
        super((LayoutManager)new BorderLayout());
        this.session = session;
        Project project = this.session.getTableViewer().getGrid().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.project = project;
        this.cardLayout = new JBCardLayout();
        this.cardPanel = new JPanel((LayoutManager)this.cardLayout);
        this.paramsScrollPane = new JBScrollPane(20, 31);
        List commands = this.session.getBackendSession().getEngine().collectCommandsFactories();
        this.treePanel = new JPanel(new BorderLayout());
        TransformationsTree treeView = this.createTreeView();
        TransformationsFilterTree filterTree = new TransformationsFilterTree(this.project, treeView, commands);
        SearchTextField searchField = filterTree.installSearchField();
        JBScrollPane treeScrollPane = new JBScrollPane(20, 31);
        this.treePanel.add((Component)searchField, "North");
        treeScrollPane.setViewportView((Component)((Object)treeView));
        this.treePanel.add((Component)treeScrollPane, "Center");
        this.parameterPanel = this.createParametersPanel((CommandFactory)CollectionsKt.first((List)commands));
        this.paramPanelWrapper = new JPanel(new BorderLayout());
        this.paramPanelWrapper.add((Component)this.parameterPanel.getPanel());
        JButton $this$_init__u24lambda_u241 = jButton = new JButton(DataWranglerBundle.message("dw.button.apply", new Object[0]));
        boolean bl = false;
        $this$_init__u24lambda_u241.addActionListener(arg_0 -> TransformationsPanel.lambda$1$lambda$0(this, arg_0));
        JButton applyCommandButton = jButton;
        DialogPanel $this$_init__u24lambda_u246 = dialogPanel = BuilderKt.panel(arg_0 -> TransformationsPanel._init_$lambda$5(this, applyCommandButton, arg_0));
        boolean bl2 = false;
        $this$_init__u24lambda_u246.setBorder((Border)JBUI.Borders.empty((int)4, (int)10));
        DialogPanel panel = dialogPanel;
        this.cardPanel.add((Component)this.treePanel, "tree");
        this.paramsScrollPane.setViewportView((Component)panel);
        this.cardPanel.add((Component)this.paramsScrollPane, "params");
        this.add(this.cardPanel);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final JPanel getTreePanel() {
        return this.treePanel;
    }

    @NotNull
    public final ParameterPanel<?, C> getParameterPanel() {
        return this.parameterPanel;
    }

    public final void setParameterPanel(@NotNull ParameterPanel<?, C> parameterPanel) {
        Intrinsics.checkNotNullParameter(parameterPanel, (String)"<set-?>");
        this.parameterPanel = parameterPanel;
    }

    @NotNull
    public final JPanel getParamPanelWrapper() {
        return this.paramPanelWrapper;
    }

    private final void updateParametersPanel(CommandFactory<?, C> commandFactory) {
        this.setParametersPanel(this.createParametersPanel(commandFactory));
    }

    private final ParameterPanel<? extends Object, C> createParametersPanel(CommandFactory<?, C> commandFactory) {
        return new ParameterPanel(commandFactory, this.session);
    }

    private final void setParametersPanel(ParameterPanel<?, C> newChildPanel) {
        this.disposeParametersPanel(this.parameterPanel);
        this.parameterPanel = newChildPanel;
        this.paramPanelWrapper.add((Component)this.parameterPanel.getPanel());
        this.paramPanelWrapper.revalidate();
        this.paramPanelWrapper.repaint();
    }

    private final void disposeParametersPanel(ParameterPanel<?, C> parameters) {
        this.paramPanelWrapper.remove((Component)parameters.getPanel());
        Disposer.dispose((Disposable)((Disposable)parameters));
    }

    private final void parameterApplyHandler() {
        this.parameterPanel.getPanel().apply();
        TransformationStep<?, C> step = this.parameterPanel.createTransformationStep();
        this.session.getBackendSession().runTransformation(step);
        this.swipeToTreeView();
    }

    private final void swipeToTreeView() {
        this.cardLayout.swipe((Container)this.cardPanel, "tree", JBCardLayout.SwipeDirection.BACKWARD);
    }

    private final void swipeToParameterPanel() {
        this.cardLayout.swipe((Container)this.cardPanel, "params", JBCardLayout.SwipeDirection.FORWARD);
    }

    private final TransformationsTree createTreeView() {
        TransformationsTree transformationsTree;
        TransformationsTree $this$createTreeView_u24lambda_u247 = transformationsTree = new TransformationsTree();
        boolean bl = false;
        $this$createTreeView_u24lambda_u247.addMouseListener(new MouseAdapter($this$createTreeView_u24lambda_u247, this){
            final /* synthetic */ TransformationsTree $this_apply;
            final /* synthetic */ TransformationsPanel<C> this$0;
            {
                this.$this_apply = $receiver;
                this.this$0 = $receiver2;
            }

            public void mouseClicked(MouseEvent e) {
                if (e != null && SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 1) {
                    TransformationsCommandNode node;
                    TransformationsTree myTree = this.$this_apply;
                    TreePath treePath = myTree.getPathForLocation(e.getX(), e.getY());
                    if (treePath == null) {
                        return;
                    }
                    TreePath path = treePath;
                    Object $this$asSafely$iv = path.getLastPathComponent();
                    boolean $i$f$asSafely = false;
                    Object object = $this$asSafely$iv;
                    if (!(object instanceof TransformationsCommandNode)) {
                        object = null;
                    }
                    if ((node = (TransformationsCommandNode)object) != null) {
                        TransformationsPanel.access$perform(this.this$0, node);
                    }
                    e.consume();
                }
            }
        });
        $this$createTreeView_u24lambda_u247.addKeyListener(new KeyAdapter($this$createTreeView_u24lambda_u247, this){
            final /* synthetic */ TransformationsTree $this_apply;
            final /* synthetic */ TransformationsPanel<C> this$0;
            {
                this.$this_apply = $receiver;
                this.this$0 = $receiver2;
            }

            public void keyPressed(KeyEvent e) {
                KeyEvent keyEvent = e;
                boolean bl = keyEvent != null ? keyEvent.getKeyCode() == 10 : false;
                if (bl) {
                    TransformationsCommandNode node;
                    TransformationsTree myTree = this.$this_apply;
                    Object $this$asSafely$iv = myTree.getLastSelectedPathComponent();
                    boolean $i$f$asSafely = false;
                    Object object = $this$asSafely$iv;
                    if (!(object instanceof TransformationsCommandNode)) {
                        object = null;
                    }
                    if ((node = (TransformationsCommandNode)object) != null) {
                        TransformationsPanel.access$perform(this.this$0, node);
                    }
                }
            }
        });
        return transformationsTree;
    }

    private final Unit perform(TransformationsCommandNode $this$perform) {
        Unit unit;
        TransformationsCommandNode transformationsCommandNode = $this$perform;
        if (transformationsCommandNode instanceof TransformationsCommandNode.CommandActionNode) {
            ((TransformationsCommandNode.CommandActionNode)$this$perform).getUserObject().perform(this.project);
            unit = Unit.INSTANCE;
        } else if (transformationsCommandNode instanceof TransformationsCommandNode.CommandGroupNode) {
            unit = Unit.INSTANCE;
        } else if (transformationsCommandNode instanceof TransformationsCommandNode.CommandNode) {
            TransformationsCommandNode $this$asSafely$iv = $this$perform;
            boolean $i$f$asSafely = false;
            TransformationsCommandNode transformationsCommandNode2 = $this$asSafely$iv;
            if (!(transformationsCommandNode2 instanceof TransformationsCommandNode.CommandNode)) {
                transformationsCommandNode2 = null;
            }
            TransformationsCommandNode.CommandNode commandNode = (TransformationsCommandNode.CommandNode)transformationsCommandNode2;
            if (commandNode != null) {
                TransformationsCommandNode.CommandNode commandNode2 = commandNode;
                boolean bl = false;
                this.updateParametersPanel(commandNode2.getCommand());
                this.swipeToParameterPanel();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return unit;
    }

    private final JButton createBackButton() {
        JButton jButton;
        JButton $this$createBackButton_u24lambda_u2410 = jButton = new JButton(DataWranglerBundle.message("label.transformation.panel.back.to.transformations", new Object[0]), AllIcons.Actions.Back);
        boolean bl = false;
        $this$createBackButton_u24lambda_u2410.setHorizontalAlignment(2);
        $this$createBackButton_u24lambda_u2410.setVerticalAlignment(1);
        $this$createBackButton_u24lambda_u2410.setBorder((Border)JBUI.Borders.empty());
        $this$createBackButton_u24lambda_u2410.setBorderPainted(false);
        $this$createBackButton_u24lambda_u2410.addActionListener(arg_0 -> TransformationsPanel.createBackButton$lambda$10$lambda$9(this, arg_0));
        return jButton;
    }

    private static final void lambda$1$lambda$0(TransformationsPanel this$0, ActionEvent it) {
        this$0.parameterApplyHandler();
    }

    private static final Unit lambda$5$lambda$2(TransformationsPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.bottomGap(BottomGap.NONE);
        $this$row.topGap(TopGap.NONE);
        $this$row.cell((JComponent)this$0.createBackButton()).align((Align)AlignX.LEFT.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$5$lambda$3(TransformationsPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.topGap(TopGap.NONE);
        $this$row.cell((JComponent)this$0.paramPanelWrapper).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$5$lambda$4(JButton $applyCommandButton, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)$applyCommandButton).align((Align)AlignX.LEFT.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$5(TransformationsPanel this$0, JButton $applyCommandButton, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> TransformationsPanel.lambda$5$lambda$2(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> TransformationsPanel.lambda$5$lambda$3(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> TransformationsPanel.lambda$5$lambda$4($applyCommandButton, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final void createBackButton$lambda$10$lambda$9(TransformationsPanel this$0, ActionEvent it) {
        this$0.swipeToTreeView();
    }

    public static final /* synthetic */ Unit access$perform(TransformationsPanel $this, TransformationsCommandNode $receiver) {
        return $this.perform($receiver);
    }
}

