/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_ak extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_IQD = "Irak dinaa";
        final Object[][] data = new Object[][] {
            { "GHS", "GH\u20b5" },
            { "IQD", metaValue_IQD },
            { "XOF", "AAS" },
            { "aed", "\u0190mirete Arab Nkab\u0254mu Deram" },
            { "afn", "Afghanfo\u0254 Afghani" },
            { "all", "Albania Lek" },
            { "amd", "Am\u025bnia dram" },
            { "ang", "N\u025bd\u025blande Ant\u025blia guuda" },
            { "aoa", "Angola Kwanza" },
            { "ars", "Ag\u025bntina peso" },
            { "aud", "\u0186strelia D\u0254la" },
            { "awg", "Aruba fl\u0254rin" },
            { "azn", "Az\u025bbagyan manat" },
            { "bam", "B\u0254snia-H\u025bzeg\u0254vina nsesa maake" },
            { "bbd", "Babad\u0254so d\u0254la" },
            { "bdt", "Bangladehye taka" },
            { "bgn", "B\u0254\u0254garia l\u025bv" },
            { "bhd", "Baren Dina" },
            { "bif", "Burundi Frank" },
            { "bmd", "B\u025b\u025bmuda d\u0254la" },
            { "bnd", "Brunei d\u0254la" },
            { "bob", "Bolivia boliviano" },
            { "brl", "Brazil reale" },
            { "bsd", "Bahama d\u0254la" },
            { "btn", "Butanfo\u0254 ngutrum" },
            { "bwp", "Botswana Pula" },
            { "byn", "B\u025blaruhyia ruble" },
            { "bzd", "Belize D\u0254la" },
            { "cad", "Kanada D\u0254la" },
            { "cdf", "Kongo Frank" },
            { "chf", "Swiss Franc" },
            { "clp", "Kyili Peso" },
            { "cnh", "kyaena yuan (offshore)" },
            { "cny", "kyaena yuan" },
            { "cop", "Kolombia peso" },
            { "crc", "K\u0254sta Rika k\u0254l\u0254n" },
            { "cuc", "Kuba nsesa peso" },
            { "cup", "Kuba peso" },
            { "cve", "\u0190skudo" },
            { "czk", "Ky\u025bk koruna" },
            { "djf", "Gyebuti Frank" },
            { "dkk", "Danefo\u0254 krone" },
            { "dop", "D\u0254menika peso" },
            { "dzd", "\u0186lgyeria Dina" },
            { "egp", "Egypt P\u0254n" },
            { "ern", "\u0190retereya Nakfa" },
            { "etb", "Itiopia Bir" },
            { "eur", "Iro" },
            { "fjd", "Figyi D\u0254la" },
            { "fkp", "F\u0254kland Aelande P\u0254n" },
            { "gbp", "Breten P\u0254n" },
            { "gel", "Gy\u0254\u0254gyia lari" },
            { "ghc", "Ghana Sidi (1979\u20132007)" },
            { "ghs", "Ghana Sidi" },
            { "gip", "Gyebrotaa p\u0254n" },
            { "gmd", "Gambia Dalasi" },
            { "gnf", "Gini franke" },
            { "gns", "Gini Frank" },
            { "gtq", "Guatemala kw\u025btsaa" },
            { "gyd", "Gayana d\u0254la" },
            { "hkd", "H\u0254nk\u0254n D\u0254la" },
            { "hnl", "H\u0254ndura l\u025bmpira" },
            { "hrk", "Krohyia kuna" },
            { "htg", "Haiti g\u0254\u0254de" },
            { "huf", "Hangari f\u0254rint" },
            { "idr", "Ind\u0254nihyia rupia" },
            { "ils", "Israel hyekel fofor\u0254" },
            { "inr", "India Rupi" },
            { "iqd", metaValue_IQD },
            { "irr", "Yiranfo\u0254 rial" },
            { "isk", "Icelandfo\u0254 Kr\u00f3na" },
            { "jmd", "Gyameka d\u0254la" },
            { "jod", "Gy\u0254\u0254dan dinaa" },
            { "jpy", "Gyapan Y\u025bn" },
            { "kes", "Kenya Hyelen" },
            { "kgs", "Kagy\u025bstan som" },
            { "khr", "Kambodia riel" },
            { "kmf", "Komoro Frank" },
            { "kpw", "Korea Atifi won" },
            { "krw", "Korea Anaafo\u0254 won" },
            { "kwd", "Kuwait dinaa" },
            { "kyd", "Kayemanfo Aelande d\u0254la" },
            { "kzt", "Kagyastan tenge" },
            { "lak", "Laohyia kip" },
            { "lbp", "L\u025bbanon p\u0254n" },
            { "lkr", "Sri Lankafo\u0254 rupee" },
            { "lrd", "Laeberia D\u0254la" },
            { "lsl", "Lesoto Loti" },
            { "lyd", "Libya Dina" },
            { "mad", "Moroko Diram" },
            { "mdl", "Moldova Leu" },
            { "mga", "Madagasi Frank" },
            { "mkd", "Masidonia denaa" },
            { "mmk", "Mayamaa kyat" },
            { "mnt", "Mongoliafo\u0254 tugrike" },
            { "mop", "Makaw pataka" },
            { "mro", "M\u0254retenia Ouguiya (1973\u20132017)" },
            { "mru", "M\u0254retenia Ouguiya" },
            { "mur", "M\u0254rehye\u0254s Rupi" },
            { "mvr", "Maldivefo\u0254 rufiyaa" },
            { "mwk", "Malawi Kwakya" },
            { "mxn", "M\u025bksiko p\u025bso" },
            { "myr", "Malaahyia ringgit" },
            { "mzm", "Mozambik Metical" },
            { "mzn", "Mozambik m\u025btikaa" },
            { "nad", "Namibia D\u0254la" },
            { "ngn", "Naegyeria Naira" },
            { "nio", "Nikaragua k\u0254\u0254d\u0254ba" },
            { "nok", "N\u0254\u0254wee Krone" },
            { "npr", "Nepalfo\u0254 rupee" },
            { "nzd", "New Zealand D\u0254la" },
            { "omr", "Oman rial" },
            { "pab", "Panama baaboa" },
            { "pen", "P\u025bruvia sol" },
            { "pgk", "Papua New Gini kina" },
            { "php", "Filipine peso" },
            { "pkr", "Pakistanfo\u0254 rupee" },
            { "pln", "P\u0254lihye zloty" },
            { "pyg", "Paragayana guarani" },
            { "qar", "Kata riyaa" },
            { "ron", "Romania Leu" },
            { "rsd", "S\u025b\u025bbia dinaa" },
            { "rub", "R\u0254hyia rubuu" },
            { "rwf", "Rewanda Frank" },
            { "sar", "Saudi Riyal" },
            { "sbd", "Solomon Aeland D\u0254la" },
            { "scr", "Seyhy\u025bls Rupi" },
            { "sdg", "Sudan Dina" },
            { "sdp", "Sudan P\u0254n" },
            { "sek", "Sweden Krona" },
            { "sgd", "Singap\u0254\u0254 d\u0254la" },
            { "shp", "St Helena P\u0254n" },
            { "sle", "Leone" },
            { "sll", "Leone (1964\u20142022)" },
            { "sos", "Somailia Hyelen" },
            { "srd", "Suriname d\u0254la" },
            { "ssp", "Sudan Anaafo\u0254 P\u0254n" },
            { "std", "Sao Tome ne Principe Dobra (1977\u20132017)" },
            { "stn", "Sao Tome ne Principe Dobra" },
            { "syp", "Siria p\u0254n" },
            { "szl", "Lilangeni" },
            { "thb", "Tai bat" },
            { "tjs", "Tagyikistan somoni" },
            { "tmt", "T\u025bkm\u025bstan manat" },
            { "tnd", "Tunisia Dina" },
            { "top", "Tonga Pa\u02bbanga" },
            { "try", "T\u025bki lira" },
            { "ttd", "Trinidad ne Tobago d\u0254la" },
            { "twd", "Taewanfo\u0254 d\u0254la fofor\u0254" },
            { "tzs", "Tanzania Hyelen" },
            { "uah", "Yukren hryvnia" },
            { "ugx", "Uganda Hyelen" },
            { "usd", "Am\u025brika D\u0254la" },
            { "uyu", "Yurugue\u025b peso" },
            { "uzs", "Yusb\u025bkistan som" },
            { "ves", "Venezuelan bol\u00edvar" },
            { "vnd", "Vi\u025btnamfo\u0254 d\u0254n" },
            { "vuv", "Vanuatu vatu" },
            { "wst", "Samoa Tala" },
            { "xaf", "Afrika Mfinimfini Sefa" },
            { "xcd", "Karibine Apuee\u025b d\u0254la" },
            { "xof", "Afrika At\u0254e\u025b Sefa" },
            { "xpf", "CFP Franc" },
            { "xxx", "sika a y\u025bnnim" },
            { "yer", "Y\u025bm\u025bn rial" },
            { "zar", "Afrika Anaafo Rand" },
            { "zmk", "Zambia Kwacha (1968\u20132012)" },
            { "zmw", "Zambia Kwakya" },
            { "zwd", "Zimbabwe D\u0254la" },
        };
        return data;
    }
}
