/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.runfiles;

import com.google.devtools.build.runfiles.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.SoftReference;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class Runfiles {
    private static final String MAIN_REPOSITORY = "";
    private static SoftReference<Preloaded> defaultInstance = new SoftReference<Object>(null);
    private final Preloaded preloadedRunfiles;
    private final String sourceRepository;

    private Runfiles(Preloaded preloadedRunfiles, String sourceRepository) {
        this.preloadedRunfiles = preloadedRunfiles;
        this.sourceRepository = sourceRepository;
    }

    public static synchronized Preloaded preload() throws IOException {
        Preloaded instance = defaultInstance.get();
        if (instance != null) {
            return instance;
        }
        instance = Runfiles.preload(System.getenv());
        defaultInstance = new SoftReference<Preloaded>(instance);
        return instance;
    }

    public static Preloaded preload(Map<String, String> env) throws IOException {
        if (Runfiles.isManifestOnly(env)) {
            return new ManifestBased(Runfiles.getManifestPath(env));
        }
        return new DirectoryBased(Runfiles.getRunfilesDir(env));
    }

    @Deprecated
    public static Runfiles create() throws IOException {
        return Runfiles.preload().withSourceRepository(MAIN_REPOSITORY);
    }

    @Deprecated
    public static Runfiles create(Map<String, String> env) throws IOException {
        return Runfiles.preload(env).withSourceRepository(MAIN_REPOSITORY);
    }

    public String rlocation(String path) {
        Util.checkArgument(path != null);
        Util.checkArgument(!path.isEmpty());
        Util.checkArgument(!path.startsWith("../") && !path.contains("/..") && !path.startsWith("./") && !path.contains("/./") && !path.endsWith("/.") && !path.contains("//"), "path is not normalized: \"%s\"", path);
        Util.checkArgument(!path.startsWith("\\"), "path is absolute without a drive letter: \"%s\"", path);
        if (new File(path).isAbsolute()) {
            return path;
        }
        if (this.sourceRepository == null) {
            return this.preloadedRunfiles.rlocationChecked(path);
        }
        String[] apparentTargetAndRemainder = path.split("/", 2);
        if (apparentTargetAndRemainder.length < 2) {
            return this.preloadedRunfiles.rlocationChecked(path);
        }
        String targetCanonical = this.getCanonicalRepositoryName(apparentTargetAndRemainder[0]);
        return this.preloadedRunfiles.rlocationChecked(targetCanonical + "/" + apparentTargetAndRemainder[1]);
    }

    public Map<String, String> getEnvVars() {
        return this.preloadedRunfiles.getEnvVars();
    }

    String getCanonicalRepositoryName(String apparentRepositoryName) {
        return this.preloadedRunfiles.getRepoMapping().getOrDefault(new Preloaded.RepoMappingKey(this.sourceRepository, apparentRepositoryName), apparentRepositoryName);
    }

    private static boolean isManifestOnly(Map<String, String> env) {
        return "1".equals(env.get("RUNFILES_MANIFEST_ONLY"));
    }

    private static String getManifestPath(Map<String, String> env) throws IOException {
        String value = env.get("RUNFILES_MANIFEST_FILE");
        if (Util.isNullOrEmpty(value)) {
            throw new IOException("Cannot load runfiles manifest: $RUNFILES_MANIFEST_ONLY is 1 but $RUNFILES_MANIFEST_FILE is empty or undefined");
        }
        return value;
    }

    private static String getRunfilesDir(Map<String, String> env) throws IOException {
        String value = env.get("RUNFILES_DIR");
        if (Util.isNullOrEmpty(value)) {
            value = env.get("JAVA_RUNFILES");
        }
        if (Util.isNullOrEmpty(value)) {
            throw new IOException("Cannot find runfiles: $RUNFILES_DIR and $JAVA_RUNFILES are both unset or empty");
        }
        return value;
    }

    private static Map<Preloaded.RepoMappingKey, String> loadRepositoryMapping(String path) throws IOException {
        if (path == null || !new File(path).exists()) {
            return Collections.emptyMap();
        }
        try (BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), StandardCharsets.UTF_8));){
            Map<Preloaded.RepoMappingKey, String> map = Collections.unmodifiableMap(r.lines().filter(line -> !line.isEmpty()).map(line -> {
                String[] split = line.split(",");
                if (split.length != 3) {
                    throw new IllegalArgumentException("Invalid line in repository mapping: '" + line + "'");
                }
                return split;
            }).collect(Collectors.toMap(split -> new Preloaded.RepoMappingKey(split[0], split[1]), split -> split[2])));
            return map;
        }
    }

    static Preloaded createManifestBasedForTesting(String manifestPath) throws IOException {
        return new ManifestBased(manifestPath);
    }

    static Preloaded createDirectoryBasedForTesting(String runfilesDir) throws IOException {
        return new DirectoryBased(runfilesDir);
    }

    public static abstract class Preloaded {
        public final Runfiles withSourceRepository(String sourceRepository) {
            Util.checkArgument(sourceRepository != null);
            return new Runfiles(this, sourceRepository);
        }

        public final Runfiles unmapped() {
            return new Runfiles(this, null);
        }

        protected abstract Map<String, String> getEnvVars();

        protected abstract String rlocationChecked(String var1);

        protected abstract Map<RepoMappingKey, String> getRepoMapping();

        private Preloaded() {
        }

        static class RepoMappingKey {
            public final String sourceRepo;
            public final String targetRepoApparentName;

            public RepoMappingKey(String sourceRepo, String targetRepoApparentName) {
                this.sourceRepo = sourceRepo;
                this.targetRepoApparentName = targetRepoApparentName;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || !(o instanceof RepoMappingKey)) {
                    return false;
                }
                RepoMappingKey that = (RepoMappingKey)o;
                return this.sourceRepo.equals(that.sourceRepo) && this.targetRepoApparentName.equals(that.targetRepoApparentName);
            }

            public int hashCode() {
                return Objects.hash(this.sourceRepo, this.targetRepoApparentName);
            }
        }
    }

    private static final class ManifestBased
    extends Preloaded {
        private final Map<String, String> runfiles;
        private final String manifestPath;
        private final Map<Preloaded.RepoMappingKey, String> repoMapping;

        ManifestBased(String manifestPath) throws IOException {
            Util.checkArgument(manifestPath != null);
            Util.checkArgument(!manifestPath.isEmpty());
            this.manifestPath = manifestPath;
            this.runfiles = ManifestBased.loadRunfiles(manifestPath);
            this.repoMapping = Runfiles.loadRepositoryMapping(this.rlocationChecked("_repo_mapping"));
        }

        @Override
        protected String rlocationChecked(String path) {
            String exactMatch = this.runfiles.get(path);
            if (exactMatch != null) {
                return exactMatch;
            }
            int prefixEnd = path.length();
            while ((prefixEnd = path.lastIndexOf(47, prefixEnd - 1)) != -1) {
                String prefixMatch = this.runfiles.get(path.substring(0, prefixEnd));
                if (prefixMatch == null) continue;
                return prefixMatch + '/' + path.substring(prefixEnd + 1);
            }
            return null;
        }

        @Override
        protected Map<String, String> getEnvVars() {
            HashMap<String, String> result = new HashMap<String, String>(4);
            result.put("RUNFILES_MANIFEST_ONLY", "1");
            result.put("RUNFILES_MANIFEST_FILE", this.manifestPath);
            String runfilesDir = ManifestBased.findRunfilesDir(this.manifestPath);
            result.put("RUNFILES_DIR", runfilesDir);
            result.put("JAVA_RUNFILES", runfilesDir);
            return result;
        }

        @Override
        protected Map<Preloaded.RepoMappingKey, String> getRepoMapping() {
            return this.repoMapping;
        }

        private static Map<String, String> loadRunfiles(String path) throws IOException {
            HashMap<String, String> result = new HashMap<String, String>();
            try (BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), StandardCharsets.UTF_8));){
                String line = null;
                while ((line = r.readLine()) != null) {
                    int index = line.indexOf(32);
                    String runfile = index == -1 ? line : line.substring(0, index);
                    String realPath = index == -1 ? line : line.substring(index + 1);
                    result.put(runfile, realPath);
                }
            }
            return Collections.unmodifiableMap(result);
        }

        private static String findRunfilesDir(String manifest) {
            String path;
            if ((manifest.endsWith("/MANIFEST") || manifest.endsWith("\\MANIFEST") || manifest.endsWith(".runfiles_manifest")) && new File(path = manifest.substring(0, manifest.length() - 9)).isDirectory()) {
                return path;
            }
            return Runfiles.MAIN_REPOSITORY;
        }
    }

    private static final class DirectoryBased
    extends Preloaded {
        private final String runfilesRoot;
        private final Map<Preloaded.RepoMappingKey, String> repoMapping;

        DirectoryBased(String runfilesDir) throws IOException {
            Util.checkArgument(!Util.isNullOrEmpty(runfilesDir));
            Util.checkArgument(new File(runfilesDir).isDirectory());
            this.runfilesRoot = runfilesDir;
            this.repoMapping = Runfiles.loadRepositoryMapping(this.rlocationChecked("_repo_mapping"));
        }

        @Override
        protected String rlocationChecked(String path) {
            return this.runfilesRoot + "/" + path;
        }

        @Override
        protected Map<Preloaded.RepoMappingKey, String> getRepoMapping() {
            return this.repoMapping;
        }

        @Override
        protected Map<String, String> getEnvVars() {
            HashMap<String, String> result = new HashMap<String, String>(2);
            result.put("RUNFILES_DIR", this.runfilesRoot);
            result.put("JAVA_RUNFILES", this.runfilesRoot);
            return result;
        }
    }
}

