// Copyright 2023-2024 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.4
// 	protoc        (unknown)
// source: buf/validate/conformance/harness/harness.proto

//go:build protoopaque

package harness

import (
	validate "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	descriptorpb "google.golang.org/protobuf/types/descriptorpb"
	anypb "google.golang.org/protobuf/types/known/anypb"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// TestConformanceRequest is the request for Conformance Tests.
// The FileDescriptorSet is the FileDescriptorSet to test against.
// The cases map is a map of case name to the Any message that represents the case.
type TestConformanceRequest struct {
	state            protoimpl.MessageState          `protogen:"opaque.v1"`
	xxx_hidden_Fdset *descriptorpb.FileDescriptorSet `protobuf:"bytes,2,opt,name=fdset,proto3"`
	xxx_hidden_Cases map[string]*anypb.Any           `protobuf:"bytes,3,rep,name=cases,proto3" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *TestConformanceRequest) Reset() {
	*x = TestConformanceRequest{}
	mi := &file_buf_validate_conformance_harness_harness_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TestConformanceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestConformanceRequest) ProtoMessage() {}

func (x *TestConformanceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_conformance_harness_harness_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *TestConformanceRequest) GetFdset() *descriptorpb.FileDescriptorSet {
	if x != nil {
		return x.xxx_hidden_Fdset
	}
	return nil
}

func (x *TestConformanceRequest) GetCases() map[string]*anypb.Any {
	if x != nil {
		return x.xxx_hidden_Cases
	}
	return nil
}

func (x *TestConformanceRequest) SetFdset(v *descriptorpb.FileDescriptorSet) {
	x.xxx_hidden_Fdset = v
}

func (x *TestConformanceRequest) SetCases(v map[string]*anypb.Any) {
	x.xxx_hidden_Cases = v
}

func (x *TestConformanceRequest) HasFdset() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Fdset != nil
}

func (x *TestConformanceRequest) ClearFdset() {
	x.xxx_hidden_Fdset = nil
}

type TestConformanceRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Fdset *descriptorpb.FileDescriptorSet
	Cases map[string]*anypb.Any
}

func (b0 TestConformanceRequest_builder) Build() *TestConformanceRequest {
	m0 := &TestConformanceRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Fdset = b.Fdset
	x.xxx_hidden_Cases = b.Cases
	return m0
}

// TestConformanceResponse is the response for Conformance Tests.
// The results map is a map of case name to the TestResult.
type TestConformanceResponse struct {
	state              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Results map[string]*TestResult `protobuf:"bytes,1,rep,name=results,proto3" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *TestConformanceResponse) Reset() {
	*x = TestConformanceResponse{}
	mi := &file_buf_validate_conformance_harness_harness_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TestConformanceResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestConformanceResponse) ProtoMessage() {}

func (x *TestConformanceResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_conformance_harness_harness_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *TestConformanceResponse) GetResults() map[string]*TestResult {
	if x != nil {
		return x.xxx_hidden_Results
	}
	return nil
}

func (x *TestConformanceResponse) SetResults(v map[string]*TestResult) {
	x.xxx_hidden_Results = v
}

type TestConformanceResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Results map[string]*TestResult
}

func (b0 TestConformanceResponse_builder) Build() *TestConformanceResponse {
	m0 := &TestConformanceResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Results = b.Results
	return m0
}

// TestResult is the result of a single test. Only one of the fields will be set.
type TestResult struct {
	state             protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Result isTestResult_Result    `protobuf_oneof:"result"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *TestResult) Reset() {
	*x = TestResult{}
	mi := &file_buf_validate_conformance_harness_harness_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TestResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestResult) ProtoMessage() {}

func (x *TestResult) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_conformance_harness_harness_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *TestResult) GetSuccess() bool {
	if x != nil {
		if x, ok := x.xxx_hidden_Result.(*testResult_Success); ok {
			return x.Success
		}
	}
	return false
}

func (x *TestResult) GetValidationError() *validate.Violations {
	if x != nil {
		if x, ok := x.xxx_hidden_Result.(*testResult_ValidationError); ok {
			return x.ValidationError
		}
	}
	return nil
}

func (x *TestResult) GetCompilationError() string {
	if x != nil {
		if x, ok := x.xxx_hidden_Result.(*testResult_CompilationError); ok {
			return x.CompilationError
		}
	}
	return ""
}

func (x *TestResult) GetRuntimeError() string {
	if x != nil {
		if x, ok := x.xxx_hidden_Result.(*testResult_RuntimeError); ok {
			return x.RuntimeError
		}
	}
	return ""
}

func (x *TestResult) GetUnexpectedError() string {
	if x != nil {
		if x, ok := x.xxx_hidden_Result.(*testResult_UnexpectedError); ok {
			return x.UnexpectedError
		}
	}
	return ""
}

func (x *TestResult) SetSuccess(v bool) {
	x.xxx_hidden_Result = &testResult_Success{v}
}

func (x *TestResult) SetValidationError(v *validate.Violations) {
	if v == nil {
		x.xxx_hidden_Result = nil
		return
	}
	x.xxx_hidden_Result = &testResult_ValidationError{v}
}

func (x *TestResult) SetCompilationError(v string) {
	x.xxx_hidden_Result = &testResult_CompilationError{v}
}

func (x *TestResult) SetRuntimeError(v string) {
	x.xxx_hidden_Result = &testResult_RuntimeError{v}
}

func (x *TestResult) SetUnexpectedError(v string) {
	x.xxx_hidden_Result = &testResult_UnexpectedError{v}
}

func (x *TestResult) HasResult() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Result != nil
}

func (x *TestResult) HasSuccess() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Result.(*testResult_Success)
	return ok
}

func (x *TestResult) HasValidationError() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Result.(*testResult_ValidationError)
	return ok
}

func (x *TestResult) HasCompilationError() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Result.(*testResult_CompilationError)
	return ok
}

func (x *TestResult) HasRuntimeError() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Result.(*testResult_RuntimeError)
	return ok
}

func (x *TestResult) HasUnexpectedError() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Result.(*testResult_UnexpectedError)
	return ok
}

func (x *TestResult) ClearResult() {
	x.xxx_hidden_Result = nil
}

func (x *TestResult) ClearSuccess() {
	if _, ok := x.xxx_hidden_Result.(*testResult_Success); ok {
		x.xxx_hidden_Result = nil
	}
}

func (x *TestResult) ClearValidationError() {
	if _, ok := x.xxx_hidden_Result.(*testResult_ValidationError); ok {
		x.xxx_hidden_Result = nil
	}
}

func (x *TestResult) ClearCompilationError() {
	if _, ok := x.xxx_hidden_Result.(*testResult_CompilationError); ok {
		x.xxx_hidden_Result = nil
	}
}

func (x *TestResult) ClearRuntimeError() {
	if _, ok := x.xxx_hidden_Result.(*testResult_RuntimeError); ok {
		x.xxx_hidden_Result = nil
	}
}

func (x *TestResult) ClearUnexpectedError() {
	if _, ok := x.xxx_hidden_Result.(*testResult_UnexpectedError); ok {
		x.xxx_hidden_Result = nil
	}
}

const TestResult_Result_not_set_case case_TestResult_Result = 0
const TestResult_Success_case case_TestResult_Result = 1
const TestResult_ValidationError_case case_TestResult_Result = 2
const TestResult_CompilationError_case case_TestResult_Result = 3
const TestResult_RuntimeError_case case_TestResult_Result = 4
const TestResult_UnexpectedError_case case_TestResult_Result = 5

func (x *TestResult) WhichResult() case_TestResult_Result {
	if x == nil {
		return TestResult_Result_not_set_case
	}
	switch x.xxx_hidden_Result.(type) {
	case *testResult_Success:
		return TestResult_Success_case
	case *testResult_ValidationError:
		return TestResult_ValidationError_case
	case *testResult_CompilationError:
		return TestResult_CompilationError_case
	case *testResult_RuntimeError:
		return TestResult_RuntimeError_case
	case *testResult_UnexpectedError:
		return TestResult_UnexpectedError_case
	default:
		return TestResult_Result_not_set_case
	}
}

type TestResult_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Fields of oneof xxx_hidden_Result:
	// success is true if the test succeeded.
	Success *bool
	// validation_error is the error if the test failed due to validation errors.
	ValidationError *validate.Violations
	// compilation_error is the error if the test failed due to compilation errors.
	CompilationError *string
	// runtime_error is the error if the test failed due to runtime errors.
	RuntimeError *string
	// unexpected_error is any other error that may have occurred.
	UnexpectedError *string
	// -- end of xxx_hidden_Result
}

func (b0 TestResult_builder) Build() *TestResult {
	m0 := &TestResult{}
	b, x := &b0, m0
	_, _ = b, x
	if b.Success != nil {
		x.xxx_hidden_Result = &testResult_Success{*b.Success}
	}
	if b.ValidationError != nil {
		x.xxx_hidden_Result = &testResult_ValidationError{b.ValidationError}
	}
	if b.CompilationError != nil {
		x.xxx_hidden_Result = &testResult_CompilationError{*b.CompilationError}
	}
	if b.RuntimeError != nil {
		x.xxx_hidden_Result = &testResult_RuntimeError{*b.RuntimeError}
	}
	if b.UnexpectedError != nil {
		x.xxx_hidden_Result = &testResult_UnexpectedError{*b.UnexpectedError}
	}
	return m0
}

type case_TestResult_Result protoreflect.FieldNumber

func (x case_TestResult_Result) String() string {
	md := file_buf_validate_conformance_harness_harness_proto_msgTypes[2].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isTestResult_Result interface {
	isTestResult_Result()
}

type testResult_Success struct {
	// success is true if the test succeeded.
	Success bool `protobuf:"varint,1,opt,name=success,proto3,oneof"`
}

type testResult_ValidationError struct {
	// validation_error is the error if the test failed due to validation errors.
	ValidationError *validate.Violations `protobuf:"bytes,2,opt,name=validation_error,json=validationError,proto3,oneof"`
}

type testResult_CompilationError struct {
	// compilation_error is the error if the test failed due to compilation errors.
	CompilationError string `protobuf:"bytes,3,opt,name=compilation_error,json=compilationError,proto3,oneof"`
}

type testResult_RuntimeError struct {
	// runtime_error is the error if the test failed due to runtime errors.
	RuntimeError string `protobuf:"bytes,4,opt,name=runtime_error,json=runtimeError,proto3,oneof"`
}

type testResult_UnexpectedError struct {
	// unexpected_error is any other error that may have occurred.
	UnexpectedError string `protobuf:"bytes,5,opt,name=unexpected_error,json=unexpectedError,proto3,oneof"`
}

func (*testResult_Success) isTestResult_Result() {}

func (*testResult_ValidationError) isTestResult_Result() {}

func (*testResult_CompilationError) isTestResult_Result() {}

func (*testResult_RuntimeError) isTestResult_Result() {}

func (*testResult_UnexpectedError) isTestResult_Result() {}

var File_buf_validate_conformance_harness_harness_proto protoreflect.FileDescriptor

var file_buf_validate_conformance_harness_harness_proto_rawDesc = string([]byte{
	0x0a, 0x2e, 0x62, 0x75, 0x66, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2f, 0x63,
	0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x2f, 0x68, 0x61, 0x72, 0x6e, 0x65,
	0x73, 0x73, 0x2f, 0x68, 0x61, 0x72, 0x6e, 0x65, 0x73, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x20, 0x62, 0x75, 0x66, 0x2e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x68, 0x61, 0x72, 0x6e, 0x65,
	0x73, 0x73, 0x1a, 0x1b, 0x62, 0x75, 0x66, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x61, 0x6e, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xfd, 0x01, 0x0a,
	0x16, 0x54, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x38, 0x0a, 0x05, 0x66, 0x64, 0x73, 0x65, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x44, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x74, 0x52, 0x05, 0x66, 0x64, 0x73, 0x65,
	0x74, 0x12, 0x59, 0x0a, 0x05, 0x63, 0x61, 0x73, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x43, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x68, 0x61, 0x72, 0x6e,
	0x65, 0x73, 0x73, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x43, 0x61, 0x73, 0x65, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x05, 0x63, 0x61, 0x73, 0x65, 0x73, 0x1a, 0x4e, 0x0a, 0x0a,
	0x43, 0x61, 0x73, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2a, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e,
	0x79, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xe5, 0x01, 0x0a,
	0x17, 0x54, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x60, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x6e, 0x63, 0x65, 0x2e, 0x68, 0x61, 0x72, 0x6e, 0x65, 0x73, 0x73, 0x2e, 0x54, 0x65, 0x73,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x1a, 0x68, 0x0a, 0x0c, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x42, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x68, 0x61, 0x72, 0x6e, 0x65, 0x73, 0x73, 0x2e, 0x54,
	0x65, 0x73, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x22, 0xfc, 0x01, 0x0a, 0x0a, 0x54, 0x65, 0x73, 0x74, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x12, 0x1a, 0x0a, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12,
	0x45, 0x0a, 0x10, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x0f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x2d, 0x0a, 0x11, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x00, 0x52, 0x10, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x25, 0x0a, 0x0d, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0c,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x2b, 0x0a, 0x10,
	0x75, 0x6e, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0f, 0x75, 0x6e, 0x65, 0x78, 0x70, 0x65,
	0x63, 0x74, 0x65, 0x64, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x42, 0x08, 0x0a, 0x06, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x42, 0xac, 0x02, 0x0a, 0x24, 0x63, 0x6f, 0x6d, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x6e, 0x63, 0x65, 0x2e, 0x68, 0x61, 0x72, 0x6e, 0x65, 0x73, 0x73, 0x42, 0x0c, 0x48, 0x61,
	0x72, 0x6e, 0x65, 0x73, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x52, 0x67, 0x69,
	0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x62, 0x75, 0x66, 0x62, 0x75, 0x69, 0x6c,
	0x64, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2d,
	0x67, 0x6f, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2f, 0x67, 0x65, 0x6e, 0x2f,
	0x62, 0x75, 0x66, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2f, 0x63, 0x6f, 0x6e,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x2f, 0x68, 0x61, 0x72, 0x6e, 0x65, 0x73, 0x73,
	0xa2, 0x02, 0x04, 0x42, 0x56, 0x43, 0x48, 0xaa, 0x02, 0x20, 0x42, 0x75, 0x66, 0x2e, 0x56, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e,
	0x63, 0x65, 0x2e, 0x48, 0x61, 0x72, 0x6e, 0x65, 0x73, 0x73, 0xca, 0x02, 0x20, 0x42, 0x75, 0x66,
	0x5c, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5c, 0x43, 0x6f, 0x6e, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x6e, 0x63, 0x65, 0x5c, 0x48, 0x61, 0x72, 0x6e, 0x65, 0x73, 0x73, 0xe2, 0x02, 0x2c,
	0x42, 0x75, 0x66, 0x5c, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5c, 0x43, 0x6f, 0x6e,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x5c, 0x48, 0x61, 0x72, 0x6e, 0x65, 0x73, 0x73,
	0x5c, 0x47, 0x50, 0x42, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xea, 0x02, 0x23, 0x42,
	0x75, 0x66, 0x3a, 0x3a, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x3a, 0x3a, 0x43, 0x6f,
	0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x3a, 0x3a, 0x48, 0x61, 0x72, 0x6e, 0x65,
	0x73, 0x73, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
})

var file_buf_validate_conformance_harness_harness_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_buf_validate_conformance_harness_harness_proto_goTypes = []any{
	(*TestConformanceRequest)(nil),         // 0: buf.validate.conformance.harness.TestConformanceRequest
	(*TestConformanceResponse)(nil),        // 1: buf.validate.conformance.harness.TestConformanceResponse
	(*TestResult)(nil),                     // 2: buf.validate.conformance.harness.TestResult
	nil,                                    // 3: buf.validate.conformance.harness.TestConformanceRequest.CasesEntry
	nil,                                    // 4: buf.validate.conformance.harness.TestConformanceResponse.ResultsEntry
	(*descriptorpb.FileDescriptorSet)(nil), // 5: google.protobuf.FileDescriptorSet
	(*validate.Violations)(nil),            // 6: buf.validate.Violations
	(*anypb.Any)(nil),                      // 7: google.protobuf.Any
}
var file_buf_validate_conformance_harness_harness_proto_depIdxs = []int32{
	5, // 0: buf.validate.conformance.harness.TestConformanceRequest.fdset:type_name -> google.protobuf.FileDescriptorSet
	3, // 1: buf.validate.conformance.harness.TestConformanceRequest.cases:type_name -> buf.validate.conformance.harness.TestConformanceRequest.CasesEntry
	4, // 2: buf.validate.conformance.harness.TestConformanceResponse.results:type_name -> buf.validate.conformance.harness.TestConformanceResponse.ResultsEntry
	6, // 3: buf.validate.conformance.harness.TestResult.validation_error:type_name -> buf.validate.Violations
	7, // 4: buf.validate.conformance.harness.TestConformanceRequest.CasesEntry.value:type_name -> google.protobuf.Any
	2, // 5: buf.validate.conformance.harness.TestConformanceResponse.ResultsEntry.value:type_name -> buf.validate.conformance.harness.TestResult
	6, // [6:6] is the sub-list for method output_type
	6, // [6:6] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() { file_buf_validate_conformance_harness_harness_proto_init() }
func file_buf_validate_conformance_harness_harness_proto_init() {
	if File_buf_validate_conformance_harness_harness_proto != nil {
		return
	}
	file_buf_validate_conformance_harness_harness_proto_msgTypes[2].OneofWrappers = []any{
		(*testResult_Success)(nil),
		(*testResult_ValidationError)(nil),
		(*testResult_CompilationError)(nil),
		(*testResult_RuntimeError)(nil),
		(*testResult_UnexpectedError)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_validate_conformance_harness_harness_proto_rawDesc), len(file_buf_validate_conformance_harness_harness_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_buf_validate_conformance_harness_harness_proto_goTypes,
		DependencyIndexes: file_buf_validate_conformance_harness_harness_proto_depIdxs,
		MessageInfos:      file_buf_validate_conformance_harness_harness_proto_msgTypes,
	}.Build()
	File_buf_validate_conformance_harness_harness_proto = out.File
	file_buf_validate_conformance_harness_harness_proto_goTypes = nil
	file_buf_validate_conformance_harness_harness_proto_depIdxs = nil
}
