/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.cert.CRLException;
import java.security.cert.CRLSelector;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertStoreSpi;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.security.action.GetIntegerAction;
import sun.security.provider.certpath.Builder;
import sun.security.provider.certpath.CertStoreHelper;
import sun.security.provider.certpath.PKIX;
import sun.security.util.Cache;
import sun.security.util.Debug;
import sun.security.util.SecurityProperties;
import sun.security.x509.AccessDescription;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.URIName;

class URICertStore
extends CertStoreSpi {
    private static final Debug debug = Debug.getInstance("certpath");
    private static final int CHECK_INTERVAL = 30000;
    private static final int CACHE_SIZE = 185;
    private final CertificateFactory factory;
    private Collection<X509Certificate> certs = Collections.emptySet();
    private X509CRL crl;
    private long lastChecked;
    private long lastModified;
    private URI uri;
    private boolean ldap = false;
    private CertStoreHelper ldapHelper;
    private CertStore ldapCertStore;
    private String ldapPath;
    private static final int DEFAULT_CRL_CONNECT_TIMEOUT = 15000;
    private static final int CRL_CONNECT_TIMEOUT = URICertStore.initializeTimeout();
    private static Set<URI> CA_ISS_URI_FILTERS = null;
    private static final boolean CA_ISS_ALLOW_ANY;
    private static final Cache<URICertStoreParameters, CertStore> certStoreCache;

    private static int initializeTimeout() {
        Integer n = AccessController.doPrivileged(new GetIntegerAction("com.sun.security.crl.timeout"));
        if (n == null || n < 0) {
            return 15000;
        }
        return n * 1000;
    }

    private static void addCaIssUriFilters(String[] stringArray) {
        for (String string : stringArray) {
            if (string == null || string.isEmpty()) continue;
            try {
                URI uRI = new URI(string).normalize();
                if (!uRI.isAbsolute() || uRI.isOpaque()) {
                    if (debug == null) continue;
                    debug.println("allowedAIALocations: Skipping non-absolute or opaque URI " + uRI);
                    continue;
                }
                if (uRI.getHost() == null) {
                    if (debug == null) continue;
                    debug.println("allowedAIALocations: Skipping URI rule with no hostname or address: " + uRI);
                    continue;
                }
                AllowedScheme allowedScheme = AllowedScheme.nameOf(uRI.getScheme());
                if (allowedScheme != null) {
                    if (allowedScheme == AllowedScheme.LDAP || allowedScheme == AllowedScheme.LDAPS) {
                        try {
                            new X500Principal(uRI.getPath().replaceFirst("^/+", ""));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            if (debug == null) continue;
                            debug.println("allowedAIALocations: Skipping LDAP rule: " + illegalArgumentException);
                            continue;
                        }
                    }
                    if (uRI.getQuery() != null && debug != null) {
                        debug.println("allowedAIALocations: Rule will ignore non-null query");
                    }
                    if (uRI.getFragment() != null && debug != null) {
                        debug.println("allowedAIALocations: Rule will ignore non-null fragment");
                    }
                    CA_ISS_URI_FILTERS.add(uRI);
                    if (debug == null) continue;
                    debug.println("allowedAIALocations: Added " + uRI + " to URI filters");
                    continue;
                }
                if (debug == null) continue;
                debug.println("allowedAIALocations: Disallowed filter URI scheme: " + uRI.getScheme());
            }
            catch (URISyntaxException uRISyntaxException) {
                if (debug == null) continue;
                debug.println("allowedAIALocations: Skipping filter URI entry " + string + ": parse failure at index " + uRISyntaxException.getIndex());
            }
        }
    }

    URICertStore(CertStoreParameters certStoreParameters) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        super(certStoreParameters);
        if (!(certStoreParameters instanceof URICertStoreParameters)) {
            throw new InvalidAlgorithmParameterException("params must be instanceof URICertStoreParameters");
        }
        this.uri = ((URICertStoreParameters)certStoreParameters).uri;
        if (this.uri.getScheme().toLowerCase(Locale.ENGLISH).equals("ldap")) {
            this.ldap = true;
            this.ldapHelper = CertStoreHelper.getInstance("LDAP");
            this.ldapCertStore = this.ldapHelper.getCertStore(this.uri);
            this.ldapPath = this.uri.getPath();
            if (this.ldapPath.charAt(0) == '/') {
                this.ldapPath = this.ldapPath.substring(1);
            }
        }
        try {
            this.factory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            throw new RuntimeException();
        }
    }

    static synchronized CertStore getInstance(URICertStoreParameters uRICertStoreParameters) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        CertStore certStore;
        if (debug != null) {
            debug.println("CertStore URI:" + uRICertStoreParameters.uri);
        }
        if ((certStore = certStoreCache.get(uRICertStoreParameters)) == null) {
            certStore = new UCS(new URICertStore(uRICertStoreParameters), null, "URI", uRICertStoreParameters);
            certStoreCache.put(uRICertStoreParameters, certStore);
        } else if (debug != null) {
            debug.println("URICertStore.getInstance: cache hit");
        }
        return certStore;
    }

    static CertStore getInstance(AccessDescription accessDescription) {
        if (!accessDescription.getAccessMethod().equals((Object)AccessDescription.Ad_CAISSUERS_Id)) {
            return null;
        }
        GeneralNameInterface generalNameInterface = accessDescription.getAccessLocation().getName();
        if (!(generalNameInterface instanceof URIName)) {
            return null;
        }
        URI uRI = ((URIName)generalNameInterface).getURI();
        if (Builder.USE_AIA && !CA_ISS_ALLOW_ANY) {
            URI uRI3 = uRI.normalize();
            AllowedScheme allowedScheme = AllowedScheme.nameOf(uRI3.getScheme());
            if (allowedScheme == null) {
                if (debug != null) {
                    debug.println("allowedAIALocations: No matching ruleset for scheme " + uRI3.getScheme());
                }
                return null;
            }
            if (CA_ISS_URI_FILTERS.stream().noneMatch(uRI2 -> allowedScheme.ruleMatcher.matchRule((URI)uRI2, uRI3))) {
                if (debug != null) {
                    debug.println("allowedAIALocations: Warning - The caIssuer URI " + uRI3 + " in the AuthorityInfoAccess extension is denied access. Use the com.sun.security.allowedAIALocations security/system property to allow access.");
                }
                return null;
            }
        }
        try {
            return URICertStore.getInstance(new URICertStoreParameters(uRI));
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.println("exception creating CertStore: " + exception);
                exception.printStackTrace();
            }
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Collection<X509Certificate> engineGetCertificates(CertSelector certSelector) throws CertStoreException {
        if (this.ldap) {
            X509CertSelector x509CertSelector = (X509CertSelector)certSelector;
            try {
                x509CertSelector = this.ldapHelper.wrap(x509CertSelector, x509CertSelector.getSubject(), this.ldapPath);
                return this.ldapCertStore.getCertificates(x509CertSelector);
            }
            catch (IOException iOException) {
                throw new CertStoreException(iOException);
            }
        }
        long l = System.currentTimeMillis();
        if (l - this.lastChecked < 30000L) {
            if (debug == null) return URICertStore.getMatchingCerts(this.certs, certSelector);
            debug.println("Returning certificates from cache");
            return URICertStore.getMatchingCerts(this.certs, certSelector);
        }
        this.lastChecked = l;
        try {
            URLConnection uRLConnection = this.uri.toURL().openConnection();
            if (this.lastModified != 0L) {
                uRLConnection.setIfModifiedSince(this.lastModified);
            }
            long l2 = this.lastModified;
            try (InputStream inputStream = uRLConnection.getInputStream();){
                this.lastModified = uRLConnection.getLastModified();
                if (l2 != 0L) {
                    HttpURLConnection httpURLConnection;
                    if (l2 == this.lastModified) {
                        if (debug != null) {
                            debug.println("Not modified, using cached copy");
                        }
                        Collection<X509Certificate> collection = URICertStore.getMatchingCerts(this.certs, certSelector);
                        return collection;
                    }
                    if (uRLConnection instanceof HttpURLConnection && (httpURLConnection = (HttpURLConnection)uRLConnection).getResponseCode() == 304) {
                        if (debug != null) {
                            debug.println("Not modified, using cached copy");
                        }
                        Collection<X509Certificate> collection = URICertStore.getMatchingCerts(this.certs, certSelector);
                        return collection;
                    }
                }
                if (debug != null) {
                    debug.println("Downloading new certificates...");
                }
                this.certs = this.factory.generateCertificates(inputStream);
                return URICertStore.getMatchingCerts(this.certs, certSelector);
            }
        }
        catch (IOException | CertificateException exception) {
            if (debug != null) {
                debug.println("Exception fetching certificates:");
                exception.printStackTrace();
            }
            this.lastModified = 0L;
            this.certs = Collections.emptySet();
            return this.certs;
        }
    }

    private static Collection<X509Certificate> getMatchingCerts(Collection<X509Certificate> collection, CertSelector certSelector) {
        if (certSelector == null) {
            return collection;
        }
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>(collection.size());
        for (X509Certificate x509Certificate : collection) {
            if (!certSelector.match(x509Certificate)) continue;
            arrayList.add(x509Certificate);
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Collection<X509CRL> engineGetCRLs(CRLSelector cRLSelector) throws CertStoreException {
        if (this.ldap) {
            X509CRLSelector x509CRLSelector = (X509CRLSelector)cRLSelector;
            try {
                x509CRLSelector = this.ldapHelper.wrap(x509CRLSelector, null, this.ldapPath);
            }
            catch (IOException iOException) {
                throw new CertStoreException(iOException);
            }
            try {
                return this.ldapCertStore.getCRLs(x509CRLSelector);
            }
            catch (CertStoreException certStoreException) {
                throw new PKIX.CertStoreTypeException("LDAP", certStoreException);
            }
        }
        long l = System.currentTimeMillis();
        if (l - this.lastChecked < 30000L) {
            if (debug == null) return URICertStore.getMatchingCRLs(this.crl, cRLSelector);
            debug.println("Returning CRL from cache");
            return URICertStore.getMatchingCRLs(this.crl, cRLSelector);
        }
        this.lastChecked = l;
        try {
            URLConnection uRLConnection = this.uri.toURL().openConnection();
            if (this.lastModified != 0L) {
                uRLConnection.setIfModifiedSince(this.lastModified);
            }
            long l2 = this.lastModified;
            uRLConnection.setConnectTimeout(CRL_CONNECT_TIMEOUT);
            try (InputStream inputStream = uRLConnection.getInputStream();){
                this.lastModified = uRLConnection.getLastModified();
                if (l2 != 0L) {
                    HttpURLConnection httpURLConnection;
                    if (l2 == this.lastModified) {
                        if (debug != null) {
                            debug.println("Not modified, using cached copy");
                        }
                        Collection<X509CRL> collection = URICertStore.getMatchingCRLs(this.crl, cRLSelector);
                        return collection;
                    }
                    if (uRLConnection instanceof HttpURLConnection && (httpURLConnection = (HttpURLConnection)uRLConnection).getResponseCode() == 304) {
                        if (debug != null) {
                            debug.println("Not modified, using cached copy");
                        }
                        Collection<X509CRL> collection = URICertStore.getMatchingCRLs(this.crl, cRLSelector);
                        return collection;
                    }
                }
                if (debug != null) {
                    debug.println("Downloading new CRL...");
                }
                this.crl = (X509CRL)this.factory.generateCRL(inputStream);
                return URICertStore.getMatchingCRLs(this.crl, cRLSelector);
            }
        }
        catch (IOException | CRLException exception) {
            if (debug != null) {
                debug.println("Exception fetching CRL:");
                exception.printStackTrace();
            }
            this.lastModified = 0L;
            this.crl = null;
            throw new PKIX.CertStoreTypeException("URI", new CertStoreException(exception));
        }
    }

    private static Collection<X509CRL> getMatchingCRLs(X509CRL x509CRL, CRLSelector cRLSelector) {
        if (cRLSelector == null || x509CRL != null && cRLSelector.match(x509CRL)) {
            return Collections.singletonList(x509CRL);
        }
        return Collections.emptyList();
    }

    static {
        boolean bl = false;
        try {
            if (Builder.USE_AIA) {
                CA_ISS_URI_FILTERS = new LinkedHashSet<URI>();
                String string = SecurityProperties.privilegedGetOverridable("com.sun.security.allowedAIALocations");
                String string2 = string = string != null ? string.trim() : "";
                if (string.equalsIgnoreCase("any")) {
                    bl = true;
                    if (debug != null) {
                        debug.println("allowedAIALocations: Warning: Allow-All URI filtering enabled!");
                    }
                } else {
                    if (!string.isEmpty()) {
                        String[] stringArray = string.trim().split("\\s+");
                        URICertStore.addCaIssUriFilters(stringArray);
                    }
                    if (CA_ISS_URI_FILTERS.isEmpty() && debug != null) {
                        debug.println("allowedAIALocations: Warning: No valid filters found. Deny-all URI filtering is active.");
                    }
                }
            }
        }
        finally {
            CA_ISS_ALLOW_ANY = bl;
        }
        certStoreCache = Cache.newSoftMemoryCache(185);
    }

    static class LdapRuleMatcher
    extends URIRuleMatcher {
        static final LdapRuleMatcher LDAP = new LdapRuleMatcher(389);
        static final LdapRuleMatcher LDAPS = new LdapRuleMatcher(636);

        private LdapRuleMatcher(int n) {
            super(n);
        }

        @Override
        boolean matchRule(URI uRI, URI uRI2) {
            if (!this.schemeHostPortCheck(uRI, uRI2)) {
                return false;
            }
            try {
                X500Principal x500Principal = new X500Principal(uRI.getPath().replaceFirst("^/+", ""));
                X500Principal x500Principal2 = new X500Principal(uRI2.getPath().replaceFirst("^/+", ""));
                if (!x500Principal.equals(x500Principal2)) {
                    if (debug != null) {
                        debug.println("allowedAIALocations: Match failed: Base DN mismatch (" + x500Principal + " vs " + x500Principal2 + ")");
                    }
                    return false;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (debug != null) {
                    debug.println("allowedAIALocations: Match failed on DN: " + illegalArgumentException);
                }
                return false;
            }
            return true;
        }
    }

    static class HttpFtpRuleMatcher
    extends URIRuleMatcher {
        static final HttpFtpRuleMatcher HTTP = new HttpFtpRuleMatcher(80);
        static final HttpFtpRuleMatcher HTTPS = new HttpFtpRuleMatcher(443);
        static final HttpFtpRuleMatcher FTP = new HttpFtpRuleMatcher(21);

        private HttpFtpRuleMatcher(int n) {
            super(n);
        }

        @Override
        boolean matchRule(URI uRI, URI uRI2) {
            if (!this.schemeHostPortCheck(uRI, uRI2)) {
                return false;
            }
            if (!HttpFtpRuleMatcher.isRootOf(uRI, uRI2)) {
                if (debug != null) {
                    debug.println("allowedAIALocations: Match failed: AIA URI is not within the rule's path hierarchy.");
                }
                return false;
            }
            return true;
        }

        private static boolean isRootOf(URI uRI, URI uRI2) {
            String string2 = Optional.of(uRI.getPath()).filter(string -> !string.isEmpty()).orElse("/");
            String string3 = Optional.of(uRI2.getPath()).filter(string -> !string.isEmpty()).orElse("/");
            return string2.endsWith("/") ? string3.startsWith(string2) : string3.equals(string2);
        }
    }

    static abstract class URIRuleMatcher {
        protected final int wellKnownPort;

        protected URIRuleMatcher(int n) {
            this.wellKnownPort = n;
        }

        boolean schemeHostPortCheck(URI uRI, URI uRI2) {
            if (!uRI.getScheme().equalsIgnoreCase(uRI2.getScheme())) {
                return false;
            }
            if (!uRI.getHost().equalsIgnoreCase(uRI2.getHost())) {
                return false;
            }
            try {
                int n;
                int n2 = uRI.getPort() == -1 ? this.wellKnownPort : uRI.getPort();
                int n3 = n = uRI2.getPort() == -1 ? this.wellKnownPort : uRI2.getPort();
                if (n2 != n) {
                    return false;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            return true;
        }

        abstract boolean matchRule(URI var1, URI var2);
    }

    private static class UCS
    extends CertStore {
        protected UCS(CertStoreSpi certStoreSpi, Provider provider, String string, CertStoreParameters certStoreParameters) {
            super(certStoreSpi, provider, string, certStoreParameters);
        }
    }

    static class URICertStoreParameters
    implements CertStoreParameters {
        private final URI uri;
        private volatile int hashCode = 0;

        URICertStoreParameters(URI uRI) {
            this.uri = uRI;
        }

        public boolean equals(Object object) {
            if (!(object instanceof URICertStoreParameters)) {
                return false;
            }
            URICertStoreParameters uRICertStoreParameters = (URICertStoreParameters)object;
            return this.uri.equals(uRICertStoreParameters.uri);
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int n = 17;
                this.hashCode = n = 37 * n + this.uri.hashCode();
            }
            return this.hashCode;
        }

        @Override
        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError(cloneNotSupportedException.toString(), cloneNotSupportedException);
            }
        }
    }

    private static enum AllowedScheme {
        HTTP(HttpFtpRuleMatcher.HTTP),
        HTTPS(HttpFtpRuleMatcher.HTTPS),
        LDAP(LdapRuleMatcher.LDAP),
        LDAPS(LdapRuleMatcher.LDAPS),
        FTP(HttpFtpRuleMatcher.FTP);

        final URIRuleMatcher ruleMatcher;

        private AllowedScheme(URIRuleMatcher uRIRuleMatcher) {
            this.ruleMatcher = uRIRuleMatcher;
        }

        static AllowedScheme nameOf(String string) {
            if (string == null) {
                return null;
            }
            try {
                return AllowedScheme.valueOf(string.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
    }
}

