/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.junit.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.Parameterized;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.ops4j.pax.exam.junit.impl.TestClassRunnerForParameters;
import org.ops4j.pax.exam.spi.StagedExamReactor;
import org.ops4j.pax.exam.spi.reactors.ReactorManager;

public class ParameterizedInjectingRunner
extends Suite {
    private static final List<Runner> NO_RUNNERS = Collections.emptyList();
    private final ArrayList<Runner> runners = new ArrayList();
    private ReactorManager manager = ReactorManager.getInstance();
    private StagedExamReactor stagedReactor;

    public ParameterizedInjectingRunner(Class<?> klass) throws InitializationError {
        super(klass, NO_RUNNERS);
        this.manager.prepareReactor(klass, null);
        this.stagedReactor = this.manager.stageReactor();
        Parameterized.Parameters parameters = (Parameterized.Parameters)this.getParametersMethod().getAnnotation(Parameterized.Parameters.class);
        this.createRunnersForParameters(this.allParameters(), parameters.name());
    }

    protected List<Runner> getChildren() {
        return this.runners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunNotifier notifier) {
        Class testClass = this.getTestClass().getJavaClass();
        try {
            this.manager.beforeClass(this.stagedReactor, (Object)testClass);
            super.run(notifier);
        }
        catch (Throwable e) {
            Description description = Description.createSuiteDescription((Class)testClass);
            notifier.fireTestFailure(new Failure(description, e));
        }
        finally {
            this.manager.afterClass(this.stagedReactor, testClass);
        }
    }

    private Iterable<Object[]> allParameters() throws InitializationError {
        Object parameters;
        try {
            parameters = this.getParametersMethod().invokeExplosively(null, new Object[0]);
        }
        catch (Throwable t) {
            throw new InitializationError(t);
        }
        if (parameters instanceof Iterable) {
            return (Iterable)parameters;
        }
        throw this.parametersMethodReturnedWrongType();
    }

    private FrameworkMethod getParametersMethod() throws InitializationError {
        List methods = this.getTestClass().getAnnotatedMethods(Parameterized.Parameters.class);
        for (FrameworkMethod each : methods) {
            if (!each.isStatic() || !each.isPublic()) continue;
            return each;
        }
        throw new InitializationError("No public static parameters method on class " + this.getTestClass().getName());
    }

    private void createRunnersForParameters(Iterable<Object[]> allParameters, String namePattern) throws InitializationError {
        try {
            int i = 0;
            for (Object[] parametersOfSingleTest : allParameters) {
                String name = this.nameFor(namePattern, i, parametersOfSingleTest);
                TestClassRunnerForParameters runner = new TestClassRunnerForParameters(this.getTestClass().getJavaClass(), parametersOfSingleTest, name);
                this.runners.add((Runner)runner);
                ++i;
            }
        }
        catch (ClassCastException e) {
            throw this.parametersMethodReturnedWrongType();
        }
    }

    private String nameFor(String namePattern, int index, Object[] parameters) {
        String finalPattern = namePattern.replaceAll("\\{index\\}", Integer.toString(index));
        String name = MessageFormat.format(finalPattern, parameters);
        return "[" + name + "]";
    }

    private InitializationError parametersMethodReturnedWrongType() throws InitializationError {
        String className = this.getTestClass().getName();
        String methodName = this.getParametersMethod().getName();
        String message = MessageFormat.format("{0}.{1}() must return an Iterable of arrays.", className, methodName);
        return new InitializationError(message);
    }
}

