/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.event;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.event.EventListenerSupport;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.function.FailableConsumer;
import org.easymock.EasyMock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EventListenerSupportTest
extends AbstractLangTest {
    private void addDeregisterListener(final EventListenerSupport<VetoableChangeListener> listenerSupport) {
        listenerSupport.addListener((Object)new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent e) {
                listenerSupport.removeListener((Object)this);
            }
        });
    }

    private VetoableChangeListener createListener(final List<VetoableChangeListener> calledListeners) {
        return new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent e) {
                calledListeners.add(this);
            }
        };
    }

    @Test
    public void testAddListenerNoDuplicates() {
        EventListenerSupport listenerSupport = EventListenerSupport.create(VetoableChangeListener.class);
        VetoableChangeListener[] listeners = (VetoableChangeListener[])listenerSupport.getListeners();
        Assertions.assertEquals((int)0, (int)listeners.length);
        Assertions.assertEquals(VetoableChangeListener.class, listeners.getClass().getComponentType());
        VetoableChangeListener[] empty = listeners;
        Assertions.assertSame((Object)empty, (Object)listenerSupport.getListeners());
        VetoableChangeListener listener1 = (VetoableChangeListener)EasyMock.createNiceMock(VetoableChangeListener.class);
        listenerSupport.addListener((Object)listener1);
        Assertions.assertEquals((int)1, (int)((VetoableChangeListener[])listenerSupport.getListeners()).length);
        listenerSupport.addListener((Object)listener1, false);
        Assertions.assertEquals((int)1, (int)((VetoableChangeListener[])listenerSupport.getListeners()).length);
        listenerSupport.removeListener((Object)listener1);
        Assertions.assertSame((Object)empty, (Object)listenerSupport.getListeners());
    }

    @Test
    public void testAddNullListener() {
        EventListenerSupport listenerSupport = EventListenerSupport.create(VetoableChangeListener.class);
        Assertions.assertThrows(NullPointerException.class, () -> listenerSupport.addListener(null));
    }

    @Test
    public void testCreateWithNonInterfaceParameter() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> EventListenerSupport.create(String.class));
    }

    @Test
    public void testCreateWithNullParameter() {
        Assertions.assertThrows(NullPointerException.class, () -> EventListenerSupport.create(null));
    }

    @Test
    public void testEventDispatchOrder() throws PropertyVetoException {
        EventListenerSupport listenerSupport = EventListenerSupport.create(VetoableChangeListener.class);
        ArrayList<VetoableChangeListener> calledListeners = new ArrayList<VetoableChangeListener>();
        VetoableChangeListener listener1 = this.createListener(calledListeners);
        VetoableChangeListener listener2 = this.createListener(calledListeners);
        listenerSupport.addListener((Object)listener1);
        listenerSupport.addListener((Object)listener2);
        ((VetoableChangeListener)listenerSupport.fire()).vetoableChange(new PropertyChangeEvent(new Date(), "Day", 4, 5));
        Assertions.assertEquals((int)calledListeners.size(), (int)2);
        Assertions.assertSame(calledListeners.get(0), (Object)listener1);
        Assertions.assertSame(calledListeners.get(1), (Object)listener2);
    }

    @Test
    public void testGetListeners() {
        EventListenerSupport listenerSupport = EventListenerSupport.create(VetoableChangeListener.class);
        VetoableChangeListener[] listeners = (VetoableChangeListener[])listenerSupport.getListeners();
        Assertions.assertEquals((int)0, (int)listeners.length);
        Assertions.assertEquals(VetoableChangeListener.class, listeners.getClass().getComponentType());
        VetoableChangeListener[] empty = listeners;
        Assertions.assertSame((Object)empty, (Object)listenerSupport.getListeners());
        VetoableChangeListener listener1 = (VetoableChangeListener)EasyMock.createNiceMock(VetoableChangeListener.class);
        listenerSupport.addListener((Object)listener1);
        Assertions.assertEquals((int)1, (int)((VetoableChangeListener[])listenerSupport.getListeners()).length);
        VetoableChangeListener listener2 = (VetoableChangeListener)EasyMock.createNiceMock(VetoableChangeListener.class);
        listenerSupport.addListener((Object)listener2);
        Assertions.assertEquals((int)2, (int)((VetoableChangeListener[])listenerSupport.getListeners()).length);
        listenerSupport.removeListener((Object)listener1);
        Assertions.assertEquals((int)1, (int)((VetoableChangeListener[])listenerSupport.getListeners()).length);
        listenerSupport.removeListener((Object)listener2);
        Assertions.assertSame((Object)empty, (Object)listenerSupport.getListeners());
    }

    @Test
    public void testRemoveListenerDuringEvent() throws PropertyVetoException {
        EventListenerSupport listenerSupport = EventListenerSupport.create(VetoableChangeListener.class);
        for (int i = 0; i < 10; ++i) {
            this.addDeregisterListener((EventListenerSupport<VetoableChangeListener>)listenerSupport);
        }
        Assertions.assertEquals((int)listenerSupport.getListenerCount(), (int)10);
        ((VetoableChangeListener)listenerSupport.fire()).vetoableChange(new PropertyChangeEvent(new Date(), "Day", 4, 5));
        Assertions.assertEquals((int)listenerSupport.getListenerCount(), (int)0);
    }

    @Test
    public void testRemoveNullListener() {
        EventListenerSupport listenerSupport = EventListenerSupport.create(VetoableChangeListener.class);
        Assertions.assertThrows(NullPointerException.class, () -> listenerSupport.removeListener(null));
    }

    @Test
    public void testSerialization() throws IOException, ClassNotFoundException, PropertyVetoException {
        EventListenerSupport listenerSupport = EventListenerSupport.create(VetoableChangeListener.class);
        listenerSupport.addListener(Function.identity()::apply);
        listenerSupport.addListener((Object)((VetoableChangeListener)EasyMock.createNiceMock(VetoableChangeListener.class)));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);){
            objectOutputStream.writeObject(listenerSupport);
        }
        EventListenerSupport deserializedListenerSupport = (EventListenerSupport)new ObjectInputStream(new ByteArrayInputStream(outputStream.toByteArray())).readObject();
        VetoableChangeListener[] listeners = (VetoableChangeListener[])deserializedListenerSupport.getListeners();
        Assertions.assertEquals(VetoableChangeListener.class, listeners.getClass().getComponentType());
        Assertions.assertEquals((int)1, (int)listeners.length);
        VetoableChangeListener listener = listeners[0];
        PropertyChangeEvent evt = new PropertyChangeEvent(new Date(), "Day", 7, 9);
        listener.vetoableChange(evt);
        EasyMock.replay((Object[])new Object[]{listener});
        ((VetoableChangeListener)deserializedListenerSupport.fire()).vetoableChange(evt);
        EasyMock.verify((Object[])new Object[]{listener});
        deserializedListenerSupport.removeListener((Object)listener);
        Assertions.assertEquals((int)0, (int)((VetoableChangeListener[])deserializedListenerSupport.getListeners()).length);
    }

    @Test
    public void testSubclassInvocationHandling() throws PropertyVetoException {
        EventListenerSupport<VetoableChangeListener> eventListenerSupport = new EventListenerSupport<VetoableChangeListener>(VetoableChangeListener.class){
            private static final long serialVersionUID = 1L;

            protected InvocationHandler createInvocationHandler() {
                return new EventListenerSupport.ProxyInvocationHandler(){

                    public Object invoke(Object proxy, Method method, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                        return "vetoableChange".equals(method.getName()) && "Hour".equals(((PropertyChangeEvent)args[0]).getPropertyName()) ? null : super.invoke(proxy, method, args);
                    }
                };
            }
        };
        VetoableChangeListener listener = (VetoableChangeListener)EasyMock.createNiceMock(VetoableChangeListener.class);
        eventListenerSupport.addListener((Object)listener);
        Date source = new Date();
        PropertyChangeEvent ignore = new PropertyChangeEvent(source, "Hour", 5, 6);
        PropertyChangeEvent respond = new PropertyChangeEvent(source, "Day", 6, 7);
        listener.vetoableChange(respond);
        EasyMock.replay((Object[])new Object[]{listener});
        ((VetoableChangeListener)eventListenerSupport.fire()).vetoableChange(ignore);
        ((VetoableChangeListener)eventListenerSupport.fire()).vetoableChange(respond);
        EasyMock.verify((Object[])new Object[]{listener});
    }

    @Test
    public void testThrowingListener() {
        AtomicInteger count = new AtomicInteger();
        EventListenerSupport listenerSupport = EventListenerSupport.create(VetoableChangeListener.class);
        boolean vetoLimit = true;
        int listenerCount = 10;
        for (int i = 0; i < 10; ++i) {
            listenerSupport.addListener(evt -> {
                if (count.incrementAndGet() > 1) {
                    throw new PropertyVetoException(count.toString(), evt);
                }
            });
        }
        Assertions.assertEquals((int)10, (int)listenerSupport.getListenerCount());
        Assertions.assertEquals((int)0, (int)count.get());
        Exception e = (Exception)Assertions.assertThrows(UndeclaredThrowableException.class, () -> ((VetoableChangeListener)listenerSupport.fire()).vetoableChange(new PropertyChangeEvent(new Date(), "Day", 0, 1)));
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
        Assertions.assertTrue((boolean)(rootCause instanceof PropertyVetoException));
        Assertions.assertEquals((int)2, (int)count.get());
    }

    @Test
    public void testThrowingListenerContinues() throws PropertyVetoException {
        AtomicInteger count = new AtomicInteger();
        EventListenerSupport<VetoableChangeListener> listenerSupport = new EventListenerSupport<VetoableChangeListener>(VetoableChangeListener.class){

            protected InvocationHandler createInvocationHandler() {
                return new EventListenerSupport.ProxyInvocationHandler((EventListenerSupport)this, FailableConsumer.nop());
            }
        };
        boolean vetoLimit = true;
        int listenerCount = 10;
        for (int i = 0; i < 10; ++i) {
            listenerSupport.addListener(evt -> {
                if (count.incrementAndGet() > 1) {
                    throw new PropertyVetoException(count.toString(), evt);
                }
            });
        }
        Assertions.assertEquals((int)10, (int)listenerSupport.getListenerCount());
        Assertions.assertEquals((int)0, (int)count.get());
        ((VetoableChangeListener)listenerSupport.fire()).vetoableChange(new PropertyChangeEvent(new Date(), "Day", 0, 1));
        Assertions.assertEquals((int)10, (int)count.get());
    }
}

