/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.builder.Diff;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DiffTest
extends AbstractLangTest {
    private static final String FIELD_NAME = "field";
    private static final Diff<Boolean> booleanDiff = new BooleanDiff("field");

    @Test
    public void testCannotModify() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> booleanDiff.setValue((Object)Boolean.FALSE));
    }

    @Test
    public void testGetFieldName() {
        Assertions.assertEquals((Object)FIELD_NAME, (Object)booleanDiff.getFieldName());
    }

    @Test
    public void testGetType() {
        Assertions.assertEquals(Boolean.class, (Object)booleanDiff.getType());
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)String.format("[%s: %s, %s]", FIELD_NAME, booleanDiff.getLeft(), booleanDiff.getRight()), (Object)booleanDiff.toString());
    }

    private static final class BooleanDiff
    extends Diff<Boolean> {
        private static final long serialVersionUID = 1L;

        protected BooleanDiff(String fieldName) {
            super(fieldName);
        }

        public Boolean getLeft() {
            return Boolean.TRUE;
        }

        public Boolean getRight() {
            return Boolean.FALSE;
        }
    }
}

