/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ArrayUtilsAddTest
extends AbstractLangTest {
    @Test
    public void testAddFirstBoolean() {
        boolean[] newArray = ArrayUtils.addFirst(null, (boolean)false);
        Assertions.assertArrayEquals((boolean[])new boolean[]{false}, (boolean[])newArray);
        Assertions.assertEquals(Boolean.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.addFirst(null, (boolean)true);
        Assertions.assertArrayEquals((boolean[])new boolean[]{true}, (boolean[])newArray);
        Assertions.assertEquals(Boolean.TYPE, newArray.getClass().getComponentType());
        boolean[] array1 = new boolean[]{true, false, true};
        newArray = ArrayUtils.addFirst((boolean[])array1, (boolean)false);
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, true, false, true}, (boolean[])newArray);
        Assertions.assertEquals(Boolean.TYPE, newArray.getClass().getComponentType());
    }

    @Test
    public void testAddFirstByte() {
        byte[] newArray = ArrayUtils.addFirst((byte[])null, (byte)0);
        Assertions.assertArrayEquals((byte[])new byte[]{0}, (byte[])newArray);
        Assertions.assertEquals(Byte.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.addFirst((byte[])null, (byte)1);
        Assertions.assertArrayEquals((byte[])new byte[]{1}, (byte[])newArray);
        Assertions.assertEquals(Byte.TYPE, newArray.getClass().getComponentType());
        byte[] array1 = new byte[]{1, 2, 3};
        newArray = ArrayUtils.addFirst((byte[])array1, (byte)0);
        Assertions.assertArrayEquals((byte[])new byte[]{0, 1, 2, 3}, (byte[])newArray);
        Assertions.assertEquals(Byte.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.addFirst((byte[])array1, (byte)4);
        Assertions.assertArrayEquals((byte[])new byte[]{4, 1, 2, 3}, (byte[])newArray);
        Assertions.assertEquals(Byte.TYPE, newArray.getClass().getComponentType());
    }

    @Test
    public void testAddFirstChar() {
        char[] newArray = ArrayUtils.addFirst((char[])null, (char)'\u0000');
        Assertions.assertArrayEquals((char[])new char[]{'\u0000'}, (char[])newArray);
        Assertions.assertEquals(Character.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.addFirst((char[])null, (char)'\u0001');
        Assertions.assertArrayEquals((char[])new char[]{'\u0001'}, (char[])newArray);
        Assertions.assertEquals(Character.TYPE, newArray.getClass().getComponentType());
        char[] array1 = new char[]{'\u0001', '\u0002', '\u0003'};
        newArray = ArrayUtils.addFirst((char[])array1, (char)'\u0000');
        Assertions.assertArrayEquals((char[])new char[]{'\u0000', '\u0001', '\u0002', '\u0003'}, (char[])newArray);
        Assertions.assertEquals(Character.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.addFirst((char[])array1, (char)'\u0004');
        Assertions.assertArrayEquals((char[])new char[]{'\u0004', '\u0001', '\u0002', '\u0003'}, (char[])newArray);
        Assertions.assertEquals(Character.TYPE, newArray.getClass().getComponentType());
    }

    @Test
    public void testAddFirstDouble() {
        double[] newArray = ArrayUtils.addFirst((double[])null, (double)0.0);
        Assertions.assertArrayEquals((double[])new double[]{0.0}, (double[])newArray);
        Assertions.assertEquals(Double.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.addFirst((double[])null, (double)1.0);
        Assertions.assertArrayEquals((double[])new double[]{1.0}, (double[])newArray);
        Assertions.assertEquals(Double.TYPE, newArray.getClass().getComponentType());
        double[] array1 = new double[]{1.0, 2.0, 3.0};
        newArray = ArrayUtils.addFirst((double[])array1, (double)0.0);
        Assertions.assertArrayEquals((double[])new double[]{0.0, 1.0, 2.0, 3.0}, (double[])newArray);
        Assertions.assertEquals(Double.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.addFirst((double[])array1, (double)4.0);
        Assertions.assertArrayEquals((double[])new double[]{4.0, 1.0, 2.0, 3.0}, (double[])newArray);
        Assertions.assertEquals(Double.TYPE, newArray.getClass().getComponentType());
    }

    @Test
    public void testAddFirstFloat() {
        float[] newArray = ArrayUtils.addFirst((float[])null, (float)0.0f);
        Assertions.assertArrayEquals((float[])new float[]{0.0f}, (float[])newArray);
        Assertions.assertEquals(Float.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.addFirst((float[])null, (float)1.0f);
        Assertions.assertArrayEquals((float[])new float[]{1.0f}, (float[])newArray);
        Assertions.assertEquals(Float.TYPE, newArray.getClass().getComponentType());
        float[] array1 = new float[]{1.0f, 2.0f, 3.0f};
        newArray = ArrayUtils.addFirst((float[])array1, (float)0.0f);
        Assertions.assertArrayEquals((float[])new float[]{0.0f, 1.0f, 2.0f, 3.0f}, (float[])newArray);
        Assertions.assertEquals(Float.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.addFirst((float[])array1, (float)4.0f);
        Assertions.assertArrayEquals((float[])new float[]{4.0f, 1.0f, 2.0f, 3.0f}, (float[])newArray);
        Assertions.assertEquals(Float.TYPE, newArray.getClass().getComponentType());
    }

    @Test
    public void testAddFirstInt() {
        int[] newArray = ArrayUtils.addFirst((int[])null, (int)0);
        Assertions.assertArrayEquals((int[])new int[]{0}, (int[])newArray);
        Assertions.assertEquals(Integer.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.addFirst((int[])null, (int)1);
        Assertions.assertArrayEquals((int[])new int[]{1}, (int[])newArray);
        Assertions.assertEquals(Integer.TYPE, newArray.getClass().getComponentType());
        int[] array1 = new int[]{1, 2, 3};
        newArray = ArrayUtils.addFirst((int[])array1, (int)0);
        Assertions.assertArrayEquals((int[])new int[]{0, 1, 2, 3}, (int[])newArray);
        Assertions.assertEquals(Integer.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.addFirst((int[])array1, (int)4);
        Assertions.assertArrayEquals((int[])new int[]{4, 1, 2, 3}, (int[])newArray);
        Assertions.assertEquals(Integer.TYPE, newArray.getClass().getComponentType());
    }

    @Test
    public void testAddFirstLong() {
        long[] newArray = ArrayUtils.addFirst((long[])null, (long)0L);
        Assertions.assertArrayEquals((long[])new long[]{0L}, (long[])newArray);
        Assertions.assertEquals(Long.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.addFirst((long[])null, (long)1L);
        Assertions.assertArrayEquals((long[])new long[]{1L}, (long[])newArray);
        Assertions.assertEquals(Long.TYPE, newArray.getClass().getComponentType());
        long[] array1 = new long[]{1L, 2L, 3L};
        newArray = ArrayUtils.addFirst((long[])array1, (long)0L);
        Assertions.assertArrayEquals((long[])new long[]{0L, 1L, 2L, 3L}, (long[])newArray);
        Assertions.assertEquals(Long.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.addFirst((long[])array1, (long)4L);
        Assertions.assertArrayEquals((long[])new long[]{4L, 1L, 2L, 3L}, (long[])newArray);
        Assertions.assertEquals(Long.TYPE, newArray.getClass().getComponentType());
    }

    @Test
    public void testAddFirstObject() {
        Object[] newArray = ArrayUtils.add((Object[])null, (Object)"a");
        Assertions.assertArrayEquals((Object[])new String[]{"a"}, (Object[])newArray);
        Assertions.assertArrayEquals((Object[])new Object[]{"a"}, (Object[])newArray);
        Assertions.assertEquals(String.class, newArray.getClass().getComponentType());
        Object[] newStringArray = (String[])ArrayUtils.add(null, (Object)"a");
        Assertions.assertArrayEquals((Object[])new String[]{"a"}, (Object[])newStringArray);
        Assertions.assertArrayEquals((Object[])new Object[]{"a"}, (Object[])newStringArray);
        Assertions.assertEquals(String.class, newStringArray.getClass().getComponentType());
        Object[] stringArray1 = new String[]{"a", "b", "c"};
        newArray = ArrayUtils.addFirst((Object[])stringArray1, null);
        Assertions.assertArrayEquals((Object[])new String[]{null, "a", "b", "c"}, (Object[])newArray);
        Assertions.assertEquals(String.class, newArray.getClass().getComponentType());
        newArray = ArrayUtils.addFirst((Object[])stringArray1, (Object)"d");
        Assertions.assertArrayEquals((Object[])new String[]{"d", "a", "b", "c"}, (Object[])newArray);
        Assertions.assertEquals(String.class, newArray.getClass().getComponentType());
        Object[] numberArray1 = new Number[]{1, 2.0};
        newArray = ArrayUtils.addFirst((Object[])numberArray1, (Object)Float.valueOf(3.0f));
        Assertions.assertArrayEquals((Object[])new Number[]{Float.valueOf(3.0f), 1, 2.0}, (Object[])newArray);
        Assertions.assertEquals(Number.class, newArray.getClass().getComponentType());
        numberArray1 = null;
        newArray = ArrayUtils.addFirst((Object[])numberArray1, (Object)Float.valueOf(3.0f));
        Assertions.assertArrayEquals((Object[])new Float[]{Float.valueOf(3.0f)}, (Object[])newArray);
        Assertions.assertEquals(Float.class, newArray.getClass().getComponentType());
    }

    @Test
    public void testAddFirstShort() {
        short[] newArray = ArrayUtils.addFirst((short[])null, (short)0);
        Assertions.assertArrayEquals((short[])new short[]{0}, (short[])newArray);
        Assertions.assertEquals(Short.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.addFirst((short[])null, (short)1);
        Assertions.assertArrayEquals((short[])new short[]{1}, (short[])newArray);
        Assertions.assertEquals(Short.TYPE, newArray.getClass().getComponentType());
        short[] array1 = new short[]{1, 2, 3};
        newArray = ArrayUtils.addFirst((short[])array1, (short)0);
        Assertions.assertArrayEquals((short[])new short[]{0, 1, 2, 3}, (short[])newArray);
        Assertions.assertEquals(Short.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.addFirst((short[])array1, (short)4);
        Assertions.assertArrayEquals((short[])new short[]{4, 1, 2, 3}, (short[])newArray);
        Assertions.assertEquals(Short.TYPE, newArray.getClass().getComponentType());
    }

    @Test
    public void testAddObjectArrayBoolean() {
        boolean[] newArray = ArrayUtils.add(null, (boolean)false);
        Assertions.assertArrayEquals((boolean[])new boolean[]{false}, (boolean[])newArray);
        Assertions.assertEquals(Boolean.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add(null, (boolean)true);
        Assertions.assertArrayEquals((boolean[])new boolean[]{true}, (boolean[])newArray);
        Assertions.assertEquals(Boolean.TYPE, newArray.getClass().getComponentType());
        boolean[] array1 = new boolean[]{true, false, true};
        newArray = ArrayUtils.add((boolean[])array1, (boolean)false);
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, false, true, false}, (boolean[])newArray);
        Assertions.assertEquals(Boolean.TYPE, newArray.getClass().getComponentType());
    }

    @Test
    public void testAddObjectArrayByte() {
        byte[] newArray = ArrayUtils.add((byte[])null, (byte)0);
        Assertions.assertArrayEquals((byte[])new byte[]{0}, (byte[])newArray);
        Assertions.assertEquals(Byte.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((byte[])null, (byte)1);
        Assertions.assertArrayEquals((byte[])new byte[]{1}, (byte[])newArray);
        Assertions.assertEquals(Byte.TYPE, newArray.getClass().getComponentType());
        byte[] array1 = new byte[]{1, 2, 3};
        newArray = ArrayUtils.add((byte[])array1, (byte)0);
        Assertions.assertArrayEquals((byte[])new byte[]{1, 2, 3, 0}, (byte[])newArray);
        Assertions.assertEquals(Byte.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((byte[])array1, (byte)4);
        Assertions.assertArrayEquals((byte[])new byte[]{1, 2, 3, 4}, (byte[])newArray);
        Assertions.assertEquals(Byte.TYPE, newArray.getClass().getComponentType());
    }

    @Test
    public void testAddObjectArrayChar() {
        char[] newArray = ArrayUtils.add((char[])null, (char)'\u0000');
        Assertions.assertArrayEquals((char[])new char[]{'\u0000'}, (char[])newArray);
        Assertions.assertEquals(Character.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((char[])null, (char)'\u0001');
        Assertions.assertArrayEquals((char[])new char[]{'\u0001'}, (char[])newArray);
        Assertions.assertEquals(Character.TYPE, newArray.getClass().getComponentType());
        char[] array1 = new char[]{'\u0001', '\u0002', '\u0003'};
        newArray = ArrayUtils.add((char[])array1, (char)'\u0000');
        Assertions.assertArrayEquals((char[])new char[]{'\u0001', '\u0002', '\u0003', '\u0000'}, (char[])newArray);
        Assertions.assertEquals(Character.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((char[])array1, (char)'\u0004');
        Assertions.assertArrayEquals((char[])new char[]{'\u0001', '\u0002', '\u0003', '\u0004'}, (char[])newArray);
        Assertions.assertEquals(Character.TYPE, newArray.getClass().getComponentType());
    }

    @Test
    public void testAddObjectArrayDouble() {
        double[] newArray = ArrayUtils.add((double[])null, (double)0.0);
        Assertions.assertArrayEquals((double[])new double[]{0.0}, (double[])newArray);
        Assertions.assertEquals(Double.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((double[])null, (double)1.0);
        Assertions.assertArrayEquals((double[])new double[]{1.0}, (double[])newArray);
        Assertions.assertEquals(Double.TYPE, newArray.getClass().getComponentType());
        double[] array1 = new double[]{1.0, 2.0, 3.0};
        newArray = ArrayUtils.add((double[])array1, (double)0.0);
        Assertions.assertArrayEquals((double[])new double[]{1.0, 2.0, 3.0, 0.0}, (double[])newArray);
        Assertions.assertEquals(Double.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((double[])array1, (double)4.0);
        Assertions.assertArrayEquals((double[])new double[]{1.0, 2.0, 3.0, 4.0}, (double[])newArray);
        Assertions.assertEquals(Double.TYPE, newArray.getClass().getComponentType());
    }

    @Test
    public void testAddObjectArrayFloat() {
        float[] newArray = ArrayUtils.add((float[])null, (float)0.0f);
        Assertions.assertArrayEquals((float[])new float[]{0.0f}, (float[])newArray);
        Assertions.assertEquals(Float.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((float[])null, (float)1.0f);
        Assertions.assertArrayEquals((float[])new float[]{1.0f}, (float[])newArray);
        Assertions.assertEquals(Float.TYPE, newArray.getClass().getComponentType());
        float[] array1 = new float[]{1.0f, 2.0f, 3.0f};
        newArray = ArrayUtils.add((float[])array1, (float)0.0f);
        Assertions.assertArrayEquals((float[])new float[]{1.0f, 2.0f, 3.0f, 0.0f}, (float[])newArray);
        Assertions.assertEquals(Float.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((float[])array1, (float)4.0f);
        Assertions.assertArrayEquals((float[])new float[]{1.0f, 2.0f, 3.0f, 4.0f}, (float[])newArray);
        Assertions.assertEquals(Float.TYPE, newArray.getClass().getComponentType());
    }

    @Test
    public void testAddObjectArrayInt() {
        int[] newArray = ArrayUtils.add((int[])null, (int)0);
        Assertions.assertArrayEquals((int[])new int[]{0}, (int[])newArray);
        Assertions.assertEquals(Integer.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((int[])null, (int)1);
        Assertions.assertArrayEquals((int[])new int[]{1}, (int[])newArray);
        Assertions.assertEquals(Integer.TYPE, newArray.getClass().getComponentType());
        int[] array1 = new int[]{1, 2, 3};
        newArray = ArrayUtils.add((int[])array1, (int)0);
        Assertions.assertArrayEquals((int[])new int[]{1, 2, 3, 0}, (int[])newArray);
        Assertions.assertEquals(Integer.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((int[])array1, (int)4);
        Assertions.assertArrayEquals((int[])new int[]{1, 2, 3, 4}, (int[])newArray);
        Assertions.assertEquals(Integer.TYPE, newArray.getClass().getComponentType());
    }

    @Test
    public void testAddObjectArrayLong() {
        long[] newArray = ArrayUtils.add((long[])null, (long)0L);
        Assertions.assertArrayEquals((long[])new long[]{0L}, (long[])newArray);
        Assertions.assertEquals(Long.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((long[])null, (long)1L);
        Assertions.assertArrayEquals((long[])new long[]{1L}, (long[])newArray);
        Assertions.assertEquals(Long.TYPE, newArray.getClass().getComponentType());
        long[] array1 = new long[]{1L, 2L, 3L};
        newArray = ArrayUtils.add((long[])array1, (long)0L);
        Assertions.assertArrayEquals((long[])new long[]{1L, 2L, 3L, 0L}, (long[])newArray);
        Assertions.assertEquals(Long.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((long[])array1, (long)4L);
        Assertions.assertArrayEquals((long[])new long[]{1L, 2L, 3L, 4L}, (long[])newArray);
        Assertions.assertEquals(Long.TYPE, newArray.getClass().getComponentType());
    }

    @Test
    public void testAddObjectArrayObject() {
        Object[] newArray = ArrayUtils.add((Object[])null, (Object)"a");
        Assertions.assertArrayEquals((Object[])new String[]{"a"}, (Object[])newArray);
        Assertions.assertArrayEquals((Object[])new Object[]{"a"}, (Object[])newArray);
        Assertions.assertEquals(String.class, newArray.getClass().getComponentType());
        Object[] newStringArray = (String[])ArrayUtils.add(null, (Object)"a");
        Assertions.assertArrayEquals((Object[])new String[]{"a"}, (Object[])newStringArray);
        Assertions.assertArrayEquals((Object[])new Object[]{"a"}, (Object[])newStringArray);
        Assertions.assertEquals(String.class, newStringArray.getClass().getComponentType());
        Object[] stringArray1 = new String[]{"a", "b", "c"};
        newArray = ArrayUtils.add((Object[])stringArray1, null);
        Assertions.assertArrayEquals((Object[])new String[]{"a", "b", "c", null}, (Object[])newArray);
        Assertions.assertEquals(String.class, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((Object[])stringArray1, (Object)"d");
        Assertions.assertArrayEquals((Object[])new String[]{"a", "b", "c", "d"}, (Object[])newArray);
        Assertions.assertEquals(String.class, newArray.getClass().getComponentType());
        Object[] numberArray1 = new Number[]{1, 2.0};
        newArray = ArrayUtils.add((Object[])numberArray1, (Object)Float.valueOf(3.0f));
        Assertions.assertArrayEquals((Object[])new Number[]{1, 2.0, Float.valueOf(3.0f)}, (Object[])newArray);
        Assertions.assertEquals(Number.class, newArray.getClass().getComponentType());
        numberArray1 = null;
        newArray = ArrayUtils.add((Object[])numberArray1, (Object)Float.valueOf(3.0f));
        Assertions.assertArrayEquals((Object[])new Float[]{Float.valueOf(3.0f)}, (Object[])newArray);
        Assertions.assertEquals(Float.class, newArray.getClass().getComponentType());
    }

    @Test
    public void testAddObjectArrayShort() {
        short[] newArray = ArrayUtils.add((short[])null, (short)0);
        Assertions.assertArrayEquals((short[])new short[]{0}, (short[])newArray);
        Assertions.assertEquals(Short.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((short[])null, (short)1);
        Assertions.assertArrayEquals((short[])new short[]{1}, (short[])newArray);
        Assertions.assertEquals(Short.TYPE, newArray.getClass().getComponentType());
        short[] array1 = new short[]{1, 2, 3};
        newArray = ArrayUtils.add((short[])array1, (short)0);
        Assertions.assertArrayEquals((short[])new short[]{1, 2, 3, 0}, (short[])newArray);
        Assertions.assertEquals(Short.TYPE, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((short[])array1, (short)4);
        Assertions.assertArrayEquals((short[])new short[]{1, 2, 3, 4}, (short[])newArray);
        Assertions.assertEquals(Short.TYPE, newArray.getClass().getComponentType());
    }

    @Test
    public void testAddObjectArrayToObjectArray() {
        Assertions.assertNull((Object)ArrayUtils.addAll(null, (Object[])null));
        Object[] stringArray1 = new String[]{"a", "b", "c"};
        Object[] stringArray2 = new String[]{"1", "2", "3"};
        Object[] newArray = ArrayUtils.addAll((Object[])stringArray1, (Object[])null);
        Assertions.assertNotSame((Object)stringArray1, (Object)newArray);
        Assertions.assertArrayEquals((Object[])stringArray1, (Object[])newArray);
        Assertions.assertArrayEquals((Object[])new String[]{"a", "b", "c"}, (Object[])newArray);
        Assertions.assertEquals(String.class, newArray.getClass().getComponentType());
        newArray = ArrayUtils.addAll(null, (Object[])stringArray2);
        Assertions.assertNotSame((Object)stringArray2, (Object)newArray);
        Assertions.assertArrayEquals((Object[])stringArray2, (Object[])newArray);
        Assertions.assertArrayEquals((Object[])new String[]{"1", "2", "3"}, (Object[])newArray);
        Assertions.assertEquals(String.class, newArray.getClass().getComponentType());
        newArray = ArrayUtils.addAll((Object[])stringArray1, (Object[])stringArray2);
        Assertions.assertArrayEquals((Object[])new String[]{"a", "b", "c", "1", "2", "3"}, (Object[])newArray);
        Assertions.assertEquals(String.class, newArray.getClass().getComponentType());
        newArray = ArrayUtils.addAll((Object[])ArrayUtils.EMPTY_STRING_ARRAY, (Object[])null);
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_STRING_ARRAY, (Object[])newArray);
        Assertions.assertArrayEquals((Object[])new String[0], (Object[])newArray);
        Assertions.assertEquals(String.class, newArray.getClass().getComponentType());
        newArray = ArrayUtils.addAll(null, (Object[])ArrayUtils.EMPTY_STRING_ARRAY);
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_STRING_ARRAY, (Object[])newArray);
        Assertions.assertArrayEquals((Object[])new String[0], (Object[])newArray);
        Assertions.assertEquals(String.class, newArray.getClass().getComponentType());
        newArray = ArrayUtils.addAll((Object[])ArrayUtils.EMPTY_STRING_ARRAY, (Object[])ArrayUtils.EMPTY_STRING_ARRAY);
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_STRING_ARRAY, (Object[])newArray);
        Assertions.assertArrayEquals((Object[])new String[0], (Object[])newArray);
        Assertions.assertEquals(String.class, newArray.getClass().getComponentType());
        Object[] stringArrayNull = new String[]{null};
        newArray = ArrayUtils.addAll((Object[])stringArrayNull, (Object[])stringArrayNull);
        Assertions.assertArrayEquals((Object[])new String[]{null, null}, (Object[])newArray);
        Assertions.assertEquals(String.class, newArray.getClass().getComponentType());
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, false, false, true}, (boolean[])ArrayUtils.addAll((boolean[])new boolean[]{true, false}, (boolean[])new boolean[]{false, true}));
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, true}, (boolean[])ArrayUtils.addAll(null, (boolean[])new boolean[]{false, true}));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, false}, (boolean[])ArrayUtils.addAll((boolean[])new boolean[]{true, false}, null));
        Assertions.assertArrayEquals((char[])new char[]{'a', 'b', 'c', 'd'}, (char[])ArrayUtils.addAll((char[])new char[]{'a', 'b'}, (char[])new char[]{'c', 'd'}));
        Assertions.assertArrayEquals((char[])new char[]{'c', 'd'}, (char[])ArrayUtils.addAll(null, (char[])new char[]{'c', 'd'}));
        Assertions.assertArrayEquals((char[])new char[]{'a', 'b'}, (char[])ArrayUtils.addAll((char[])new char[]{'a', 'b'}, null));
        Assertions.assertArrayEquals((byte[])new byte[]{0, 1, 2, 3}, (byte[])ArrayUtils.addAll((byte[])new byte[]{0, 1}, (byte[])new byte[]{2, 3}));
        Assertions.assertArrayEquals((byte[])new byte[]{2, 3}, (byte[])ArrayUtils.addAll(null, (byte[])new byte[]{2, 3}));
        Assertions.assertArrayEquals((byte[])new byte[]{0, 1}, (byte[])ArrayUtils.addAll((byte[])new byte[]{0, 1}, null));
        Assertions.assertArrayEquals((short[])new short[]{10, 20, 30, 40}, (short[])ArrayUtils.addAll((short[])new short[]{10, 20}, (short[])new short[]{30, 40}));
        Assertions.assertArrayEquals((short[])new short[]{30, 40}, (short[])ArrayUtils.addAll(null, (short[])new short[]{30, 40}));
        Assertions.assertArrayEquals((short[])new short[]{10, 20}, (short[])ArrayUtils.addAll((short[])new short[]{10, 20}, null));
        Assertions.assertArrayEquals((int[])new int[]{1, 1000, -1000, -1}, (int[])ArrayUtils.addAll((int[])new int[]{1, 1000}, (int[])new int[]{-1000, -1}));
        Assertions.assertArrayEquals((int[])new int[]{-1000, -1}, (int[])ArrayUtils.addAll(null, (int[])new int[]{-1000, -1}));
        Assertions.assertArrayEquals((int[])new int[]{1, 1000}, (int[])ArrayUtils.addAll((int[])new int[]{1, 1000}, null));
        Assertions.assertArrayEquals((long[])new long[]{1L, -1L, 1000L, -1000L}, (long[])ArrayUtils.addAll((long[])new long[]{1L, -1L}, (long[])new long[]{1000L, -1000L}));
        Assertions.assertArrayEquals((long[])new long[]{1000L, -1000L}, (long[])ArrayUtils.addAll(null, (long[])new long[]{1000L, -1000L}));
        Assertions.assertArrayEquals((long[])new long[]{1L, -1L}, (long[])ArrayUtils.addAll((long[])new long[]{1L, -1L}, null));
        Assertions.assertArrayEquals((float[])new float[]{10.5f, 10.1f, 1.6f, 0.01f}, (float[])ArrayUtils.addAll((float[])new float[]{10.5f, 10.1f}, (float[])new float[]{1.6f, 0.01f}));
        Assertions.assertArrayEquals((float[])new float[]{1.6f, 0.01f}, (float[])ArrayUtils.addAll(null, (float[])new float[]{1.6f, 0.01f}));
        Assertions.assertArrayEquals((float[])new float[]{10.5f, 10.1f}, (float[])ArrayUtils.addAll((float[])new float[]{10.5f, 10.1f}, null));
        Assertions.assertArrayEquals((double[])new double[]{Math.PI, -Math.PI, 0.0, 9.99}, (double[])ArrayUtils.addAll((double[])new double[]{Math.PI, -Math.PI}, (double[])new double[]{0.0, 9.99}));
        Assertions.assertArrayEquals((double[])new double[]{0.0, 9.99}, (double[])ArrayUtils.addAll(null, (double[])new double[]{0.0, 9.99}));
        Assertions.assertArrayEquals((double[])new double[]{Math.PI, -Math.PI}, (double[])ArrayUtils.addAll((double[])new double[]{Math.PI, -Math.PI}, null));
    }

    @Test
    public void testAddObjectAtIndex() {
        Object[] newArray = ArrayUtils.add((Object[])null, (int)0, (Object)"a");
        Assertions.assertArrayEquals((Object[])new String[]{"a"}, (Object[])newArray);
        Assertions.assertArrayEquals((Object[])new Object[]{"a"}, (Object[])newArray);
        Assertions.assertEquals(String.class, newArray.getClass().getComponentType());
        Object[] stringArray1 = new String[]{"a", "b", "c"};
        newArray = ArrayUtils.add((Object[])stringArray1, (int)0, null);
        Assertions.assertArrayEquals((Object[])new String[]{null, "a", "b", "c"}, (Object[])newArray);
        Assertions.assertEquals(String.class, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((Object[])stringArray1, (int)1, null);
        Assertions.assertArrayEquals((Object[])new String[]{"a", null, "b", "c"}, (Object[])newArray);
        Assertions.assertEquals(String.class, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((Object[])stringArray1, (int)3, null);
        Assertions.assertArrayEquals((Object[])new String[]{"a", "b", "c", null}, (Object[])newArray);
        Assertions.assertEquals(String.class, newArray.getClass().getComponentType());
        newArray = ArrayUtils.add((Object[])stringArray1, (int)3, (Object)"d");
        Assertions.assertArrayEquals((Object[])new String[]{"a", "b", "c", "d"}, (Object[])newArray);
        Assertions.assertEquals(String.class, newArray.getClass().getComponentType());
        Assertions.assertEquals(String.class, newArray.getClass().getComponentType());
        Object[] o = new Object[]{"1", "2", "4"};
        Object[] result = ArrayUtils.add((Object[])o, (int)2, (Object)"3");
        Object[] result2 = ArrayUtils.add((Object[])o, (int)3, (Object)"5");
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((int)4, (int)result.length);
        Assertions.assertEquals((Object)"1", (Object)result[0]);
        Assertions.assertEquals((Object)"2", (Object)result[1]);
        Assertions.assertEquals((Object)"3", (Object)result[2]);
        Assertions.assertEquals((Object)"4", (Object)result[3]);
        Assertions.assertNotNull((Object)result2);
        Assertions.assertEquals((int)4, (int)result2.length);
        Assertions.assertEquals((Object)"1", (Object)result2[0]);
        Assertions.assertEquals((Object)"2", (Object)result2[1]);
        Assertions.assertEquals((Object)"4", (Object)result2[2]);
        Assertions.assertEquals((Object)"5", (Object)result2[3]);
        boolean[] booleanArray = ArrayUtils.add(null, (int)0, (boolean)true);
        Assertions.assertArrayEquals((boolean[])new boolean[]{true}, (boolean[])booleanArray);
        IndexOutOfBoundsException e = (IndexOutOfBoundsException)Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.add(null, (int)-1, (boolean)true));
        Assertions.assertEquals((Object)"Index: -1, Length: 0", (Object)e.getMessage());
        booleanArray = ArrayUtils.add((boolean[])new boolean[]{true}, (int)0, (boolean)false);
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, true}, (boolean[])booleanArray);
        booleanArray = ArrayUtils.add((boolean[])new boolean[]{false}, (int)1, (boolean)true);
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, true}, (boolean[])booleanArray);
        booleanArray = ArrayUtils.add((boolean[])new boolean[]{true, false}, (int)1, (boolean)true);
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true, false}, (boolean[])booleanArray);
        e = (IndexOutOfBoundsException)Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.add((boolean[])new boolean[]{true, false}, (int)4, (boolean)true));
        Assertions.assertEquals((Object)"Index: 4, Length: 2", (Object)e.getMessage());
        e = (IndexOutOfBoundsException)Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.add((boolean[])new boolean[]{true, false}, (int)-1, (boolean)true));
        Assertions.assertEquals((Object)"Index: -1, Length: 2", (Object)e.getMessage());
        char[] charArray = ArrayUtils.add((char[])null, (int)0, (char)'a');
        Assertions.assertArrayEquals((char[])new char[]{'a'}, (char[])charArray);
        e = (IndexOutOfBoundsException)Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.add((char[])null, (int)-1, (char)'a'));
        Assertions.assertEquals((Object)"Index: -1, Length: 0", (Object)e.getMessage());
        charArray = ArrayUtils.add((char[])new char[]{'a'}, (int)0, (char)'b');
        Assertions.assertArrayEquals((char[])new char[]{'b', 'a'}, (char[])charArray);
        charArray = ArrayUtils.add((char[])new char[]{'a', 'b'}, (int)0, (char)'c');
        Assertions.assertArrayEquals((char[])new char[]{'c', 'a', 'b'}, (char[])charArray);
        charArray = ArrayUtils.add((char[])new char[]{'a', 'b'}, (int)1, (char)'k');
        Assertions.assertArrayEquals((char[])new char[]{'a', 'k', 'b'}, (char[])charArray);
        charArray = ArrayUtils.add((char[])new char[]{'a', 'b', 'c'}, (int)1, (char)'t');
        Assertions.assertArrayEquals((char[])new char[]{'a', 't', 'b', 'c'}, (char[])charArray);
        e = (IndexOutOfBoundsException)Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.add((char[])new char[]{'a', 'b'}, (int)4, (char)'c'));
        Assertions.assertEquals((Object)"Index: 4, Length: 2", (Object)e.getMessage());
        e = (IndexOutOfBoundsException)Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.add((char[])new char[]{'a', 'b'}, (int)-1, (char)'c'));
        Assertions.assertEquals((Object)"Index: -1, Length: 2", (Object)e.getMessage());
        short[] shortArray = ArrayUtils.add((short[])new short[]{1}, (int)0, (short)2);
        Assertions.assertArrayEquals((short[])new short[]{2, 1}, (short[])shortArray);
        e = (IndexOutOfBoundsException)Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.add((short[])null, (int)-1, (short)2));
        Assertions.assertEquals((Object)"Index: -1, Length: 0", (Object)e.getMessage());
        shortArray = ArrayUtils.add((short[])new short[]{2, 6}, (int)2, (short)10);
        Assertions.assertArrayEquals((short[])new short[]{2, 6, 10}, (short[])shortArray);
        shortArray = ArrayUtils.add((short[])new short[]{2, 6}, (int)0, (short)-4);
        Assertions.assertArrayEquals((short[])new short[]{-4, 2, 6}, (short[])shortArray);
        shortArray = ArrayUtils.add((short[])new short[]{2, 6, 3}, (int)2, (short)1);
        Assertions.assertArrayEquals((short[])new short[]{2, 6, 1, 3}, (short[])shortArray);
        e = (IndexOutOfBoundsException)Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.add((short[])new short[]{2, 6}, (int)4, (short)10));
        Assertions.assertEquals((Object)"Index: 4, Length: 2", (Object)e.getMessage());
        e = (IndexOutOfBoundsException)Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.add((short[])new short[]{2, 6}, (int)-1, (short)10));
        Assertions.assertEquals((Object)"Index: -1, Length: 2", (Object)e.getMessage());
        byte[] byteArray = ArrayUtils.add((byte[])new byte[]{1}, (int)0, (byte)2);
        Assertions.assertArrayEquals((byte[])new byte[]{2, 1}, (byte[])byteArray);
        e = (IndexOutOfBoundsException)Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.add((byte[])null, (int)-1, (byte)2));
        Assertions.assertEquals((Object)"Index: -1, Length: 0", (Object)e.getMessage());
        byteArray = ArrayUtils.add((byte[])new byte[]{2, 6}, (int)2, (byte)3);
        Assertions.assertArrayEquals((byte[])new byte[]{2, 6, 3}, (byte[])byteArray);
        byteArray = ArrayUtils.add((byte[])new byte[]{2, 6}, (int)0, (byte)1);
        Assertions.assertArrayEquals((byte[])new byte[]{1, 2, 6}, (byte[])byteArray);
        byteArray = ArrayUtils.add((byte[])new byte[]{2, 6, 3}, (int)2, (byte)1);
        Assertions.assertArrayEquals((byte[])new byte[]{2, 6, 1, 3}, (byte[])byteArray);
        e = (IndexOutOfBoundsException)Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.add((byte[])new byte[]{2, 6}, (int)4, (byte)3));
        Assertions.assertEquals((Object)"Index: 4, Length: 2", (Object)e.getMessage());
        e = (IndexOutOfBoundsException)Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.add((byte[])new byte[]{2, 6}, (int)-1, (byte)3));
        Assertions.assertEquals((Object)"Index: -1, Length: 2", (Object)e.getMessage());
        int[] intArray = ArrayUtils.add((int[])new int[]{1}, (int)0, (int)2);
        Assertions.assertArrayEquals((int[])new int[]{2, 1}, (int[])intArray);
        e = (IndexOutOfBoundsException)Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.add((int[])null, (int)-1, (int)2));
        Assertions.assertEquals((Object)"Index: -1, Length: 0", (Object)e.getMessage());
        intArray = ArrayUtils.add((int[])new int[]{2, 6}, (int)2, (int)10);
        Assertions.assertArrayEquals((int[])new int[]{2, 6, 10}, (int[])intArray);
        intArray = ArrayUtils.add((int[])new int[]{2, 6}, (int)0, (int)-4);
        Assertions.assertArrayEquals((int[])new int[]{-4, 2, 6}, (int[])intArray);
        intArray = ArrayUtils.add((int[])new int[]{2, 6, 3}, (int)2, (int)1);
        Assertions.assertArrayEquals((int[])new int[]{2, 6, 1, 3}, (int[])intArray);
        e = (IndexOutOfBoundsException)Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.add((int[])new int[]{2, 6}, (int)4, (int)10));
        Assertions.assertEquals((Object)"Index: 4, Length: 2", (Object)e.getMessage());
        e = (IndexOutOfBoundsException)Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.add((int[])new int[]{2, 6}, (int)-1, (int)10));
        Assertions.assertEquals((Object)"Index: -1, Length: 2", (Object)e.getMessage());
        long[] longArray = ArrayUtils.add((long[])new long[]{1L}, (int)0, (long)2L);
        Assertions.assertArrayEquals((long[])new long[]{2L, 1L}, (long[])longArray);
        e = (IndexOutOfBoundsException)Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.add((long[])null, (int)-1, (long)2L));
        Assertions.assertEquals((Object)"Index: -1, Length: 0", (Object)e.getMessage());
        longArray = ArrayUtils.add((long[])new long[]{2L, 6L}, (int)2, (long)10L);
        Assertions.assertArrayEquals((long[])new long[]{2L, 6L, 10L}, (long[])longArray);
        longArray = ArrayUtils.add((long[])new long[]{2L, 6L}, (int)0, (long)-4L);
        Assertions.assertArrayEquals((long[])new long[]{-4L, 2L, 6L}, (long[])longArray);
        longArray = ArrayUtils.add((long[])new long[]{2L, 6L, 3L}, (int)2, (long)1L);
        Assertions.assertArrayEquals((long[])new long[]{2L, 6L, 1L, 3L}, (long[])longArray);
        e = (IndexOutOfBoundsException)Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.add((long[])new long[]{2L, 6L}, (int)4, (long)10L));
        Assertions.assertEquals((Object)"Index: 4, Length: 2", (Object)e.getMessage());
        e = (IndexOutOfBoundsException)Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.add((long[])new long[]{2L, 6L}, (int)-1, (long)10L));
        Assertions.assertEquals((Object)"Index: -1, Length: 2", (Object)e.getMessage());
        float[] floatArray = ArrayUtils.add((float[])new float[]{1.1f}, (int)0, (float)2.2f);
        Assertions.assertArrayEquals((float[])new float[]{2.2f, 1.1f}, (float[])floatArray);
        e = (IndexOutOfBoundsException)Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.add((float[])null, (int)-1, (float)2.2f));
        Assertions.assertEquals((Object)"Index: -1, Length: 0", (Object)e.getMessage());
        floatArray = ArrayUtils.add((float[])new float[]{2.3f, 6.4f}, (int)2, (float)10.5f);
        Assertions.assertArrayEquals((float[])new float[]{2.3f, 6.4f, 10.5f}, (float[])floatArray);
        floatArray = ArrayUtils.add((float[])new float[]{2.6f, 6.7f}, (int)0, (float)-4.8f);
        Assertions.assertArrayEquals((float[])new float[]{-4.8f, 2.6f, 6.7f}, (float[])floatArray);
        floatArray = ArrayUtils.add((float[])new float[]{2.9f, 6.0f, 0.3f}, (int)2, (float)1.0f);
        Assertions.assertArrayEquals((float[])new float[]{2.9f, 6.0f, 1.0f, 0.3f}, (float[])floatArray);
        e = (IndexOutOfBoundsException)Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.add((float[])new float[]{2.3f, 6.4f}, (int)4, (float)10.5f));
        Assertions.assertEquals((Object)"Index: 4, Length: 2", (Object)e.getMessage());
        e = (IndexOutOfBoundsException)Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.add((float[])new float[]{2.3f, 6.4f}, (int)-1, (float)10.5f));
        Assertions.assertEquals((Object)"Index: -1, Length: 2", (Object)e.getMessage());
        double[] doubleArray = ArrayUtils.add((double[])new double[]{1.1}, (int)0, (double)2.2);
        Assertions.assertArrayEquals((double[])new double[]{2.2, 1.1}, (double[])doubleArray);
        e = (IndexOutOfBoundsException)Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.add(null, (int)-1, (double)2.2));
        Assertions.assertEquals((Object)"Index: -1, Length: 0", (Object)e.getMessage());
        doubleArray = ArrayUtils.add((double[])new double[]{2.3, 6.4}, (int)2, (double)10.5);
        Assertions.assertArrayEquals((double[])new double[]{2.3, 6.4, 10.5}, (double[])doubleArray);
        doubleArray = ArrayUtils.add((double[])new double[]{2.6, 6.7}, (int)0, (double)-4.8);
        Assertions.assertArrayEquals((double[])new double[]{-4.8, 2.6, 6.7}, (double[])doubleArray);
        doubleArray = ArrayUtils.add((double[])new double[]{2.9, 6.0, 0.3}, (int)2, (double)1.0);
        Assertions.assertArrayEquals((double[])new double[]{2.9, 6.0, 1.0, 0.3}, (double[])doubleArray);
        e = (IndexOutOfBoundsException)Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.add((double[])new double[]{2.3, 6.4}, (int)4, (double)10.5));
        Assertions.assertEquals((Object)"Index: 4, Length: 2", (Object)e.getMessage());
        e = (IndexOutOfBoundsException)Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.add((double[])new double[]{2.3, 6.4}, (int)-1, (double)10.5));
        Assertions.assertEquals((Object)"Index: -1, Length: 2", (Object)e.getMessage());
    }

    @Test
    public void testJira567() {
        Number[] n = (Number[])ArrayUtils.addAll((Object[])new Number[]{1}, (Object[])new Long[]{2L});
        Assertions.assertEquals((int)2, (int)n.length);
        Assertions.assertEquals(Number.class, n.getClass().getComponentType());
        Assertions.assertThrows(IllegalArgumentException.class, () -> ArrayUtils.addAll((Object[])new Integer[]{1}, (Object[])new Long[]{2L}));
    }

    @Test
    public void testLANG571() {
        String[] stringArray = null;
        String aString = null;
        Assertions.assertThrows(IllegalArgumentException.class, () -> ArrayUtils.add((Object[])stringArray, (Object)aString));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ArrayUtils.add((Object[])stringArray, (int)0, (Object)aString));
    }
}

