/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.jdbc;

import java.util.Map;
import javax.sql.DataSource;
import org.apache.karaf.jaas.modules.BackingEngine;
import org.apache.karaf.jaas.modules.BackingEngineFactory;
import org.apache.karaf.jaas.modules.JAASUtils;
import org.apache.karaf.jaas.modules.encryption.EncryptionSupport;
import org.apache.karaf.jaas.modules.jdbc.JDBCBackingEngine;
import org.apache.karaf.jaas.modules.jdbc.JDBCLoginModule;
import org.apache.karaf.jaas.modules.jdbc.JDBCUtils;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCBackingEngineFactory
implements BackingEngineFactory {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(JDBCBackingEngineFactory.class);

    @Override
    public BackingEngine build(Map<String, ?> options) {
        JDBCBackingEngine instance = null;
        String datasourceURL = JAASUtils.getString(options, "datasource");
        BundleContext bundleContext = (BundleContext)options.get(BundleContext.class.getName());
        String addUserStatement = JAASUtils.getString(options, "insert.user");
        String addRoleStatement = JAASUtils.getString(options, "insert.role");
        String deleteRoleStatement = JAASUtils.getString(options, "delete.role");
        String deleteAllUserRolesStatement = JAASUtils.getString(options, "delete.roles");
        String deleteUserStatement = JAASUtils.getString(options, "delete.user");
        String selectUsersQuery = JAASUtils.getString(options, "query.user");
        String selectRolesQuery = JAASUtils.getString(options, "query.role");
        try {
            DataSource dataSource = JDBCUtils.createDatasource(bundleContext, datasourceURL);
            EncryptionSupport encryptionSupport = new EncryptionSupport(options);
            instance = new JDBCBackingEngine(dataSource, encryptionSupport);
            if (addUserStatement != null) {
                instance.setAddUserStatement(addUserStatement);
            }
            if (addRoleStatement != null) {
                instance.setAddRoleStatement(addRoleStatement);
            }
            if (deleteRoleStatement != null) {
                instance.setDeleteRoleStatement(deleteRoleStatement);
            }
            if (deleteAllUserRolesStatement != null) {
                instance.setDeleteAllUserRolesStatement(deleteAllUserRolesStatement);
            }
            if (deleteUserStatement != null) {
                instance.setDeleteUserStatement(deleteUserStatement);
            }
            if (selectUsersQuery != null) {
                instance.setSelectUsersQuery(selectUsersQuery);
            }
            if (selectRolesQuery != null) {
                instance.setSelectRolesQuery(selectRolesQuery);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error creating JDBCBackingEngine.", (Throwable)e);
        }
        return instance;
    }

    @Override
    public String getModuleClass() {
        return JDBCLoginModule.class.getName();
    }
}

