/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ks_Deva extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_DE = "जर्मन";
        final Object[][] data = new Object[][] {
            { "BR", "ब्राज़ील" },
            { "CN", "चीन" },
            { "DE", metaValue_DE },
            { "FR", "फ्रांस" },
            { "GB", "मुतहीद बादशाहत" },
            { "IN", "हिंदोस्तान" },
            { "IT", "इटली" },
            { "JP", "जापान" },
            { "RU", "रूस" },
            { "US", "मूतहीद रियासत" },
            { "ZZ", "नामोलुम अलाक़" },
            { "de", metaValue_DE },
            { "en", "अंगरिज़ी" },
            { "es", "हसपानवी" },
            { "fr", "फ्रांसीसी" },
            { "it", "इतालवी" },
            { "ja", "जापानी" },
            { "ks", "कॉशुर" },
            { "pt", "पुरतउगाली" },
            { "ru", "रूसी" },
            { "zh", "चीनी (तरजुम इशार: खास तोर, मैन्डरिन चीनी।)" },
            { "und", "नामोलुम ज़बान" },
            { "Arab", "अरबी" },
            { "Cyrl", "सिरिलिक" },
            { "Deva", "देवनागरी" },
            { "Hans", "आसान (तरजुम इशार: स्क्रिप्ट नवुक यि वर्ज़न छु चीनी बापथ ज़बान नाव किस मुरकब कि इस्तिमल करान।)" },
            { "Hant", "रिवायाती (तरजुम इशार: स्क्रिप्ट नवुक यि वर्ज़न छु चीनी बापथ ज़बान नाव किस मुरकब कि इस्तिमल करान।)" },
            { "Latn", "लातिनी" },
            { "Zxxx", "गेर तहरीर" },
            { "Zzzz", "गेर तहरीर स्क्रिप्ट" },
            { "de_AT", "आस्ट्रियन जर्मन" },
            { "de_CH", "स्विस हाई जर्मन" },
            { "en_AU", "आसट्रेलवी अंगरिज़ी" },
            { "en_CA", "कनाडियन अंगरिज़ी" },
            { "en_GB", "बरतानवी अंगरिज़ी" },
            { "en_US", "अमरीकी अंगरिज़ी" },
            { "es_ES", "यूरपी हसपानवी" },
            { "es_MX", "मेकसिकी हसपानवी" },
            { "fr_CA", "कनाडियन फ्रांसीसी" },
            { "fr_CH", "स्विस फ्रांसीसी" },
            { "pt_BR", "ब्राज़िली पुरतउगाली" },
            { "pt_PT", "यूरपी पुरतउगाली" },
            { "es_419", "लातिनी अमरीकी हसपानवी" },
            { "zh_Hans", "आसान चीनी" },
            { "zh_Hant", "रिवायाती चीनी" },
            { "type.nu.arab", "अरबी-इंडिक हिंदसी" },
            { "type.nu.deva", "देवनागरी हिंदसि" },
            { "type.nu.latn", "यूरपी हिंदसी" },
            { "type.nu.arabext", "तोसी शुद अरबी-इंडिक हिंदसी" },
            { "type.co.standard", "मियारी तरतीब ऑर्डर" },
            { "type.ca.gregorian", "ग्रिगोरियन कैलंडर" },
        };
        return data;
    }
}
