/*
 * MOTIS API
 *
 * This is the MOTIS routing API.  Overview of MOTIS API versions:  MOTIS 0.x - deprecated/discontinued  MOTIS 2.x - current, providing:  * /api/v5/{plan,trip,stoptimes,map/trips} renamed METRO mode to SUBURBAN, AREAL_LIFT to AERIAL_LIFT; since MOTIS 2.5.0 * /api/v4/{plan,trip,stoptimes,map/trips} new displayName property, routeShortName only contains actual route short name from source; since MOTIS 2.2.0 * /api/v3/plan with correct maxTransfers API parameter (transfers actually corresponding to number of changes between transit legs (and not to number of transit legs), i.e. maxTransfers=0 returns direct public transit connections, as expected); since MOTIS 2.0.84  * /api/v2/{plan,trip} returns Google polylines with precision=6; since MOTIS 2.0.60 * /api/v1/{plan,trip} returns Google polylines with precision=7 (not defined for |longitude|>107) * /api/v1/_* all other endpoints  If you use the JS client lib https://www.npmjs.com/package/@motis-project/motis-client, endpoint versions will be taken into account automatically (i.e. the newest one available will be used). 
 *
 * The version of the OpenAPI document: v5
 * Contact: felix@triptix.tech
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct RentalStation {
    /// Unique identifier of the rental station
    #[serde(rename = "id")]
    pub id: String,
    /// Unique identifier of the rental provider
    #[serde(rename = "providerId")]
    pub provider_id: String,
    /// Unique identifier of the rental provider group
    #[serde(rename = "providerGroupId")]
    pub provider_group_id: String,
    /// Public name of the station
    #[serde(rename = "name")]
    pub name: String,
    /// latitude
    #[serde(rename = "lat")]
    pub lat: f64,
    /// longitude
    #[serde(rename = "lon")]
    pub lon: f64,
    /// Address where the station is located
    #[serde(rename = "address", skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
    /// Cross street or landmark where the station is located
    #[serde(rename = "crossStreet", skip_serializing_if = "Option::is_none")]
    pub cross_street: Option<String>,
    /// Rental URI for Android (deep link to the specific station)
    #[serde(rename = "rentalUriAndroid", skip_serializing_if = "Option::is_none")]
    pub rental_uri_android: Option<String>,
    /// Rental URI for iOS (deep link to the specific station)
    #[serde(rename = "rentalUriIOS", skip_serializing_if = "Option::is_none")]
    pub rental_uri_ios: Option<String>,
    /// Rental URI for web (deep link to the specific station)
    #[serde(rename = "rentalUriWeb", skip_serializing_if = "Option::is_none")]
    pub rental_uri_web: Option<String>,
    /// true if vehicles can be rented from this station, false if it is temporarily out of service
    #[serde(rename = "isRenting")]
    pub is_renting: bool,
    /// true if vehicles can be returned to this station, false if it is temporarily out of service
    #[serde(rename = "isReturning")]
    pub is_returning: bool,
    /// Number of vehicles available for rental at this station
    #[serde(rename = "numVehiclesAvailable")]
    pub num_vehicles_available: i32,
    /// List of form factors available for rental and/or return at this station
    #[serde(rename = "formFactors")]
    pub form_factors: Vec<models::RentalFormFactor>,
    /// List of vehicle types currently available at this station (vehicle type ID -> count)
    #[serde(rename = "vehicleTypesAvailable")]
    pub vehicle_types_available: std::collections::HashMap<String, i32>,
    /// List of vehicle docks currently available at this station (vehicle type ID -> count)
    #[serde(rename = "vehicleDocksAvailable")]
    pub vehicle_docks_available: std::collections::HashMap<String, i32>,
    /// A multi-polygon contains a number of polygons, each containing a number of rings, which are encoded as polylines (with precision 6).  For each polygon, the first ring is the outer ring, all subsequent rings are inner rings (holes). 
    #[serde(rename = "stationArea", skip_serializing_if = "Option::is_none")]
    pub station_area: Option<Vec<Vec<models::EncodedPolyline>>>,
    /// Bounding box of the area covered by this station, [west, south, east, north] as [lon, lat, lon, lat] 
    #[serde(rename = "bbox")]
    pub bbox: Vec<f64>,
}

impl RentalStation {
    pub fn new(id: String, provider_id: String, provider_group_id: String, name: String, lat: f64, lon: f64, is_renting: bool, is_returning: bool, num_vehicles_available: i32, form_factors: Vec<models::RentalFormFactor>, vehicle_types_available: std::collections::HashMap<String, i32>, vehicle_docks_available: std::collections::HashMap<String, i32>, bbox: Vec<f64>) -> RentalStation {
        RentalStation {
            id,
            provider_id,
            provider_group_id,
            name,
            lat,
            lon,
            address: None,
            cross_street: None,
            rental_uri_android: None,
            rental_uri_ios: None,
            rental_uri_web: None,
            is_renting,
            is_returning,
            num_vehicles_available,
            form_factors,
            vehicle_types_available,
            vehicle_docks_available,
            station_area: None,
            bbox,
        }
    }
}

