/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.retention;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ThreadedActionListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.action.util.QueryPage;
import org.elasticsearch.xpack.core.common.time.TimeUtils;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.ml.job.persistence.JobDataDeleter;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;
import org.elasticsearch.xpack.ml.job.retention.AbstractExpiredJobDataRemover;
import org.elasticsearch.xpack.ml.notifications.AnomalyDetectionAuditor;
import org.elasticsearch.xpack.ml.utils.MlIndicesUtils;

public class ExpiredModelSnapshotsRemover
extends AbstractExpiredJobDataRemover {
    private static final Logger LOGGER = LogManager.getLogger(ExpiredModelSnapshotsRemover.class);
    private static final long MS_IN_ONE_DAY = TimeValue.timeValueDays((long)1L).getMillis();
    private static final int MODEL_SNAPSHOT_SEARCH_SIZE = 10000;
    private final ThreadPool threadPool;
    private final JobResultsProvider jobResultsProvider;
    private final AnomalyDetectionAuditor auditor;

    public ExpiredModelSnapshotsRemover(OriginSettingClient client, Iterator<Job> jobIterator, ThreadPool threadPool, TaskId parentTaskId, JobResultsProvider jobResultsProvider, AnomalyDetectionAuditor auditor) {
        super(client, jobIterator, parentTaskId);
        this.threadPool = Objects.requireNonNull(threadPool);
        this.jobResultsProvider = jobResultsProvider;
        this.auditor = auditor;
    }

    @Override
    Long getRetentionDays(Job job) {
        Long retentionDaysForConsideration = job.getDailyModelSnapshotRetentionAfterDays();
        if (retentionDaysForConsideration == null) {
            retentionDaysForConsideration = job.getModelSnapshotRetentionDays();
        }
        return retentionDaysForConsideration;
    }

    @Override
    void calcCutoffEpochMs(String jobId, long retentionDays, ActionListener<AbstractExpiredJobDataRemover.CutoffDetails> listener) {
        this.latestSnapshotTimeStamp(jobId, (ActionListener<Long>)listener.delegateFailureAndWrap((l, latestTime) -> {
            ThreadedActionListener threadedActionListener = new ThreadedActionListener((Executor)this.threadPool.executor("ml_utility"), l);
            if (latestTime == null) {
                threadedActionListener.onResponse(null);
            } else {
                long cutoff = latestTime - new TimeValue(retentionDays, TimeUnit.DAYS).getMillis();
                threadedActionListener.onResponse((Object)new AbstractExpiredJobDataRemover.CutoffDetails((long)latestTime, cutoff));
            }
        }));
    }

    private void latestSnapshotTimeStamp(String jobId, ActionListener<Long> listener) {
        SortBuilder sortBuilder = new FieldSortBuilder(ModelSnapshot.TIMESTAMP.getPreferredName()).order(SortOrder.DESC);
        BoolQueryBuilder snapshotQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.existsQuery((String)ModelSnapshot.SNAPSHOT_DOC_COUNT.getPreferredName())).filter((QueryBuilder)QueryBuilders.existsQuery((String)ModelSnapshot.TIMESTAMP.getPreferredName()));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.sort(sortBuilder);
        searchSourceBuilder.query((QueryBuilder)snapshotQuery);
        searchSourceBuilder.size(1);
        searchSourceBuilder.trackTotalHits(false);
        searchSourceBuilder.fetchSource(false);
        searchSourceBuilder.docValueField(ModelSnapshot.TIMESTAMP.getPreferredName(), "epoch_millis");
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId);
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        searchRequest.source(searchSourceBuilder);
        searchRequest.indicesOptions(MlIndicesUtils.addIgnoreUnavailable(SearchRequest.DEFAULT_INDICES_OPTIONS));
        searchRequest.setParentTask(this.getParentTaskId());
        this.client.search(searchRequest, listener.delegateFailureAndWrap((delegate, response) -> {
            SearchHit[] hits = response.getHits().getHits();
            if (hits.length == 0) {
                delegate.onResponse(null);
            } else {
                String timestamp = this.stringFieldValueOrNull(hits[0], ModelSnapshot.TIMESTAMP.getPreferredName());
                if (timestamp == null) {
                    LOGGER.warn("Model snapshot document [{}] has a null timestamp field", (Object)hits[0].getId());
                    delegate.onResponse(null);
                } else {
                    long timestampMs = TimeUtils.parseToEpochMs((String)timestamp);
                    delegate.onResponse((Object)timestampMs);
                }
            }
        }));
    }

    @Override
    protected void removeDataBefore(Job job, float requestsPerSec, long latestTimeMs, long cutoffEpochMs, ActionListener<Boolean> listener) {
        if (job.getModelSnapshotId() == null) {
            listener.onResponse((Object)true);
            return;
        }
        LOGGER.debug(() -> Strings.format((String)"Considering model snapshots of job [%s] that have a timestamp before [%s] for removal", (Object[])new Object[]{job.getId(), cutoffEpochMs}));
        long deleteAllBeforeMs = job.getModelSnapshotRetentionDays() == null ? 0L : latestTimeMs - TimeValue.timeValueDays((long)job.getModelSnapshotRetentionDays()).getMillis();
        ActionListener<QueryPage<ModelSnapshot>> snapshotsListener = this.expiredSnapshotsListener(job, deleteAllBeforeMs, listener);
        this.jobResultsProvider.modelSnapshots(job.getId(), 0, 10000, null, String.valueOf(cutoffEpochMs), ModelSnapshot.TIMESTAMP.getPreferredName(), false, null, null, arg_0 -> snapshotsListener.onResponse(arg_0), arg_0 -> snapshotsListener.onFailure(arg_0));
    }

    private ActionListener<QueryPage<ModelSnapshot>> expiredSnapshotsListener(final Job job, final long deleteAllBeforeMs, final ActionListener<Boolean> listener) {
        return new ActionListener<QueryPage<ModelSnapshot>>(){

            public void onResponse(QueryPage<ModelSnapshot> searchResponse) {
                long nextToKeepMs = deleteAllBeforeMs;
                try {
                    ArrayList<ModelSnapshot> snapshots = new ArrayList<ModelSnapshot>();
                    for (ModelSnapshot snapshot : searchResponse.results()) {
                        if (snapshot.getSnapshotId().equals(job.getModelSnapshotId()) || snapshot.isRetain()) continue;
                        if (snapshot.getTimestamp() == null) {
                            LOGGER.warn("Model snapshot document [{}] has a null timestamp field", (Object)snapshot.getSnapshotId());
                            continue;
                        }
                        long timestampMs = snapshot.getTimestamp().getTime();
                        if (timestampMs >= nextToKeepMs) {
                            while (timestampMs >= (nextToKeepMs += MS_IN_ONE_DAY)) {
                            }
                            continue;
                        }
                        snapshots.add(snapshot);
                    }
                    ExpiredModelSnapshotsRemover.this.deleteModelSnapshots(snapshots, job.getId(), (ActionListener<Boolean>)listener);
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure((Exception)new ElasticsearchStatusException("[{}] Search for expired snapshots failed", RestStatus.TOO_MANY_REQUESTS, (Throwable)e, new Object[]{job.getId()}));
            }
        };
    }

    private void deleteModelSnapshots(List<ModelSnapshot> modelSnapshots, String jobId, ActionListener<Boolean> listener) {
        if (modelSnapshots.isEmpty()) {
            listener.onResponse((Object)true);
            return;
        }
        JobDataDeleter deleter = new JobDataDeleter((Client)this.client, jobId);
        deleter.deleteModelSnapshots(modelSnapshots, (ActionListener<BulkByScrollResponse>)listener.delegateFailureAndWrap((l, bulkResponse) -> {
            this.auditor.info(jobId, Messages.getMessage((String)"[{0}] expired model snapshots deleted", (Object[])new Object[]{modelSnapshots.size()}));
            LOGGER.debug(() -> Strings.format((String)"[%s] deleted model snapshots %s with descriptions %s", (Object[])new Object[]{jobId, modelSnapshots.stream().map(ModelSnapshot::getSnapshotId).collect(Collectors.toList()), modelSnapshots.stream().map(ModelSnapshot::getDescription).collect(Collectors.toList())}));
            l.onResponse((Object)true);
        }));
    }
}

