/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.categorization;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.charfilter.BaseCharFilter;

public class FirstLineWithLettersCharFilter
extends BaseCharFilter {
    public static final String NAME = "first_line_with_letters";
    private Reader transformedInput;

    FirstLineWithLettersCharFilter(Reader in) {
        super(in);
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.transformedInput == null) {
            this.fill();
        }
        return this.transformedInput.read(cbuf, off, len);
    }

    public int read() throws IOException {
        if (this.transformedInput == null) {
            this.fill();
        }
        return this.transformedInput.read();
    }

    private void fill() throws IOException {
        StringBuilder buffered = new StringBuilder();
        char[] temp = new char[1024];
        int cnt = this.input.read(temp);
        while (cnt > 0) {
            buffered.append(temp, 0, cnt);
            cnt = this.input.read(temp);
        }
        this.transformedInput = new StringReader(this.process(buffered).toString());
    }

    private CharSequence process(CharSequence input) {
        boolean seenLetter = false;
        int prevNewlineIndex = -1;
        int endIndex = -1;
        for (int index = 0; index < input.length(); ++index) {
            if (input.charAt(index) == '\n') {
                if (seenLetter) {
                    endIndex = input.charAt(index - 1) == '\r' ? index - 1 : index;
                    break;
                }
                prevNewlineIndex = index;
                continue;
            }
            seenLetter = seenLetter || Character.isLetter(input.charAt(index));
        }
        if (!seenLetter) {
            return "";
        }
        if (endIndex == -1) {
            if (prevNewlineIndex == -1) {
                return input;
            }
            endIndex = input.length();
        }
        this.addOffCorrectMap(0, prevNewlineIndex + 1);
        if (endIndex < input.length()) {
            this.addOffCorrectMap(endIndex - prevNewlineIndex - 1, input.length() - endIndex + prevNewlineIndex + 1);
        }
        return input.subSequence(prevNewlineIndex + 1, endIndex);
    }
}

