/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.pytorch;

import java.util.concurrent.PriorityBlockingQueue;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.xpack.ml.job.process.AbstractInitializableRunnable;
import org.elasticsearch.xpack.ml.job.process.AbstractProcessWorkerExecutorService;

public class PriorityProcessWorkerExecutorService
extends AbstractProcessWorkerExecutorService<OrderedRunnable> {
    private final int queueCapacity;

    @SuppressForbidden(reason="properly rethrowing errors, see EsExecutors.rethrowErrors")
    public PriorityProcessWorkerExecutorService(ThreadContext contextHolder, String processName, int queueCapacity) {
        super(contextHolder, processName, queueCapacity, PriorityBlockingQueue::new);
        this.queueCapacity = queueCapacity;
    }

    public synchronized void executeWithPriority(AbstractInitializableRunnable command, RequestPriority priority, long tieBreaker) {
        command.init();
        if (this.isShutdown()) {
            EsRejectedExecutionException rejected = new EsRejectedExecutionException(this.processName + " worker service has shutdown", true);
            command.onRejection((Exception)((Object)rejected));
            this.notifyQueueRunnables();
            return;
        }
        if (this.queue.size() >= this.queueCapacity && priority != RequestPriority.HIGHEST) {
            command.onRejection((Exception)((Object)new EsRejectedExecutionException(this.processName + " queue is full. Unable to execute command", false)));
            return;
        }
        this.queue.offer(new OrderedRunnable(priority, tieBreaker, this.contextHolder.preserveContext((Runnable)((Object)command))));
        if (this.isShutdown()) {
            this.notifyQueueRunnables();
        }
    }

    @Override
    public synchronized void execute(Runnable command) {
        throw new UnsupportedOperationException("use executeWithPriority");
    }

    public static enum RequestPriority {
        HIGHEST,
        HIGH,
        NORMAL;

    }

    public record OrderedRunnable(RequestPriority priority, long tieBreaker, Runnable runnable) implements Comparable<OrderedRunnable>,
    Runnable
    {
        @Override
        public int compareTo(OrderedRunnable o) {
            int p = this.priority.compareTo(o.priority);
            if (p == 0) {
                return (int)(this.tieBreaker - o.tieBreaker);
            }
            return p;
        }

        @Override
        public void run() {
            this.runnable.run();
        }
    }
}

