/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ParentTaskAssigningClient;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.license.RemoteClusterLicenseChecker;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedJobValidator;
import org.elasticsearch.xpack.core.ml.job.config.DataDescription;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.action.TransportStartDatafeedAction;
import org.elasticsearch.xpack.ml.annotations.AnnotationPersister;
import org.elasticsearch.xpack.ml.datafeed.DatafeedContext;
import org.elasticsearch.xpack.ml.datafeed.DatafeedJob;
import org.elasticsearch.xpack.ml.datafeed.DatafeedTimingStatsReporter;
import org.elasticsearch.xpack.ml.datafeed.delayeddatacheck.DelayedDataDetector;
import org.elasticsearch.xpack.ml.datafeed.delayeddatacheck.DelayedDataDetectorFactory;
import org.elasticsearch.xpack.ml.datafeed.extractor.DataExtractorFactory;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsPersister;
import org.elasticsearch.xpack.ml.notifications.AnomalyDetectionAuditor;

public class DatafeedJobBuilder {
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;
    private final AnomalyDetectionAuditor auditor;
    private final AnnotationPersister annotationPersister;
    private final Supplier<Long> currentTimeSupplier;
    private final JobResultsPersister jobResultsPersister;
    private final boolean remoteClusterClient;
    private final ClusterService clusterService;
    private volatile long delayedDataCheckFreq;

    public DatafeedJobBuilder(Client client, NamedXContentRegistry xContentRegistry, AnomalyDetectionAuditor auditor, AnnotationPersister annotationPersister, Supplier<Long> currentTimeSupplier, JobResultsPersister jobResultsPersister, Settings settings, ClusterService clusterService) {
        this.client = client;
        this.xContentRegistry = Objects.requireNonNull(xContentRegistry);
        this.auditor = Objects.requireNonNull(auditor);
        this.annotationPersister = Objects.requireNonNull(annotationPersister);
        this.currentTimeSupplier = Objects.requireNonNull(currentTimeSupplier);
        this.jobResultsPersister = Objects.requireNonNull(jobResultsPersister);
        this.remoteClusterClient = DiscoveryNode.isRemoteClusterClient((Settings)settings);
        this.delayedDataCheckFreq = ((TimeValue)MachineLearning.DELAYED_DATA_CHECK_FREQ.get(settings)).millis();
        this.clusterService = Objects.requireNonNull(clusterService);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.DELAYED_DATA_CHECK_FREQ, this::setDelayedDataCheckFreq);
    }

    private void setDelayedDataCheckFreq(TimeValue value) {
        this.delayedDataCheckFreq = value.millis();
    }

    void build(TransportStartDatafeedAction.DatafeedTask task, DatafeedContext context, ActionListener<DatafeedJob> listener) {
        ParentTaskAssigningClient parentTaskAssigningClient = new ParentTaskAssigningClient(this.client, this.clusterService.localNode(), (Task)task);
        DatafeedConfig datafeedConfig = context.datafeedConfig();
        Job job = context.job();
        long latestFinalBucketEndMs = context.restartTimeInfo().getLatestFinalBucketTimeMs() == null ? -1L : context.restartTimeInfo().getLatestFinalBucketTimeMs() + job.getAnalysisConfig().getBucketSpan().millis() - 1L;
        long latestRecordTimeMs = context.restartTimeInfo().getLatestRecordTimeMs() == null ? -1L : context.restartTimeInfo().getLatestRecordTimeMs();
        DatafeedTimingStatsReporter timingStatsReporter = new DatafeedTimingStatsReporter(context.timingStats(), this.jobResultsPersister::persistDatafeedTimingStats);
        try {
            this.checkRemoteIndicesAreAvailable(datafeedConfig);
        }
        catch (Exception e2) {
            listener.onFailure(e2);
            return;
        }
        try {
            DatafeedJobValidator.validate((DatafeedConfig)datafeedConfig, (Job)job, (NamedXContentRegistry)this.xContentRegistry);
        }
        catch (Exception e3) {
            listener.onFailure(e3);
            return;
        }
        ActionListener dataExtractorFactoryHandler = ActionListener.wrap(dataExtractorFactory -> {
            TimeValue frequency = DatafeedJobBuilder.getFrequencyOrDefault(datafeedConfig, job, this.xContentRegistry);
            TimeValue queryDelay = datafeedConfig.getQueryDelay();
            DelayedDataDetector delayedDataDetector = DelayedDataDetectorFactory.buildDetector(job, datafeedConfig, (Client)parentTaskAssigningClient, this.xContentRegistry);
            DatafeedJob datafeedJob = new DatafeedJob(job.getId(), DatafeedJobBuilder.buildDataDescription(job), frequency.millis(), queryDelay.millis(), (DataExtractorFactory)dataExtractorFactory, timingStatsReporter, (Client)parentTaskAssigningClient, this.auditor, this.annotationPersister, this.currentTimeSupplier, delayedDataDetector, datafeedConfig.getMaxEmptySearches(), latestFinalBucketEndMs, latestRecordTimeMs, context.restartTimeInfo().haveSeenDataPreviously(), this.delayedDataCheckFreq);
            listener.onResponse((Object)datafeedJob);
        }, e -> {
            this.auditor.error(job.getId(), e.getMessage());
            listener.onFailure(e);
        });
        DataExtractorFactory.create((Client)parentTaskAssigningClient, datafeedConfig, job, this.xContentRegistry, timingStatsReporter, (ActionListener<DataExtractorFactory>)dataExtractorFactoryHandler);
    }

    private void checkRemoteIndicesAreAvailable(DatafeedConfig datafeedConfig) {
        List remoteIndices;
        if (!this.remoteClusterClient && !(remoteIndices = RemoteClusterLicenseChecker.remoteIndices((Collection)datafeedConfig.getIndices())).isEmpty()) {
            throw ExceptionsHelper.badRequestException((String)Messages.getMessage((String)"Datafeed [{0}] is configured with a remote index pattern(s) {1} but the current node [{2}] is not allowed to connect to remote clusters. Please enable node.remote_cluster_client for all machine learning nodes and master-eligible nodes.", (Object[])new Object[]{datafeedConfig.getId(), remoteIndices, this.clusterService.getNodeName()}), (Object[])new Object[0]);
        }
    }

    private static TimeValue getFrequencyOrDefault(DatafeedConfig datafeed, Job job, NamedXContentRegistry xContentRegistry) {
        TimeValue frequency = datafeed.getFrequency();
        if (frequency == null) {
            TimeValue bucketSpan = job.getAnalysisConfig().getBucketSpan();
            return datafeed.defaultFrequency(bucketSpan, xContentRegistry);
        }
        return frequency;
    }

    private static DataDescription buildDataDescription(Job job) {
        DataDescription.Builder dataDescription = new DataDescription.Builder();
        if (job.getDataDescription() != null) {
            dataDescription.setTimeField(job.getDataDescription().getTimeField());
        }
        dataDescription.setTimeFormat("epoch_ms");
        return dataDescription.build();
    }
}

