/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml;

import java.util.ArrayList;
import java.util.Arrays;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequestBuilder;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.elasticsearch.action.admin.indices.rollover.RolloverRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.utils.MlIndexAndAlias;
import org.elasticsearch.xpack.core.ml.utils.MlStrings;
import org.elasticsearch.xpack.ml.MlAutoUpdateService;

public class MlAnomaliesIndexUpdate
implements MlAutoUpdateService.UpdateAction {
    private static final Logger logger = LogManager.getLogger(MlAnomaliesIndexUpdate.class);
    private final IndexNameExpressionResolver expressionResolver;
    private final OriginSettingClient client;

    public MlAnomaliesIndexUpdate(IndexNameExpressionResolver expressionResolver, Client client) {
        this.expressionResolver = expressionResolver;
        this.client = new OriginSettingClient(client, "ml");
    }

    @Override
    public boolean isMinTransportVersionSupported(TransportVersion minTransportVersion) {
        return minTransportVersion.onOrAfter((VersionId)TransportVersions.ML_ROLLOVER_LEGACY_INDICES);
    }

    @Override
    public boolean isAbleToRun(ClusterState latestState) {
        String[] indices;
        for (String index : indices = this.expressionResolver.concreteIndexNames(latestState, IndicesOptions.lenientExpandOpenHidden(), new String[]{AnomalyDetectorsIndex.jobResultsIndexPattern()})) {
            IndexRoutingTable routingTable = latestState.getRoutingTable().index(index);
            if (routingTable != null && routingTable.allPrimaryShardsActive()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getName() {
        return "ml_anomalies_index_update";
    }

    @Override
    public void runUpdate(ClusterState latestState) {
        String[] indices;
        ArrayList<ElasticsearchStatusException> failures = new ArrayList<ElasticsearchStatusException>();
        for (String index : indices = this.expressionResolver.concreteIndexNames(latestState, IndicesOptions.lenientExpandOpenHidden(), new String[]{AnomalyDetectorsIndex.jobResultsIndexPattern()})) {
            boolean isCompatibleIndexVersion = MlIndexAndAlias.indexIsReadWriteCompatibleInV9((IndexVersion)latestState.metadata().index(index).getCreationVersion());
            if (isCompatibleIndexVersion) continue;
            String latestIndex = MlAnomaliesIndexUpdate.latestIndexMatchingBaseName(index, this.expressionResolver, latestState);
            if (!index.equals(latestIndex)) {
                logger.debug("index [{}] will not be rolled over as there is a later index [{}]", new Object[]{index, latestIndex});
                continue;
            }
            PlainActionFuture updated = new PlainActionFuture();
            this.rollAndUpdateAliases(latestState, index, (ActionListener<Boolean>)updated);
            try {
                updated.actionGet();
            }
            catch (Exception ex) {
                String message = "failed rolling over legacy ml anomalies index [" + index + "]";
                logger.warn(message, (Throwable)ex);
                if (ex instanceof ElasticsearchException) {
                    ElasticsearchException elasticsearchException = (ElasticsearchException)ex;
                    failures.add(new ElasticsearchStatusException(message, elasticsearchException.status(), (Throwable)elasticsearchException, new Object[0]));
                    break;
                }
                failures.add(new ElasticsearchStatusException(message, RestStatus.REQUEST_TIMEOUT, (Throwable)ex, new Object[0]));
                break;
            }
        }
        if (failures.isEmpty()) {
            logger.info("legacy ml anomalies indices rolled over and aliases updated");
            return;
        }
        ElasticsearchStatusException exception = new ElasticsearchStatusException("failed to roll over legacy ml anomalies", RestStatus.CONFLICT, new Object[0]);
        failures.forEach(arg_0 -> exception.addSuppressed(arg_0));
        throw exception;
    }

    private void rollAndUpdateAliases(ClusterState clusterState, String index, ActionListener<Boolean> listener) {
        String rolloverAlias = index + ".rollover_alias";
        String newIndexName = MlIndexAndAlias.has6DigitSuffix((String)index) ? null : index + "-000001";
        IndicesAliasesRequestBuilder aliasRequestBuilder = this.client.admin().indices().prepareAliases();
        SubscribableListener.newForked(l -> this.createAliasForRollover(index, rolloverAlias, (ActionListener<IndicesAliasesResponse>)l.map(AcknowledgedResponse::isAcknowledged))).andThen((l, success) -> this.rollover(rolloverAlias, newIndexName, (ActionListener<String>)l)).andThen((l, newIndexNameResponse) -> {
            this.addIndexAliasesRequests(aliasRequestBuilder, index, (String)newIndexNameResponse, clusterState);
            aliasRequestBuilder.removeAlias(newIndexNameResponse, rolloverAlias);
            this.updateAliases(aliasRequestBuilder, (ActionListener<Boolean>)l);
        }).addListener(listener);
    }

    private void rollover(String alias, @Nullable String newIndexName, ActionListener<String> listener) {
        this.client.admin().indices().rolloverIndex(new RolloverRequest(alias, newIndexName), ActionListener.wrap(response -> listener.onResponse((Object)response.getNewIndex()), e -> {
            if (e instanceof ResourceAlreadyExistsException) {
                ResourceAlreadyExistsException alreadyExistsException = (ResourceAlreadyExistsException)e;
                listener.onResponse((Object)alreadyExistsException.getIndex().getName());
            } else {
                listener.onFailure(e);
            }
        }));
    }

    private void createAliasForRollover(String indexName, String aliasName, ActionListener<IndicesAliasesResponse> listener) {
        logger.info("creating alias for rollover [{}]", new Object[]{aliasName});
        this.client.admin().indices().prepareAliases().addAliasAction(IndicesAliasesRequest.AliasActions.add().index(indexName).alias(aliasName).isHidden(Boolean.valueOf(true))).execute(listener);
    }

    private void updateAliases(IndicesAliasesRequestBuilder request, ActionListener<Boolean> listener) {
        request.execute(listener.delegateFailure((l, response) -> l.onResponse((Object)Boolean.TRUE)));
    }

    IndicesAliasesRequestBuilder addIndexAliasesRequests(IndicesAliasesRequestBuilder aliasRequestBuilder, String oldIndex, String newIndex, ClusterState clusterState) {
        IndexMetadata meta = clusterState.metadata().index(oldIndex);
        assert (meta != null);
        if (meta == null) {
            return aliasRequestBuilder;
        }
        for (AliasMetadata alias : meta.getAliases().values()) {
            if (MlAnomaliesIndexUpdate.isAnomaliesWriteAlias(alias.alias())) {
                aliasRequestBuilder.addAliasAction(IndicesAliasesRequest.AliasActions.add().index(newIndex).alias(alias.alias()).isHidden(Boolean.valueOf(true)).writeIndex(Boolean.valueOf(true)));
                aliasRequestBuilder.addAliasAction(IndicesAliasesRequest.AliasActions.remove().index(oldIndex).alias(alias.alias()));
                continue;
            }
            if (!MlAnomaliesIndexUpdate.isAnomaliesReadAlias(alias.alias())) continue;
            String jobId = AnomalyDetectorsIndex.jobIdFromAlias((String)alias.alias());
            aliasRequestBuilder.addAliasAction(IndicesAliasesRequest.AliasActions.add().index(newIndex).alias(alias.alias()).isHidden(Boolean.valueOf(true)).filter((QueryBuilder)QueryBuilders.termQuery((String)Job.ID.getPreferredName(), (String)jobId)));
        }
        return aliasRequestBuilder;
    }

    static boolean isAnomaliesWriteAlias(String aliasName) {
        return aliasName.startsWith(".ml-anomalies-.write-");
    }

    static boolean isAnomaliesReadAlias(String aliasName) {
        if (!aliasName.startsWith(".ml-anomalies-")) {
            return false;
        }
        String jobIdPart = aliasName.substring(".ml-anomalies-".length());
        return MlStrings.isValidId((String)jobIdPart);
    }

    static String latestIndexMatchingBaseName(String index, IndexNameExpressionResolver expressionResolver, ClusterState latestState) {
        String baseIndexName = MlIndexAndAlias.has6DigitSuffix((String)index) ? index.substring(0, index.length() - "-000001".length()) : index;
        String[] matching = expressionResolver.concreteIndexNames(latestState, IndicesOptions.lenientExpandOpenHidden(), new String[]{baseIndexName + "*"});
        assert (matching.length > 0) : "No indices matching [" + baseIndexName + "*]";
        if (matching.length == 0) {
            return index;
        }
        String[] filtered = (String[])Arrays.stream(matching).filter(i -> i.equals(index) || MlIndexAndAlias.has6DigitSuffix((String)i) && i.length() == baseIndexName.length() + "-000001".length()).toArray(String[]::new);
        return MlIndexAndAlias.latestIndex((String[])filtered);
    }
}

