/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.entitlement.runtime.policy;

import org.elasticsearch.entitlement.runtime.policy.PolicyValidationException;
import org.elasticsearch.xcontent.XContentLocation;

public class PolicyParserException
extends RuntimeException {
    public static PolicyParserException newPolicyParserException(XContentLocation location, String policyName, String message) {
        return new PolicyParserException("[" + location.lineNumber() + ":" + location.columnNumber() + "] policy parsing error for [" + policyName + "]: " + message);
    }

    public static PolicyParserException newPolicyParserException(XContentLocation location, String policyName, String scopeName, String message) {
        if (scopeName == null) {
            return new PolicyParserException("[" + location.lineNumber() + ":" + location.columnNumber() + "] policy parsing error for [" + policyName + "]: " + message);
        }
        return new PolicyParserException("[" + location.lineNumber() + ":" + location.columnNumber() + "] policy parsing error for [" + policyName + "] in scope [" + scopeName + "]: " + message);
    }

    public static PolicyParserException newPolicyParserException(XContentLocation location, String policyName, String scopeName, String entitlementType, String message) {
        if (scopeName == null) {
            return new PolicyParserException("[" + location.lineNumber() + ":" + location.columnNumber() + "] policy parsing error for [" + policyName + "] for entitlement type [" + entitlementType + "]: " + message);
        }
        return new PolicyParserException("[" + location.lineNumber() + ":" + location.columnNumber() + "] policy parsing error for [" + policyName + "] in scope [" + scopeName + "] for entitlement type [" + entitlementType + "]: " + message);
    }

    public static PolicyParserException newPolicyParserException(XContentLocation location, String policyName, String scopeName, String entitlementType, PolicyValidationException cause) {
        assert (scopeName != null);
        return new PolicyParserException("[" + location.lineNumber() + ":" + location.columnNumber() + "] policy parsing error for [" + policyName + "] in scope [" + scopeName + "] for entitlement type [" + entitlementType + "]: " + cause.getMessage(), cause);
    }

    private PolicyParserException(String message) {
        super(message);
    }

    private PolicyParserException(String message, PolicyValidationException cause) {
        super(message, cause);
    }
}

