/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.vectortile.rest;

import com.wdtinc.mapbox_vector_tile.VectorTile;
import com.wdtinc.mapbox_vector_tile.build.MvtLayerProps;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.geo.GeoBoundingBox;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.io.stream.BytesStream;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.GeoShapeQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestResponseListener;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoGridAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.geogrid.InternalGeoGrid;
import org.elasticsearch.search.aggregations.bucket.geogrid.InternalGeoGridBucket;
import org.elasticsearch.search.aggregations.metrics.GeoBoundsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.GeoCentroidAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.InternalGeoBounds;
import org.elasticsearch.search.aggregations.pipeline.StatsBucketPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.fetch.subphase.FieldAndFormat;
import org.elasticsearch.search.profile.SearchProfileResults;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.usage.SearchUsageHolder;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.vectortile.feature.FeatureFactory;
import org.elasticsearch.xpack.vectortile.rest.GridAggregation;
import org.elasticsearch.xpack.vectortile.rest.GridType;
import org.elasticsearch.xpack.vectortile.rest.VectorTileRequest;
import org.elasticsearch.xpack.vectortile.rest.VectorTileUtils;

@ServerlessScope(value=Scope.PUBLIC)
public class RestVectorTileAction
extends BaseRestHandler {
    private static final String META_LAYER = "meta";
    private static final String HITS_LAYER = "hits";
    private static final String AGGS_LAYER = "aggs";
    private static final String GRID_FIELD = "grid";
    private static final String BOUNDS_FIELD = "bounds";
    private static final String COUNT_TAG = "_count";
    private static final String ID_TAG = "_id";
    private static final String INDEX_TAG = "_index";
    private static final String KEY_TAG = "_key";
    private static final String MIME_TYPE = "application/vnd.mapbox-vector-tile";
    private static final String INTERNAL_AGG_PREFIX = "_mvt_";
    static final String CENTROID_AGG_NAME = "_mvt_centroid";
    static final String LABEL_POSITION_FIELD_NAME = "_mvt_label_position";
    private final SearchUsageHolder searchUsageHolder;

    public RestVectorTileAction(SearchUsageHolder searchUsageHolder) {
        this.searchUsageHolder = searchUsageHolder;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "{index}/_mvt/{field}/{z}/{x}/{y}"), new RestHandler.Route(RestRequest.Method.POST, "{index}/_mvt/{field}/{z}/{x}/{y}"));
    }

    public String getName() {
        return "vector_tile_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        RestCancellableNodeClient cancellableNodeClient = new RestCancellableNodeClient(client, restRequest.getHttpChannel());
        final VectorTileRequest request = VectorTileRequest.parseRestRequest(restRequest, arg_0 -> ((SearchUsageHolder)this.searchUsageHolder).updateUsage(arg_0));
        SearchRequestBuilder searchRequestBuilder = RestVectorTileAction.searchRequestBuilder(cancellableNodeClient, request);
        return channel -> searchRequestBuilder.execute((ActionListener)new RestResponseListener<SearchResponse>(this, channel){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public RestResponse buildResponse(SearchResponse searchResponse) throws Exception {
                try (BytesStream bytesOut = Streams.flushOnCloseStream((BytesStream)this.channel.bytesOutput());){
                    RestResponse restResponse;
                    InternalGeoGrid grid;
                    FeatureFactory featureFactory = new FeatureFactory(request.getZ(), request.getX(), request.getY(), request.getExtent(), request.getBuffer());
                    VectorTile.Tile.Builder tileBuilder = VectorTile.Tile.newBuilder();
                    this.ensureOpen();
                    SearchHit[] hits = searchResponse.getHits().getHits();
                    if (hits.length > 0) {
                        tileBuilder.addLayers(RestVectorTileAction.buildHitsLayer(hits, request, featureFactory));
                    }
                    this.ensureOpen();
                    InternalGeoGrid internalGeoGrid = grid = searchResponse.getAggregations() != null ? (InternalGeoGrid)searchResponse.getAggregations().get(RestVectorTileAction.GRID_FIELD) : null;
                    if (grid != null && grid.getBuckets().size() > 0) {
                        tileBuilder.addLayers(RestVectorTileAction.buildAggsLayer(grid, request, featureFactory));
                    }
                    this.ensureOpen();
                    InternalGeoBounds bounds = searchResponse.getAggregations() != null ? (InternalGeoBounds)searchResponse.getAggregations().get(RestVectorTileAction.BOUNDS_FIELD) : null;
                    InternalAggregations aggsWithoutGridAndBounds = searchResponse.getAggregations() == null ? null : InternalAggregations.from(searchResponse.getAggregations().asList().stream().filter(a -> !RestVectorTileAction.GRID_FIELD.equals(a.getName()) && !RestVectorTileAction.BOUNDS_FIELD.equals(a.getName())).collect(Collectors.toList()));
                    SearchResponse meta = new SearchResponse(SearchHits.empty((TotalHits)searchResponse.getHits().getTotalHits(), (float)searchResponse.getHits().getMaxScore()), aggsWithoutGridAndBounds, searchResponse.getSuggest(), searchResponse.isTimedOut(), searchResponse.isTerminatedEarly(), searchResponse.getProfileResults() == null ? null : new SearchProfileResults(searchResponse.getProfileResults()), searchResponse.getNumReducePhases(), searchResponse.getScrollId(), searchResponse.getTotalShards(), searchResponse.getSuccessfulShards(), searchResponse.getSkippedShards(), searchResponse.getTook().millis(), searchResponse.getShardFailures(), searchResponse.getClusters());
                    try {
                        tileBuilder.addLayers(RestVectorTileAction.buildMetaLayer(meta, bounds, request, featureFactory));
                        this.ensureOpen();
                        tileBuilder.build().writeTo((OutputStream)bytesOut);
                        restResponse = new RestResponse(RestStatus.OK, RestVectorTileAction.MIME_TYPE, bytesOut.bytes());
                    }
                    catch (Throwable throwable) {
                        meta.decRef();
                        throw throwable;
                    }
                    meta.decRef();
                    return restResponse;
                }
            }
        });
    }

    private static SearchRequestBuilder searchRequestBuilder(RestCancellableNodeClient client, VectorTileRequest request) throws IOException {
        SearchRequestBuilder searchRequestBuilder = client.prepareSearch(request.getIndexes());
        searchRequestBuilder.setSize(request.getSize());
        searchRequestBuilder.setFetchSource(false);
        searchRequestBuilder.setTrackTotalHitsUpTo(request.getTrackTotalHitsUpTo());
        for (FieldAndFormat field : request.getFieldAndFormats()) {
            searchRequestBuilder.addFetchField(field);
        }
        String args = request.getZ() + "/" + request.getX() + "/" + request.getY() + "@" + request.getExtent() + ":" + request.getBuffer();
        searchRequestBuilder.addFetchField(new FieldAndFormat(request.getField(), "mvt(" + args + ")"));
        Map<String, Object> runtimeMappings = request.getRuntimeMappings();
        if (request.getWithLabels()) {
            HashMap<String, Object> mappings = new HashMap<String, Object>();
            if (runtimeMappings.size() > 0) {
                mappings.putAll(runtimeMappings);
            }
            HashMap<String, Object> labelsMap = new HashMap<String, Object>();
            labelsMap.put("type", "geo_point");
            labelsMap.put("script", "GeoPoint point = doc['" + request.getField() + "'].getLabelPosition(); emit(point.getLat(), point.getLon());");
            mappings.put(LABEL_POSITION_FIELD_NAME, labelsMap);
            searchRequestBuilder.addFetchField(LABEL_POSITION_FIELD_NAME);
            runtimeMappings = mappings;
        }
        searchRequestBuilder.setRuntimeMappings(runtimeMappings);
        Rectangle boxFilter = request.getGridAgg().bufferTile(request.getBoundingBox(), request.getZ(), request.getGridPrecision());
        GeoShapeQueryBuilder qBuilder = QueryBuilders.geoShapeQuery((String)request.getField(), (Geometry)boxFilter);
        if (request.getQueryBuilder() != null) {
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.filter(request.getQueryBuilder());
            boolQueryBuilder.filter((QueryBuilder)qBuilder);
            qBuilder = boolQueryBuilder;
        }
        searchRequestBuilder.setQuery((QueryBuilder)qBuilder);
        if (request.getGridPrecision() > 0) {
            GeoBoundingBox boundingBox;
            if (request.getGridAgg().needsBounding(request.getZ(), request.getGridPrecision())) {
                Rectangle rectangle = request.getBoundingBox();
                boundingBox = new GeoBoundingBox(new GeoPoint(rectangle.getMaxLat(), rectangle.getMinLon()), new GeoPoint(rectangle.getMinLat(), rectangle.getMaxLon()));
            } else {
                boundingBox = new GeoBoundingBox(new GeoPoint(Double.NaN, Double.NaN), new GeoPoint(Double.NaN, Double.NaN));
            }
            GeoGridAggregationBuilder tileAggBuilder = ((GeoGridAggregationBuilder)request.getGridAgg().newAgg(GRID_FIELD).field(request.getField())).precision(request.getGridAgg().gridPrecisionToAggPrecision(request.getZ(), request.getGridPrecision())).setGeoBoundingBox(boundingBox).size(65536);
            searchRequestBuilder.addAggregation((AggregationBuilder)tileAggBuilder);
            searchRequestBuilder.addAggregation((PipelineAggregationBuilder)new StatsBucketPipelineAggregationBuilder(COUNT_TAG, "grid._count"));
            if (request.getGridType() == GridType.CENTROID) {
                tileAggBuilder.subAggregation((AggregationBuilder)new GeoCentroidAggregationBuilder(CENTROID_AGG_NAME).field(request.getField()));
            }
            List<ValuesSourceAggregationBuilder.MetricsAggregationBuilder<?>> aggregations = request.getAggBuilder();
            for (ValuesSourceAggregationBuilder.MetricsAggregationBuilder<?> aggregation : aggregations) {
                if (aggregation.getName().startsWith(INTERNAL_AGG_PREFIX)) {
                    throw new IllegalArgumentException("Invalid aggregation name [" + aggregation.getName() + "]. Aggregation names cannot start with prefix '_mvt_'");
                }
                tileAggBuilder.subAggregation(aggregation);
                Set metricNames = aggregation.metricNames();
                for (String metric : metricNames) {
                    String bucketPath = metric.contains(".") ? "grid>" + aggregation.getName() + "[" + metric + "]" : "grid>" + aggregation.getName() + "." + metric;
                    String aggName = metricNames.size() == 1 ? aggregation.getName() : aggregation.getName() + "." + metric;
                    searchRequestBuilder.addAggregation((PipelineAggregationBuilder)new StatsBucketPipelineAggregationBuilder(aggName, bucketPath));
                }
            }
        }
        if (request.getExactBounds()) {
            GeoBoundsAggregationBuilder boundsBuilder = ((GeoBoundsAggregationBuilder)new GeoBoundsAggregationBuilder(BOUNDS_FIELD).field(request.getField())).wrapLongitude(false);
            searchRequestBuilder.addAggregation((AggregationBuilder)boundsBuilder);
        }
        for (SortBuilder<?> sortBuilder : request.getSortBuilders()) {
            searchRequestBuilder.addSort(sortBuilder);
        }
        return searchRequestBuilder;
    }

    private static VectorTile.Tile.Layer.Builder buildHitsLayer(SearchHit[] hits, VectorTileRequest request, FeatureFactory featureFactory) throws IOException {
        VectorTile.Tile.Layer.Builder hitsLayerBuilder = VectorTileUtils.createLayerBuilder(HITS_LAYER, request.getExtent());
        MvtLayerProps layerProps = new MvtLayerProps();
        VectorTile.Tile.Feature.Builder featureBuilder = VectorTile.Tile.Feature.newBuilder();
        for (SearchHit searchHit : hits) {
            Object labelPosValue;
            GeoPoint labelPos;
            byte[] labelPosFeature;
            DocumentField labelField;
            String requestField = request.getField();
            DocumentField geoField = searchHit.field(requestField);
            if (geoField == null) continue;
            Map fields = searchHit.getDocumentFields();
            for (Object feature : geoField) {
                featureBuilder.clear();
                featureBuilder.mergeFrom((byte[])feature);
                VectorTileUtils.addPropertyToFeature(featureBuilder, layerProps, ID_TAG, searchHit.getId());
                VectorTileUtils.addPropertyToFeature(featureBuilder, layerProps, INDEX_TAG, RestVectorTileAction.buildQualifiedIndex(searchHit));
                RestVectorTileAction.addHitsFields(featureBuilder, layerProps, requestField, fields);
                hitsLayerBuilder.addFeatures(featureBuilder);
            }
            if (!request.getWithLabels() || (labelField = searchHit.field(LABEL_POSITION_FIELD_NAME)) == null || (labelPosFeature = featureFactory.point((labelPos = GeoUtils.parseGeoPoint((Object)(labelPosValue = labelField.getValue()), (boolean)true)).lon(), labelPos.lat())) == null || labelPosFeature.length == 0) continue;
            featureBuilder.clear();
            featureBuilder.mergeFrom(labelPosFeature);
            VectorTileUtils.addPropertyToFeature(featureBuilder, layerProps, ID_TAG, searchHit.getId());
            VectorTileUtils.addPropertyToFeature(featureBuilder, layerProps, INDEX_TAG, RestVectorTileAction.buildQualifiedIndex(searchHit));
            VectorTileUtils.addPropertyToFeature(featureBuilder, layerProps, LABEL_POSITION_FIELD_NAME, true);
            RestVectorTileAction.addHitsFields(featureBuilder, layerProps, requestField, fields);
            hitsLayerBuilder.addFeatures(featureBuilder);
        }
        VectorTileUtils.addPropertiesToLayer(hitsLayerBuilder, layerProps);
        return hitsLayerBuilder;
    }

    private static void addHitsFields(VectorTile.Tile.Feature.Builder featureBuilder, MvtLayerProps layerProps, String requestField, Map<String, DocumentField> fields) {
        for (String field : fields.keySet()) {
            if (requestField.equals(field) || field.equals(LABEL_POSITION_FIELD_NAME)) continue;
            VectorTileUtils.addPropertyToFeature(featureBuilder, layerProps, field, fields.get(field).getValue());
        }
    }

    private static String buildQualifiedIndex(SearchHit hit) {
        return RemoteClusterAware.buildRemoteIndexName((String)hit.getClusterAlias(), (String)hit.getIndex());
    }

    private static VectorTile.Tile.Layer.Builder buildAggsLayer(InternalGeoGrid<?> grid, VectorTileRequest request, FeatureFactory featureFactory) throws IOException {
        VectorTile.Tile.Layer.Builder aggLayerBuilder = VectorTileUtils.createLayerBuilder(AGGS_LAYER, request.getExtent());
        MvtLayerProps layerProps = new MvtLayerProps();
        VectorTile.Tile.Feature.Builder featureBuilder = VectorTile.Tile.Feature.newBuilder();
        for (InternalGeoGridBucket bucket : grid.getBuckets()) {
            featureBuilder.clear();
            String bucketKey = bucket.getKeyAsString();
            byte[] feature = request.getGridType().toFeature(request.getGridAgg(), bucket, bucketKey, featureFactory);
            if (feature == null) {
                assert (request.getGridAgg() == GridAggregation.GEOHEX);
                continue;
            }
            featureBuilder.mergeFrom(feature);
            VectorTileUtils.addPropertyToFeature(featureBuilder, layerProps, KEY_TAG, bucketKey);
            VectorTileUtils.addPropertyToFeature(featureBuilder, layerProps, COUNT_TAG, bucket.getDocCount());
            RestVectorTileAction.addAggsFields(featureBuilder, layerProps, bucket);
            aggLayerBuilder.addFeatures(featureBuilder);
            if (!request.getWithLabels()) continue;
            featureBuilder.clear();
            GeoPoint labelPos = (GeoPoint)bucket.getKey();
            byte[] labelPosFeature = featureFactory.point(labelPos.lon(), labelPos.lat());
            if (labelPosFeature == null || labelPosFeature.length == 0) continue;
            featureBuilder.mergeFrom(labelPosFeature);
            VectorTileUtils.addPropertyToFeature(featureBuilder, layerProps, KEY_TAG, bucketKey);
            VectorTileUtils.addPropertyToFeature(featureBuilder, layerProps, COUNT_TAG, bucket.getDocCount());
            VectorTileUtils.addPropertyToFeature(featureBuilder, layerProps, LABEL_POSITION_FIELD_NAME, true);
            RestVectorTileAction.addAggsFields(featureBuilder, layerProps, bucket);
            aggLayerBuilder.addFeatures(featureBuilder);
        }
        VectorTileUtils.addPropertiesToLayer(aggLayerBuilder, layerProps);
        return aggLayerBuilder;
    }

    private static void addAggsFields(VectorTile.Tile.Feature.Builder featureBuilder, MvtLayerProps layerProps, InternalGeoGridBucket bucket) throws IOException {
        for (Aggregation aggregation : bucket.getAggregations()) {
            if (aggregation.getName().startsWith(INTERNAL_AGG_PREFIX)) continue;
            VectorTileUtils.addToXContentToFeature(featureBuilder, layerProps, (ToXContent)aggregation);
        }
    }

    private static VectorTile.Tile.Layer.Builder buildMetaLayer(SearchResponse response, InternalGeoBounds bounds, VectorTileRequest request, FeatureFactory featureFactory) throws IOException {
        VectorTile.Tile.Layer.Builder metaLayerBuilder = VectorTileUtils.createLayerBuilder(META_LAYER, request.getExtent());
        MvtLayerProps layerProps = new MvtLayerProps();
        VectorTile.Tile.Feature.Builder featureBuilder = VectorTile.Tile.Feature.newBuilder();
        if (bounds != null && bounds.topLeft() != null) {
            GeoPoint topLeft = (GeoPoint)bounds.topLeft();
            GeoPoint bottomRight = (GeoPoint)bounds.bottomRight();
            featureBuilder.mergeFrom(featureFactory.box(topLeft.lon(), bottomRight.lon(), bottomRight.lat(), topLeft.lat()));
        } else {
            Rectangle tile = request.getBoundingBox();
            featureBuilder.mergeFrom(featureFactory.box(tile.getMinLon(), tile.getMaxLon(), tile.getMinLat(), tile.getMaxLat()));
        }
        VectorTileUtils.addToXContentToFeature(featureBuilder, layerProps, ChunkedToXContent.wrapAsToXContent((ChunkedToXContent)response));
        metaLayerBuilder.addFeatures(featureBuilder);
        VectorTileUtils.addPropertiesToLayer(metaLayerBuilder, layerProps);
        return metaLayerBuilder;
    }
}

