/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.notification.slack.message;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.xcontent.ObjectPath;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.watcher.common.text.TextTemplateEngine;
import org.elasticsearch.xpack.watcher.notification.slack.message.Attachment;
import org.elasticsearch.xpack.watcher.notification.slack.message.MessageElement;
import org.elasticsearch.xpack.watcher.notification.slack.message.SlackMessageDefaults;

public class DynamicAttachments
implements MessageElement {
    private String listPath;
    private Attachment.Template attachment;

    public DynamicAttachments(String listPath, Attachment.Template attachment) {
        this.listPath = listPath;
        this.attachment = attachment;
    }

    public List<Attachment> render(TextTemplateEngine engine, Map<String, Object> model, SlackMessageDefaults.AttachmentDefaults defaults) {
        Object value = ObjectPath.eval((String)this.listPath, model);
        if (!(value instanceof Iterable)) {
            throw new IllegalArgumentException("dynamic attachment could not be resolved. expected context [" + this.listPath + "] to be a list, but found [" + String.valueOf(value) + "] instead");
        }
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        for (Object obj : (Iterable)value) {
            if (!(obj instanceof Map)) {
                throw new IllegalArgumentException("dynamic attachment could not be resolved. expected [" + this.listPath + "] list to contain key/value pairs, but found [" + String.valueOf(obj) + "] instead");
            }
            Map attachmentModel = (Map)obj;
            attachments.add(this.attachment.render(engine, attachmentModel, defaults));
        }
        return attachments;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field(XField.LIST_PATH.getPreferredName(), this.listPath).field(XField.TEMPLATE.getPreferredName(), (ToXContent)this.attachment, params).endObject();
    }

    public static DynamicAttachments parse(XContentParser parser) throws IOException {
        String listPath = null;
        Attachment.Template template = null;
        String currentFieldName = null;
        XContentParser.Token token = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (XField.LIST_PATH.match(currentFieldName, parser.getDeprecationHandler())) {
                if (token == XContentParser.Token.VALUE_STRING) {
                    listPath = parser.text();
                    continue;
                }
                throw new ElasticsearchParseException("could not parse dynamic attachments. expected a string value for [{}] field, but found [{}]", new Object[]{XField.LIST_PATH.getPreferredName(), token});
            }
            if (XField.TEMPLATE.match(currentFieldName, parser.getDeprecationHandler())) {
                try {
                    template = Attachment.Template.parse(parser);
                    continue;
                }
                catch (ElasticsearchParseException pe) {
                    throw new ElasticsearchParseException("could not parse dynamic attachments. failed to parse [{}] field", (Throwable)pe, new Object[]{XField.TEMPLATE.getPreferredName()});
                }
            }
            throw new ElasticsearchParseException("could not parse dynamic attachments. unexpected field [{}]", new Object[]{currentFieldName});
        }
        if (listPath == null) {
            throw new ElasticsearchParseException("could not parse dynamic attachments. missing required field [{}]", new Object[]{XField.LIST_PATH.getPreferredName()});
        }
        if (template == null) {
            throw new ElasticsearchParseException("could not parse dynamic attachments. missing required field [{}]", new Object[]{XField.TEMPLATE.getPreferredName()});
        }
        return new DynamicAttachments(listPath, template);
    }

    static interface XField
    extends MessageElement.XField {
        public static final ParseField LIST_PATH = new ParseField("list_path", new String[0]);
        public static final ParseField TEMPLATE = new ParseField("attachment_template", new String[0]);
    }
}

