/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.execution;

import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.core.Strings;
import org.elasticsearch.xpack.core.watcher.trigger.TriggerEvent;
import org.elasticsearch.xpack.watcher.execution.ExecutionService;

public class AsyncTriggerEventConsumer
implements Consumer<Iterable<TriggerEvent>> {
    private static final Logger logger = LogManager.getLogger(AsyncTriggerEventConsumer.class);
    private final ExecutionService executionService;

    public AsyncTriggerEventConsumer(ExecutionService executionService) {
        this.executionService = executionService;
    }

    @Override
    public void accept(Iterable<TriggerEvent> events) {
        try {
            this.executionService.processEventsAsync(events);
        }
        catch (Exception e) {
            logger.error(() -> Strings.format((String)"failed to process triggered events [%s]", (Object[])new Object[]{StreamSupport.stream(events.spliterator(), false).toArray(TriggerEvent[]::new)}), (Throwable)e);
        }
    }
}

