/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.internal.avro.implementation.schema.complex;

import com.azure.storage.internal.avro.implementation.AvroParserState;
import com.azure.storage.internal.avro.implementation.schema.AvroCompositeSchema;
import com.azure.storage.internal.avro.implementation.schema.AvroSchema;
import com.azure.storage.internal.avro.implementation.schema.AvroType;
import com.azure.storage.internal.avro.implementation.schema.primitive.AvroLongSchema;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class AvroArraySchema
extends AvroCompositeSchema {
    private final AvroType itemType;
    private Long blockCount;
    private List<Object> ret = new ArrayList<Object>();

    public AvroArraySchema(AvroType itemType, AvroParserState state, Consumer<Object> onResult) {
        super(state, onResult);
        this.itemType = itemType;
    }

    @Override
    public void pushToStack() {
        this.state.pushToStack(this);
        AvroLongSchema blockCountSchema = new AvroLongSchema(this.state, this::onBlockCount);
        blockCountSchema.pushToStack();
    }

    private void onBlockCount(Object blockCount) {
        AvroArraySchema.checkType("blockCount", blockCount, Long.class);
        Long bc = (Long)blockCount;
        if (bc == 0L) {
            this.result = this.ret;
            this.done = true;
        } else if (bc > 0L) {
            this.blockCount = bc;
            AvroSchema itemSchema = AvroArraySchema.getSchema(this.itemType, this.state, this::onItem);
            itemSchema.pushToStack();
        } else {
            this.blockCount = -bc.longValue();
            AvroLongSchema byteCountSchema = new AvroLongSchema(this.state, this::onByteCount);
            byteCountSchema.pushToStack();
        }
    }

    private void onByteCount(Object byteCount) {
        AvroSchema itemSchema = AvroArraySchema.getSchema(this.itemType, this.state, this::onItem);
        itemSchema.pushToStack();
    }

    private void onItem(Object item) {
        this.ret.add(item);
        Long l = this.blockCount;
        this.blockCount = this.blockCount - 1L;
        if (this.blockCount == 0L) {
            AvroLongSchema blockCountSchema = new AvroLongSchema(this.state, this::onBlockCount);
            blockCountSchema.pushToStack();
        } else {
            AvroSchema itemSchema = AvroArraySchema.getSchema(this.itemType, this.state, this::onItem);
            itemSchema.pushToStack();
        }
    }
}

